/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.controllers.app;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.xforceplus.seller.config.client.model.AllElectricIssuerInfoRecord;
import com.xforceplus.seller.config.client.model.AllElectricIssuerInfoResult;
import com.xforceplus.seller.config.client.model.AllElectricIssuerRecordRequest;
import com.xforceplus.seller.config.client.model.AllElectricIssuerRequest;
import com.xforceplus.seller.config.client.model.AllElectricQualificationData;
import com.xforceplus.seller.config.client.model.CfgAllElectricIssuerRecord;
import com.xforceplus.seller.config.client.model.ConfigAddElectricIssuerInfoRequest;
import com.xforceplus.seller.config.client.model.ConfigDeleteElectricIssuerInfoRequest;
import com.xforceplus.seller.config.client.model.MsAddTerminalResponse;
import com.xforceplus.seller.config.client.model.MsCompanyInfo;
import com.xforceplus.seller.config.client.model.MsConfigAddTerminalRequest;
import com.xforceplus.seller.config.client.model.MsConfigDeviceQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigTemialAuthQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigTemialQueryMakeOutRequest;
import com.xforceplus.seller.config.client.model.MsConfigTemialQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigUpdateTerminalRequest;
import com.xforceplus.seller.config.client.model.MsConfigUpdateTerminalStatusRequest;
import com.xforceplus.seller.config.client.model.MsDeviceInfo;
import com.xforceplus.seller.config.client.model.MsDeviceQueryInfo;
import com.xforceplus.seller.config.client.model.MsQueryDeviceResponse;
import com.xforceplus.seller.config.client.model.MsQueryMakeOutTerminalResponse;
import com.xforceplus.seller.config.client.model.MsQueryTerminalRequest;
import com.xforceplus.seller.config.client.model.MsQueryTerminalResponse;
import com.xforceplus.seller.config.client.model.MsResponse;
import com.xforceplus.seller.config.client.model.MsTerminalQueryInfo;
import com.xforceplus.seller.config.client.model.QueryAllElectricQualificationRequest;
import com.xforceplus.seller.config.client.model.UserRelationData;
import com.xforceplus.seller.config.config.ConfigTerminalProperties;
import com.xforceplus.seller.config.config.annotation.APIV1ConfigTerminal;
import com.xforceplus.seller.config.converters.DeviceConverter;
import com.xforceplus.seller.config.core.enums.InvoiceType;
import com.xforceplus.seller.config.facade.TerminalDeviceFacade;
import com.xforceplus.seller.config.models.AddTerminalResponse;
import com.xforceplus.seller.config.models.ConfigAddTerminalRequest;
import com.xforceplus.seller.config.models.ConfigTemialAuthQueryRequest;
import com.xforceplus.seller.config.models.ConfigTemialQueryMakeOutRequest;
import com.xforceplus.seller.config.models.ConfigTemialQueryRequest;
import com.xforceplus.seller.config.models.ConfigUpdateTerminalRequest;
import com.xforceplus.seller.config.models.ConfigUpdateTerminalStatusRequest;
import com.xforceplus.seller.config.models.QueryMakeOutTerminalResponse;
import com.xforceplus.seller.config.models.QueryMakeOutTerminalWithDeviceResponse;
import com.xforceplus.seller.config.models.QueryTerminalResponse;
import com.xforceplus.seller.config.models.TerminalDefaultRequest;
import com.xforceplus.seller.config.models.TerminalQueryResponseInfo;
import com.xforceplus.seller.config.services.ConfigDeviceService;
import com.xforceplus.seller.config.services.ConfigTerminalService;
import com.xforceplus.seller.config.util.BeanMapper;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatsecurity.base.BaseAppController;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@APIV1ConfigTerminal
public class ConfigTerminalController
extends BaseAppController {
    private final ConfigTerminalService configTerminalService;
    private final ConfigDeviceService configDeviceService;
    private final DeviceConverter deviceConverter;
    private final UserInfoHolder<UserInfo> userInfoHolder;
    private final TerminalDeviceFacade terminalDeviceFacade;
    private final ConfigTerminalProperties configTerminalProperties;

    @ApiOperation(value="\u65b0\u589e\u7ec8\u7aef", notes="", response=AddTerminalResponse.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfigTemial"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7ec8\u7aef\u65b0\u589e", response=AddTerminalResponse.class)})
    @RequestMapping(value={"/configTerminal/addTerminal"}, produces={"application/json"}, method={RequestMethod.POST})
    public AddTerminalResponse addTerminal(@ApiParam(value="\u7ec8\u7aef\u65b0\u589e") @RequestBody ConfigAddTerminalRequest request) {
        MsConfigAddTerminalRequest destinationRequest = new MsConfigAddTerminalRequest();
        BeanMapper.copy((Object)request, (Object)destinationRequest);
        MsAddTerminalResponse msResponse = this.configTerminalService.addTerminal(destinationRequest);
        AddTerminalResponse response2 = new AddTerminalResponse();
        BeanMapper.copy((Object)msResponse, (Object)response2);
        return response2;
    }

    @ApiOperation(value="\u5bfc\u5165\u7ec8\u7aef", notes="", response=Response.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfigTemial"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=Response.class)})
    @RequestMapping(value={"/configTerminal/import"}, produces={"application/json"}, method={RequestMethod.POST})
    public Response<?> callImport(@ApiParam(value="\u66f4\u65b0\u7ec8\u7aef\u8bf7\u6c42\u5bf9\u8c61", required=true) @RequestBody Object request) {
        return null;
    }

    @ApiOperation(value="\u5bfc\u51fa\u7ec8\u7aef", notes="", response=Response.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfigTemial"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=Response.class)})
    @RequestMapping(value={"/configTerminal/export"}, produces={"application/json"}, method={RequestMethod.POST})
    public Response<?> export(@ApiParam(value="\u66f4\u65b0\u7ec8\u7aef\u8bf7\u6c42\u5bf9\u8c61", required=true) @RequestBody Object request) {
        return null;
    }

    @ApiOperation(value="\u67e5\u8be2\u7ec8\u7aef", notes="", response=QueryTerminalResponse.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfigTemial"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7ec8\u7aef\u4fe1\u606f\u83b7\u53d6\u54cd\u5e94", response=QueryTerminalResponse.class)})
    @RequestMapping(value={"/configTerminal/getTerminalList"}, produces={"application/json"}, method={RequestMethod.POST})
    public QueryTerminalResponse getTerminalList(@ApiParam(value="\u67e5\u8be2\u7ec8\u7aef\u8bf7\u6c42\u5bf9\u8c61", required=true) @RequestBody ConfigTemialQueryRequest request) {
        MsConfigTemialQueryRequest destinationRequest = new MsConfigTemialQueryRequest();
        BeanMapper.copy((Object)request, (Object)destinationRequest);
        this.logger.info("app\u8bf7\u6c42\u53c2\u6570{}", (Object)JSON.toJSONString((Object)destinationRequest));
        MsQueryTerminalResponse msResponse = this.configTerminalService.getTerminalList(destinationRequest, (UserInfo)this.userInfoHolder.get());
        this.logger.info("msResponse = {}", (Object)JSON.toJSONString((Object)msResponse));
        QueryTerminalResponse response2 = new QueryTerminalResponse();
        BeanMapper.copy((Object)msResponse, (Object)response2);
        this.logger.info("response = {}", (Object)JSON.toJSONString((Object)response2));
        return response2;
    }

    @ApiOperation(value="\u66f4\u65b0\u7ec8\u7aef\u4fe1\u606f", notes="", response=Response.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfigTemial"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=Response.class)})
    @RequestMapping(value={"/configTerminal/update"}, produces={"application/json"}, method={RequestMethod.POST})
    public Response<?> update(@ApiParam(value="\u66f4\u65b0\u7ec8\u7aef\u8bf7\u6c42\u5bf9\u8c61", required=true) @RequestBody ConfigUpdateTerminalRequest request) {
        MsConfigUpdateTerminalRequest destinationRequest = new MsConfigUpdateTerminalRequest();
        BeanMapper.copy((Object)request, (Object)destinationRequest);
        MsResponse msResponse = this.configTerminalService.update(destinationRequest);
        Response response2 = new Response();
        BeanMapper.copy((Object)msResponse, (Object)response2);
        return response2;
    }

    @ApiOperation(value="\u66f4\u65b0\u7ec8\u7aef\u72b6\u6001", notes="", response=Response.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfigTemial"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=Response.class)})
    @RequestMapping(value={"/configTerminal/updateStatus"}, produces={"application/json"}, method={RequestMethod.POST})
    public Response<?> updateStatus(@ApiParam(value="\u66f4\u65b0\u7ec8\u7aef\u72b6\u6001\u8bf7\u6c42\u5bf9\u8c61", required=true) @RequestBody ConfigUpdateTerminalStatusRequest request) {
        MsConfigUpdateTerminalStatusRequest destinationRequest = new MsConfigUpdateTerminalStatusRequest();
        BeanMapper.copy((Object)request, (Object)destinationRequest);
        MsResponse msResponse = this.configTerminalService.updateStatus(destinationRequest);
        Response response2 = new Response();
        BeanMapper.copy((Object)msResponse, (Object)response2);
        return response2;
    }

    @ApiOperation(value="\u67e5\u8be2\u5f00\u7968\u7ec8\u7aef", notes="", response=QueryMakeOutTerminalResponse.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfigTemial"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7ec8\u7aef\u4fe1\u606f\u83b7\u53d6\u54cd\u5e94", response=QueryMakeOutTerminalResponse.class)})
    @RequestMapping(value={"/configTerminal/getMakeOutTerminalList"}, produces={"application/json"}, method={RequestMethod.POST})
    public QueryMakeOutTerminalResponse getMakeOutTerminalList(@ApiParam(value="\u67e5\u8be2\u5f00\u7968\u7ec8\u7aef\u8bf7\u6c42\u5bf9\u8c61", required=true) @RequestBody ConfigTemialQueryMakeOutRequest request) {
        MsConfigTemialQueryMakeOutRequest destinationRequest = new MsConfigTemialQueryMakeOutRequest();
        BeanMapper.copy((Object)request, (Object)destinationRequest);
        MsQueryMakeOutTerminalResponse msResponse = this.configTerminalService.getMakeOutTerminalList(destinationRequest);
        QueryMakeOutTerminalResponse response2 = new QueryMakeOutTerminalResponse();
        BeanMapper.copy((Object)msResponse, (Object)response2);
        return response2;
    }

    @ApiOperation(value="\u67e5\u8be2\u5f00\u7968(\u6216\u6253\u5370)\u7ec8\u7aef", notes="", response=QueryMakeOutTerminalWithDeviceResponse.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfigTemial"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7ec8\u7aef\u4fe1\u606f\u83b7\u53d6\u54cd\u5e94", response=QueryMakeOutTerminalWithDeviceResponse.class)})
    @RequestMapping(value={"/permitted/terminals"}, produces={"application/json"}, method={RequestMethod.POST})
    public QueryMakeOutTerminalWithDeviceResponse getIssueTerminalList(@ApiParam(value="\u67e5\u8be2\u5f00\u7968\u7ec8\u7aef\u8bf7\u6c42\u5bf9\u8c61", required=true) @RequestBody TerminalDefaultRequest request) {
        this.logger.info("invoker getIssueTerminalList, params = {}", (Object)JSON.toJSONString((Object)request));
        MsConfigTemialQueryMakeOutRequest destinationRequest = new MsConfigTemialQueryMakeOutRequest();
        MsTerminalQueryInfo terminalInfo = new MsTerminalQueryInfo();
        MsCompanyInfo companyInfo = new MsCompanyInfo();
        BeanMapper.copy((Object)request.getCompanyInfo(), (Object)companyInfo);
        terminalInfo.setCompanyInfo(companyInfo);
        ArrayList invoiceTypes = Lists.newArrayList((Object[])new String[]{InvoiceType.NORMAL.value(), InvoiceType.SPECIAL.value(), InvoiceType.SPECIAL_ELECTRONIC.value(), InvoiceType.VEHICLE.value(), InvoiceType.ELECTRONIC.value(), InvoiceType.NORMAL_ROLL.value()});
        terminalInfo.setInvoiceType((List)invoiceTypes);
        terminalInfo.setSupportService(request.getSupportService());
        destinationRequest.setTerminalInfo(terminalInfo);
        this.logger.info("invoker getIssueTerminalList, destinationRequest = {}", (Object)JSON.toJSONString((Object)terminalInfo));
        MsQueryMakeOutTerminalResponse msResponse = this.configTerminalService.getMakeOutTerminalList(destinationRequest);
        QueryMakeOutTerminalWithDeviceResponse response2 = new QueryMakeOutTerminalWithDeviceResponse();
        BeanMapper.copy((Object)msResponse, (Object)response2);
        MsConfigDeviceQueryRequest deviceRequest = new MsConfigDeviceQueryRequest();
        MsDeviceQueryInfo queryInfo = new MsDeviceQueryInfo();
        deviceRequest.setQueryInfo(queryInfo);
        queryInfo.setSupportService(request.getSupportService());
        queryInfo.setCompanyInfo(this.deviceConverter.convert(request.getCompanyInfo()));
        MsQueryDeviceResponse deviceResponse = this.configDeviceService.getDeviceList(deviceRequest, (UserInfo)this.userInfoHolder.get(), true);
        if (null != response2.getResult() && CollectionUtils.isNotEmpty((Collection)response2.getResult().getMakeOutTerminals())) {
            Map<String, List<MsDeviceInfo>> map = deviceResponse.getResult().getDevices().stream().collect(Collectors.groupingBy(MsDeviceInfo::getDeviceUn));
            ArrayList<TerminalQueryResponseInfo> terminalList = new ArrayList<TerminalQueryResponseInfo>();
            ArrayList<String> onlineDeviceUnList = new ArrayList<String>();
            for (TerminalQueryResponseInfo terminal : response2.getResult().getMakeOutTerminals()) {
                List<MsDeviceInfo> list;
                if (StringUtils.isEmpty((CharSequence)terminal.getDeviceUn()) || terminal.getDirectOnlineFlag() != 1) continue;
                onlineDeviceUnList.add(terminal.getDeviceUn());
                List<MsDeviceInfo> list2 = list = MapUtils.isEmpty(map) ? null : map.get(terminal.getDeviceUn());
                if (CollectionUtils.isNotEmpty(list)) {
                    MsDeviceInfo device = list.get(0);
                    HashSet set1 = new HashSet(terminal.getInvoiceType());
                    HashSet set2 = new HashSet(device.getTaxDeviceInfo().getInvoiceType());
                    Set intersect = set1.stream().filter(set2::contains).collect(Collectors.toSet());
                    terminal.setInvoiceType((List)Lists.newArrayList(intersect));
                }
                terminalList.add(terminal);
            }
            response2.getResult().setMakeOutTerminals(terminalList);
            deviceResponse.getResult().setOnlineDeviceUns(onlineDeviceUnList);
        }
        response2.setDeviceResult(deviceResponse.getResult());
        return response2;
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237\u6743\u9650\u67e5\u8be2\u7ec8\u7aef", notes="", response=QueryTerminalResponse.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfigTemial"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7ec8\u7aef\u4fe1\u606f\u83b7\u53d6\u54cd\u5e94", response=QueryTerminalResponse.class)})
    @RequestMapping(value={"/configTerminal/getAuthTerminalList"}, produces={"application/json"}, method={RequestMethod.POST})
    public QueryTerminalResponse getAuthTerminalList(@ApiParam(value="\u67e5\u8be2\u7ec8\u7aef\u8bf7\u6c42\u5bf9\u8c61", required=true) @RequestBody ConfigTemialAuthQueryRequest request) {
        if (this.configTerminalProperties.getQueryTerminalMethodUnifySwitch().booleanValue()) {
            MsQueryTerminalRequest msQueryTerminalRequest = new MsQueryTerminalRequest();
            msQueryTerminalRequest.setInvoiceType(request.getInvoiceType());
            msQueryTerminalRequest.setSupportService(request.getSupportService());
            msQueryTerminalRequest.setTaxNo(request.getSellerTaxNo());
            msQueryTerminalRequest.setLimitByUser(Boolean.valueOf(true));
            msQueryTerminalRequest.setQueryOnline(Boolean.valueOf(true));
            msQueryTerminalRequest.setQueryInventory(Boolean.valueOf(true));
            MsQueryTerminalResponse msResponse = this.terminalDeviceFacade.getTerminalList(msQueryTerminalRequest);
            return this.deviceConverter.convert(msResponse);
        }
        MsConfigTemialAuthQueryRequest destinationRequest = new MsConfigTemialAuthQueryRequest();
        BeanMapper.copy((Object)request, (Object)destinationRequest);
        MsQueryTerminalResponse msResponse = this.configTerminalService.getAuthTerminalList(destinationRequest);
        return this.deviceConverter.convert(msResponse);
    }

    @ApiOperation(value="\u65b0\u83b7\u53d6\u7ec8\u7aef\u4fe1\u606f", response=MsQueryTerminalResponse.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfigTemial"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=MsQueryTerminalResponse.class)})
    @RequestMapping(value={"/configTerminal/new/getTerminalList"}, produces={"application/json"}, method={RequestMethod.POST})
    public MsQueryTerminalResponse getTerminalList(@RequestBody MsQueryTerminalRequest request) {
        return this.terminalDeviceFacade.getTerminalList(request);
    }

    @ApiOperation(value="\u67e5\u8be2\u7a0e\u53f7\u5168\u7535\u8d44\u8d28", response=Response.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfigTemial"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=Response.class)})
    @RequestMapping(value={"/configTerminal/query-all-electric-qualification"}, produces={"application/json"}, method={RequestMethod.POST})
    public Response<AllElectricQualificationData> queryAllElectricQualification(@RequestBody QueryAllElectricQualificationRequest request) {
        Either eitherResult = this.terminalDeviceFacade.queryAllElectricQualification(Long.valueOf(((UserInfo)this.userInfoHolder.get()).getGroupId()), request.getTaxNoList());
        if (eitherResult.isLeft()) {
            return Response.from((Integer)Response.Fail, (String)((String)eitherResult.getLeft()), null);
        }
        return Response.from((Integer)Response.OK, (String)"\u6210\u529f", (Object)eitherResult.get());
    }

    @ApiOperation(value="\u67e5\u8be2\u5728\u7ebf\u5f00\u7968\u4eba\u4fe1\u606f\u5217\u8868", response=Response.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfigTemial"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=Response.class)})
    @RequestMapping(value={"/configTerminal/query-all-electric-issuerinfo-list"}, produces={"application/json"}, method={RequestMethod.POST})
    public Response<List<AllElectricIssuerInfoRecord>> queryAllElectricIssuerInfoList(@RequestBody AllElectricIssuerRequest request) {
        Either eitherResult = this.terminalDeviceFacade.queryAllElectricIssuerInfoList(request);
        if (eitherResult.isLeft()) {
            return Response.from((Integer)Response.Fail, (String)((String)eitherResult.getLeft()), null);
        }
        return Response.from((Integer)Response.OK, (String)"\u6210\u529f", (Object)eitherResult.get());
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5728\u7ebf\u5f00\u7968\u4eba\u4fe1\u606f\u5217\u8868", response=Response.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfigTemial"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=Response.class)})
    @RequestMapping(value={"/configTerminal/query-electric-issuerinfo-by-page"}, produces={"application/json"}, method={RequestMethod.POST})
    public Response<AllElectricIssuerInfoResult> queryElectricIssuerInfoByPage(@RequestBody AllElectricIssuerRequest request) {
        Either eitherResult = this.terminalDeviceFacade.queryElectricIssuerInfoByPage(request);
        if (eitherResult.isLeft()) {
            return Response.from((Integer)Response.Fail, (String)((String)eitherResult.getLeft()), null);
        }
        return Response.from((Integer)Response.OK, (String)"\u6210\u529f", (Object)eitherResult.get());
    }

    @ApiOperation(value="\u65b0\u589e\u5168\u7535\u53d1\u7968\u5f00\u7968\u4eba", notes="", response=Response.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfigTemial"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=Response.class)})
    @RequestMapping(value={"/configTerminal/add-electric-issuerinfo"}, produces={"application/json"}, method={RequestMethod.POST})
    public Response addElectricIssuerInfo(@RequestBody ConfigAddElectricIssuerInfoRequest request) {
        Either eitherResult = this.terminalDeviceFacade.addElectricIssuerInfo(request);
        if (eitherResult.isLeft()) {
            return Response.failed((String)((String)eitherResult.getLeft()));
        }
        return Response.ok((String)((String)eitherResult.get()));
    }

    @ApiOperation(value="\u4fee\u6539\u5168\u7535\u53d1\u7968\u5f00\u7968\u4eba", notes="", response=Response.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfigTemial"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=Response.class)})
    @RequestMapping(value={"/configTerminal/update-electric-issuerinfo"}, produces={"application/json"}, method={RequestMethod.POST})
    public Response updateElectricIssuerInfo(@RequestBody ConfigAddElectricIssuerInfoRequest request) {
        Either eitherResult = this.terminalDeviceFacade.updateElectricIssuerInfo(request);
        if (eitherResult.isLeft()) {
            return Response.failed((String)((String)eitherResult.getLeft()));
        }
        return Response.ok((String)((String)eitherResult.get()));
    }

    @ApiOperation(value="\u5220\u9664\u5168\u7535\u53d1\u7968\u5f00\u7968\u4eba", notes="", response=Response.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfigTemial"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=Response.class)})
    @RequestMapping(value={"/configTerminal/delete-electric-issuerinfo"}, produces={"application/json"}, method={RequestMethod.POST})
    public Response deleteElectricIssuerInfoList(@RequestBody ConfigDeleteElectricIssuerInfoRequest request) {
        Either eitherResult = this.terminalDeviceFacade.deleteElectricIssuerInfoList(request);
        if (eitherResult.isLeft()) {
            return Response.failed((String)((String)eitherResult.getLeft()));
        }
        return Response.ok((String)((String)eitherResult.get()));
    }

    @ApiOperation(value="\u67e5\u8be2\u5f00\u7968\u4eba\u64cd\u4f5c\u8bb0\u5f55", response=Response.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfigTemial"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=Response.class)})
    @RequestMapping(value={"/configTerminal/query-all-electric-issuer-record"}, produces={"application/json"}, method={RequestMethod.POST})
    public Response<List<CfgAllElectricIssuerRecord>> queryAllElectricIssuerRecord(@RequestBody AllElectricIssuerRecordRequest request) {
        Either eitherResult = this.terminalDeviceFacade.queryAllElectricIssuerRecord(request);
        if (eitherResult.isLeft()) {
            return Response.from((Integer)Response.Fail, (String)((String)eitherResult.getLeft()), null);
        }
        return Response.from((Integer)Response.OK, (String)"\u6210\u529f", (Object)eitherResult.get());
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5df2\u7ed1\u5b9a\u7684\u5728\u7ebf\u5f00\u7968\u4eba", response=Response.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfigTemial"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=Response.class)})
    @RequestMapping(value={"/configTerminal/query-permitted-user-issuer-relation-by-page"}, produces={"application/json"}, method={RequestMethod.POST})
    public Response<AllElectricIssuerInfoResult> queryPermittedUserIssuerRelationByPage(@RequestBody UserRelationData.UserRelationRequest request) {
        Either eitherRelationResult = this.terminalDeviceFacade.queryUserRelationByPage(request);
        if (eitherRelationResult.isLeft()) {
            return Response.from((Integer)Response.Fail, (String)((String)eitherRelationResult.getLeft()), null);
        }
        return Response.from((Integer)Response.OK, (String)"\u6210\u529f", (Object)eitherRelationResult.get());
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7528\u6237\u548c\u5728\u7ebf\u5f00\u7968\u4eba\u5173\u7cfb\u4fe1\u606f\u5217\u8868", response=Response.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfigTemial"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=Response.class)})
    @RequestMapping(value={"/configTerminal/query-user-issuer-relation-by-page"}, produces={"application/json"}, method={RequestMethod.POST})
    public Response<AllElectricIssuerInfoResult> queryUserIssuerRelationByPage(@RequestBody UserRelationData.UserRelationRequest request) {
        if (CollectionUtils.isEmpty((Collection)request.getTaxNoList())) {
            List hasTaxNoList = this.terminalDeviceFacade.queryTaxNoListByUserId(Long.valueOf(((UserInfo)this.userInfoHolder.get()).getGroupId()), request.getUserId());
            request.setTaxNoList(hasTaxNoList);
        }
        if (CollectionUtils.isEmpty((Collection)request.getTaxNoList())) {
            return Response.from((Integer)Response.Fail, (String)"\u83b7\u53d6\u79df\u6237\u4e0b\u7528\u6237\u6240\u5c5e\u7a0e\u53f7\u4e3a\u7a7a", null);
        }
        AllElectricIssuerRequest allElectricIssuerRequest = new AllElectricIssuerRequest();
        allElectricIssuerRequest.setTaxNoList(request.getTaxNoList());
        allElectricIssuerRequest.setIssuer(Optional.ofNullable(request.getIssuer()).orElse(""));
        allElectricIssuerRequest.setNeedPermission(Optional.ofNullable(request.getNeedPermission()).orElse(false));
        allElectricIssuerRequest.setPageIndex(request.getPageIndex());
        allElectricIssuerRequest.setPageSize(request.getPageSize());
        Either eitherResult = this.terminalDeviceFacade.queryElectricIssuerInfoByPage(allElectricIssuerRequest);
        if (eitherResult.isLeft()) {
            return Response.from((Integer)Response.Fail, (String)((String)eitherResult.getLeft()), null);
        }
        Either eitherRelationResult = this.terminalDeviceFacade.queryUserRelationList(request);
        if (eitherResult.isLeft()) {
            return Response.from((Integer)Response.OK, (String)"\u6210\u529f", (Object)eitherResult.get());
        }
        List recordList = ((AllElectricIssuerInfoResult)eitherResult.get()).getAllElectricIssuerInfoRecordList();
        Set uniqueKeySet = ((List)eitherRelationResult.get()).stream().filter(r -> r.getStatus() == 1).map(UserRelationData.UserRelationInfo::getUniqueKey).collect(Collectors.toSet());
        recordList.forEach(r -> {
            if (uniqueKeySet.contains(r.convertUniqueKey(Long.valueOf(((UserInfo)this.userInfoHolder.get()).getGroupId())))) {
                r.setStatus(Integer.valueOf(1));
            }
        });
        return Response.from((Integer)Response.OK, (String)"\u6210\u529f", (Object)eitherResult.get());
    }

    @ApiOperation(value="\u67e5\u8be2\u4eba\u5458\u548c\u5f00\u7968\u4eba\uff08\u5176\u5b83\uff09\u5173\u7cfb\u5217\u8868", response=Response.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfigTemial"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=Response.class)})
    @RequestMapping(value={"/configTerminal/query-userinfo-relation"}, produces={"application/json"}, method={RequestMethod.POST})
    public Response<List<UserRelationData.UserRelationInfo>> queryUserinfoRelation(@RequestBody UserRelationData.UserRelationRequest request) {
        Either eitherResult = this.terminalDeviceFacade.queryUserRelationList(request);
        if (eitherResult.isLeft()) {
            return Response.from((Integer)Response.Fail, (String)((String)eitherResult.getLeft()), null);
        }
        return Response.from((Integer)Response.OK, (String)"\u6210\u529f", (Object)eitherResult.get());
    }

    @ApiOperation(value="\u4fdd\u5b58\u4eba\u5458\u548c\u5f00\u7968\u4eba\uff08\u5176\u5b83\uff09\u5173\u7cfb", response=Response.class, authorizations={@Authorization(value="x-access-token")}, tags={"SellerConfigTemial"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7edf\u4e00\u8fd4\u56de", response=Response.class)})
    @RequestMapping(value={"/configTerminal/save-userinfo-relation"}, produces={"application/json"}, method={RequestMethod.POST})
    public Response saveUserInfoRelation(@RequestBody UserRelationData userRelationData) {
        Tuple2 groupList = this.terminalDeviceFacade.groupUserRelationList(userRelationData.getUserInfoRelationList(), Long.valueOf(((UserInfo)this.userInfoHolder.get()).getGroupId()));
        if (CollectionUtils.isNotEmpty((Collection)((Collection)groupList._2))) {
            return Response.from((Integer)0, (String)"\u64cd\u4f5c\u5931\u8d25", (Object)groupList._2);
        }
        Either eitherResult = this.terminalDeviceFacade.saveUserRelationList((List)groupList._1);
        if (eitherResult.isRight()) {
            return Response.ok((String)"\u64cd\u4f5c\u6210\u529f");
        }
        return Response.ok((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    public ConfigTerminalController(ConfigTerminalService configTerminalService, ConfigDeviceService configDeviceService, DeviceConverter deviceConverter, UserInfoHolder<UserInfo> userInfoHolder, TerminalDeviceFacade terminalDeviceFacade, ConfigTerminalProperties configTerminalProperties) {
        this.configTerminalService = configTerminalService;
        this.configDeviceService = configDeviceService;
        this.deviceConverter = deviceConverter;
        this.userInfoHolder = userInfoHolder;
        this.terminalDeviceFacade = terminalDeviceFacade;
        this.configTerminalProperties = configTerminalProperties;
    }
}

