/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.controllers.app;

import com.xforceplus.seller.config.client.model.SyncTaxPlateGoodsRequest;
import com.xforceplus.seller.config.config.annotation.APIV1Config;
import com.xforceplus.seller.config.facade.GoodsFacade;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@APIV1Config
public class GoodsController {
    private final GoodsFacade goodsFacade;
    private final UserInfoHolder<UserInfo> userInfoHolder;

    public GoodsController(GoodsFacade goodsFacade, UserInfoHolder<UserInfo> userInfoHolder) {
        this.goodsFacade = goodsFacade;
        this.userInfoHolder = userInfoHolder;
    }

    @PostMapping(value={"/goods/tax-plate/sync"})
    public Response<Object> syncTaxPlateGoods(@RequestBody SyncTaxPlateGoodsRequest request) {
        Either eitherResult = this.goodsFacade.syncTaxPlateGoods(request);
        if (eitherResult.isLeft()) {
            return Response.from((Integer)Response.Fail, (String)((String)eitherResult.getLeft()), null);
        }
        return Response.from((Integer)Response.OK, (String)((String)eitherResult.get()), null);
    }

    @GetMapping(value={"/goods/view-goods-module"})
    public Response<Boolean> viewGoodsModule() {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        Either eitherResult = this.goodsFacade.queryGoods(Long.valueOf(userInfo.getGroupId()), Integer.valueOf(1), Integer.valueOf(5));
        if (eitherResult.isLeft()) {
            return Response.from((Integer)Response.Fail, (String)((String)eitherResult.getLeft()), null);
        }
        Tuple2 tuple = (Tuple2)eitherResult.get();
        return Response.from((Integer)Response.OK, (String)"\u6210\u529f", (Object)((Integer)tuple._1() <= 0 ? 1 : 0));
    }
}

