/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.controllers.app;

import com.xforceplus.seller.config.client.model.PersonTitleDto;
import com.xforceplus.seller.config.config.annotation.APIV1Config;
import com.xforceplus.seller.config.services.ThirdPersonTitleService;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatsecurity.base.BaseAppController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@APIV1Config
public class PersonTitleController
extends BaseAppController {
    @Autowired
    private ThirdPersonTitleService thirdPersonTitleService;

    @PostMapping(value={"/person/edit"})
    public Response insertAndUpdate(@RequestBody PersonTitleDto dto) {
        if (dto == null) {
            return Response.failed((String)"\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        if (StringUtils.isEmpty((CharSequence)dto.getAliUserId()) && StringUtils.isEmpty((CharSequence)dto.getWxOpenId())) {
            return Response.failed((String)"\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        if (dto.getId() == null) {
            this.thirdPersonTitleService.insertPerson(dto);
        } else {
            this.thirdPersonTitleService.updatePerson(dto);
        }
        return Response.ok((String)"\u53d8\u66f4\u6210\u529f");
    }

    @PostMapping(value={"/person/query"})
    public Response query(@RequestBody PersonTitleDto dto) {
        if (dto == null) {
            return Response.failed((String)"\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        if (StringUtils.isEmpty((CharSequence)dto.getAliUserId()) && StringUtils.isEmpty((CharSequence)dto.getWxOpenId())) {
            return Response.failed((String)"\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        List list = this.thirdPersonTitleService.query(dto);
        return Response.ok((String)"\u67e5\u8be2\u6210\u529f", (Object)list);
    }

    @PostMapping(value={"/person/delete"})
    public Response delete(@RequestBody PersonTitleDto dto) {
        if (dto == null || dto.getId() == null) {
            return Response.failed((String)"\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        this.thirdPersonTitleService.deletePerson(dto);
        return Response.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/person/cancelDefault"})
    public Response cancelDefaultByOpenIdOrUserId(@RequestBody PersonTitleDto dto) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{dto.getAliUserId(), dto.getWxOpenId()})) {
            return Response.failed((String)"\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        this.thirdPersonTitleService.cancelDefaultByOpenIdOrUserId(dto.getAliUserId(), dto.getWxOpenId());
        return Response.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }
}

