/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.controllers.app;

import com.xforceplus.seller.config.models.SqsModel;
import com.xforceplus.xplat.aws.sqs.SqsService;
import com.xforceplus.xplatframework.model.Response;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.wicp.tams.common.Result;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/config/sqs"})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/xforceplus/seller/config/controllers/app/SendToSqsController;", "", "sqsService", "Lcom/xforceplus/xplat/aws/sqs/SqsService;", "(Lcom/xforceplus/xplat/aws/sqs/SqsService;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "sendCooperation", "Lcom/xforceplus/xplatframework/model/Response;", "Lnet/wicp/tams/common/Result;", "queueName", "", "model", "Lcom/xforceplus/seller/config/models/SqsModel;", "seller-config-service"})
public class SendToSqsController {
    @NotNull
    private final SqsService sqsService;
    private final Logger log;

    public SendToSqsController(@NotNull SqsService sqsService) {
        Intrinsics.checkNotNullParameter((Object)sqsService, (String)"sqsService");
        this.sqsService = sqsService;
        this.log = LoggerFactory.getLogger(SendToSqsController.class);
    }

    @PostMapping(value={"send/{queueName}"})
    @NotNull
    public Response<Result> sendCooperation(@PathVariable(value="queueName") @NotNull String queueName, @RequestBody @NotNull SqsModel model) {
        Response response2;
        Intrinsics.checkNotNullParameter((Object)queueName, (String)"queueName");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        try {
            String string = model.getMessage();
            Map map = model.getProperties();
            if (map == null) {
                map = new LinkedHashMap();
            }
            Result result = this.sqsService.sendStrMsg(queueName, string, map);
            Response response3 = Response.from((Integer)1, (String)"\u8c03\u7528sqs\u6210\u529f", (Object)result);
            Intrinsics.checkNotNullExpressionValue((Object)response3, (String)"{\n            val result\u2026sqs\u6210\u529f\", result)\n        }");
            response2 = response3;
        }
        catch (Exception e) {
            this.log.error("\u8c03\u7528sqs\u5f02\u5e38 " + e.getMessage() + ", " + e);
            Response response4 = Response.from((Integer)0, (String)e.getMessage(), null);
            Intrinsics.checkNotNullExpressionValue((Object)response4, (String)"{\n            log.error(\u2026.message, null)\n        }");
            response2 = response4;
        }
        return response2;
    }
}

