/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.controllers.app;

import com.google.common.collect.Lists;
import com.xforceplus.seller.config.client.api.TaxCodeNationalApi;
import com.xforceplus.seller.config.client.model.SearchModel;
import com.xforceplus.seller.config.client.model.TaxCodeVO;
import com.xforceplus.seller.config.client.model.TaxNationalCode;
import com.xforceplus.seller.config.client.model.TaxNationalCodeResponse;
import com.xforceplus.seller.config.config.annotation.APIV1Config;
import com.xforceplus.seller.config.facade.TaxNationalCodeFacade;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatsecurity.base.BaseAppController;
import io.jsonwebtoken.lang.Collections;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@APIV1Config
public class TaxCodeNationalController
extends BaseAppController
implements TaxCodeNationalApi {
    @Autowired
    private TaxNationalCodeFacade taxNationalCodeFacade;

    public TaxNationalCodeResponse getNationalTaxCodeByTaxCodeName(@RequestParam String taxCodeName) {
        return this.taxNationalCodeFacade.getNationalTaxCodeByTaxCodeName(taxCodeName);
    }

    public TaxNationalCodeResponse getNationalTaxCodeByGoodsTaxNo(@RequestParam String goodTaxNo) {
        return this.taxNationalCodeFacade.getNationalTaxCodeByGoodsTaxNo(goodTaxNo);
    }

    public Response getByGoodsTaxNo(@RequestBody SearchModel model) {
        ArrayList taxCodeList = Lists.newArrayList();
        String key = StringUtils.isNotEmpty((CharSequence)model.getKey()) ? model.getKey() : model.getKeyWord();
        TaxNationalCodeResponse nationalTaxCodeByGoodsTaxNo = this.taxNationalCodeFacade.getNationalTaxCodeByGoodsTaxNo(key);
        List result = nationalTaxCodeByGoodsTaxNo.getResult();
        for (TaxNationalCode taxNationalCode : result) {
            if (taxNationalCode.getEndFlag() != null && taxNationalCode.getEndFlag() == 0) continue;
            taxCodeList.add(new TaxCodeVO(taxNationalCode.getTaxcodeName(), taxNationalCode.getGoodsTaxNo(), taxNationalCode.getTaxRate()));
        }
        Response response2 = new Response();
        if (Collections.isEmpty((Collection)result)) {
            return Response.failed((String)"\u672a\u67e5\u8be2\u5230\u7a0e\u52a1\u7f16\u7801");
        }
        return Response.ok((String)"\u67e5\u8be2\u6210\u529f", (Object)taxCodeList);
    }

    public TaxNationalCode getNationalTaxCode(@ApiParam(value="\u7a0e\u6536\u5206\u7c7b\u7f16\u7801", required=true) @RequestParam(value="goodTaxNo", required=true) @NotNull String goodTaxNo) {
        return this.taxNationalCodeFacade.getNationalTaxCode(goodTaxNo);
    }

    @ApiOperation(value="\u6839\u636e\u7a0e\u7f16\u67e5\u8be2\u56fd\u7a0e\u6570\u636e(\u6a21\u7cca\u5339\u914d)", notes="", response=TaxNationalCode.class, authorizations={@Authorization(value="x-access-token")}, tags={"TaxCodeNational"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u4e0a\u4f20\u7ed3\u679c", response=TaxNationalCode.class)})
    @RequestMapping(value={"/taxCodeNational/query"}, produces={"application/json"}, method={RequestMethod.GET})
    public Response<List<TaxNationalCode>> getNationalTaxCodeByCodeOrName(@Param(value="taxCodeKeyWord") String taxCodeKeyWord) {
        Object[] objectArray = new Function[2];
        objectArray[0] = arg_0 -> ((TaxNationalCodeFacade)this.taxNationalCodeFacade).getNationalTaxCodeByGoodsTaxNo(arg_0);
        objectArray[1] = arg_0 -> ((TaxNationalCodeFacade)this.taxNationalCodeFacade).getNationalTaxCodeByTaxCodeName(arg_0);
        List bothResponse = Lists.newArrayList((Object[])objectArray).parallelStream().map(r -> (TaxNationalCodeResponse)r.apply(taxCodeKeyWord)).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(bothResponse)) {
            return Response.from((Integer)Response.OK, (String)"\u6210\u529f", (Object)Lists.newArrayList());
        }
        List result = bothResponse.stream().filter(r -> Response.OK.equals(r.getCode())).flatMap(r -> r.getResult().stream()).distinct().collect(Collectors.toList());
        return Response.from((Integer)Response.OK, (String)"\u6210\u529f", result);
    }
}

