/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.controllers.service;

import com.google.common.collect.Maps;
import com.xforceplus.seller.config.client.annotation.MSApiV1SellerConfig;
import com.xforceplus.seller.config.client.api.ConfigImportReasonApi;
import com.xforceplus.seller.config.client.model.ImportReasonRequest;
import com.xforceplus.seller.config.client.model.MsConfigQueryRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigUserIssuerRelationData;
import com.xforceplus.seller.config.client.model.PageQueryData;
import com.xforceplus.seller.config.core.enums.ConfigTypeEnum;
import com.xforceplus.seller.config.facade.TerminalDeviceFacade;
import com.xforceplus.seller.config.services.ImportReasonTools;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.apimodel.file.ImportResponse;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@MSApiV1SellerConfig
public class ImportReasonController
implements ConfigImportReasonApi {
    private static final Logger log = LoggerFactory.getLogger(ImportReasonController.class);
    @Autowired
    UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    ImportReasonTools importReasonTools;
    @Autowired
    private TerminalDeviceFacade terminalDeviceFacade;

    public Response generateConfigImportReason(@RequestBody ImportReasonRequest reasonRequest) {
        log.info("\u5bfc\u5165\u914d\u7f6e.\u751f\u6210\u9519\u8befexcl\u6587\u4ef6");
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        log.info("importBatchNo:{}", (Object)reasonRequest.getImportBatchNo());
        log.info("fileOriginName:{}", (Object)reasonRequest.getOriginFileName());
        log.info("configType:{}", (Object)reasonRequest.getConfigType());
        HashMap headers = Maps.newHashMap();
        headers.put("importBatchNo", Long.parseLong(reasonRequest.getImportBatchNo()));
        headers.put("userInfo", JsonUtils.writeObjectToJson((Object)userInfo));
        headers.put("fileOriginName", reasonRequest.getOriginFileName());
        headers.put("configType", reasonRequest.getConfigType());
        return this.importReasonTools.handleUploadMsg((Map)headers);
    }

    public ImportResponse getImportResult(@RequestParam(value="importBatchNo", required=false) Long importBatchNo) {
        return this.importReasonTools.queryResult(importBatchNo);
    }

    public ImportResponse getBusinessConfigImportResult(@RequestParam(value="importBatchNo", required=false) Long importBatchNo) {
        return this.importReasonTools.queryBusinessConfigResult(importBatchNo);
    }

    public Response exportConfig(@RequestBody MsConfigQueryRequestWithUserInfo request) {
        if (!ConfigTypeEnum.INVOICE_INFO_CONFIG.getConfigType().equals(request.getConfigType())) {
            return Response.failed((String)"\u53ea\u652f\u6301\u5f00\u7968\u62ac\u5934\u89c4\u5219\u7684\u5bfc\u51fa");
        }
        this.importReasonTools.exportConfig(request, (UserInfo)this.userInfoHolder.get());
        return Response.ok((String)"\u5bfc\u51fa\u4fe1\u606f\u5df2\u53d1\u9001, \u7a0d\u540e\u5728\u6d88\u606f\u4e2d\u5fc3\u67e5\u770b");
    }

    public Response<Long> getUserIssuerRelationCount(@RequestBody MsConfigUserIssuerRelationData.MsConfigUserIssuerRelationConditionRequest request) {
        log.info("getUserIssuerRelationCount request {}", (Object)JsonUtils.writeObjectToJson((Object)request));
        if (Optional.ofNullable(request.getTenantId()).orElse(0L) <= 0L) {
            return Response.from((Integer)0, (String)"\u79df\u6237Id\u53c2\u6570\u5fc5\u4f20");
        }
        long count = this.terminalDeviceFacade.countUserIssuerRelationByCondition(request);
        return Response.ok((String)"\u6210\u529f", (Object)count);
    }

    public Response<PageQueryData<MsConfigUserIssuerRelationData.UserIssuerRelationVo>> queryUserIssuerRelationList(@RequestBody MsConfigUserIssuerRelationData.MsConfigUserIssuerRelationConditionRequest request) {
        log.info("queryUserIssuerRelationList request {}", (Object)JsonUtils.writeObjectToJson((Object)request));
        if (Optional.ofNullable(request.getTenantId()).orElse(0L) <= 0L) {
            return Response.from((Integer)0, (String)"\u79df\u6237Id\u53c2\u6570\u5fc5\u4f20");
        }
        List result = this.terminalDeviceFacade.queryUserIssuerRelationList(request);
        return Response.from((Integer)Response.OK, (String)"\u6210\u529f", (Object)new PageQueryData(Long.valueOf(0L), result));
    }

    public ImportResponse getImportUserIssuerRelationResult(@RequestParam(value="importBatchNo", required=true) Long importBatchNo) {
        return this.terminalDeviceFacade.queryUserIssuerRelationImportResult(importBatchNo);
    }
}

