/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.controllers.service;

import com.xforceplus.phoenix.infrastructure.usercenter.model.CompanyData;
import com.xforceplus.seller.config.client.annotation.MSApiV1SellerConfig;
import com.xforceplus.seller.config.client.api.ConfigApi;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.constant.StatusEnum;
import com.xforceplus.seller.config.client.model.ConfigCompanyNameRequest;
import com.xforceplus.seller.config.client.model.ConfigOperatorRequest;
import com.xforceplus.seller.config.client.model.ConfigTtitleRequest;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.client.model.MsConfigDeleteRequstWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigItemAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigItemBatchQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigItemQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigItemResponse;
import com.xforceplus.seller.config.client.model.MsConfigMailRuleResponse;
import com.xforceplus.seller.config.client.model.MsConfigPageDTO;
import com.xforceplus.seller.config.client.model.MsConfigQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigQueryRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigResponse;
import com.xforceplus.seller.config.client.model.MsConfigSummaryDTO;
import com.xforceplus.seller.config.client.model.MsConfigSummaryResponse;
import com.xforceplus.seller.config.client.model.MsResponse;
import com.xforceplus.seller.config.client.translater.MsConfigQueryRequestTranslater;
import com.xforceplus.seller.config.common.UserCheckUtils;
import com.xforceplus.seller.config.models.InvoiceLimitRequest;
import com.xforceplus.seller.config.services.ConfigBizConfigService;
import com.xforceplus.seller.config.services.ConfigService;
import com.xforceplus.seller.config.util.StringUtil;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.utils.JsonUtils;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;

@MSApiV1SellerConfig
public class MsConfigController
implements ConfigApi {
    private static final Logger logger = LoggerFactory.getLogger(MsConfigController.class);
    @Autowired
    private ConfigBizConfigService configBizConfigService;
    @Autowired
    private ConfigService configService;

    public MsResponse deleteConfig(@ApiParam(value="\u67e5\u8be2\u914d\u7f6e\u660e\u7ec6") @RequestBody MsConfigDeleteRequstWithUserInfo msConfigDeleteRequst) {
        MsCommonUserInfo userInfo = msConfigDeleteRequst.getUserInfo();
        MsResponse msResponse = this.isLogin(userInfo);
        if (null != msResponse) {
            return msResponse;
        }
        msResponse = new MsResponse();
        try {
            this.configBizConfigService.deleteCfgConfig(msConfigDeleteRequst, userInfo.getUserId());
            msResponse.setCode(Response.OK);
            msResponse.setMessage("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            msResponse.setCode(Response.Fail);
            msResponse.setMessage(e.getMessage());
            e.printStackTrace();
        }
        return msResponse;
    }

    public MsConfigItemResponse queryConfigDetailRule(@ApiParam(value="\u67e5\u8be2\u914d\u7f6e\u660e\u7ec6") @RequestBody MsConfigItemQueryRequest msConfigItemQueryRequest) {
        List result = this.configBizConfigService.queryConfigItemList(msConfigItemQueryRequest);
        MsConfigItemResponse msConfigItemResponse = new MsConfigItemResponse();
        msConfigItemResponse.setCode(Response.OK);
        msConfigItemResponse.setResult(result);
        return msConfigItemResponse;
    }

    public MsConfigItemResponse batchQueryConfigDetailRule(@RequestBody MsConfigItemBatchQueryRequest msConfigItemBatchQueryRequest) {
        List result = this.configBizConfigService.batchQueryConfigItemList(msConfigItemBatchQueryRequest);
        MsConfigItemResponse msConfigItemResponse = new MsConfigItemResponse();
        msConfigItemResponse.setCode(Response.OK);
        msConfigItemResponse.setResult(result);
        return msConfigItemResponse;
    }

    public MsConfigResponse queryConfigRule(@ApiParam(value="\u7528\u6237\u67e5\u8be2\u914d\u7f6e") @RequestBody MsConfigQueryRequestWithUserInfo msConfigQueryRequestWithUserInfo) {
        MsConfigResponse msConfigResponse = new MsConfigResponse();
        MsResponse response2 = this.isLogin(msConfigQueryRequestWithUserInfo.getUserInfo());
        if (null != response2) {
            msConfigResponse.setCode(response2.getCode());
            msConfigResponse.setMessage(response2.getMessage());
            return msConfigResponse;
        }
        MsConfigQueryRequest msConfigQueryRequest = MsConfigQueryRequestTranslater.MsConfigQueryRequestWithUser2MsConfigQueryRequest((MsConfigQueryRequestWithUserInfo)msConfigQueryRequestWithUserInfo);
        MsConfigPageDTO msConfigPageDTO = this.configBizConfigService.queryConfigList(msConfigQueryRequest, msConfigQueryRequestWithUserInfo.getUserInfo().getGroupId());
        msConfigResponse.setCode(Response.OK);
        msConfigResponse.setResult(msConfigPageDTO);
        return msConfigResponse;
    }

    public MsConfigSummaryResponse queryConfigSummary(@ApiParam(value="\u7528\u6237\u67e5\u8be2\u914d\u7f6e") @RequestBody MsConfigQueryRequestWithUserInfo msConfigQueryRequestWithUserInfo) {
        MsConfigSummaryResponse msConfigSummaryResponse = new MsConfigSummaryResponse();
        logger.info("queryConfigSummary=======msConfigQueryRequestWithUserInfo:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigQueryRequestWithUserInfo));
        MsResponse response2 = this.isLogin(msConfigQueryRequestWithUserInfo.getUserInfo());
        if (null != response2) {
            msConfigSummaryResponse.setCode(response2.getCode());
            msConfigSummaryResponse.setMessage(response2.getMessage());
            return msConfigSummaryResponse;
        }
        MsConfigQueryRequest msConfigQueryRequest = MsConfigQueryRequestTranslater.MsConfigQueryRequestWithUser2MsConfigQueryRequest((MsConfigQueryRequestWithUserInfo)msConfigQueryRequestWithUserInfo);
        StatusEnum[] configStatusEnums = StatusEnum.values();
        ArrayList<MsConfigSummaryDTO> result = new ArrayList<MsConfigSummaryDTO>();
        for (StatusEnum configStatusEnum : configStatusEnums) {
            MsConfigQueryRequest request = new MsConfigQueryRequest();
            BeanUtils.copyProperties((Object)msConfigQueryRequest, (Object)request);
            request.setStatus(configStatusEnum.getStatus());
            int count = this.configBizConfigService.queryConfigCount(request, msConfigQueryRequestWithUserInfo.getUserInfo().getGroupId());
            logger.info("queryConfigSummary=======count:{}, configStatusEnum.getStatus():{}, request:{}", new Object[]{count, configStatusEnum.getStatus(), JsonUtils.writeObjectToFastJson((Object)request)});
            MsConfigSummaryDTO msConfigSummaryDTO = new MsConfigSummaryDTO();
            msConfigSummaryDTO.setCode(String.valueOf(configStatusEnum.getStatus()));
            msConfigSummaryDTO.setCount(Integer.valueOf(count));
            msConfigSummaryDTO.setName(configStatusEnum.getStatusDesc());
            result.add(msConfigSummaryDTO);
        }
        msConfigSummaryResponse.setCode(Response.OK);
        msConfigSummaryResponse.setResult(result);
        return msConfigSummaryResponse;
    }

    public MsResponse saveConfigDetailRule(@ApiParam(value="\u4fdd\u5b58\u914d\u7f6e\u660e\u7ec6") @RequestBody MsConfigItemAddRequestWithUserInfo msConfigItemAddRequest) {
        MsResponse response2 = this.isLogin(msConfigItemAddRequest.getUserInfo());
        if (null != response2) {
            return response2;
        }
        response2 = new MsResponse();
        try {
            this.configBizConfigService.addCfgConfigItem(msConfigItemAddRequest, null, new String[0]);
            response2.setCode(Response.OK);
        }
        catch (Exception e) {
            response2.setCode(Response.Fail);
            response2.setMessage(e.getMessage());
            e.printStackTrace();
        }
        return response2;
    }

    public MsResponse saveConfigRule(@ApiParam(value="\u65b0\u589e\u8bf7\u6c42") @RequestBody MsConfigAddRequestWithUserInfo msConfigAddRequest) {
        MsResponse msResponse = this.isLogin(msConfigAddRequest.getUserInfo());
        if (null != msResponse) {
            return msResponse;
        }
        msResponse = new MsResponse();
        try {
            Response response2 = this.configBizConfigService.addCfgConfig(msConfigAddRequest, new String[0]);
            logger.info("saveConfigRule response====>{}", (Object)JsonUtils.writeObjectToFastJson((Object)response2));
            msResponse.setCode(response2.getCode());
            msResponse.setMessage(response2.getMessage());
        }
        catch (Exception e) {
            msResponse.setCode(Response.Fail);
            msResponse.setMessage(e.getMessage());
            logger.error("saveConfigRule  error ", (Throwable)e);
        }
        return msResponse;
    }

    public MsResponse getInvoiceLimit(@ApiParam(value="\u540c\u6b65\u7528\u6237\u4e2d\u5fc3\u5f00\u7968\u9650\u989d", required=true) @RequestBody InvoiceLimitRequest request) {
        MsResponse msResponse = new MsResponse();
        CompanyData data = this.configBizConfigService.getCompanyInvoiceLimit(request.getTenantId(), request.getSellerTaxNo());
        msResponse.setCode(Response.OK);
        msResponse.setMessage("\u67e5\u8be2\u6210\u529f");
        msResponse.setResult((Object)data);
        if (data == null) {
            msResponse.setCode(Response.Fail);
            msResponse.setMessage("\u67e5\u8be2\u5931\u8d25");
        } else {
            logger.info("getInvoiceLimit response====>{}", (Object)JsonUtils.writeObjectToFastJson((Object)data));
        }
        return msResponse;
    }

    private MsResponse isLogin(MsCommonUserInfo msCommonUserInfo) {
        MsResponse response2 = null;
        if (!UserCheckUtils.userCheck((MsCommonUserInfo)msCommonUserInfo)) {
            response2 = new MsResponse();
            response2.setCode(Response.Fail);
            response2.setMessage("\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55");
            return response2;
        }
        return response2;
    }

    public Response updateConfigOperator(@ApiParam(value="\u7968\u9762\u4eba\u4fe1\u606f") @RequestBody ConfigOperatorRequest configOperatorRequest) {
        return this.configService.updateConfigOperator(configOperatorRequest);
    }

    public Response updateConfigTtitle(@ApiParam(value="\u7968\u9762\u62ac\u5934\u4fe1\u606f") @RequestBody ConfigTtitleRequest configTtitleRequest) {
        return this.configService.updateConfigTtitle(configTtitleRequest);
    }

    public Response updateConfigCompanyName(@ApiParam(value="\u516c\u53f8\u4fe1\u606f") @RequestBody ConfigCompanyNameRequest configCompanyNameRequest) {
        return this.configService.updateConfigCompanyName(configCompanyNameRequest);
    }

    public Response<List<MsConfigBean>> queryConfigRuleItemListByItemName(@RequestBody MsConfigQueryRequestWithUserInfo msConfigQueryRequestWithUserInfo) {
        return this.configBizConfigService.queryConfigRuleItemListByItemName(msConfigQueryRequestWithUserInfo);
    }

    public MsConfigMailRuleResponse queryConfigMailRule(MsCommonUserInfo msCommonUserInfo, MsConfigQueryRequest msConfigQueryRequest) {
        MsConfigMailRuleResponse response2 = MsConfigMailRuleResponse.builder().build();
        if (!UserCheckUtils.userCheck((MsCommonUserInfo)msCommonUserInfo)) {
            response2.setCode(Response.Fail);
            response2.setMessage("\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55");
            return response2;
        }
        if (!this.checkMailRule(msConfigQueryRequest)) {
            response2.setCode(Response.Fail);
            response2.setMessage("\u83b7\u53d6\u90ae\u4ef6\u89c4\u5219\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
            return response2;
        }
        response2 = this.configBizConfigService.pullMailRuleConfig(msConfigQueryRequest.getConfigId());
        return response2;
    }

    private boolean checkMailRule(MsConfigQueryRequest msConfigQueryRequest) {
        if (null != msConfigQueryRequest && msConfigQueryRequest.getConfigId() != null && ConfigTypeEnum.INVOICE_MAIL_RULE_CONFIG_TYPE.getConfigType() == msConfigQueryRequest.getConfigType()) {
            return true;
        }
        logger.warn("@checkMailRule invalid request: " + StringUtil.describeBean((Object)msConfigQueryRequest));
        return false;
    }
}

