/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.controllers.service;

import com.xforceplus.seller.config.client.annotation.MSApiV1SellerConfig;
import com.xforceplus.seller.config.client.api.ConfigDeviceApi;
import com.xforceplus.seller.config.client.model.BuildCertificateRequest;
import com.xforceplus.seller.config.client.model.MsConfigDeviceAddRequest;
import com.xforceplus.seller.config.client.model.MsConfigDeviceAddResponse;
import com.xforceplus.seller.config.client.model.MsConfigDeviceGetCompanyListRequest;
import com.xforceplus.seller.config.client.model.MsConfigDeviceGetCompanyListResponse;
import com.xforceplus.seller.config.client.model.MsConfigDeviceQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigDeviceUpdateRequest;
import com.xforceplus.seller.config.client.model.MsConfigDeviceUpdateResponse;
import com.xforceplus.seller.config.client.model.MsConfigUpdateDeviceStatusRequest;
import com.xforceplus.seller.config.client.model.MsDeviceInfo;
import com.xforceplus.seller.config.client.model.MsDeviceSummaryQueryRequest;
import com.xforceplus.seller.config.client.model.MsDeviceSummaryQueryResponse;
import com.xforceplus.seller.config.client.model.MsQueryAllTaxDeviceByTaxDeviceTypesRequest;
import com.xforceplus.seller.config.client.model.MsQueryDeviceResponse;
import com.xforceplus.seller.config.client.model.MsResponse;
import com.xforceplus.seller.config.client.model.MsUpdateDeviceInfo;
import com.xforceplus.seller.config.client.model.QueryInventoryRequest;
import com.xforceplus.seller.config.client.model.QueryInventoryResult;
import com.xforceplus.seller.config.client.model.QueryRemarkLimitData;
import com.xforceplus.seller.config.client.model.QueryRemarkLimitRequest;
import com.xforceplus.seller.config.client.model.RemarkLimitData;
import com.xforceplus.seller.config.converters.TaxWareConverter;
import com.xforceplus.seller.config.facade.TerminalDeviceFacade;
import com.xforceplus.seller.config.services.ConfigDeviceService;
import com.xforceplus.xplatframework.apimodel.BaseResponse;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import io.vavr.control.Either;
import java.util.List;
import java.util.function.BiFunction;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@MSApiV1SellerConfig
public class MsConfigDeviceController
implements ConfigDeviceApi {
    private final ConfigDeviceService configDeviceService;
    private final UserInfoHolder<UserInfo> userInfoHolder;
    private final TerminalDeviceFacade terminalDeviceFacade;
    private final TaxWareConverter taxWareConverter;

    public MsConfigDeviceController(ConfigDeviceService configDeviceService, UserInfoHolder<UserInfo> userInfoHolder, TerminalDeviceFacade terminalDeviceFacade, TaxWareConverter taxWareConverter) {
        this.configDeviceService = configDeviceService;
        this.userInfoHolder = userInfoHolder;
        this.terminalDeviceFacade = terminalDeviceFacade;
        this.taxWareConverter = taxWareConverter;
    }

    public MsConfigDeviceAddResponse addDevice(@RequestBody MsConfigDeviceAddRequest configDeviceAddRequest) {
        BiFunction<Integer, String, MsConfigDeviceAddResponse> quickReturn = (code, message) -> {
            MsConfigDeviceAddResponse response2 = new MsConfigDeviceAddResponse();
            response2.setCode(code);
            response2.setMessage(message);
            return response2;
        };
        MsDeviceInfo msDeviceInfo = configDeviceAddRequest.getDeviceInfo();
        if (msDeviceInfo == null) {
            return quickReturn.apply(BaseResponse.Fail, "\u8bbe\u5907\u4fe1\u606f\u4e3a\u7a7a");
        }
        return this.configDeviceService.addDevice(configDeviceAddRequest);
    }

    public MsConfigDeviceGetCompanyListResponse configDeviceGetCompanyList(@RequestBody MsConfigDeviceGetCompanyListRequest configDeviceGetCompanyListRequest) {
        return this.configDeviceService.configDeviceGetCompanyList(configDeviceGetCompanyListRequest);
    }

    public MsDeviceSummaryQueryResponse deviceSummaryQuery(@RequestBody MsDeviceSummaryQueryRequest deviceSummaryQueryRequest) {
        return this.configDeviceService.deviceSummaryQuery(deviceSummaryQueryRequest, (UserInfo)this.userInfoHolder.get());
    }

    public MsQueryDeviceResponse getDeviceList(@RequestBody MsConfigDeviceQueryRequest request) {
        return this.configDeviceService.getDeviceList(request, (UserInfo)this.userInfoHolder.get(), false);
    }

    public MsQueryDeviceResponse queryAllTaxDeviceByTaxDeviceTypes(@RequestBody MsQueryAllTaxDeviceByTaxDeviceTypesRequest queryAllTaxDeviceByTaxDeviceTypesRequest) {
        if (queryAllTaxDeviceByTaxDeviceTypesRequest.getTaxDeviceTypes() == null || queryAllTaxDeviceByTaxDeviceTypesRequest.getTaxDeviceTypes().isEmpty()) {
            return new MsQueryDeviceResponse().code(BaseResponse.Fail).message("\u8bbe\u5907\u7c7b\u578b\u4e3a\u7a7a");
        }
        return this.configDeviceService.queryAllTaxDeviceByTaxDeviceTypes(queryAllTaxDeviceByTaxDeviceTypesRequest, (UserInfo)this.userInfoHolder.get());
    }

    public MsConfigDeviceUpdateResponse updateDevice(@RequestBody MsConfigDeviceUpdateRequest configDeviceUpdateRequest) {
        BiFunction<Integer, String, MsConfigDeviceUpdateResponse> quickReturn = (code, message) -> {
            MsConfigDeviceUpdateResponse response2 = new MsConfigDeviceUpdateResponse();
            response2.setCode(code);
            response2.setMessage(message);
            return response2;
        };
        MsUpdateDeviceInfo msUpdateDeviceInfo = configDeviceUpdateRequest.getDeviceInfo();
        Long deviceId = msUpdateDeviceInfo.getId();
        if (deviceId == null || deviceId < 1L) {
            return quickReturn.apply(BaseResponse.Fail, "\u4e0d\u80fd\u4f20\u5165\u7a7a\u8bbe\u5907Id");
        }
        return this.configDeviceService.updateDevice(configDeviceUpdateRequest);
    }

    public MsResponse updateStatus(@RequestBody MsConfigUpdateDeviceStatusRequest request) {
        BiFunction<Integer, String, MsResponse> quickReturn = (code, message) -> {
            MsResponse response2 = new MsResponse();
            response2.setCode(code);
            response2.setMessage(message);
            return response2;
        };
        List deviceIdList = request.getDeviceId();
        if (deviceIdList == null || deviceIdList.isEmpty()) {
            return quickReturn.apply(BaseResponse.Fail, "\u66f4\u65b0\u7684ip\u5217\u8868\u4e3a\u7a7a");
        }
        Integer updateStatus = request.getStatus();
        if (updateStatus == null || !updateStatus.equals(12) && !updateStatus.equals(11) && !updateStatus.equals(21) && !updateStatus.equals(22)) {
            return quickReturn.apply(BaseResponse.Fail, "\u8f93\u5165\u72b6\u6001\u4e0d\u6b63\u786e!");
        }
        return this.configDeviceService.updateStatus(request);
    }

    public Response<List<QueryRemarkLimitData>> getRemarkLengthBySplitRuleIds(@RequestBody QueryRemarkLimitRequest request) {
        return Response.from((Integer)Response.OK, (String)"\u6210\u529f", (Object)this.configDeviceService.getRemarkLengthBySplitRuleIds(request));
    }

    public Response<List<RemarkLimitData>> getRemarkLengthByDeviceUn(@RequestParam(value="deviceUn") String deviceUn) {
        return Response.from((Integer)Response.OK, (String)"\u6210\u529f", (Object)this.configDeviceService.getRemarkLengthByDeviceUn(deviceUn));
    }

    public Response<List<QueryInventoryResult>> queryInventory(@RequestBody QueryInventoryRequest request) {
        Either eitherResult = this.terminalDeviceFacade.queryInventory(request);
        if (eitherResult.isLeft()) {
            return Response.from((Integer)0, (String)((String)eitherResult.getLeft()), null);
        }
        return Response.from((Integer)1, (String)"\u6210\u529f", (Object)eitherResult.get());
    }

    public Response<Object> generateCertificatePost(@RequestBody BuildCertificateRequest request) {
        Either eitherResult = this.terminalDeviceFacade.generateCertificatePost(this.taxWareConverter.convert(request));
        if (eitherResult.isLeft()) {
            return Response.from((Integer)0, (String)((String)eitherResult.getLeft()), null);
        }
        return Response.from((Integer)1, (String)"\u6210\u529f", null);
    }
}

