/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.controllers.service;

import com.google.common.collect.Lists;
import com.xforceplus.seller.config.client.annotation.MSApiV1SellerConfig;
import com.xforceplus.seller.config.client.api.MetaApi;
import com.xforceplus.seller.config.client.model.MsBusinessObjBean;
import com.xforceplus.seller.config.client.model.MsBusinessObjRequest;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import com.xforceplus.seller.config.client.model.MsGroupTypeBean;
import com.xforceplus.seller.config.client.model.MsGroupTypeDTO;
import com.xforceplus.seller.config.client.model.MsGroupTypeMetaDataResponse;
import com.xforceplus.seller.config.client.model.MsGroupTypeResponse;
import com.xforceplus.seller.config.client.model.MsMataDataAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsMataDataBatchQueryRequest;
import com.xforceplus.seller.config.client.model.MsMataDataDeleteRequest;
import com.xforceplus.seller.config.client.model.MsMataDataDeleteRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsMataDataQueryRequest;
import com.xforceplus.seller.config.client.model.MsMataItemDataQueryRequest;
import com.xforceplus.seller.config.client.model.MsMetaDataPageDTO;
import com.xforceplus.seller.config.client.model.MsMetaDataResponse;
import com.xforceplus.seller.config.client.model.MsMetaDataSummaryResponse;
import com.xforceplus.seller.config.client.model.MsMetadataItemAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsMetadataItemQueryRequest;
import com.xforceplus.seller.config.client.model.MsMetadataItemResponse;
import com.xforceplus.seller.config.client.model.MsQueryHighlightFieldListResponse;
import com.xforceplus.seller.config.client.model.MsResponse;
import com.xforceplus.seller.config.common.UserCheckUtils;
import com.xforceplus.seller.config.converters.MetaDataObjTranslater;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjEntity;
import com.xforceplus.seller.config.services.ConfigMetaDataService;
import com.xforceplus.seller.config.services.ConfigMetaDataServiceKt;
import com.xforceplus.seller.config.services.MetaDataQueryBusiness;
import com.xforceplus.seller.config.util.DingDingUtils;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatframework.utils.JsonUtils;
import com.xforceplus.xplatsecurity.base.BaseMicroController;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@MSApiV1SellerConfig
@RestController
public class MsConfigMetaDataController
extends BaseMicroController
implements MetaApi {
    @Autowired
    private ConfigMetaDataService configMetaDataService;
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    private MetaDataQueryBusiness metaDataQueryBusiness;
    @Autowired
    private ConfigMetaDataServiceKt configMetaDataServiceKt;
    @Value(value="${ap.bill.allow.query.salesBillType:1203939049971830784@123}")
    private String allowQuerySalesBillType;
    @Autowired
    DingDingUtils dingDingUtils;

    public MsMetadataItemResponse batchQueryWithObjCodeFiledName(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", required=true) @RequestBody MsMataDataBatchQueryRequest mataDataBatchQueryRequest) {
        List msBusinessObjMetadataBeanList = this.configMetaDataService.batchQueryWithObjCodeFiledName(mataDataBatchQueryRequest);
        MsMetadataItemResponse response2 = new MsMetadataItemResponse();
        response2.setCode(Response.OK);
        response2.setResult(msBusinessObjMetadataBeanList);
        return response2;
    }

    public MsResponse metaDataDelete(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61\u5220\u9664", required=true) @RequestBody MsMataDataDeleteRequestWithUserInfo mataDataDeleteRequest) {
        MsResponse response2 = new MsResponse();
        MsCommonUserInfo msCommonUserInfo = mataDataDeleteRequest.getUserInfo();
        if (!UserCheckUtils.userCheck((MsCommonUserInfo)msCommonUserInfo)) {
            response2.setCode(Response.Fail);
            response2.setMessage("\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55");
            return response2;
        }
        try {
            this.configMetaDataService.deleteMetaData(mataDataDeleteRequest.getItems(), msCommonUserInfo);
            response2.setCode(Response.OK);
            return response2;
        }
        catch (RuntimeException e) {
            response2.setCode(Response.Fail);
            response2.setMessage(e.getMessage());
            return response2;
        }
    }

    public MsResponse bizorderRuleExist(MsMataDataDeleteRequest request) {
        MsResponse response2 = new MsResponse();
        Long groupId = Optional.ofNullable(this.userInfoHolder.get()).map(it -> it.getGroupId()).orElse(null);
        if (groupId == null) {
            return response2.code(Response.Fail).message("\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55");
        }
        if (CollectionUtils.isNotEmpty((Collection)request.getItems())) {
            try {
                request.getItems().forEach(it -> this.configMetaDataService.getCfgBusinessObjEntity(groupId, it));
            }
            catch (RuntimeException e) {
                return response2.code(Response.Fail).message(e.getMessage());
            }
        }
        return response2.code(Response.OK).message("\u6210\u529f");
    }

    public MsMetaDataSummaryResponse metaDataSummary(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", required=true) @RequestBody MsMataDataQueryRequest msMataDataQueryRequest) {
        List msMetaDataSummaryDTOs = this.configMetaDataService.metaDataSummary(msMataDataQueryRequest);
        MsMetaDataSummaryResponse response2 = new MsMetaDataSummaryResponse();
        response2.setCode(Response.OK);
        response2.setResult(msMetaDataSummaryDTOs);
        return response2;
    }

    public MsMetadataItemResponse queryEffctiveMetaData(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", required=true) @RequestBody MsMataDataQueryRequest mataDataQueryRequest) {
        List msBusinessObjMetadataBeanList = this.configMetaDataService.queryEffectiveMetaDataList(mataDataQueryRequest, null);
        MsMetadataItemResponse response2 = new MsMetadataItemResponse();
        response2.setCode(Response.OK);
        response2.setResult(msBusinessObjMetadataBeanList);
        return response2;
    }

    public MsMetadataItemResponse queryTemplateMetaData(@ApiParam(value="\u6a21\u677f\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", required=true) @RequestBody MsMataDataQueryRequest mataDataQueryRequest) {
        List msBusinessObjMetadataBeanList = this.configMetaDataService.queryTemplateMetaDataList(mataDataQueryRequest);
        MsMetadataItemResponse response2 = new MsMetadataItemResponse();
        response2.setCode(Response.OK);
        response2.setResult(msBusinessObjMetadataBeanList);
        return response2;
    }

    public MsGroupTypeMetaDataResponse queryGroupMetaDataWithObjType(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", required=true) @RequestBody MsMataDataQueryRequest groupId) {
        List result = this.configMetaDataService.queryMetaDataByObjType(groupId);
        MsGroupTypeMetaDataResponse msGroupTypeMetaDataResponse = new MsGroupTypeMetaDataResponse();
        msGroupTypeMetaDataResponse.setCode(Response.OK);
        msGroupTypeMetaDataResponse.setResult(result);
        return msGroupTypeMetaDataResponse;
    }

    public MsGroupTypeResponse queryAuthorizationBillTypeList(@ApiParam(value="\u67e5\u8be2\u5df2\u6388\u6743\u4e1a\u52a1\u5355\u7c7b\u578b\u5217\u8868\u4fe1\u606f", required=true) @RequestBody MsMataDataQueryRequest msMataDataQueryRequest) {
        List result = this.configMetaDataService.queryGroupObjType(msMataDataQueryRequest);
        MsGroupTypeResponse msGroupTypeResponse = new MsGroupTypeResponse();
        msGroupTypeResponse.setCode(Response.OK);
        this.logger.info("queryAuthorizationBillTypeList-request:{},{}", (Object)JsonUtils.writeObjectToFastJson((Object)msMataDataQueryRequest));
        Boolean skipAuth = msMataDataQueryRequest.getSkipAuth() != null && msMataDataQueryRequest.getSkipAuth() != false;
        this.logger.info("queryAuthorizationBillTypeList-result:{},{}", (Object)JsonUtils.writeObjectToFastJson((Object)result), (Object)skipAuth);
        if (StringUtils.equals((CharSequence)msMataDataQueryRequest.getRequestSource(), (CharSequence)"settledTemplate") && skipAuth.booleanValue()) {
            msGroupTypeResponse.setResult(result);
            return msGroupTypeResponse;
        }
        List<Object> skipResult = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)result) || skipAuth.booleanValue()) {
            String[] groups;
            Long groupId = msMataDataQueryRequest.getGroupId();
            for (String group : groups = this.allowQuerySalesBillType.split("%")) {
                String[] split = group.split("@");
                if (!String.valueOf(groupId).equals(split[0])) continue;
                Object[] salesbillTypes = split[1].split(",");
                ArrayList billTypeList = Lists.newArrayList((Object[])salesbillTypes);
                skipResult = result.stream().filter(it -> billTypeList.contains(it.getObjType()) || "\u4e1a\u52a1\u5355".equals(it.getObjType())).collect(Collectors.toList());
            }
            msGroupTypeResponse.setResult((List)skipResult);
            return msGroupTypeResponse;
        }
        this.logger.info("queryGroupObjType userInfoHolder {}", (Object)JsonUtils.writeObjectToFastJson((Object)this.userInfoHolder));
        if (Objects.isNull(this.userInfoHolder) || Objects.isNull(this.userInfoHolder.get())) {
            msGroupTypeResponse.setResult(result);
            return msGroupTypeResponse;
        }
        List ownObjTypeList = null;
        try {
            long userId = ((UserInfo)this.userInfoHolder.get()).getUserId();
            long groupId = msMataDataQueryRequest.getGroupId();
            ownObjTypeList = this.configMetaDataServiceKt.queryAuthorizedBillType(groupId, userId);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u83b7\u53d6\u7528\u6237\u4e2d\u5fc3\u4e1a\u52a1\u6269\u5c55\u5c5e\u6027\u5904\u7406\u5931\u8d25", (Throwable)e);
        }
        ArrayList filterResult = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(ownObjTypeList) && !CollectionUtils.isEmpty((Collection)result)) {
            for (MsGroupTypeBean msGroupTypeBean : result) {
                if (!ownObjTypeList.contains(msGroupTypeBean.getObjType())) continue;
                filterResult.add(msGroupTypeBean);
            }
        }
        msGroupTypeResponse.setResult((List)filterResult);
        return msGroupTypeResponse;
    }

    public MsGroupTypeResponse queryGroupObjType(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", required=true) @RequestBody MsMataDataQueryRequest msMataDataQueryRequest) {
        List result = this.configMetaDataService.queryGroupObjType(msMataDataQueryRequest);
        MsGroupTypeResponse msGroupTypeResponse = new MsGroupTypeResponse();
        msGroupTypeResponse.setCode(Response.OK);
        msGroupTypeResponse.setResult(result);
        return msGroupTypeResponse;
    }

    public MsMetaDataResponse queryMetaData(@ApiParam(value="\u4e1a\u52a1\u5bf9\u8c61\u4fdd\u5b58", required=true) @RequestBody MsMataDataQueryRequest mataDataQueryRequest) {
        List cfgBusinessObjEntities = this.configMetaDataService.queryMetaDataList(mataDataQueryRequest);
        ArrayList<MsBusinessObjBean> msBusinessObjBeans = new ArrayList<MsBusinessObjBean>();
        for (CfgBusinessObjEntity tmp : cfgBusinessObjEntities) {
            MsBusinessObjBean msBusinessObjBean = MetaDataObjTranslater.convertFromConfigEntity((CfgBusinessObjEntity)tmp);
            msBusinessObjBeans.add(msBusinessObjBean);
        }
        MsMetaDataPageDTO msMetaDataPageDTO = new MsMetaDataPageDTO();
        msMetaDataPageDTO.setResult(msBusinessObjBeans);
        Long count = this.configMetaDataService.queryMetaDataCount(mataDataQueryRequest);
        msMetaDataPageDTO.setTotal(Integer.valueOf(count.intValue()));
        msMetaDataPageDTO.setPageNo(mataDataQueryRequest.getPageNo());
        MsMetaDataResponse response2 = new MsMetaDataResponse();
        response2.setResult(msMetaDataPageDTO);
        response2.setCode(Response.OK);
        return response2;
    }

    public MsMetadataItemResponse queryMetaDataItem(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", required=true) @RequestBody MsMetadataItemQueryRequest metadataItemQueryRequest) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        if (userInfo == null || userInfo.getGroupId() == 0L) {
            if (metadataItemQueryRequest.getGroupId() != null) {
                userInfo = new UserInfo();
                userInfo.setGroupId(metadataItemQueryRequest.getGroupId().longValue());
            }
            String businessId = String.valueOf(metadataItemQueryRequest.getBusinessObjId());
            this.dingDingUtils.sendMsgMarkDownWarn(businessId, "", businessId, "\u67e5\u8be2\u5143\u6570\u636e\u65e0\u4e0a\u4e0b\u6587\u4fe1\u606f", "");
        }
        this.logger.info("queryMetaDataItem metadataItemQueryRequest==========={}", (Object)JsonUtils.writeObjectToFastJson((Object)metadataItemQueryRequest));
        List msBusinessObjMetadataBeanList = this.configMetaDataService.queryMetaDataItemListByObjId(userInfo == null ? null : Long.valueOf(userInfo.getGroupId()), metadataItemQueryRequest.getBusinessObjId());
        this.logger.debug("queryMetaDataItem msBusinessObjMetadataBeanList==========={}", (Object)JsonUtils.writeObjectToFastJson((Object)msBusinessObjMetadataBeanList));
        MsMetadataItemResponse msMetadataItemResponse = new MsMetadataItemResponse();
        msMetadataItemResponse.setCode(Response.OK);
        msMetadataItemResponse.setResult(msBusinessObjMetadataBeanList);
        return msMetadataItemResponse;
    }

    public MsResponse saveMetaData(@ApiParam(value="\u4e1a\u52a1\u5bf9\u8c61\u4fdd\u5b58", required=true) @RequestBody MsMataDataAddRequestWithUserInfo mataDataAddRequest) {
        MsResponse response2 = new MsResponse();
        MsCommonUserInfo msCommonUserInfo = mataDataAddRequest.getUserInfo();
        if (!UserCheckUtils.userCheck((MsCommonUserInfo)msCommonUserInfo)) {
            response2.setCode(Response.Fail);
            response2.setMessage("\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55.");
            return response2;
        }
        try {
            int isOk = this.configMetaDataService.addMetaObjData(mataDataAddRequest);
            if (isOk == Response.OK) {
                response2.setCode(Response.OK);
            } else {
                response2.setCode(Response.Fail);
                response2.setMessage("\u4e1a\u52a1\u5bf9\u8c61\u4fdd\u5b58\u5931\u8d25.");
            }
        }
        catch (Exception e) {
            response2.setCode(Response.Fail);
            response2.setMessage(e.getMessage());
        }
        return response2;
    }

    public MsResponse saveMetaDataItem(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", required=true) @RequestBody MsMetadataItemAddRequestWithUserInfo metadataItemAddRequest) {
        MsResponse msResponse = new MsResponse();
        MsCommonUserInfo userInfo = metadataItemAddRequest.getUserInfo();
        if (!UserCheckUtils.userCheck((MsCommonUserInfo)userInfo)) {
            msResponse.setCode(Response.Fail);
            msResponse.setMessage("\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55");
            return msResponse;
        }
        this.configMetaDataService.addMetaDataItem(metadataItemAddRequest);
        msResponse.setCode(Response.OK);
        return msResponse;
    }

    public MsQueryHighlightFieldListResponse queryHighlightFieldList(@NotNull @ApiParam(value="\u6a21\u677f\u7f16\u7801", required=true) @RequestParam(value="objCode", required=true) String objCode, @NotNull @ApiParam(value="\u5355\u636e\u5bf9\u8c61\u7c7b\u578b", required=true) @RequestParam(value="objType", required=true) String objType, @ApiParam(value="\u96c6\u56e2id") @RequestParam(value="groupId", required=false) Long groupId) {
        if (Objects.isNull(groupId) || groupId == 0L) {
            groupId = ((UserInfo)this.userInfoHolder.get()).getGroupId();
        }
        List msHighlightFieldDTOList = this.configMetaDataService.queryHighlightFieldList(objCode, objType, groupId);
        MsQueryHighlightFieldListResponse msQueryHighlightFieldListResponse = new MsQueryHighlightFieldListResponse();
        msQueryHighlightFieldListResponse.setCode(Response.OK);
        msQueryHighlightFieldListResponse.setMessage("ok");
        msQueryHighlightFieldListResponse.setResult(msHighlightFieldDTOList);
        return msQueryHighlightFieldListResponse;
    }

    public Response queryMetaObjMetadata(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", required=true) @RequestBody MsMataItemDataQueryRequest msMataItemDataQueryRequest) {
        Long groupId = msMataItemDataQueryRequest.getGroupId();
        if (groupId == null) {
            msMataItemDataQueryRequest.setGroupId(Long.valueOf(((UserInfo)this.userInfoHolder.get()).getGroupId()));
        }
        return this.configMetaDataService.queryMetaObjMetadata(msMataItemDataQueryRequest);
    }

    public Response queryMetaObj(@ApiParam(value="\u67e5\u8be2\u5143\u6570\u636e\u4e3b\u5bf9\u8c61", required=true) @RequestBody MsBusinessObjRequest msBusinessObjRequest) {
        return this.configMetaDataService.queryMetaObj(msBusinessObjRequest.getBusinessObjId(), msBusinessObjRequest.getGroupId());
    }

    public Response addOrUpdateMetaObjData(@ApiParam(value="\u4fdd\u5b58\u6216\u66f4\u65b0\u5143\u6570\u636e\u5bf9\u8c61", required=true) @RequestBody MsBusinessObjBean msBusinessObjBean) {
        Long groupId = msBusinessObjBean.getGroupId();
        Long userId = null;
        if (groupId == null) {
            msBusinessObjBean.setGroupId(Long.valueOf(((UserInfo)this.userInfoHolder.get()).getGroupId()));
            userId = ((UserInfo)this.userInfoHolder.get()).getUserId();
        }
        return this.configMetaDataService.addOrUpdateMetaObjData(msBusinessObjBean, userId);
    }

    public MsGroupTypeResponse queryGroupObjType4local(@ApiParam(value="\u5143\u6570\u636e\u5bf9\u8c61\u67e5\u8be2", required=true) @RequestBody MsMataDataQueryRequest groupId) {
        List result = this.configMetaDataService.queryGroupObjType(groupId);
        MsGroupTypeResponse msGroupTypeResponse = new MsGroupTypeResponse();
        msGroupTypeResponse.setCode(Response.OK);
        msGroupTypeResponse.setResult(result);
        return msGroupTypeResponse;
    }

    public Response<List<MsGroupTypeDTO>> getMetaDataList(@RequestParam(value="tenantId", required=true) Long tenantId, @RequestParam(value="needDetailExt", required=true) boolean needDetailExt, @RequestParam(value="needNotEnumExt", required=true) boolean needNotEnumExt) {
        Response response2 = new Response();
        response2.setCode(Response.OK);
        response2.setResult((Object)this.metaDataQueryBusiness.getMetaDataList(tenantId, needDetailExt, needNotEnumExt));
        return response2;
    }
}

