/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.controllers.service;

import com.xforceplus.seller.config.client.annotation.MSApiV1SellerConfig;
import com.xforceplus.seller.config.client.api.ConfigTerminalApi;
import com.xforceplus.seller.config.client.model.AllElectricIssuerInfoData;
import com.xforceplus.seller.config.client.model.AllElectricIssuerInfoRecord;
import com.xforceplus.seller.config.client.model.AllElectricIssuerInfoResult;
import com.xforceplus.seller.config.client.model.AllElectricIssuerRequest;
import com.xforceplus.seller.config.client.model.AllElectricQualificationData;
import com.xforceplus.seller.config.client.model.MsAddTerminalResponse;
import com.xforceplus.seller.config.client.model.MsConfigAddTerminalRequest;
import com.xforceplus.seller.config.client.model.MsConfigTemialAuthQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigTemialQueryMakeOutRequest;
import com.xforceplus.seller.config.client.model.MsConfigTemialQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigUpdateTerminalRequest;
import com.xforceplus.seller.config.client.model.MsConfigUpdateTerminalStatusRequest;
import com.xforceplus.seller.config.client.model.MsQueryDeviceResponse;
import com.xforceplus.seller.config.client.model.MsQueryDeviceResult;
import com.xforceplus.seller.config.client.model.MsQueryMakeOutTerminalResponse;
import com.xforceplus.seller.config.client.model.MsQueryTerminalRequest;
import com.xforceplus.seller.config.client.model.MsQueryTerminalResponse;
import com.xforceplus.seller.config.client.model.MsResponse;
import com.xforceplus.seller.config.client.model.QueryAllElectricIssuerInfoRequest;
import com.xforceplus.seller.config.client.model.QueryAllElectricQualificationRequest;
import com.xforceplus.seller.config.config.ConfigTerminalProperties;
import com.xforceplus.seller.config.facade.TerminalDeviceFacade;
import com.xforceplus.seller.config.models.RestQueryDeviceResponse;
import com.xforceplus.seller.config.services.ConfigTerminalService;
import com.xforceplus.seller.config.util.BeanMapper;
import com.xforceplus.xplatframework.apimodel.BaseResponse;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatsecurity.base.BaseMicroController;
import io.swagger.annotations.ApiParam;
import io.vavr.control.Either;
import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;

@MSApiV1SellerConfig
public class MsConfigTerminalController
extends BaseMicroController
implements ConfigTerminalApi {
    private final ConfigTerminalService configTerminalService;
    private final UserInfoHolder<UserInfo> userInfoHolder;
    private final TerminalDeviceFacade terminalDeviceFacade;
    private final ConfigTerminalProperties configTerminalProperties;

    public MsQueryTerminalResponse getTerminalList(@RequestBody MsConfigTemialQueryRequest request) {
        return this.configTerminalService.getTerminalList(request, (UserInfo)this.userInfoHolder.get());
    }

    public MsResponse updateStatus(@RequestBody MsConfigUpdateTerminalStatusRequest request) {
        return this.configTerminalService.updateStatus(request);
    }

    public MsResponse update(@RequestBody MsConfigUpdateTerminalRequest request) {
        return this.configTerminalService.update(request);
    }

    public MsResponse callImport(@RequestBody Object configImportTerminalRequest) {
        return null;
    }

    public MsResponse export(@RequestBody Object configExportTerminalRequest) {
        return null;
    }

    public MsAddTerminalResponse addTerminal(@RequestBody MsConfigAddTerminalRequest request) {
        return this.configTerminalService.addTerminal(request);
    }

    public MsQueryMakeOutTerminalResponse getMakeOutTerminalList(@RequestBody MsConfigTemialQueryMakeOutRequest request) {
        return this.configTerminalService.getMakeOutTerminalList(request);
    }

    public MsQueryDeviceResponse getDeviceList(@ApiParam(value="\u67e5\u8be2\u5f00\u7968\u7ec8\u7aef\u8bbe\u5907\u8bf7\u6c42\u5bf9\u8c61", required=true) @RequestBody List<String> devcieUnList) {
        RestQueryDeviceResponse sourceResponse = this.terminalDeviceFacade.getDeviceListByQueryInfo(devcieUnList, false);
        MsQueryDeviceResponse response2 = new MsQueryDeviceResponse();
        MsQueryDeviceResult destinationResponse = new MsQueryDeviceResult();
        response2.setResult(destinationResponse);
        if ("1".equals(sourceResponse.getCode())) {
            BeanMapper.copy((Object)sourceResponse.getResult(), (Object)destinationResponse);
            response2.setCode(BaseResponse.OK);
            response2.setMessage("\u67e5\u8be2\u6210\u529f");
            return response2;
        }
        response2.setCode(BaseResponse.Fail);
        response2.setMessage("\u67e5\u8be2\u5931\u8d25");
        return response2;
    }

    public MsQueryTerminalResponse getAuthTerminalList(@RequestBody MsConfigTemialAuthQueryRequest request) {
        if (this.configTerminalProperties.getQueryTerminalMethodUnifySwitch().booleanValue()) {
            MsQueryTerminalRequest msQueryTerminalRequest = new MsQueryTerminalRequest();
            msQueryTerminalRequest.setInvoiceType(request.getInvoiceType());
            msQueryTerminalRequest.setSupportService(request.getSupportService());
            msQueryTerminalRequest.setTaxNo(request.getSellerTaxNo());
            msQueryTerminalRequest.setTaxNos(request.getTaxNos());
            msQueryTerminalRequest.setLimitByUser(Boolean.valueOf(true));
            msQueryTerminalRequest.setQueryOnline(Boolean.valueOf(true));
            msQueryTerminalRequest.setQueryInventory(Boolean.valueOf(true));
            return this.terminalDeviceFacade.getTerminalList(msQueryTerminalRequest);
        }
        return this.configTerminalService.getAuthTerminalList(request);
    }

    public MsQueryTerminalResponse getTerminalList(@RequestBody MsQueryTerminalRequest request) {
        return this.terminalDeviceFacade.getTerminalList(request);
    }

    public Response<AllElectricQualificationData> queryAllElectricQualification(@RequestBody QueryAllElectricQualificationRequest request) {
        Either eitherResult = this.terminalDeviceFacade.queryAllElectricQualification(Long.valueOf(((UserInfo)this.userInfoHolder.get()).getGroupId()), request.getTaxNoList());
        if (eitherResult.isLeft()) {
            return Response.from((Integer)Response.Fail, (String)((String)eitherResult.getLeft()), null);
        }
        return Response.from((Integer)Response.OK, (String)"\u6210\u529f", (Object)eitherResult.get());
    }

    public Response<AllElectricIssuerInfoData> queryAllElectricIssuerInfo(@RequestBody QueryAllElectricIssuerInfoRequest request) {
        Either eitherResult = this.terminalDeviceFacade.queryAllElectricIssuerInfo(Long.valueOf(((UserInfo)this.userInfoHolder.get()).getGroupId()), request.getTaxNo(), request.getIssuers());
        if (eitherResult.isRight()) {
            return Response.from((Integer)Response.OK, (String)"\u6210\u529f", (Object)eitherResult.get());
        }
        return Response.from((Integer)Response.Fail, (String)((String)eitherResult.getLeft()), null);
    }

    public Response<List<AllElectricIssuerInfoRecord>> queryAllElectricIssuerInfoList(@RequestBody AllElectricIssuerRequest request) {
        Either eitherResult = this.terminalDeviceFacade.queryAllElectricIssuerInfoList(request);
        if (eitherResult.isRight()) {
            return Response.from((Integer)Response.OK, (String)"\u6210\u529f", (Object)eitherResult.get());
        }
        return Response.from((Integer)Response.Fail, (String)((String)eitherResult.getLeft()), null);
    }

    public Response<AllElectricIssuerInfoResult> queryElectricIssuerInfoByPage(@RequestBody AllElectricIssuerRequest request) {
        Either eitherResult = this.terminalDeviceFacade.queryElectricIssuerInfoByPage(request);
        if (eitherResult.isRight()) {
            return Response.from((Integer)Response.OK, (String)"\u6210\u529f", (Object)eitherResult.get());
        }
        return Response.from((Integer)Response.Fail, (String)((String)eitherResult.getLeft()), null);
    }

    public MsConfigTerminalController(ConfigTerminalService configTerminalService, UserInfoHolder<UserInfo> userInfoHolder, TerminalDeviceFacade terminalDeviceFacade, ConfigTerminalProperties configTerminalProperties) {
        this.configTerminalService = configTerminalService;
        this.userInfoHolder = userInfoHolder;
        this.terminalDeviceFacade = terminalDeviceFacade;
        this.configTerminalProperties = configTerminalProperties;
    }
}

