/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.controllers.service;

import com.google.common.collect.Lists;
import com.xforceplus.seller.config.client.annotation.MSApiV1SellerConfig;
import com.xforceplus.seller.config.client.api.TaxCodeNationalApi;
import com.xforceplus.seller.config.client.model.SearchModel;
import com.xforceplus.seller.config.client.model.TaxCodeVO;
import com.xforceplus.seller.config.client.model.TaxNationalCode;
import com.xforceplus.seller.config.client.model.TaxNationalCodeResponse;
import com.xforceplus.seller.config.facade.TaxNationalCodeFacade;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatsecurity.base.BaseAppController;
import io.jsonwebtoken.lang.Collections;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@MSApiV1SellerConfig
public class MsTaxCodeNationalController
extends BaseAppController
implements TaxCodeNationalApi {
    @Autowired
    private TaxNationalCodeFacade taxNationalCodeFacade;

    public TaxNationalCodeResponse getNationalTaxCodeByTaxCodeName(@RequestParam String taxCodeName) {
        return this.taxNationalCodeFacade.getNationalTaxCodeByTaxCodeName(taxCodeName);
    }

    public TaxNationalCodeResponse getNationalTaxCodeByGoodsTaxNo(@RequestParam String goodTaxNo) {
        return this.taxNationalCodeFacade.getNationalTaxCodeByGoodsTaxNo(goodTaxNo);
    }

    public Response getByGoodsTaxNo(@RequestBody SearchModel model) {
        ArrayList taxCodeList = Lists.newArrayList();
        TaxNationalCodeResponse nationalTaxCodeByGoodsTaxNo = this.taxNationalCodeFacade.getNationalTaxCodeByGoodsTaxNo(model.getKey());
        List result = nationalTaxCodeByGoodsTaxNo.getResult();
        for (TaxNationalCode taxNationalCode : result) {
            taxCodeList.add(new TaxCodeVO(taxNationalCode.getTaxcodeName(), taxNationalCode.getGoodsTaxNo(), taxNationalCode.getTaxRate()));
        }
        Response response2 = new Response();
        if (Collections.isEmpty((Collection)result)) {
            return Response.failed((String)"\u672a\u67e5\u8be2\u5230\u7a0e\u52a1\u7f16\u7801");
        }
        return Response.ok((String)"\u67e5\u8be2\u6210\u529f", (Object)taxCodeList);
    }

    public TaxNationalCode getNationalTaxCode(@ApiParam(value="\u7a0e\u6536\u5206\u7c7b\u7f16\u7801", required=true) @RequestParam(value="goodTaxNo", required=true) @NotNull String goodTaxNo) {
        return this.taxNationalCodeFacade.getNationalTaxCode(goodTaxNo);
    }
}

