/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.controllers.service;

import com.xforceplus.seller.config.client.annotation.MSApiV1SellerConfig;
import com.xforceplus.seller.config.client.api.InvoiceSplitConfigApi;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.constant.ObjCodeEnum;
import com.xforceplus.seller.config.client.constant.StatusEnum;
import com.xforceplus.seller.config.client.model.MsBusinessObjBean;
import com.xforceplus.seller.config.client.model.MsConfigBatchQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.model.MsConfigQueryRequest;
import com.xforceplus.seller.config.client.model.MsMataDataQueryRequest;
import com.xforceplus.seller.config.client.model.MsResponse;
import com.xforceplus.seller.config.client.parse.bean.InvoiceInfoRuleDTO;
import com.xforceplus.seller.config.client.parse.bean.SysInfoRuleDTO;
import com.xforceplus.seller.config.client.parse.impl.SysInfoRuleParser;
import com.xforceplus.seller.config.converters.ConfigConverter;
import com.xforceplus.seller.config.facade.ConfigMatchingFacade;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigEntity;
import com.xforceplus.seller.config.services.CfgConfigDataService;
import com.xforceplus.seller.config.services.ConfigBizConfigService;
import com.xforceplus.seller.config.services.ConfigMetaDataService;
import com.xforceplus.seller.config.services.TaxInvoiceQuotaInfoService;
import com.xforceplus.seller.config.services.adapter.AdapterConfig;
import com.xforceplus.seller.config.services.adapter.AdapterService;
import com.xforceplus.seller.config.util.CommonTools;
import com.xforceplus.seller.config.util.StringUtil;
import com.xforceplus.seller.enums.BusinessBillType;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatframework.utils.JsonUtils;
import io.swagger.annotations.ApiParam;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;

@MSApiV1SellerConfig
public class SplitConfigController
implements InvoiceSplitConfigApi {
    private static final Logger logger = LoggerFactory.getLogger(SplitConfigController.class);
    private final ConfigBizConfigService configBizConfigService;
    private final ConfigMatchingFacade configMatchingFacade;
    private final ConfigConverter configConverter;
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    private SysInfoRuleParser sysInfoRuleParser;
    @Autowired
    private ConfigMetaDataService configMetaDataService;
    @Autowired
    AdapterConfig adapterConfig;
    @Autowired
    AdapterService adapterService;
    @Autowired
    CfgConfigDataService cfgConfigDataService;
    @Autowired
    TaxInvoiceQuotaInfoService taxInvoiceQuotaInfoService;
    private static Map<String, String> globalInvoiceLimitMap = new HashMap(5);

    public SplitConfigController(ConfigBizConfigService configBizConfigService, ConfigMatchingFacade configMatchingFacade, ConfigConverter configConverter) {
        this.configBizConfigService = configBizConfigService;
        this.configMatchingFacade = configMatchingFacade;
        this.configConverter = configConverter;
    }

    public MsResponse queryAllSysConfig(@ApiParam(value="\u67e5\u8be2\u5339\u914d\u5168\u90e8\u914d\u7f6e\u89c4\u5219") @RequestBody MsConfigQueryRequest msConfigQueryRequest) {
        if (logger.isInfoEnabled()) {
            logger.info("@queryAllSysConfig invoiceTypeList====>{}", (Object)msConfigQueryRequest.getInvoiceType().toString());
        }
        MsResponse msResponse = new MsResponse();
        ConfigTypeEnum configTypeEnum = ConfigTypeEnum.getConfigTypeByValue((Integer)msConfigQueryRequest.getConfigType());
        if (null == configTypeEnum || configTypeEnum.getConfigType() == 0) {
            msResponse.setCode(Response.Fail);
            msResponse.setMessage("\u89c4\u5219\u914d\u7f6e\u7c7b\u578b\u6709\u8bef.");
            return msResponse;
        }
        msConfigQueryRequest.setStatus(StatusEnum.NORMAL.getStatus());
        Response response2 = this.configBizConfigService.getOriginalMatchedCfgs(msConfigQueryRequest);
        msResponse.setCode(response2.getCode());
        msResponse.setResult(response2.getResult());
        logger.info("@queryAllSysConfig msResponse====>{}", (Object)JsonUtils.writeObjectToFastJson((Object)msResponse));
        return msResponse;
    }

    public MsResponse<Map<String, List<String>>> batchQueryOptimalMatchConfig(@ApiParam(value="\u67e5\u8be2\u5339\u914d\u5168\u90e8\u914d\u7f6e\u89c4\u5219") @RequestBody MsConfigBatchQueryRequest request) {
        List queryList = request.getQueryList();
        MsResponse msResponse = new MsResponse();
        if (CollectionUtils.isEmpty((Collection)queryList)) {
            msResponse.setCode(Response.Fail);
            msResponse.setMessage("\u6279\u91cf\u67e5\u8be2\u89c4\u5219\u5165\u53c2\u4e3a\u7a7a");
            return msResponse;
        }
        Map result = queryList.parallelStream().map(r -> Tuple.of((Object)r.getSerialNo(), Optional.ofNullable(this.getOptimalMatchConfigNew(r.getRequest()).getResult()).map(JsonUtils::writeObjectToFastJson).orElse(null))).collect(Collectors.groupingBy(Tuple2::_2, Collectors.mapping(Tuple2::_1, Collectors.toList())));
        msResponse.setCode(Response.OK);
        msResponse.setResult(result);
        return msResponse;
    }

    public MsResponse getOptimalMatchConfig(@ApiParam(value="\u67e5\u8be2\u5339\u914d\u6700\u4f18\u914d\u7f6e\u89c4\u5219") @RequestBody MsConfigQueryRequest msConfigQueryRequest) {
        if (logger.isInfoEnabled()) {
            logger.info("@getOptimalMatchConfig invoiceTypeList====> " + msConfigQueryRequest.getInvoiceType().toString());
        }
        MsResponse msResponse = new MsResponse();
        ConfigTypeEnum configTypeEnum = ConfigTypeEnum.getConfigTypeByValue((Integer)msConfigQueryRequest.getConfigType());
        if (null == configTypeEnum || configTypeEnum.getConfigType() == 0) {
            msResponse.setCode(Response.Fail);
            msResponse.setMessage("\u89c4\u5219\u914d\u7f6e\u7c7b\u578b\u6709\u8bef.");
            return msResponse;
        }
        msConfigQueryRequest.setStatus(StatusEnum.NORMAL.getStatus());
        Integer apiVersion = msConfigQueryRequest.getApiVersion();
        if (null == apiVersion) {
            apiVersion = 3;
        }
        Response response2 = null;
        logger.info("getOptimalMatchConfig msConfigQueryRequest {}", (Object)StringUtil.describeBean((Object)msConfigQueryRequest));
        switch (apiVersion) {
            case 1: {
                response2 = this.configBizConfigService.getOptimalMatchConfig(msConfigQueryRequest);
                break;
            }
            case 2: {
                response2 = this.configBizConfigService.getOriginalCfgs(msConfigQueryRequest);
                break;
            }
            case 3: {
                response2 = this.configBizConfigService.getOptimalMatchConfigWithAttr(msConfigQueryRequest);
                break;
            }
            case 4: {
                response2 = this.configBizConfigService.getOptimalMatchConfigNullable(msConfigQueryRequest);
                break;
            }
            case 5: {
                response2 = this.configBizConfigService.getOptimalMatchConfigWithAttrOfEmail(msConfigQueryRequest);
                break;
            }
            default: {
                response2 = this.configBizConfigService.getOptimalMatchConfigWithAttr(msConfigQueryRequest);
            }
        }
        this.invoiceLimitSpecialHandler(msConfigQueryRequest, response2);
        msResponse.setCode(response2.getCode());
        msResponse.setResult(response2.getResult());
        if (logger.isInfoEnabled()) {
            logger.debug("getOptimalMatchConfig response {}", (Object)StringUtil.describeBean((Object)response2.getResult()));
        }
        return msResponse;
    }

    private void invoiceLimitSpecialHandler(MsConfigQueryRequest msConfigQueryRequest, Response response2) {
        String taxNo = msConfigQueryRequest.getSellerTaxNo();
        if (ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType().equals(msConfigQueryRequest.getConfigType())) {
            List list = JsonUtils.writeJsonToListObject((String)response2.getResult().toString(), MsConfigItemBean.class);
            long configId = ((MsConfigItemBean)list.get(0)).getConfigId();
            MsConfigItemBean qdFlagBean = list.stream().filter(item -> item.getConfigItemName().equalsIgnoreCase("taxInvoiceSource") && ((String)item.getConfigItemValue().get(0)).equalsIgnoreCase("qd")).findFirst().orElse(null);
            if (qdFlagBean != null) {
                return;
            }
            CfgConfigEntity loadCfgConfigEntity = this.cfgConfigDataService.queryById(Long.valueOf(configId));
            String invoiceType = loadCfgConfigEntity.getInvoiceType();
            long sellerGroupId = loadCfgConfigEntity.getSellerGroupId();
            long purchaserGroupId = loadCfgConfigEntity.getPurchaserGroupId();
            String sellerTaxNo = loadCfgConfigEntity.getSellerTaxNo();
            for (MsConfigItemBean msConfigItemBean : list) {
                if (!msConfigItemBean.getConfigItemName().equalsIgnoreCase("invoiceLimit")) continue;
                if (!(StringUtils.isNotBlank((CharSequence)sellerTaxNo) && CollectionUtils.isEmpty((Collection)msConfigItemBean.getConfigItemValue()) || StringUtils.isBlank((CharSequence)sellerTaxNo) && sellerGroupId > 0L) && (sellerGroupId != 0L || purchaserGroupId != 0L)) break;
                BigDecimal invoiceLimit = this.taxInvoiceQuotaInfoService.getAndFillTaxRateLimitByTaxNo(taxNo, invoiceType);
                if (invoiceLimit != null) {
                    msConfigItemBean.setConfigItemValue(Arrays.asList(invoiceLimit.toString()));
                    logger.info("\u6839\u636e\u7a0e\u53f7\u8868\u9650\u989d\uff0c\u7a0e\u53f7\uff1a{}\uff0c\u53d1\u7968\u7c7b\u578b\uff1a{}\uff0c\u9650\u989d\u4fee\u6539\u4e86\uff1a{}", new Object[]{taxNo, invoiceType, invoiceLimit});
                    break;
                }
                msConfigItemBean.setConfigItemValue(Arrays.asList((String)globalInvoiceLimitMap.get(invoiceType)));
                logger.info("\u6839\u636e\u5168\u5c40\u9ed8\u8ba4\u62c6\u7968\u89c4\u5219\uff0c\u7a0e\u53f7\uff1a{}\uff0c\u53d1\u7968\u7c7b\u578b\uff1a{}\uff0c\u9650\u989d\u4fee\u6539\u4e86\uff1a{}", new Object[]{taxNo, invoiceType, invoiceLimit});
                break;
            }
            response2.setResult((Object)JsonUtils.writeObjectToFastJson((Object)list));
        }
    }

    public MsResponse getOrderOptimalMatchConfig(@RequestBody MsConfigQueryRequest msConfigQueryRequest) {
        Integer apiVersion;
        Long groupId = msConfigQueryRequest.getSellerGroupId();
        if (groupId == null || groupId == 0L) {
            groupId = ((UserInfo)this.userInfoHolder.get()).getGroupId();
        }
        if (null == (apiVersion = msConfigQueryRequest.getApiVersion())) {
            msConfigQueryRequest.setApiVersion(Integer.valueOf(3));
        }
        MsMataDataQueryRequest dataQueryRequest = new MsMataDataQueryRequest();
        dataQueryRequest.setGroupId(groupId);
        dataQueryRequest.setObjCode(ObjCodeEnum.BILL.getObjCode());
        dataQueryRequest.setPageNo(Integer.valueOf(1));
        dataQueryRequest.setPageSize(Integer.valueOf(5));
        dataQueryRequest.setObjStatus(Integer.valueOf(1));
        dataQueryRequest.setObjFlag(Integer.valueOf(1));
        String salesBillType = this.getSalesBillType(dataQueryRequest);
        if (CommonTools.isEmpty((String)salesBillType)) {
            return MsResponse.ok(null);
        }
        msConfigQueryRequest.setSalesbillType(salesBillType);
        msConfigQueryRequest.setBusinessBillType(BusinessBillType.AR.value());
        msConfigQueryRequest.setSellerGroupId(groupId);
        MsResponse msResponse = new MsResponse();
        if (CollectionUtils.isEmpty((Collection)msConfigQueryRequest.getConfigTypeList())) {
            msResponse.setCode(Response.Fail);
            msResponse.setMessage("\u89c4\u5219\u914d\u7f6e\u7c7b\u578b\u6709\u8bef.");
            return msResponse;
        }
        List msResponseList = msConfigQueryRequest.getConfigTypeList().parallelStream().map(r -> {
            MsConfigQueryRequest tempRequest = this.configConverter.copy(msConfigQueryRequest);
            tempRequest.setConfigType(r);
            MsResponse response2 = this.getOptimalMatchConfig(tempRequest);
            response2.setSalesbillType(salesBillType);
            if (Response.OK.equals(response2.getCode())) {
                return response2;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(msResponseList)) {
            msResponse.setSalesbillType(salesBillType);
            msResponse.setCode(Response.Fail);
            msResponse.setMessage("\u89c4\u5219\u914d\u7f6e\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return msResponse;
        }
        msResponse = (MsResponse)msResponseList.get(0);
        if (1 == msConfigQueryRequest.getApiVersion() || 3 == msConfigQueryRequest.getApiVersion() || msConfigQueryRequest.getApiVersion() == null) {
            ArrayList allItemList = new ArrayList();
            for (MsResponse response2 : msResponseList) {
                String itemListString = (String)response2.getResult();
                List itemList = JsonUtils.writeJsonToListObject((String)itemListString, MsConfigItemBean.class);
                logger.info("@itemList {}", (Object)JsonUtils.writeObjectToFastJson((Object)itemList));
                allItemList.addAll(itemList);
            }
            SysInfoRuleDTO baseRuleBean = this.sysInfoRuleParser.parse(allItemList);
            msResponse.setResult((Object)baseRuleBean);
        }
        return msResponse;
    }

    private String getSalesBillType(MsMataDataQueryRequest dataQueryRequest) {
        if (this.adapterConfig.isAdapterOpen(dataQueryRequest.getGroupId()).booleanValue()) {
            List typeList = this.adapterService.getBizorderTypeList(dataQueryRequest.getGroupId().longValue(), false);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)typeList)) {
                return "";
            }
            Optional<MsBusinessObjBean> first = typeList.stream().filter(item -> String.valueOf(item.getBusinessObjId()).equals(item.getObjCode())).findFirst();
            if (first.isPresent()) {
                return first.get().getObjType();
            }
            return "";
        }
        List cfgBusinessObjEntities = this.configMetaDataService.queryMetaDataList(dataQueryRequest);
        if (CollectionUtils.isEmpty((Collection)cfgBusinessObjEntities)) {
            return "";
        }
        return ((CfgBusinessObjEntity)cfgBusinessObjEntities.get(0)).getObjType();
    }

    public MsResponse<MsConfigBean> getOptimalMatchConfigNew(MsConfigQueryRequest msConfigQueryRequest) {
        if (logger.isInfoEnabled()) {
            logger.info("@getOptimalMatchConfig invoiceTypeList====> " + msConfigQueryRequest.getInvoiceType().toString());
        }
        MsResponse msResponse = new MsResponse();
        ConfigTypeEnum configTypeEnum = ConfigTypeEnum.getConfigTypeByValue((Integer)msConfigQueryRequest.getConfigType());
        if (null == configTypeEnum || configTypeEnum.getConfigType() == 0) {
            msResponse.setCode(Response.Fail);
            msResponse.setMessage("\u89c4\u5219\u914d\u7f6e\u7c7b\u578b\u6709\u8bef.");
            return msResponse;
        }
        msConfigQueryRequest.setStatus(StatusEnum.NORMAL.getStatus());
        Integer apiVersion = msConfigQueryRequest.getApiVersion();
        if (null == apiVersion) {
            apiVersion = 3;
        }
        logger.info("getOptimalMatchConfig msConfigQueryRequest {}", (Object)StringUtil.describeBean((Object)msConfigQueryRequest));
        MsConfigBean msConfigBean = 3 == apiVersion ? this.configBizConfigService.getOptimalMatchConfigWithAttrNew(msConfigQueryRequest) : null;
        msResponse.setCode(msConfigBean == null ? Response.Fail : Response.OK);
        msResponse.setResult((Object)msConfigBean);
        logger.info("getOptimalMatchConfig response {}", (Object)StringUtil.describeBean((Object)msResponse.getResult()));
        return msResponse;
    }

    public MsResponse<String> getOptimalMatchConfigList(@ApiParam(value="\u67e5\u8be2\u5339\u914d\u6700\u4f18\u914d\u7f6e\u89c4\u5219") @RequestBody MsConfigQueryRequest msConfigQueryRequest) {
        String resultJson;
        MsResponse msResponse = new MsResponse();
        ConfigTypeEnum configTypeEnum = ConfigTypeEnum.getConfigTypeByValue((Integer)msConfigQueryRequest.getConfigType());
        if (null == configTypeEnum || configTypeEnum.getConfigType() == 0) {
            msResponse.setCode(Response.Fail);
            msResponse.setMessage("\u89c4\u5219\u914d\u7f6e\u7c7b\u578b\u6709\u8bef.");
            return msResponse;
        }
        msConfigQueryRequest.setStatus(StatusEnum.NORMAL.getStatus());
        Integer apiVersion = msConfigQueryRequest.getApiVersion();
        if (null == apiVersion) {
            apiVersion = 3;
        }
        logger.info("getOptimalMatchConfigList msConfigQueryRequest {}", (Object)StringUtil.describeBean((Object)msConfigQueryRequest));
        switch (apiVersion) {
            case 5: {
                resultJson = this.configMatchingFacade.getOptimalMatchConfigForEmail(msConfigQueryRequest);
                break;
            }
            default: {
                resultJson = null;
            }
        }
        msResponse.setCode(Response.OK);
        msResponse.setResult((Object)resultJson);
        logger.info("getOptimalMatchConfigList response {}", (Object)resultJson);
        return msResponse;
    }

    public MsResponse<List<InvoiceInfoRuleDTO>> getSellerIssueInfoConfig(@ApiParam(value="\u7968\u9762\u4fe1\u606f\u83b7\u53d6") @RequestBody MsConfigQueryRequest msConfigQueryRequest) {
        MsResponse msResponse = new MsResponse();
        msResponse.setResult((Object)this.configMatchingFacade.getSellerIssueInfoConfig(msConfigQueryRequest));
        return msResponse;
    }

    public MsResponse<List<MsConfigBean>> getConfigByTenantId(@RequestBody MsConfigQueryRequest msConfigQueryRequest) {
        return this.configBizConfigService.getConfigByTenantId(msConfigQueryRequest);
    }

    public MsResponse<Boolean> getAllowAddIssuerConfig(@ApiParam(value="\u67e5\u8be2\u6dfb\u52a0\u5f00\u7968\u4eba\u6743\u9650\uff08\u9875\u9762\u5f00\u5177\u3001\u7ea2\u51b2\u573a\u666f\uff09") @RequestBody MsConfigQueryRequest msConfigQueryRequest) {
        return null;
    }

    static {
        globalInvoiceLimitMap.put("se", "100000");
        globalInvoiceLimitMap.put("c", "99999.99");
        globalInvoiceLimitMap.put("s", "99999.99");
        globalInvoiceLimitMap.put("ce", "99999.99");
        globalInvoiceLimitMap.put("v", "100000000");
    }
}

