/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.controllers.service;

import com.xforceplus.seller.config.client.annotation.MSApiV1SellerConfig;
import com.xforceplus.seller.config.client.api.TaxInvoiceQuotaInfoApi;
import com.xforceplus.seller.config.client.model.ResponseV2;
import com.xforceplus.seller.config.client.model.TaxInvoiceQuotaInfoModel;
import com.xforceplus.seller.config.client.model.TaxInvoiceQuotaInfoQueryRequest;
import com.xforceplus.seller.config.converters.TaxInvoiceQuotaInfoConverter;
import com.xforceplus.seller.config.infrastructure.taxware.TaxWareService;
import com.xforceplus.seller.config.services.TaxInvoiceQuotaInfoService;
import com.xforceplus.seller.config.services.TaxInvoiceQuotaInfoServiceHelper;
import com.xforceplus.xplatsecurity.base.BaseAppController;
import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;

@MSApiV1SellerConfig
public class TaxInvoiceQuotaInfoController
extends BaseAppController
implements TaxInvoiceQuotaInfoApi {
    private final TaxInvoiceQuotaInfoService taxInvoiceQuotaInfoService;
    private final TaxWareService taxWareService;
    private final TaxInvoiceQuotaInfoConverter taxInvoiceQuotaInfoConverter;
    private final TaxInvoiceQuotaInfoServiceHelper taxQuotaInfoServiceHelper;

    public TaxInvoiceQuotaInfoController(TaxInvoiceQuotaInfoService taxInvoiceQuotaInfoService, TaxWareService taxWareService, TaxInvoiceQuotaInfoConverter taxInvoiceQuotaInfoConverter, TaxInvoiceQuotaInfoServiceHelper taxQuotaInfoServiceHelper) {
        this.taxInvoiceQuotaInfoService = taxInvoiceQuotaInfoService;
        this.taxWareService = taxWareService;
        this.taxInvoiceQuotaInfoConverter = taxInvoiceQuotaInfoConverter;
        this.taxQuotaInfoServiceHelper = taxQuotaInfoServiceHelper;
    }

    public ResponseV2<List<TaxInvoiceQuotaInfoModel>> getTaxQuotaInfoByTaxNumber(@RequestBody TaxInvoiceQuotaInfoQueryRequest taxInvoiceQuotaInfoQueryRequest) {
        String taxNumber = (String)taxInvoiceQuotaInfoQueryRequest.getTaxNumbers().get(0);
        String invoiceType = taxInvoiceQuotaInfoQueryRequest.getInvoiceType();
        this.taxInvoiceQuotaInfoService.getAndFillTaxRateLimitByTaxNo(taxNumber, invoiceType);
        List list = this.taxInvoiceQuotaInfoService.getEntityByTaxNo(taxNumber);
        ResponseV2 response2 = new ResponseV2();
        response2.setResult((Object)this.taxInvoiceQuotaInfoConverter.convert(list));
        response2.setCode("0000");
        return response2;
    }

    public ResponseV2<List<TaxInvoiceQuotaInfoModel>> findTaxQuotaInfoByTaxNumbers(TaxInvoiceQuotaInfoQueryRequest taxInvoiceQuotaInfoQueryRequest) {
        return null;
    }
}

