/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.converters;

import com.xforceplus.seller.config.converters.BusinessConfigConverter;
import com.xforceplus.seller.config.converters.Helper;
import com.xforceplus.seller.config.models.SellerBusinessConfig;
import com.xforceplus.seller.config.repository.model.CfgConfigInterfaceEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BusinessConfigConverterImpl
implements BusinessConfigConverter {
    private final Helper helper;

    @Autowired
    public BusinessConfigConverterImpl(Helper helper) {
        this.helper = helper;
    }

    public CfgConfigInterfaceEntity toEntity(SellerBusinessConfig sellerBusinessConfig) {
        if (sellerBusinessConfig == null) {
            return null;
        }
        CfgConfigInterfaceEntity cfgConfigInterfaceEntity = new CfgConfigInterfaceEntity();
        cfgConfigInterfaceEntity.setOrigData(this.toJSONString(sellerBusinessConfig));
        cfgConfigInterfaceEntity.setSellerName(this.helper.stringNullToEmpty(sellerBusinessConfig.getSellerName()));
        cfgConfigInterfaceEntity.setSellerTaxNo(this.helper.stringNullToEmpty(sellerBusinessConfig.getSellerTaxNo()));
        cfgConfigInterfaceEntity.setPurchaserName(this.helper.stringNullToEmpty(sellerBusinessConfig.getPurchaserName()));
        cfgConfigInterfaceEntity.setPurchaserTaxNo(this.helper.stringNullToEmpty(sellerBusinessConfig.getPurchaserTaxNo()));
        cfgConfigInterfaceEntity.setConfigName(this.helper.stringNullToEmpty(sellerBusinessConfig.getConfigName()));
        if (sellerBusinessConfig.getSellerOrgType() != null) {
            cfgConfigInterfaceEntity.setSellerOrgType(Integer.valueOf(Integer.parseInt(this.helper.stringNullToEmpty(sellerBusinessConfig.getSellerOrgType()))));
        }
        if (sellerBusinessConfig.getConfigType() != null) {
            cfgConfigInterfaceEntity.setConfigType(Integer.valueOf(Integer.parseInt(sellerBusinessConfig.getConfigType())));
        }
        cfgConfigInterfaceEntity.setBusinessBillType(sellerBusinessConfig.getBusinessBillType());
        cfgConfigInterfaceEntity.setSalesbillType(sellerBusinessConfig.getSalesbillType());
        return cfgConfigInterfaceEntity;
    }
}

