/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.converters;

import com.xforceplus.micro.tax.device.contract.model.DeviceInfo;
import com.xforceplus.micro.tax.device.contract.model.TaxDeviceInfo;
import com.xforceplus.phoenix.infrastructure.usercenter.model.OrgData;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.converters.CommonConverter;
import com.xforceplus.seller.config.converters.Helper;
import com.xforceplus.seller.config.models.CompanyData;
import com.xforceplus.seller.config.models.DeviceData;
import com.xforceplus.seller.config.models.ExportConfigModel;
import com.xforceplus.seller.config.models.ExportInvoiceAgentModel;
import com.xforceplus.seller.config.models.ExportSplitModel;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommonConverterImpl
implements CommonConverter {
    private final Helper helper;

    @Autowired
    public CommonConverterImpl(Helper helper) {
        this.helper = helper;
    }

    public List<CompanyData> convert(List<OrgData> list) {
        if (list == null) {
            return null;
        }
        ArrayList<CompanyData> list1 = new ArrayList<CompanyData>(list.size());
        for (OrgData orgData : list) {
            list1.add(this.convert(orgData));
        }
        return list1;
    }

    public CompanyData convert(OrgData data) {
        if (data == null) {
            return null;
        }
        CompanyData companyData = new CompanyData();
        companyData.setName(data.getCompanyName());
        companyData.setTaxNo(data.getTaxNum());
        if (data.getOrgId() != null) {
            companyData.setOrganizationId(data.getOrgId().longValue());
        }
        if (data.getTenantId() != null) {
            companyData.setGroupId(data.getTenantId().longValue());
        }
        if (data.getCompanyId() != null) {
            companyData.setCompanyId(data.getCompanyId().longValue());
        }
        return companyData;
    }

    public List<DeviceData> convertDevice(List<DeviceInfo> list) {
        if (list == null) {
            return null;
        }
        ArrayList<DeviceData> list1 = new ArrayList<DeviceData>(list.size());
        for (DeviceInfo deviceInfo : list) {
            list1.add(this.convertDevice(deviceInfo));
        }
        return list1;
    }

    public DeviceData convertDevice(DeviceInfo info) {
        if (info == null) {
            return null;
        }
        DeviceData deviceData = new DeviceData();
        deviceData.setDeviceNo(this.helper.stringNullToEmpty(info.getDeviceNo()));
        deviceData.setDeviceName(this.helper.stringNullToEmpty(info.getDeviceName()));
        deviceData.setDeviceType(this.helper.stringNullToEmpty(info.getDeviceType()));
        deviceData.setMachineNo(this.helper.stringNullToEmpty(this.infoTaxDeviceInfoTaxDeviceMachineNo(info)));
        deviceData.setDeviceUn(this.helper.stringNullToEmpty(info.getDeviceUn()));
        return deviceData;
    }

    public List<ExportConfigModel> convertToExportConfigModel(List<MsConfigBean> itemDTOList) {
        if (itemDTOList == null) {
            return null;
        }
        ArrayList<ExportConfigModel> list = new ArrayList<ExportConfigModel>(itemDTOList.size());
        for (MsConfigBean msConfigBean : itemDTOList) {
            list.add(this.msConfigBeanToExportConfigModel(msConfigBean));
        }
        return list;
    }

    public List<ExportInvoiceAgentModel> convertToExportInvoiceAgentModel(List<MsConfigBean> itemDTOList) {
        if (itemDTOList == null) {
            return null;
        }
        ArrayList<ExportInvoiceAgentModel> list = new ArrayList<ExportInvoiceAgentModel>(itemDTOList.size());
        for (MsConfigBean msConfigBean : itemDTOList) {
            list.add(this.msConfigBeanToExportInvoiceAgentModel(msConfigBean));
        }
        return list;
    }

    public List<ExportSplitModel> convertToExportSplitModel(List<MsConfigBean> itemDTOList) {
        if (itemDTOList == null) {
            return null;
        }
        ArrayList<ExportSplitModel> list = new ArrayList<ExportSplitModel>(itemDTOList.size());
        for (MsConfigBean msConfigBean : itemDTOList) {
            list.add(this.msConfigBeanToExportSplitModel(msConfigBean));
        }
        return list;
    }

    private String infoTaxDeviceInfoTaxDeviceMachineNo(DeviceInfo deviceInfo) {
        if (deviceInfo == null) {
            return null;
        }
        TaxDeviceInfo taxDeviceInfo = deviceInfo.getTaxDeviceInfo();
        if (taxDeviceInfo == null) {
            return null;
        }
        String taxDeviceMachineNo = taxDeviceInfo.getTaxDeviceMachineNo();
        if (taxDeviceMachineNo == null) {
            return null;
        }
        return taxDeviceMachineNo;
    }

    protected ExportConfigModel msConfigBeanToExportConfigModel(MsConfigBean msConfigBean) {
        if (msConfigBean == null) {
            return null;
        }
        ExportConfigModel exportConfigModel = new ExportConfigModel();
        exportConfigModel.setBusinessBillType(msConfigBean.getBusinessBillType());
        exportConfigModel.setSellerName(msConfigBean.getSellerName());
        exportConfigModel.setSellerTaxNo(msConfigBean.getSellerTaxNo());
        exportConfigModel.setPurchaserName(msConfigBean.getPurchaserName());
        exportConfigModel.setPurchaserTaxNo(msConfigBean.getPurchaserTaxNo());
        exportConfigModel.setSalesbillType(msConfigBean.getSalesbillType());
        exportConfigModel.setConfigName(msConfigBean.getConfigName());
        return exportConfigModel;
    }

    protected ExportInvoiceAgentModel msConfigBeanToExportInvoiceAgentModel(MsConfigBean msConfigBean) {
        if (msConfigBean == null) {
            return null;
        }
        ExportInvoiceAgentModel exportInvoiceAgentModel = new ExportInvoiceAgentModel();
        exportInvoiceAgentModel.setSellerName(msConfigBean.getSellerName());
        exportInvoiceAgentModel.setSellerTaxNo(msConfigBean.getSellerTaxNo());
        exportInvoiceAgentModel.setPurchaserName(msConfigBean.getPurchaserName());
        exportInvoiceAgentModel.setPurchaserTaxNo(msConfigBean.getPurchaserTaxNo());
        exportInvoiceAgentModel.setSalesbillType(msConfigBean.getSalesbillType());
        exportInvoiceAgentModel.setConfigName(msConfigBean.getConfigName());
        return exportInvoiceAgentModel;
    }

    protected ExportSplitModel msConfigBeanToExportSplitModel(MsConfigBean msConfigBean) {
        if (msConfigBean == null) {
            return null;
        }
        ExportSplitModel exportSplitModel = new ExportSplitModel();
        exportSplitModel.setBusinessBillType(msConfigBean.getBusinessBillType());
        exportSplitModel.setSellerName(msConfigBean.getSellerName());
        exportSplitModel.setSellerTaxNo(msConfigBean.getSellerTaxNo());
        exportSplitModel.setPurchaserName(msConfigBean.getPurchaserName());
        exportSplitModel.setPurchaserTaxNo(msConfigBean.getPurchaserTaxNo());
        exportSplitModel.setSalesbillType(msConfigBean.getSalesbillType());
        exportSplitModel.setConfigName(msConfigBean.getConfigName());
        exportSplitModel.setInvoiceType(msConfigBean.getInvoiceType());
        exportSplitModel.setTaxInvoiceSource(msConfigBean.getTaxInvoiceSource());
        return exportSplitModel;
    }
}

