/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.converters;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.seller.config.client.constant.BusinessSalesBillTypeEnum;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.model.ConfigIssueInfoEditRequest;
import com.xforceplus.seller.config.client.model.ConfigIssueUserInfoDTO;
import com.xforceplus.seller.config.client.model.ConfigSellerInfoEditRequest;
import com.xforceplus.seller.config.client.model.EmailConfigEntity;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.model.MsConfigQueryRequest;
import com.xforceplus.seller.config.converters.GlobalConfig;
import com.xforceplus.seller.config.repository.model.CfgConfigMailRuleEntity;
import com.xforceplus.seller.config.repository.model.CfgIssueUserInfoEntity;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper(config=GlobalConfig.class, imports={ConfigTypeEnum.class, BusinessSalesBillTypeEnum.class, Date.class, StringUtils.class})
public interface ConfigConverter {
    public EmailConfigEntity convert(CfgConfigMailRuleEntity var1);

    default public EmailConfigEntity init() {
        EmailConfigEntity entity = new EmailConfigEntity();
        entity.setAutosend(Boolean.valueOf(true));
        entity.setPickBizBillAddress(Boolean.valueOf(true));
        entity.setUseCustomAddress(Boolean.valueOf(false));
        entity.setPickUcAddress(Boolean.valueOf(false));
        return entity;
    }

    @Mappings(value={@Mapping(target="configType", expression="java( ConfigTypeEnum.INVOICE_CONFIG_TYPE.getConfigType() )"), @Mapping(target="businessBillType", expression="java( BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType() )"), @Mapping(target="salesbillType", source="request.salsebillType"), @Mapping(target="sellerGroupId", source="userInfo.groupId"), @Mapping(target="sellerName", source="request.sellerName"), @Mapping(target="sellerTaxNo", source="request.sellerTaxNo"), @Mapping(target="sysOrgId", source="request.sysOrgId"), @Mapping(target="configName", expression="java( request.getSellerName() + \"-to-all\" )"), @Mapping(target="status", constant="1")})
    public MsConfigBean convert(ConfigSellerInfoEditRequest var1, UserInfo var2);

    default public List<MsConfigItemBean> convert(ConfigSellerInfoEditRequest request) {
        ArrayList itemBeans = Lists.newArrayList();
        MsConfigItemBean sellerAddressBean = new MsConfigItemBean();
        sellerAddressBean.setConfigItemName("sellerAddress");
        sellerAddressBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{Optional.ofNullable(request.getSellerAddress()).orElse("")}));
        itemBeans.add(sellerAddressBean);
        MsConfigItemBean sellerBankAccountBean = new MsConfigItemBean();
        sellerBankAccountBean.setConfigItemName("sellerBankAccount");
        sellerBankAccountBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{Optional.ofNullable(request.getSellerBankAccount()).orElse("")}));
        itemBeans.add(sellerBankAccountBean);
        MsConfigItemBean sellerBankNameBean = new MsConfigItemBean();
        sellerBankNameBean.setConfigItemName("sellerBankAccount");
        sellerBankNameBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{Optional.ofNullable(request.getSellerBankName()).orElse("")}));
        itemBeans.add(sellerBankNameBean);
        MsConfigItemBean sellerTelBean = new MsConfigItemBean();
        sellerTelBean.setConfigItemName("sellerTel");
        sellerTelBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{Optional.ofNullable(request.getSellerTel()).orElse("")}));
        itemBeans.add(sellerTelBean);
        return itemBeans;
    }

    @Mappings(value={@Mapping(target="id", expression="java( idGenerator.nextId() )"), @Mapping(target="groupId", source="userInfo.groupId"), @Mapping(target="companyTaxNo", source="request.companyTaxNo"), @Mapping(target="sysOrgId", source="request.sysOrgId"), @Mapping(target="userId", source="userInfo.userId"), @Mapping(target="invoicerName", source="request.invoicerName"), @Mapping(target="cashierName", source="request.cashierName"), @Mapping(target="checkerName", source="request.checkerName"), @Mapping(target="createTime", expression="java(new Date())"), @Mapping(target="updateTime", expression="java(new Date())")})
    public CfgIssueUserInfoEntity convert(ConfigIssueInfoEditRequest var1, UserInfo var2, IDGenerator var3);

    public ConfigIssueUserInfoDTO convert(CfgIssueUserInfoEntity var1);

    public MsConfigQueryRequest copy(MsConfigQueryRequest var1);
}

