/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.converters;

import com.google.common.collect.Lists;
import com.xforceplus.micro.tax.device.contract.model.CompanyInfo;
import com.xforceplus.micro.tax.device.contract.model.QueryDeviceRequest;
import com.xforceplus.micro.tax.device.contract.model.TerminalQueryInfo;
import com.xforceplus.seller.config.client.constant.BusinessSalesBillTypeEnum;
import com.xforceplus.seller.config.client.model.Inventory;
import com.xforceplus.seller.config.client.model.MsCompanyInfo;
import com.xforceplus.seller.config.client.model.MsCompanyQueryInfo;
import com.xforceplus.seller.config.client.model.MsQueryTerminalRequest;
import com.xforceplus.seller.config.client.model.MsQueryTerminalResponse;
import com.xforceplus.seller.config.client.model.MsResponsePageInfo;
import com.xforceplus.seller.config.client.model.MsTerminalQueryInfo;
import com.xforceplus.seller.config.client.model.MsTerminalQueryResponseInfo;
import com.xforceplus.seller.config.client.model.MsTerminalQueryResult;
import com.xforceplus.seller.config.models.QueryTerminalResponse;
import com.xforceplus.seller.config.models.ResponsePageInfo;
import com.xforceplus.seller.config.models.RestQueryDeviceRequest;
import com.xforceplus.seller.config.models.TerminalQueryResponseInfo;
import com.xforceplus.seller.config.models.TerminalQueryResult;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper(componentModel="spring", imports={Lists.class, BusinessSalesBillTypeEnum.class, Date.class, StringUtils.class})
public interface DeviceConverter {
    @Mappings(value={@Mapping(target="queryServiceState", expression="java(request.QueryServiceState())"), @Mapping(target="queryOriginAccountServiceState", expression="java(request.QueryOriginAccountServiceState())")})
    public RestQueryDeviceRequest convertQueryRequestToRest(QueryDeviceRequest var1);

    public TerminalQueryInfo convert(MsTerminalQueryInfo var1);

    public CompanyInfo convert(MsCompanyInfo var1);

    @Mappings(value={@Mapping(target="directOnlineFlag", ignore=true), @Mapping(target="printerOnlineFlag", ignore=true), @Mapping(target="onlineDevice.id", ignore=true), @Mapping(target="onlineFlag", ignore=true)})
    public MsTerminalQueryResponseInfo convert(com.xforceplus.micro.tax.device.contract.model.TerminalQueryResponseInfo var1);

    @Mapping(target="companyInfo", source="request")
    public TerminalQueryInfo convert(MsQueryTerminalRequest var1);

    public CompanyInfo convertCompanyInfo(MsQueryTerminalRequest var1);

    public MsQueryTerminalRequest copy(MsQueryTerminalRequest var1);

    @Mappings(value={@Mapping(target="companyId", expression="java( null != companyInfo.getCompanyId() ? Lists.newArrayList(companyInfo.getCompanyId()) : Lists.newArrayList())"), @Mapping(target="organizationId", expression="java(null != companyInfo.getOrganizationId() ? Lists.newArrayList(companyInfo.getOrganizationId()) : Lists.newArrayList())"), @Mapping(target="tenantId", expression="java(null != companyInfo.getTenantId() ? Lists.newArrayList(companyInfo.getTenantId()) : Lists.newArrayList())")})
    public MsCompanyQueryInfo convert(com.xforceplus.seller.config.models.CompanyInfo var1);

    public QueryTerminalResponse convert(MsQueryTerminalResponse var1);

    public TerminalQueryResult convert(MsTerminalQueryResult var1);

    public ResponsePageInfo convert(MsResponsePageInfo var1);

    public TerminalQueryResponseInfo convert(MsTerminalQueryResponseInfo var1);

    public List<Inventory> copy(List<Inventory> var1);

    public Inventory copy(Inventory var1);
}

