/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.converters;

import com.xforceplus.seller.config.converters.GlobalConfig;
import com.xforceplus.seller.config.converters.Helper;
import com.xforceplus.seller.config.converters.InventoryConfigBase;
import com.xforceplus.seller.config.core.enums.InventoryReceiverType;
import com.xforceplus.seller.config.core.enums.ValueEnum;
import com.xforceplus.seller.config.models.AddInventoryConfigRequest;
import com.xforceplus.seller.config.models.InventoryData;
import com.xforceplus.seller.config.models.InventoryLogData;
import com.xforceplus.seller.config.models.InventoryUniqueData;
import com.xforceplus.seller.config.models.Receiver;
import com.xforceplus.seller.config.models.WarnReceiver;
import com.xforceplus.seller.config.repository.model.CfgConfigInventoryEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigInventoryLogEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigInventoryReceiverEntity;
import java.util.Date;
import java.util.List;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper(config=GlobalConfig.class, uses={Helper.class}, imports={Date.class, ValueEnum.class, InventoryReceiverType.class})
public interface InventoryConfigConverter {
    @Mapping(target="id", source="id")
    @InventoryConfigBase
    public CfgConfigInventoryEntity convert(AddInventoryConfigRequest var1, Long var2, Long var3);

    @Mappings(value={@Mapping(target="id", source="id"), @Mapping(target="inventoryId", source="inventoryId"), @Mapping(target="receiver", source="receiver.receiver"), @Mapping(target="receiverType", expression="java(ValueEnum.getOrdinalByValue(InventoryReceiverType.class, receiver.getType()))")})
    @InventoryConfigBase
    public CfgConfigInventoryReceiverEntity convert(WarnReceiver var1, Long var2, Long var3, Long var4);

    public List<InventoryLogData> convert(List<CfgConfigInventoryLogEntity> var1);

    @Mapping(target="createdAt", qualifiedByName={"helper", "Date_ToString"})
    public InventoryLogData convert(CfgConfigInventoryLogEntity var1);

    @Mapping(target="receiverList", source="receiverEntityList")
    public InventoryData convert(CfgConfigInventoryEntity var1, List<CfgConfigInventoryReceiverEntity> var2);

    @Mapping(target="type", source="receiverType")
    public WarnReceiver convert(CfgConfigInventoryReceiverEntity var1);

    public List<Receiver> convertReceiver(List<CfgConfigInventoryReceiverEntity> var1);

    @Mapping(target="receiverType", expression="java(InventoryReceiverType.EMAIL.getValue())")
    public Receiver convertReceiver(CfgConfigInventoryReceiverEntity var1);

    public List<InventoryUniqueData> convertToUniqueData(List<CfgConfigInventoryEntity> var1);

    public InventoryUniqueData convertToUniqueData(CfgConfigInventoryEntity var1);
}

