/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.converters;

import com.xforceplus.seller.config.converters.Helper;
import com.xforceplus.seller.config.converters.InventoryConfigConverter;
import com.xforceplus.seller.config.core.enums.InventoryReceiverType;
import com.xforceplus.seller.config.core.enums.ValueEnum;
import com.xforceplus.seller.config.models.AddInventoryConfigRequest;
import com.xforceplus.seller.config.models.InventoryData;
import com.xforceplus.seller.config.models.InventoryLogData;
import com.xforceplus.seller.config.models.InventoryUniqueData;
import com.xforceplus.seller.config.models.Receiver;
import com.xforceplus.seller.config.models.WarnReceiver;
import com.xforceplus.seller.config.repository.model.CfgConfigInventoryEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigInventoryLogEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigInventoryReceiverEntity;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InventoryConfigConverterImpl
implements InventoryConfigConverter {
    private final Helper helper;

    @Autowired
    public InventoryConfigConverterImpl(Helper helper) {
        this.helper = helper;
    }

    public CfgConfigInventoryEntity convert(AddInventoryConfigRequest request, Long id, Long userId) {
        if (request == null && id == null && userId == null) {
            return null;
        }
        CfgConfigInventoryEntity cfgConfigInventoryEntity = new CfgConfigInventoryEntity();
        if (request != null) {
            cfgConfigInventoryEntity.setCompanyName(request.getCompanyName());
            cfgConfigInventoryEntity.setTaxNo(request.getTaxNo());
            cfgConfigInventoryEntity.setGroupId(Long.valueOf(request.getGroupId()));
            cfgConfigInventoryEntity.setCompanyId(Long.valueOf(request.getCompanyId()));
            cfgConfigInventoryEntity.setOrganizationId(Long.valueOf(request.getOrganizationId()));
            cfgConfigInventoryEntity.setDeviceNo(request.getDeviceNo());
            cfgConfigInventoryEntity.setDeviceType(request.getDeviceType());
            cfgConfigInventoryEntity.setMachineNo(request.getMachineNo());
            cfgConfigInventoryEntity.setInvoiceType(request.getInvoiceType());
            cfgConfigInventoryEntity.setWarnNum(Integer.valueOf(request.getWarnNum()));
            cfgConfigInventoryEntity.setDeviceUn(request.getDeviceUn());
        }
        if (id != null) {
            cfgConfigInventoryEntity.setId(id);
        }
        if (userId != null) {
            cfgConfigInventoryEntity.setCreatedBy(userId);
        }
        cfgConfigInventoryEntity.setDeletedFlag(Long.valueOf(0L));
        cfgConfigInventoryEntity.setCreatedAt(new Date());
        cfgConfigInventoryEntity.setModifiedBy(null);
        cfgConfigInventoryEntity.setModifiedAt(null);
        return cfgConfigInventoryEntity;
    }

    public CfgConfigInventoryReceiverEntity convert(WarnReceiver receiver, Long inventoryId, Long id, Long userId) {
        if (receiver == null && inventoryId == null && id == null && userId == null) {
            return null;
        }
        CfgConfigInventoryReceiverEntity cfgConfigInventoryReceiverEntity = new CfgConfigInventoryReceiverEntity();
        if (receiver != null) {
            cfgConfigInventoryReceiverEntity.setReceiver(receiver.getReceiver());
        }
        if (inventoryId != null) {
            cfgConfigInventoryReceiverEntity.setInventoryId(inventoryId);
        }
        if (id != null) {
            cfgConfigInventoryReceiverEntity.setId(id);
        }
        if (userId != null) {
            cfgConfigInventoryReceiverEntity.setCreatedBy(userId);
        }
        cfgConfigInventoryReceiverEntity.setReceiverType(ValueEnum.getOrdinalByValue(InventoryReceiverType.class, (Object)receiver.getType()));
        cfgConfigInventoryReceiverEntity.setDeletedFlag(Long.valueOf(0L));
        cfgConfigInventoryReceiverEntity.setCreatedAt(new Date());
        cfgConfigInventoryReceiverEntity.setModifiedBy(null);
        cfgConfigInventoryReceiverEntity.setModifiedAt(null);
        return cfgConfigInventoryReceiverEntity;
    }

    public List<InventoryLogData> convert(List<CfgConfigInventoryLogEntity> entityList) {
        if (entityList == null) {
            return null;
        }
        ArrayList<InventoryLogData> list = new ArrayList<InventoryLogData>(entityList.size());
        for (CfgConfigInventoryLogEntity cfgConfigInventoryLogEntity : entityList) {
            list.add(this.convert(cfgConfigInventoryLogEntity));
        }
        return list;
    }

    public InventoryLogData convert(CfgConfigInventoryLogEntity entity) {
        if (entity == null) {
            return null;
        }
        InventoryLogData inventoryLogData = new InventoryLogData();
        inventoryLogData.setCreatedAt(this.helper.dateToString(entity.getCreatedAt()));
        if (entity.getId() != null) {
            inventoryLogData.setId(entity.getId().longValue());
        }
        if (entity.getInventoryId() != null) {
            inventoryLogData.setInventoryId(entity.getInventoryId().longValue());
        }
        if (entity.getAction() != null) {
            inventoryLogData.setAction(entity.getAction().intValue());
        }
        inventoryLogData.setMessage(entity.getMessage());
        inventoryLogData.setCreatedBy(entity.getCreatedBy());
        return inventoryLogData;
    }

    public InventoryData convert(CfgConfigInventoryEntity entity, List<CfgConfigInventoryReceiverEntity> receiverEntityList) {
        if (entity == null && receiverEntityList == null) {
            return null;
        }
        InventoryData inventoryData = new InventoryData();
        if (entity != null) {
            if (entity.getId() != null) {
                inventoryData.setId(entity.getId().longValue());
            }
            inventoryData.setCompanyName(entity.getCompanyName());
            inventoryData.setTaxNo(entity.getTaxNo());
            if (entity.getCompanyId() != null) {
                inventoryData.setCompanyId(entity.getCompanyId().longValue());
            }
            inventoryData.setDeviceNo(entity.getDeviceNo());
            inventoryData.setDeviceUn(entity.getDeviceUn());
            inventoryData.setDeviceType(entity.getDeviceType());
            inventoryData.setMachineNo(entity.getMachineNo());
            inventoryData.setInvoiceType(entity.getInvoiceType());
            if (entity.getWarnNum() != null) {
                inventoryData.setWarnNum(entity.getWarnNum().intValue());
            }
        }
        if (receiverEntityList != null) {
            inventoryData.setReceiverList(this.cfgConfigInventoryReceiverEntityListToWarnReceiverList(receiverEntityList));
        }
        return inventoryData;
    }

    public WarnReceiver convert(CfgConfigInventoryReceiverEntity entity) {
        if (entity == null) {
            return null;
        }
        WarnReceiver warnReceiver = new WarnReceiver();
        if (entity.getReceiverType() != null) {
            warnReceiver.setType(String.valueOf(entity.getReceiverType()));
        }
        warnReceiver.setReceiver(entity.getReceiver());
        return warnReceiver;
    }

    public List<Receiver> convertReceiver(List<CfgConfigInventoryReceiverEntity> entityList) {
        if (entityList == null) {
            return null;
        }
        ArrayList<Receiver> list = new ArrayList<Receiver>(entityList.size());
        for (CfgConfigInventoryReceiverEntity cfgConfigInventoryReceiverEntity : entityList) {
            list.add(this.convertReceiver(cfgConfigInventoryReceiverEntity));
        }
        return list;
    }

    public Receiver convertReceiver(CfgConfigInventoryReceiverEntity entity) {
        if (entity == null) {
            return null;
        }
        Receiver receiver = new Receiver();
        receiver.setReceiver(entity.getReceiver());
        receiver.setReceiverType((String)InventoryReceiverType.EMAIL.getValue());
        return receiver;
    }

    public List<InventoryUniqueData> convertToUniqueData(List<CfgConfigInventoryEntity> entityList) {
        if (entityList == null) {
            return null;
        }
        ArrayList<InventoryUniqueData> list = new ArrayList<InventoryUniqueData>(entityList.size());
        for (CfgConfigInventoryEntity cfgConfigInventoryEntity : entityList) {
            list.add(this.convertToUniqueData(cfgConfigInventoryEntity));
        }
        return list;
    }

    public InventoryUniqueData convertToUniqueData(CfgConfigInventoryEntity entity) {
        if (entity == null) {
            return null;
        }
        InventoryUniqueData inventoryUniqueData = new InventoryUniqueData();
        inventoryUniqueData.setTaxNo(entity.getTaxNo());
        inventoryUniqueData.setDeviceNo(entity.getDeviceNo());
        inventoryUniqueData.setInvoiceType(entity.getInvoiceType());
        if (entity.getWarnNum() != null) {
            inventoryUniqueData.setWarnNum(entity.getWarnNum().intValue());
        }
        inventoryUniqueData.setDeviceUn(entity.getDeviceUn());
        return inventoryUniqueData;
    }

    protected List<WarnReceiver> cfgConfigInventoryReceiverEntityListToWarnReceiverList(List<CfgConfigInventoryReceiverEntity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<WarnReceiver> list1 = new ArrayList<WarnReceiver>(list.size());
        for (CfgConfigInventoryReceiverEntity cfgConfigInventoryReceiverEntity : list) {
            list1.add(this.convert(cfgConfigInventoryReceiverEntity));
        }
        return list1;
    }
}

