/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.converters;

import com.xforceplus.seller.config.client.model.MsBusinessObjDTO;
import com.xforceplus.seller.config.client.model.MsBusinessObjMetadataBean;
import com.xforceplus.seller.config.client.model.MsEnumBean;
import com.xforceplus.seller.config.client.model.MsEnumBeanDTO;
import com.xforceplus.seller.config.converters.Helper;
import com.xforceplus.seller.config.converters.MsBusinessObjMetadataConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MsBusinessObjMetadataConverterImpl
implements MsBusinessObjMetadataConverter {
    private final Helper helper;

    @Autowired
    public MsBusinessObjMetadataConverterImpl(Helper helper) {
        this.helper = helper;
    }

    public MsEnumBean toMsEnumBean(MsBusinessObjMetadataBean msBusinessObjMetadataBean, Map<String, Object> map) {
        if (msBusinessObjMetadataBean == null && map == null) {
            return null;
        }
        MsEnumBean msEnumBean = new MsEnumBean();
        if (msBusinessObjMetadataBean != null) {
            msEnumBean.setCode(msBusinessObjMetadataBean.getFieldName());
            msEnumBean.setText(msBusinessObjMetadataBean.getFieldDisplayName());
            if (msBusinessObjMetadataBean.getFieldGroupIndex() != null) {
                msEnumBean.setFieldGroupIndex(String.valueOf(msBusinessObjMetadataBean.getFieldGroupIndex()));
            }
        }
        if (map != null) {
            msEnumBean.setValue(this.helper.mapToString(map));
        }
        return msEnumBean;
    }

    public MsBusinessObjDTO convert(MsBusinessObjMetadataBean bean) {
        if (bean == null) {
            return null;
        }
        MsBusinessObjDTO msBusinessObjDTO = new MsBusinessObjDTO();
        msBusinessObjDTO.setBusinessObjId(bean.getBusinessObjId());
        msBusinessObjDTO.setFieldDisplayName(bean.getFieldDisplayName());
        msBusinessObjDTO.setFieldName(bean.getFieldName());
        msBusinessObjDTO.setFieldEnumValue(this.msEnumBeanListToMsEnumBeanDTOList(bean.getFieldEnumValue()));
        msBusinessObjDTO.setFieldGroupIndex(bean.getFieldGroupIndex());
        return msBusinessObjDTO;
    }

    protected MsEnumBeanDTO msEnumBeanToMsEnumBeanDTO(MsEnumBean msEnumBean) {
        if (msEnumBean == null) {
            return null;
        }
        MsEnumBeanDTO msEnumBeanDTO = new MsEnumBeanDTO();
        msEnumBeanDTO.setValue(msEnumBean.getValue());
        msEnumBeanDTO.setCode(msEnumBean.getCode());
        msEnumBeanDTO.setText(msEnumBean.getText());
        return msEnumBeanDTO;
    }

    protected List<MsEnumBeanDTO> msEnumBeanListToMsEnumBeanDTOList(List<MsEnumBean> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MsEnumBeanDTO> list1 = new ArrayList<MsEnumBeanDTO>(list.size());
        for (MsEnumBean msEnumBean : list) {
            list1.add(this.msEnumBeanToMsEnumBeanDTO(msEnumBean));
        }
        return list1;
    }
}

