/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.converters;

import com.xforceplus.phoenix.infrastructure.usercenter.model.GenerateCertificateRequest;
import com.xforceplus.seller.config.client.model.AllElectricIssuerInfoRecord;
import com.xforceplus.seller.config.client.model.BuildCertificateRequest;
import com.xforceplus.seller.config.client.model.CfgAllElectricIssuerRecord;
import com.xforceplus.seller.config.client.model.ConfigAddElectricIssuerInfoRequest;
import com.xforceplus.seller.config.client.model.ConfigAllElectricIssuerInfoRequest;
import com.xforceplus.seller.config.client.model.ConfigDeleteElectricIssuerInfoRequest;
import com.xforceplus.seller.config.client.model.QueryInventoryRequest;
import com.xforceplus.seller.config.client.model.UserRelationData;
import com.xforceplus.seller.config.converters.Helper;
import com.xforceplus.seller.config.converters.TaxWareConverter;
import com.xforceplus.seller.config.models.RestQueryInventoryRequest;
import com.xforceplus.seller.config.repository.model.CfgAllElectricIssuerRecordEntity;
import com.xforceplus.seller.config.repository.model.CfgUserIssuerRelationEntity;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaxWareConverterImpl
implements TaxWareConverter {
    private final Helper helper;

    @Autowired
    public TaxWareConverterImpl(Helper helper) {
        this.helper = helper;
    }

    public RestQueryInventoryRequest convert(QueryInventoryRequest request) {
        if (request == null) {
            return null;
        }
        String arg0 = null;
        String arg1 = null;
        String arg2 = null;
        String arg3 = null;
        String arg4 = null;
        RestQueryInventoryRequest restQueryInventoryRequest = new RestQueryInventoryRequest(arg0, arg1, arg2, arg3, arg4);
        restQueryInventoryRequest.setTaxCodes(this.helper.listToString(request.getTaxNoList()));
        restQueryInventoryRequest.setInvoiceTypes(this.helper.listToString(request.getInvoiceTypeList()));
        restQueryInventoryRequest.setDeviceNos(this.helper.listToString(request.getDeviceNoList()));
        restQueryInventoryRequest.setInvoiceServiceType(request.getDeviceType());
        restQueryInventoryRequest.setTerminalNo(request.getTerminalNo());
        return restQueryInventoryRequest;
    }

    public GenerateCertificateRequest convert(BuildCertificateRequest request) {
        if (request == null) {
            return null;
        }
        GenerateCertificateRequest generateCertificateRequest = new GenerateCertificateRequest();
        generateCertificateRequest.setName(request.getName());
        generateCertificateRequest.setTaxCode(request.getTaxCode());
        generateCertificateRequest.setAddress(request.getAddress());
        generateCertificateRequest.setGroupCode(request.getGroupCode());
        return generateCertificateRequest;
    }

    public ConfigAllElectricIssuerInfoRequest convert(ConfigAddElectricIssuerInfoRequest request, String userName) {
        if (request == null && userName == null) {
            return null;
        }
        ConfigAllElectricIssuerInfoRequest configAllElectricIssuerInfoRequest = new ConfigAllElectricIssuerInfoRequest();
        if (request != null) {
            configAllElectricIssuerInfoRequest.setTaxNo(request.getTaxNo());
            configAllElectricIssuerInfoRequest.setIssuer(request.getIssuer());
            configAllElectricIssuerInfoRequest.setIssueType(request.getIssueType());
            configAllElectricIssuerInfoRequest.setAccount(request.getAccount());
            configAllElectricIssuerInfoRequest.setPassword(request.getPassword());
        }
        if (userName != null) {
            configAllElectricIssuerInfoRequest.setOperator(userName);
        }
        return configAllElectricIssuerInfoRequest;
    }

    public ConfigAllElectricIssuerInfoRequest convert(ConfigDeleteElectricIssuerInfoRequest.ConfigDeleteElectricIssuerInfo request, String userName) {
        if (request == null && userName == null) {
            return null;
        }
        ConfigAllElectricIssuerInfoRequest configAllElectricIssuerInfoRequest = new ConfigAllElectricIssuerInfoRequest();
        if (request != null) {
            configAllElectricIssuerInfoRequest.setTaxNo(request.getTaxNo());
            configAllElectricIssuerInfoRequest.setIssuer(request.getIssuer());
            configAllElectricIssuerInfoRequest.setIssueType(request.getIssueType());
        }
        if (userName != null) {
            configAllElectricIssuerInfoRequest.setOperator(userName);
        }
        return configAllElectricIssuerInfoRequest;
    }

    public List<CfgAllElectricIssuerRecord> convert(List<CfgAllElectricIssuerRecordEntity> entities) {
        if (entities == null) {
            return null;
        }
        ArrayList<CfgAllElectricIssuerRecord> list = new ArrayList<CfgAllElectricIssuerRecord>(entities.size());
        for (CfgAllElectricIssuerRecordEntity cfgAllElectricIssuerRecordEntity : entities) {
            list.add(this.cfgAllElectricIssuerRecordEntityToCfgAllElectricIssuerRecord(cfgAllElectricIssuerRecordEntity));
        }
        return list;
    }

    public ConfigAddElectricIssuerInfoRequest convert(ConfigDeleteElectricIssuerInfoRequest.ConfigDeleteElectricIssuerInfo info) {
        if (info == null) {
            return null;
        }
        ConfigAddElectricIssuerInfoRequest configAddElectricIssuerInfoRequest = new ConfigAddElectricIssuerInfoRequest();
        configAddElectricIssuerInfoRequest.setCompanyName(info.getCompanyName());
        configAddElectricIssuerInfoRequest.setTaxNo(info.getTaxNo());
        configAddElectricIssuerInfoRequest.setIssuer(info.getIssuer());
        configAddElectricIssuerInfoRequest.setIssueType(info.getIssueType());
        configAddElectricIssuerInfoRequest.setUniqueKey(info.getUniqueKey());
        return configAddElectricIssuerInfoRequest;
    }

    public UserRelationData.UserRelationInfo convert(CfgUserIssuerRelationEntity relationEntity) {
        if (relationEntity == null) {
            return null;
        }
        UserRelationData.UserRelationInfo userRelationInfo = new UserRelationData.UserRelationInfo();
        userRelationInfo.setId(relationEntity.getId());
        userRelationInfo.setMobile(relationEntity.getMobile());
        userRelationInfo.setEmail(relationEntity.getEmail());
        userRelationInfo.setUserId(relationEntity.getUserId());
        userRelationInfo.setUserName(relationEntity.getUserName());
        userRelationInfo.setAccountName(relationEntity.getAccountName());
        userRelationInfo.setTenantId(relationEntity.getTenantId());
        userRelationInfo.setTaxNo(relationEntity.getTaxNo());
        userRelationInfo.setRelationType(relationEntity.getRelationType());
        if (relationEntity.getStatus() != null) {
            userRelationInfo.setStatus(relationEntity.getStatus().intValue());
        }
        userRelationInfo.setIssuer(relationEntity.getIssuer());
        userRelationInfo.setIssueType(relationEntity.getIssueType());
        userRelationInfo.setCompanyName(relationEntity.getCompanyName());
        userRelationInfo.setUniqueKey(relationEntity.getUniqueKey());
        return userRelationInfo;
    }

    public List<UserRelationData.UserRelationInfo> convertList(List<CfgUserIssuerRelationEntity> entities) {
        if (entities == null) {
            return null;
        }
        ArrayList<UserRelationData.UserRelationInfo> list = new ArrayList<UserRelationData.UserRelationInfo>(entities.size());
        for (CfgUserIssuerRelationEntity cfgUserIssuerRelationEntity : entities) {
            list.add(this.convert(cfgUserIssuerRelationEntity));
        }
        return list;
    }

    public CfgUserIssuerRelationEntity convertRelationEntity(UserRelationData.UserRelationInfo userRelationInfo) {
        if (userRelationInfo == null) {
            return null;
        }
        CfgUserIssuerRelationEntity cfgUserIssuerRelationEntity = new CfgUserIssuerRelationEntity();
        cfgUserIssuerRelationEntity.setId(userRelationInfo.getId());
        cfgUserIssuerRelationEntity.setEmail(userRelationInfo.getEmail());
        cfgUserIssuerRelationEntity.setMobile(userRelationInfo.getMobile());
        cfgUserIssuerRelationEntity.setRelationType(userRelationInfo.getRelationType());
        cfgUserIssuerRelationEntity.setUserId(userRelationInfo.getUserId());
        cfgUserIssuerRelationEntity.setUserName(userRelationInfo.getUserName());
        cfgUserIssuerRelationEntity.setAccountName(userRelationInfo.getAccountName());
        cfgUserIssuerRelationEntity.setTaxNo(userRelationInfo.getTaxNo());
        cfgUserIssuerRelationEntity.setTenantId(userRelationInfo.getTenantId());
        cfgUserIssuerRelationEntity.setStatus(Integer.valueOf(userRelationInfo.getStatus()));
        cfgUserIssuerRelationEntity.setUniqueKey(userRelationInfo.getUniqueKey());
        cfgUserIssuerRelationEntity.setIssuer(userRelationInfo.getIssuer());
        cfgUserIssuerRelationEntity.setIssueType(userRelationInfo.getIssueType());
        cfgUserIssuerRelationEntity.setCompanyName(userRelationInfo.getCompanyName());
        return cfgUserIssuerRelationEntity;
    }

    public List<CfgUserIssuerRelationEntity> convertRelationEntityList(List<UserRelationData.UserRelationInfo> userRelationInfoList, List<Long> idList) {
        if (userRelationInfoList == null) {
            return null;
        }
        ArrayList<CfgUserIssuerRelationEntity> list = new ArrayList<CfgUserIssuerRelationEntity>(userRelationInfoList.size());
        for (UserRelationData.UserRelationInfo userRelationInfo : userRelationInfoList) {
            list.add(this.convertRelationEntity(userRelationInfo));
        }
        this.fillCfgUserIssuerRelationEntityList(list, idList);
        return list;
    }

    public UserRelationData.UserRelationErrorInfo convertRelationErrorInfo(UserRelationData.UserRelationInfo userRelationInfo, String errorMsg) {
        if (userRelationInfo == null && errorMsg == null) {
            return null;
        }
        UserRelationData.UserRelationErrorInfo userRelationErrorInfo = new UserRelationData.UserRelationErrorInfo();
        if (userRelationInfo != null) {
            userRelationErrorInfo.setId(userRelationInfo.getId());
            userRelationErrorInfo.setMobile(userRelationInfo.getMobile());
            userRelationErrorInfo.setEmail(userRelationInfo.getEmail());
            userRelationErrorInfo.setUserId(userRelationInfo.getUserId());
            userRelationErrorInfo.setUserName(userRelationInfo.getUserName());
            userRelationErrorInfo.setAccountName(userRelationInfo.getAccountName());
            userRelationErrorInfo.setTenantId(userRelationInfo.getTenantId());
            userRelationErrorInfo.setTaxNo(userRelationInfo.getTaxNo());
            userRelationErrorInfo.setRelationType(userRelationInfo.getRelationType());
            userRelationErrorInfo.setStatus(userRelationInfo.getStatus());
            userRelationErrorInfo.setIssuer(userRelationInfo.getIssuer());
            userRelationErrorInfo.setIssueType(userRelationInfo.getIssueType());
            userRelationErrorInfo.setCompanyName(userRelationInfo.getCompanyName());
            userRelationErrorInfo.setUniqueKey(userRelationInfo.getUniqueKey());
        }
        if (errorMsg != null) {
            userRelationErrorInfo.setErrorMsg(errorMsg);
        }
        return userRelationErrorInfo;
    }

    public UserRelationData.UserRelationErrorInfo convertRelationErrorInfo(UserRelationData.ImportUserRelationInfo importUserRelationInfo, String errorMsg) {
        if (importUserRelationInfo == null && errorMsg == null) {
            return null;
        }
        UserRelationData.UserRelationErrorInfo userRelationErrorInfo = new UserRelationData.UserRelationErrorInfo();
        if (importUserRelationInfo != null) {
            userRelationErrorInfo.setId(importUserRelationInfo.getId());
            userRelationErrorInfo.setAccountName(importUserRelationInfo.getAccountName());
            userRelationErrorInfo.setTaxNo(importUserRelationInfo.getTaxNo());
            userRelationErrorInfo.setRelationType(importUserRelationInfo.getRelationType());
            if (importUserRelationInfo.getStatus() != null) {
                userRelationErrorInfo.setStatus(importUserRelationInfo.getStatus().intValue());
            }
            userRelationErrorInfo.setIssuer(importUserRelationInfo.getIssuer());
            userRelationErrorInfo.setIssueType(importUserRelationInfo.getIssueType());
        }
        if (errorMsg != null) {
            userRelationErrorInfo.setErrorMsg(errorMsg);
        }
        return userRelationErrorInfo;
    }

    public List<AllElectricIssuerInfoRecord> convertAllElectricIssuerInfoRecordList(List<CfgUserIssuerRelationEntity> relationEntityList) {
        if (relationEntityList == null) {
            return null;
        }
        ArrayList<AllElectricIssuerInfoRecord> list = new ArrayList<AllElectricIssuerInfoRecord>(relationEntityList.size());
        for (CfgUserIssuerRelationEntity cfgUserIssuerRelationEntity : relationEntityList) {
            list.add(this.cfgUserIssuerRelationEntityToAllElectricIssuerInfoRecord(cfgUserIssuerRelationEntity));
        }
        return list;
    }

    protected CfgAllElectricIssuerRecord cfgAllElectricIssuerRecordEntityToCfgAllElectricIssuerRecord(CfgAllElectricIssuerRecordEntity cfgAllElectricIssuerRecordEntity) {
        if (cfgAllElectricIssuerRecordEntity == null) {
            return null;
        }
        CfgAllElectricIssuerRecord cfgAllElectricIssuerRecord = new CfgAllElectricIssuerRecord();
        cfgAllElectricIssuerRecord.setId(cfgAllElectricIssuerRecordEntity.getId());
        cfgAllElectricIssuerRecord.setCompanyTaxNo(cfgAllElectricIssuerRecordEntity.getCompanyTaxNo());
        cfgAllElectricIssuerRecord.setCompanyName(cfgAllElectricIssuerRecordEntity.getCompanyName());
        cfgAllElectricIssuerRecord.setIssuer(cfgAllElectricIssuerRecordEntity.getIssuer());
        cfgAllElectricIssuerRecord.setIssueType(cfgAllElectricIssuerRecordEntity.getIssueType());
        cfgAllElectricIssuerRecord.setUniqueKey(cfgAllElectricIssuerRecordEntity.getUniqueKey());
        cfgAllElectricIssuerRecord.setSellerGroupId(cfgAllElectricIssuerRecordEntity.getSellerGroupId());
        cfgAllElectricIssuerRecord.setOperateType(cfgAllElectricIssuerRecordEntity.getOperateType());
        cfgAllElectricIssuerRecord.setOperator(cfgAllElectricIssuerRecordEntity.getOperator());
        cfgAllElectricIssuerRecord.setOperatorId(cfgAllElectricIssuerRecordEntity.getOperatorId());
        cfgAllElectricIssuerRecord.setOperateTime(cfgAllElectricIssuerRecordEntity.getOperateTime());
        return cfgAllElectricIssuerRecord;
    }

    protected AllElectricIssuerInfoRecord cfgUserIssuerRelationEntityToAllElectricIssuerInfoRecord(CfgUserIssuerRelationEntity cfgUserIssuerRelationEntity) {
        if (cfgUserIssuerRelationEntity == null) {
            return null;
        }
        AllElectricIssuerInfoRecord allElectricIssuerInfoRecord = new AllElectricIssuerInfoRecord();
        allElectricIssuerInfoRecord.setTaxNo(cfgUserIssuerRelationEntity.getTaxNo());
        allElectricIssuerInfoRecord.setCompanyName(cfgUserIssuerRelationEntity.getCompanyName());
        allElectricIssuerInfoRecord.setIssuer(cfgUserIssuerRelationEntity.getIssuer());
        allElectricIssuerInfoRecord.setIssueType(cfgUserIssuerRelationEntity.getIssueType());
        allElectricIssuerInfoRecord.setUniqueKey(cfgUserIssuerRelationEntity.getUniqueKey());
        allElectricIssuerInfoRecord.setStatus(cfgUserIssuerRelationEntity.getStatus());
        return allElectricIssuerInfoRecord;
    }
}

