/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.facade;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.MqUtils;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.phoenix.infrastructure.usercenter.model.GenerateCertificateRequest;
import com.xforceplus.phoenix.sqs.SQSSender;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.constant.ObjCodeEnum;
import com.xforceplus.seller.config.client.constant.StatusEnum;
import com.xforceplus.seller.config.client.model.ConfigCommodityInfo;
import com.xforceplus.seller.config.client.model.ConfigOperatorInfo;
import com.xforceplus.seller.config.client.model.ConfigTitleAndIssueInfoAddRequest;
import com.xforceplus.seller.config.client.model.ConfigTitleAndIssueInfoBatchAddRequest;
import com.xforceplus.seller.config.client.model.ConfigTitleAndIssueInfoQueryRequest;
import com.xforceplus.seller.config.client.model.ConfigTtitleInfo;
import com.xforceplus.seller.config.client.model.GoodsRequest;
import com.xforceplus.seller.config.client.model.InitSettledTemplateConfigRequest;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.model.MsConfigQueryRequest;
import com.xforceplus.seller.config.client.model.MsMataDataQueryRequest;
import com.xforceplus.seller.config.client.model.Page;
import com.xforceplus.seller.config.client.model.QueryManualInitConfigRequest;
import com.xforceplus.seller.config.client.model.QuerySettledTemplateRequest;
import com.xforceplus.seller.config.client.model.SettledSalesbillTypeInfoVo;
import com.xforceplus.seller.config.client.model.SettledTemplateConifgVo;
import com.xforceplus.seller.config.client.model.SettledTemplateDataVo;
import com.xforceplus.seller.config.client.model.SettledTemplateDeleteRequest;
import com.xforceplus.seller.config.client.model.SettledTemplateEditRequest;
import com.xforceplus.seller.config.client.model.SettledTemplateQueryRequest;
import com.xforceplus.seller.config.client.parse.bean.InvoiceInfoRuleDTO;
import com.xforceplus.seller.config.client.parse.impl.InvoiceInfoRlueParser;
import com.xforceplus.seller.config.converters.TemplateObjMetadataConverter;
import com.xforceplus.seller.config.core.enums.BusinessBillType;
import com.xforceplus.seller.config.core.enums.ErrorCodeEnum;
import com.xforceplus.seller.config.core.enums.InitTemplateConfigEnum;
import com.xforceplus.seller.config.core.enums.InvoiceType;
import com.xforceplus.seller.config.core.enums.SettledTypeEnum;
import com.xforceplus.seller.config.facade.ConfigInfoAllInOneFacade;
import com.xforceplus.seller.config.facade.settled.SettledConfigFacade;
import com.xforceplus.seller.config.infrastructure.helper.DeviceApiProxy;
import com.xforceplus.seller.config.models.GenerateCertificateResponse;
import com.xforceplus.seller.config.models.QianNiuDeliverData;
import com.xforceplus.seller.config.models.TenantSettledFinishDeliverVo;
import com.xforceplus.seller.config.repository.model.CfgConfigEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigExample;
import com.xforceplus.seller.config.repository.model.CfgTemplateSettledObjEntity;
import com.xforceplus.seller.config.repository.model.CfgTemplateSettledObjExample;
import com.xforceplus.seller.config.services.CfgConfigDataService;
import com.xforceplus.seller.config.services.ConfigBizConfigService;
import com.xforceplus.seller.config.services.ConfigMetaDataService;
import com.xforceplus.seller.config.services.TemplateObjMetadataService;
import com.xforceplus.seller.enums.TaxPres;
import com.xforceplus.seller.enums.ZeroTaxs;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import io.geewit.web.utils.JsonUtils;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Tuple5;
import io.vavr.control.Either;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.wicp.tams.common.Result;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ConfigInfoAllInOneFacadeImpl
implements ConfigInfoAllInOneFacade {
    private static final Logger log = LoggerFactory.getLogger(ConfigInfoAllInOneFacadeImpl.class);
    private final UserInfoHolder<UserInfo> userInfoHolder;
    private final ConfigBizConfigService configBizConfigService;
    private final InvoiceInfoRlueParser invoiceInfoRlueParser;
    private static final String FIX_CHANNEL = "\u5343\u725b\u6e20\u9053";
    private final IDGenerator idGenerator;
    private final MqUtils mqUtils;
    private final DeviceApiProxy deviceApiProxy;
    private final TemplateObjMetadataService templateObjMetadataService;
    private final TemplateObjMetadataConverter templateObjMetadataConverter;
    private final CfgConfigDataService cfgConfigDataService;
    private final ConfigMetaDataService configMetaDataService;
    private final SettledConfigFacade settledConfigFacade;

    public Response addOrUpdateTitleAndIssueInfo(ConfigTitleAndIssueInfoAddRequest request, String source) {
        log.info("addOrUpdateTitleAndIssueInfo request {}", (Object)JsonUtils.toJson((Object)request));
        String salesbillType = "";
        if ("common".equals(source)) {
            String errorMsg = this.checkParam(request);
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                return Response.failed((String)errorMsg);
            }
            CfgTemplateSettledObjEntity settledObjEntity = this.settledConfigFacade.queryOneSettledTemplate(Integer.valueOf(Objects.isNull(request.getSettledType()) ? 0 : request.getSettledType()), Long.valueOf(request.getChannel()), request.getProductCode());
            if (Objects.isNull(settledObjEntity) || StringUtils.isBlank((CharSequence)settledObjEntity.getSalesbillType())) {
                return Response.failed((String)"\u672a\u67e5\u8be2\u5230\u6a21\u677f\u4fe1\u606f \u6216 \u4e1a\u52a1\u5355\u7c7b\u578b\u672a\u914d\u7f6e");
            }
            salesbillType = settledObjEntity.getSalesbillType();
        }
        if (StringUtils.equalsAny((CharSequence)request.getInvoiceType(), (CharSequence[])new CharSequence[]{InvoiceType.QC.value(), InvoiceType.QS.value(), InvoiceType.SZ.value(), InvoiceType.CZ.value()})) {
            this.sendData(request.getConfigCommodityInfo(), String.valueOf(this.idGenerator.nextId()), request.getTenantId());
            this.sendQuanNiuConfigData(this.buildQianNiuDeliverData(request));
            if ("common".equals(source)) {
                this.sendSettledDataFinishData(this.settledDataIsFinish(request), request);
            }
            return Response.ok((String)"\u64cd\u4f5c\u6210\u529f");
        }
        MsConfigAddRequestWithUserInfo addConfigRequest = this.toOperatorReuest(request, source, salesbillType);
        Response operatorResult = this.configBizConfigService.addCfgConfig(addConfigRequest, new String[0]);
        log.info("operatorResult {}", (Object)JsonUtils.toJson((Object)operatorResult));
        MsConfigAddRequestWithUserInfo addTitleConfigRequest = this.toTitleReuest(request, source, salesbillType);
        Response titleResult = this.configBizConfigService.addCfgConfig(addTitleConfigRequest, new String[0]);
        log.info("titleResult {}", (Object)JsonUtils.toJson((Object)titleResult));
        if (operatorResult.getCode().intValue() == Response.OK.intValue() && titleResult.getCode().intValue() == Response.OK.intValue()) {
            this.sendData(request.getConfigCommodityInfo(), String.valueOf(this.idGenerator.nextId()), request.getTenantId());
            GenerateCertificateRequest generateCertificateRequest = new GenerateCertificateRequest(request.getCompanyName(), request.getCompanyTaxNo(), "", "", request.getConfigTitleInfo().getAddress(), String.valueOf(((UserInfo)this.userInfoHolder.get()).getGroupId()));
            GenerateCertificateResponse commonResponse = this.deviceApiProxy.generateCerificatePost(generateCertificateRequest);
            log.info("\u5236\u8bc1\u8bf7\u6c42request {}, \u7a0e\u4ef6\u8fd4\u56de\u7684\u503c\u8bc1\u7ed3\u679c\u4e3a {}", (Object)JsonUtils.toJson((Object)generateCertificateRequest), (Object)JsonUtils.toJson((Object)commonResponse));
            this.sendQuanNiuConfigData(this.buildQianNiuDeliverData(request));
            if ("common".equals(source)) {
                this.sendSettledDataFinishData(this.settledDataIsFinish(request), request);
            }
            return Response.ok((String)"\u64cd\u4f5c\u6210\u529f");
        }
        return Response.failed((String)(operatorResult.getMessage() + "-" + titleResult.getMessage()));
    }

    public Either<List<String>, Boolean> batchAddTitleAndIssueInfo(ConfigTitleAndIssueInfoBatchAddRequest request) {
        if (Objects.isNull(request.getTenantId()) || request.getTenantId() <= 0L) {
            return Either.left((Object)Lists.newArrayList((Object[])new String[]{"\u79df\u6237Id\u4e0d\u80fd\u4e3a\u7a7a"}));
        }
        if (StringUtils.isBlank((CharSequence)request.getCompanyTaxNo())) {
            return Either.left((Object)Lists.newArrayList((Object[])new String[]{"\u516c\u53f8\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a"}));
        }
        if (CollectionUtils.isEmpty((Collection)request.getSalesbillTypeList())) {
            return Either.left((Object)Lists.newArrayList((Object[])new String[]{"\u4e1a\u52a1\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"}));
        }
        List filteredBillTypeList = request.getSalesbillTypeList().stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filteredBillTypeList)) {
            return Either.left((Object)Lists.newArrayList((Object[])new String[]{"\u4e1a\u52a1\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"}));
        }
        if (Objects.isNull(request.getConfigOperatorInfo()) || Objects.isNull(request.getConfigTitleInfo())) {
            return Either.left((Object)Lists.newArrayList((Object[])new String[]{"\u62ac\u5934\u3001\u7968\u9762\u4eba\u5458\u89c4\u5219\u4fe1\u606f\u5747\u4e0d\u80fd\u4e3a\u7a7a"}));
        }
        request.getConfigOperatorInfo().setOperatorConfigId(null);
        request.getConfigTitleInfo().setTitleConfigId(null);
        ArrayList errorList = Lists.newArrayList();
        Long tenantId = request.getTenantId();
        String companyTaxNo = request.getCompanyTaxNo();
        ConfigOperatorInfo operatorInfo = request.getConfigOperatorInfo();
        ConfigTtitleInfo titleInfo = request.getConfigTitleInfo();
        for (String salesbillType : filteredBillTypeList) {
            MsConfigAddRequestWithUserInfo addConfigRequest = this.toOperatorReuest(operatorInfo, null, tenantId, companyTaxNo, salesbillType);
            Response operatorResult = this.configBizConfigService.addCfgConfig(addConfigRequest, new String[0]);
            log.info("batchAddTitleAndIssueInfo operatorResult {}", (Object)JsonUtils.toJson((Object)operatorResult));
            MsConfigAddRequestWithUserInfo addTitleConfigRequest = this.toTitleReuest(titleInfo, null, tenantId, companyTaxNo, salesbillType);
            Response titleResult = this.configBizConfigService.addCfgConfig(addTitleConfigRequest, new String[0]);
            log.info("batchAddTitleAndIssueInfo titleResult {}", (Object)JsonUtils.toJson((Object)titleResult));
            if (Response.Fail.equals(operatorResult.getCode())) {
                errorList.add("\u4e1a\u52a1\u5355\u7c7b\u578b\u3010" + salesbillType + "\u3011\u7968\u9762\u4eba\u89c4\u5219\u521b\u5efa\u5931\u8d25\uff1a" + operatorResult.getMessage());
            }
            if (!Response.Fail.equals(titleResult.getCode())) continue;
            errorList.add("\u4e1a\u52a1\u5355\u7c7b\u578b\u3010" + salesbillType + "\u3011\u5f00\u7968\u62ac\u5934\u89c4\u5219\u521b\u5efa\u5931\u8d25\uff1a" + titleResult.getMessage());
        }
        if (CollectionUtils.isNotEmpty((Collection)errorList)) {
            return Either.left((Object)errorList);
        }
        return Either.right((Object)true);
    }

    public Tuple2<ConfigTtitleInfo, ConfigOperatorInfo> queryTitleAndIssueInfo(ConfigTitleAndIssueInfoQueryRequest request) {
        ConfigTtitleInfo configTtitleInfo = null;
        ConfigOperatorInfo configOperatorInfo = null;
        request.setTenantId(Long.valueOf(((UserInfo)this.userInfoHolder.get()).getGroupId()));
        Either eitherResult = this.configBizConfigService.getAllInOneConfigItemList(this.toMsConfigQueryRequest(request, ConfigTypeEnum.INVOICE_CONFIG_TYPE.getConfigType()));
        if (eitherResult.isRight() && CollectionUtils.isNotEmpty((Collection)((Collection)eitherResult.get()))) {
            configTtitleInfo = this.toConfigTtitleInfo((List)eitherResult.get());
        }
        if ((eitherResult = this.configBizConfigService.getAllInOneConfigItemList(this.toMsConfigQueryRequest(request, ConfigTypeEnum.INVOICE_USER_CONFIG_TYPE.getConfigType()))).isRight() && CollectionUtils.isNotEmpty((Collection)((Collection)eitherResult.get()))) {
            configOperatorInfo = this.toConfigOperatorInfo((List)eitherResult.get());
        }
        return Tuple.of((Object)configTtitleInfo, configOperatorInfo);
    }

    private MsConfigAddRequestWithUserInfo toOperatorReuest(ConfigTitleAndIssueInfoAddRequest request, String source, String salesbillType) {
        MsConfigAddRequestWithUserInfo msConfigInfo = new MsConfigAddRequestWithUserInfo();
        MsConfigBean msOperatorConfigBean = new MsConfigBean();
        ArrayList msConfigOperatorItemBeanList = Lists.newArrayList();
        ConfigOperatorInfo operatorInfo = request.getConfigOperatorInfo();
        msConfigOperatorItemBeanList.add(this.toMsConfigItemBean("cashierName", (List)Lists.newArrayList((Object[])new String[]{operatorInfo.getCashierName()})));
        msConfigOperatorItemBeanList.add(this.toMsConfigItemBean("checkerName", (List)Lists.newArrayList((Object[])new String[]{operatorInfo.getCheckerName()})));
        msConfigOperatorItemBeanList.add(this.toMsConfigItemBean("invoicerName", (List)Lists.newArrayList((Object[])new String[]{operatorInfo.getInvoicerName()})));
        msOperatorConfigBean.setItemList((List)msConfigOperatorItemBeanList);
        if ("qianniu".equals(source)) {
            salesbillType = FIX_CHANNEL;
        } else {
            operatorInfo.setOperatorConfigId(Long.valueOf(0L));
        }
        this.fillConfigBean(msOperatorConfigBean, operatorInfo.getOperatorConfigId(), request.getTenantId(), request.getCompanyTaxNo(), salesbillType, ConfigTypeEnum.INVOICE_USER_CONFIG_TYPE.getConfigType());
        msConfigInfo.setItemDTOList((List)Lists.newArrayList((Object[])new MsConfigBean[]{msOperatorConfigBean}));
        msConfigInfo.setUserInfo(this.toMsCommonUserInfo(request.getTenantId()));
        return msConfigInfo;
    }

    private MsConfigAddRequestWithUserInfo toOperatorReuest(ConfigOperatorInfo operatorInfo, String source, Long tenantId, String companyTaxNo, String salesbillType) {
        MsConfigAddRequestWithUserInfo msConfigInfo = new MsConfigAddRequestWithUserInfo();
        MsConfigBean msOperatorConfigBean = new MsConfigBean();
        ArrayList msConfigOperatorItemBeanList = Lists.newArrayList();
        msConfigOperatorItemBeanList.add(this.toMsConfigItemBean("cashierName", (List)Lists.newArrayList((Object[])new String[]{operatorInfo.getCashierName()})));
        msConfigOperatorItemBeanList.add(this.toMsConfigItemBean("checkerName", (List)Lists.newArrayList((Object[])new String[]{operatorInfo.getCheckerName()})));
        msConfigOperatorItemBeanList.add(this.toMsConfigItemBean("invoicerName", (List)Lists.newArrayList((Object[])new String[]{operatorInfo.getInvoicerName()})));
        msOperatorConfigBean.setItemList((List)msConfigOperatorItemBeanList);
        if ("qianniu".equals(source)) {
            salesbillType = FIX_CHANNEL;
        }
        this.fillConfigBean(msOperatorConfigBean, operatorInfo.getOperatorConfigId(), tenantId, companyTaxNo, salesbillType, ConfigTypeEnum.INVOICE_USER_CONFIG_TYPE.getConfigType());
        msConfigInfo.setItemDTOList((List)Lists.newArrayList((Object[])new MsConfigBean[]{msOperatorConfigBean}));
        msConfigInfo.setUserInfo(this.toMsCommonUserInfo(tenantId));
        return msConfigInfo;
    }

    private MsConfigAddRequestWithUserInfo toTitleReuest(ConfigTitleAndIssueInfoAddRequest request, String source, String salesbillType) {
        MsConfigAddRequestWithUserInfo msConfigInfo = new MsConfigAddRequestWithUserInfo();
        MsConfigBean msTitleConfigBean = new MsConfigBean();
        ConfigTtitleInfo titleInfo = request.getConfigTitleInfo();
        ArrayList msConfigTitleItemBeanList = Lists.newArrayList();
        msConfigTitleItemBeanList.add(this.toMsConfigItemBean("sellerAddress", (List)Lists.newArrayList((Object[])new String[]{titleInfo.getAddress()})));
        msConfigTitleItemBeanList.add(this.toMsConfigItemBean("sellerTel", (List)Lists.newArrayList((Object[])new String[]{titleInfo.getTel()})));
        msConfigTitleItemBeanList.add(this.toMsConfigItemBean("sellerBankName", (List)Lists.newArrayList((Object[])new String[]{titleInfo.getBankName()})));
        msConfigTitleItemBeanList.add(this.toMsConfigItemBean("sellerBankAccount", (List)Lists.newArrayList((Object[])new String[]{titleInfo.getBankAccount()})));
        msTitleConfigBean.setItemList((List)msConfigTitleItemBeanList);
        if ("qianniu".equals(source)) {
            salesbillType = FIX_CHANNEL;
        } else {
            titleInfo.setTitleConfigId(Long.valueOf(0L));
        }
        this.fillConfigBean(msTitleConfigBean, titleInfo.getTitleConfigId(), request.getTenantId(), request.getCompanyTaxNo(), salesbillType, ConfigTypeEnum.INVOICE_CONFIG_TYPE.getConfigType());
        msConfigInfo.setItemDTOList((List)Lists.newArrayList((Object[])new MsConfigBean[]{msTitleConfigBean}));
        msConfigInfo.setUserInfo(this.toMsCommonUserInfo(request.getTenantId()));
        return msConfigInfo;
    }

    private MsConfigAddRequestWithUserInfo toTitleReuest(ConfigTtitleInfo titleInfo, String source, Long tenantId, String companyTaxNo, String salesbillType) {
        MsConfigAddRequestWithUserInfo msConfigInfo = new MsConfigAddRequestWithUserInfo();
        MsConfigBean msTitleConfigBean = new MsConfigBean();
        ArrayList msConfigTitleItemBeanList = Lists.newArrayList();
        msConfigTitleItemBeanList.add(this.toMsConfigItemBean("sellerAddress", (List)Lists.newArrayList((Object[])new String[]{titleInfo.getAddress()})));
        msConfigTitleItemBeanList.add(this.toMsConfigItemBean("sellerTel", (List)Lists.newArrayList((Object[])new String[]{titleInfo.getTel()})));
        msConfigTitleItemBeanList.add(this.toMsConfigItemBean("sellerBankName", (List)Lists.newArrayList((Object[])new String[]{titleInfo.getBankName()})));
        msConfigTitleItemBeanList.add(this.toMsConfigItemBean("sellerBankAccount", (List)Lists.newArrayList((Object[])new String[]{titleInfo.getBankAccount()})));
        msTitleConfigBean.setItemList((List)msConfigTitleItemBeanList);
        if ("qianniu".equals(source)) {
            salesbillType = FIX_CHANNEL;
        }
        this.fillConfigBean(msTitleConfigBean, titleInfo.getTitleConfigId(), tenantId, companyTaxNo, salesbillType, ConfigTypeEnum.INVOICE_CONFIG_TYPE.getConfigType());
        msConfigInfo.setItemDTOList((List)Lists.newArrayList((Object[])new MsConfigBean[]{msTitleConfigBean}));
        msConfigInfo.setUserInfo(this.toMsCommonUserInfo(tenantId));
        return msConfigInfo;
    }

    private MsConfigItemBean toMsConfigItemBean(String itemName, List<String> configItemValueList) {
        MsConfigItemBean msConfigItemBean = new MsConfigItemBean();
        msConfigItemBean.setConfigItemName(itemName);
        msConfigItemBean.setConfigItemValue(configItemValueList);
        return msConfigItemBean;
    }

    private void fillConfigBean(MsConfigBean msConfigBean, Long configId, Long groupId, String sellerTaxNo, String salesbillType, Integer configType) {
        msConfigBean.setConfigId(configId);
        msConfigBean.setBusinessBillType(BusinessBillType.AR.value());
        msConfigBean.setSalesbillType(salesbillType);
        msConfigBean.setConfigName(3 == configType ? salesbillType + "\u5f00\u7968\u62ac\u5934" : salesbillType + "\u7968\u9762\u4eba\u5458");
        msConfigBean.setConfigType(configType);
        msConfigBean.setSellerGroupId(groupId);
        msConfigBean.setSellerTaxNo(sellerTaxNo);
        msConfigBean.setAttributes(Collections.emptyList());
    }

    private MsCommonUserInfo toMsCommonUserInfo(Long sellerGroupId) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        if (null == userInfo) {
            userInfo = new UserInfo();
        }
        if (0L == userInfo.getGroupId()) {
            userInfo.setGroupId(sellerGroupId.longValue());
        }
        MsCommonUserInfo msCommonUserInfo = new MsCommonUserInfo();
        msCommonUserInfo.setGroupId(Long.valueOf(userInfo.getGroupId()));
        return msCommonUserInfo;
    }

    private MsConfigQueryRequest toMsConfigQueryRequest(ConfigTitleAndIssueInfoQueryRequest request, Integer configType) {
        MsConfigQueryRequest msConfigQueryRequest = new MsConfigQueryRequest();
        msConfigQueryRequest.setSellerGroupId(request.getTenantId());
        msConfigQueryRequest.setSellerTaxNo(request.getCompanyTaxNo());
        msConfigQueryRequest.setBusinessBillType(BusinessBillType.AR.value());
        msConfigQueryRequest.setSalesbillType(FIX_CHANNEL);
        msConfigQueryRequest.setConfigType(configType);
        msConfigQueryRequest.setPurchaserGroupId(Long.valueOf(0L));
        msConfigQueryRequest.setPurchaserTaxNo("");
        return msConfigQueryRequest;
    }

    private ConfigOperatorInfo toConfigOperatorInfo(List<MsConfigItemBean> itemBeanlist) {
        InvoiceInfoRuleDTO baseRuleBean;
        ConfigOperatorInfo configOperatorInfo = new ConfigOperatorInfo();
        InvoiceInfoRuleDTO invoiceInfoRuleDTO = baseRuleBean = this.invoiceInfoRlueParser.parse(itemBeanlist);
        configOperatorInfo.setCashierName(Optional.ofNullable(invoiceInfoRuleDTO.getCashierName()).orElse(""));
        configOperatorInfo.setInvoicerName(Optional.ofNullable(invoiceInfoRuleDTO.getInvoicerName()).orElse(""));
        configOperatorInfo.setCheckerName(Optional.ofNullable(invoiceInfoRuleDTO.getCheckerName()).orElse(""));
        configOperatorInfo.setOperatorConfigId(invoiceInfoRuleDTO.getRuldId());
        return configOperatorInfo;
    }

    private ConfigTtitleInfo toConfigTtitleInfo(List<MsConfigItemBean> itemBeanlist) {
        InvoiceInfoRuleDTO baseRuleBean;
        ConfigTtitleInfo configTtitleInfo = new ConfigTtitleInfo();
        InvoiceInfoRuleDTO invoiceInfoRuleDTO = baseRuleBean = this.invoiceInfoRlueParser.parse(itemBeanlist);
        configTtitleInfo.setAddress(Optional.ofNullable(invoiceInfoRuleDTO.getSellerAddress()).orElse(""));
        configTtitleInfo.setBankAccount(Optional.ofNullable(invoiceInfoRuleDTO.getSellerBankAccount()).orElse(""));
        configTtitleInfo.setBankName(Optional.ofNullable(invoiceInfoRuleDTO.getSellerBankName()).orElse(""));
        configTtitleInfo.setTel(Optional.ofNullable(invoiceInfoRuleDTO.getSellerTel()).orElse(""));
        configTtitleInfo.setTitleConfigId(invoiceInfoRuleDTO.getRuldId());
        return configTtitleInfo;
    }

    private void sendData(ConfigCommodityInfo configCommodityInfo, String importBatchNo, Long groupId) {
        try {
            HashMap property = Maps.newHashMap();
            property.put("tenantId", String.valueOf(groupId));
            property.put("appId", "20");
            property.put("opUserId", "0");
            property.put("opUserName", "qianniu");
            property.put("messageId", importBatchNo);
            property.put("isCover", "0");
            String msg = this.convertGoods(configCommodityInfo);
            log.info("\u5343\u725b\u5546\u54c1\u5bfc\u5165groupId:{}\uff0c\u8f6c\u6362\u524dsku:{}\uff0c\u8f6c\u6362\u540egoods:{},properties:{}", new Object[]{groupId, msg, msg, com.xforceplus.xplatframework.utils.json.JsonUtils.writeObjectToJson((Object)property)});
            Result result = SQSSender.sendStrMsg((String)"goods-manager-import-deal", (String)msg, (Map)property, (boolean)true);
            if (!result.isSuc()) {
                throw new RuntimeException("\u5546\u54c1\u629b\u5165\u4e2d\u53f0sqs\u5931\u8d25 groupId" + groupId + "\uff0cbatchNo:" + importBatchNo);
            }
            log.info("\u5546\u54c1\u5bfc\u5165\u6210\u529f\uff0cgroupId:{} batchNo:{},messageId:{}", new Object[]{groupId, importBatchNo, result.getMessage()});
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u5546\u54c1\u5931\u8d25", (Throwable)e);
        }
    }

    private String convertGoods(ConfigCommodityInfo configCommodityInfo) {
        ArrayList<Map> requestMap = new ArrayList<Map>();
        GoodsRequest v = new GoodsRequest();
        v.setTaxCode(configCommodityInfo.getTaxCode());
        v.setGoodsName(configCommodityInfo.getGoodsName());
        v.setGoodsNo(configCommodityInfo.getTaxCode());
        v.setConversionCode(configCommodityInfo.getTaxCode());
        v.setTaxRate(Optional.ofNullable(configCommodityInfo.getTaxRate()).orElse(""));
        v.setZeroTax(configCommodityInfo.getZeroTax());
        v.setTaxcodeName("");
        v.setTaxcodeShortName("");
        if (StringUtils.isNotBlank((CharSequence)v.getZeroTax())) {
            String desc = ZeroTaxs.descriptionFromValue((String)v.getZeroTax());
            v.setTaxPreCon(desc);
            if (StringUtils.equalsAny((CharSequence)v.getZeroTax(), (CharSequence[])new CharSequence[]{ZeroTaxs.ONE.value(), ZeroTaxs.TWO.value()})) {
                v.setTaxPre(TaxPres.SHARE.value());
            }
            if (StringUtils.equalsAny((CharSequence)v.getZeroTax(), (CharSequence[])new CharSequence[]{ZeroTaxs.THREE.value()})) {
                v.setTaxPre(TaxPres.NOT_SHARE.value());
            }
        }
        v.setSpecification("");
        v.setPriceMethod("");
        v.setUnitPrice("");
        v.setQuantityUnit("");
        Map map = com.xforceplus.xplatframework.utils.json.JsonUtils.writeJsonToMap((String)com.xforceplus.xplatframework.utils.json.JsonUtils.writeObjectToJson((Object)v));
        map.entrySet().removeIf(entry -> StringUtils.equals((CharSequence)String.valueOf(entry.getValue()), (CharSequence)""));
        requestMap.add(map);
        return com.xforceplus.xplatframework.utils.json.JsonUtils.writeObjectToJson(requestMap);
    }

    private void sendQuanNiuConfigData(QianNiuDeliverData qianNiuDeliverData) {
        HashMap headers = Maps.newHashMap();
        headers.put("operationType", "allInOneConfigSaveType");
        headers.put("eventType", "qianNiuBaseConfigDataDeliver");
        headers.put("businessNo", String.valueOf(qianNiuDeliverData.getTenantId()));
        headers.put("transNo", qianNiuDeliverData.getSerialNo());
        headers.put("platformNo", "4.0");
        headers.put("sellerGroupId", String.valueOf(qianNiuDeliverData.getTenantId()));
        String data = JsonUtils.toJson((Object)qianNiuDeliverData);
        headers.put("channel", qianNiuDeliverData.getChannel());
        log.info("\u5343\u725b\u4e00\u7ad9\u5f0f\u914d\u7f6e\u4e0b\u53d1 groupId:{} data {}", (Object)qianNiuDeliverData.getTenantId(), (Object)data);
        boolean flag = this.mqUtils.send("it-bus-priority-high", data, (Map)headers);
        log.info("\u5343\u725b\u4e00\u7ad9\u5f0f\u914d\u7f6e\u4e0b\u53d1 groupId:{} flag {}", (Object)qianNiuDeliverData.getTenantId(), (Object)flag);
    }

    public void sendSettledDataFinishData(Boolean settledDataIsFinish, ConfigTitleAndIssueInfoAddRequest request) {
        if (Objects.isNull(settledDataIsFinish) || !settledDataIsFinish.booleanValue()) {
            return;
        }
        TenantSettledFinishDeliverVo tenantSettledFinishDeliverData = new TenantSettledFinishDeliverVo();
        tenantSettledFinishDeliverData.setTenantId(request.getTenantId());
        tenantSettledFinishDeliverData.setChannel(request.getChannel());
        tenantSettledFinishDeliverData.setCompanyName(request.getCompanyName());
        tenantSettledFinishDeliverData.setCompanyTaxNo(request.getCompanyTaxNo());
        tenantSettledFinishDeliverData.setSerialNo(String.valueOf(this.idGenerator.nextId()));
        HashMap headers = Maps.newHashMap();
        headers.put("operationType", "tenantSettledFinish");
        headers.put("eventType", "tenantSettledFinishDeliver");
        headers.put("businessNo", String.valueOf(tenantSettledFinishDeliverData.getTenantId()));
        headers.put("transNo", tenantSettledFinishDeliverData.getSerialNo());
        headers.put("platformNo", "4.0");
        headers.put("sellerGroupId", String.valueOf(tenantSettledFinishDeliverData.getTenantId()));
        headers.put("channel", tenantSettledFinishDeliverData.getChannel());
        String data = JsonUtils.toJson((Object)tenantSettledFinishDeliverData);
        log.info("\u5165\u9a7b\u5b8c\u6bd5\u4e0b\u53d1\u96c6\u6210\u5e73\u53f0\u5f00\u59cb groupId:{} data {}", (Object)tenantSettledFinishDeliverData.getTenantId(), (Object)data);
        boolean flag = this.mqUtils.send("it-bus-priority-high", data, (Map)headers);
        log.info("\u5165\u9a7b\u5b8c\u6bd5\u4e0b\u53d1\u96c6\u6210\u5e73\u53f0\u7ed3\u675f groupId:{} flag {}", (Object)tenantSettledFinishDeliverData.getTenantId(), (Object)flag);
    }

    private Boolean settledDataIsFinish(ConfigTitleAndIssueInfoAddRequest request) {
        CfgTemplateSettledObjEntity settledObjEntity = this.settledConfigFacade.queryOneSettledTemplate(request.getSettledType(), Long.valueOf(request.getChannel()), request.getProductCode());
        if (Objects.isNull(settledObjEntity)) {
            log.error("\u672a\u67e5\u8be2\u5230\u5165\u9a7b\u6a21\u677f\u4fe1\u606f\uff0c\u4e0d\u4e0b\u53d1\u96c6\u6210\u5e73\u53f0\uff1agroupId:{}\uff0cProductCode:{}", (Object)request.getTenantId(), (Object)request.getProductCode());
            return false;
        }
        MsMataDataQueryRequest mataDataQueryRequest = new MsMataDataQueryRequest();
        mataDataQueryRequest.setGroupId(request.getTenantId());
        mataDataQueryRequest.setObjCode(ObjCodeEnum.BILL.getObjCode());
        mataDataQueryRequest.setObjType(settledObjEntity.getSalesbillType());
        mataDataQueryRequest.setObjStatus(Integer.valueOf(1));
        mataDataQueryRequest.setPageNo(Integer.valueOf(1));
        mataDataQueryRequest.setPageSize(Integer.valueOf(5));
        List cfgBusinessObjEntities = this.configMetaDataService.queryMetaDataList(mataDataQueryRequest);
        if (CollectionUtils.isEmpty((Collection)cfgBusinessObjEntities)) {
            log.info("{}\u4e1a\u52a1\u5355\u7c7b\u578b\u672a\u521b\u5efa\uff0c\u4e0d\u4e0b\u53d1\u96c6\u6210\u5e73\u53f0\uff1a groupId\uff1a{}", (Object)settledObjEntity.getSalesbillType(), (Object)request.getTenantId());
            return false;
        }
        Either either = this.templateObjMetadataService.querySettledTemplateConfigItem(settledObjEntity.getSettledObjId(), Boolean.valueOf(false));
        if (either.isLeft()) {
            log.error("\u67e5\u8be2\u89c4\u5219\u6a21\u677f\u914d\u7f6e\u6709\u8bef\uff0c{},\u4e0d\u4e0b\u53d1\u96c6\u6210\u5e73\u53f0\uff0cgroupId:{}\uff0cProductCode:{}", new Object[]{either.isLeft(), request.getTenantId(), request.getProductCode()});
            return false;
        }
        SettledTemplateConifgVo settledTemplateConfigVo = (SettledTemplateConifgVo)either.get();
        if (Objects.isNull(settledTemplateConfigVo) || CollectionUtils.isEmpty((Collection)settledTemplateConfigVo.getCfgTemplateObjVoList())) {
            log.info("\u81ea\u52a8\u89c4\u5219\u6a21\u677f\u672a\u914d\u7f6e\uff0c\u4e0d\u4e0b\u53d1\u96c6\u6210\u5e73\u53f0\uff0cgroupId:{}\uff0cProductCode:{}", (Object)request.getTenantId(), (Object)request.getProductCode());
            return false;
        }
        Map<String, List<SettledTemplateConifgVo.CfgTemplateObjVo>> templateMap = settledTemplateConfigVo.getCfgTemplateObjVoList().stream().collect(Collectors.groupingBy(SettledTemplateConifgVo.CfgTemplateObjVo::getTemplateObjCode));
        for (String key : templateMap.keySet()) {
            List settingCfgConfigEntityList;
            List<String> templateObjCodeList;
            if (StringUtils.isNotBlank((CharSequence)key) && key.contains(InitTemplateConfigEnum.BILL_TEMPLATE.getObjCode())) continue;
            ArrayList list = templateMap.get(key);
            if (StringUtils.isNotBlank((CharSequence)key) && key.contains(InitTemplateConfigEnum.INVOICE_DELIVERY_TEMPLATE.getObjCode())) {
                ArrayList deliveryList = Lists.newArrayList();
                for (SettledTemplateConifgVo.CfgTemplateObjVo vo : list) {
                    Optional<SettledTemplateConifgVo.CfgTemplateObjMetadataVo> optional;
                    if (Objects.isNull(vo) || CollectionUtils.isEmpty((Collection)vo.getCfgTemplateObjMetadataList()) || !(optional = vo.getCfgTemplateObjMetadataList().stream().filter(i -> "autoSend".equals(i.getFieldName())).findFirst()).isPresent() || StringUtils.isBlank((CharSequence)optional.get().getFieldDefaultValue()) || optional.get().getFieldDefaultValue().contains("false")) continue;
                    deliveryList.add(vo);
                }
                if (CollectionUtils.isEmpty((Collection)deliveryList)) continue;
                list = deliveryList;
            }
            String invoiceType = (templateObjCodeList = Arrays.asList(key.split("-"))).size() > 2 ? templateObjCodeList.get(2) : "";
            String taxInvoiceSource = templateObjCodeList.size() > 3 ? templateObjCodeList.get(3) : null;
            MsConfigQueryRequest msConfigQueryRequest = new MsConfigQueryRequest();
            msConfigQueryRequest.setSellerGroupId(request.getTenantId());
            msConfigQueryRequest.setBusinessBillType(com.xforceplus.seller.enums.BusinessBillType.AR.value());
            msConfigQueryRequest.setStatus(StatusEnum.NORMAL.getStatus());
            msConfigQueryRequest.setConfigType(InitTemplateConfigEnum.getConfigTypeByTemplateConfig((String)templateObjCodeList.get(1)).getConfigType());
            msConfigQueryRequest.setSalesbillType(settledObjEntity.getSalesbillType());
            msConfigQueryRequest.setSellerTaxNo(request.getCompanyTaxNo());
            if (StringUtils.isNotBlank((CharSequence)invoiceType)) {
                msConfigQueryRequest.setInvoiceType((List)Lists.newArrayList((Object[])new String[]{invoiceType}));
            }
            if (StringUtils.isNotBlank((CharSequence)taxInvoiceSource)) {
                msConfigQueryRequest.setTaxInvoiceSource(taxInvoiceSource);
            }
            if (!CollectionUtils.isEmpty((Collection)(settingCfgConfigEntityList = this.configBizConfigService.querySettingConfigList(msConfigQueryRequest))) && settingCfgConfigEntityList.size() >= list.size()) continue;
            log.info("\u3010{}\u3011\u672a\u914d\u7f6e\u6216\u914d\u7f6e\u4e0d\u5168\uff0c\u4e0d\u4e0b\u53d1\u96c6\u6210\u5e73\u53f0\uff0cgroupId:{}\uff0cProductCode:{}", new Object[]{InitTemplateConfigEnum.getConfigTypeByTemplateConfig((String)templateObjCodeList.get(1)).getConfigTypeDesc(), request.getTenantId(), request.getProductCode()});
            return false;
        }
        return true;
    }

    private QianNiuDeliverData buildQianNiuDeliverData(ConfigTitleAndIssueInfoAddRequest request) {
        QianNiuDeliverData qianNiuDeliverData = new QianNiuDeliverData();
        qianNiuDeliverData.setCompanyName(request.getCompanyName());
        qianNiuDeliverData.setCompanyTaxNo(request.getCompanyTaxNo());
        qianNiuDeliverData.setInvoiceType(request.getInvoiceType());
        qianNiuDeliverData.setRemark(request.getRemark());
        qianNiuDeliverData.setSerialNo(String.valueOf(this.idGenerator.nextId()));
        qianNiuDeliverData.setTenantId(request.getTenantId());
        qianNiuDeliverData.setConfigTitleInfo(request.getConfigTitleInfo());
        String formatTaxRate = Optional.ofNullable(request.getConfigCommodityInfo()).map(ConfigCommodityInfo::getTaxRate).filter(r -> !StringUtils.isBlank((CharSequence)r)).map(r -> new BigDecimal((String)r).setScale(2, RoundingMode.HALF_UP).toPlainString()).orElse(new BigDecimal("0.00").toPlainString());
        Optional.ofNullable(request.getConfigCommodityInfo()).ifPresent(r -> r.setTaxRate(formatTaxRate));
        qianNiuDeliverData.setConfigCommodityInfo(request.getConfigCommodityInfo());
        qianNiuDeliverData.setConfigOperatorInfo(request.getConfigOperatorInfo());
        qianNiuDeliverData.setChannel(request.getChannel());
        return qianNiuDeliverData;
    }

    public Either<String, Boolean> initSettledTemplateConfig(InitSettledTemplateConfigRequest initTemplateConfigRequest) {
        log.info("initSettledTemplateConfig {}", (Object)JsonUtils.toJson((Object)initTemplateConfigRequest));
        Either eitherCheckParam = this.checkInitTemplateParam(initTemplateConfigRequest);
        if (eitherCheckParam.isLeft()) {
            return eitherCheckParam;
        }
        CfgTemplateSettledObjEntity settledObjEntity = this.templateObjMetadataService.convertSettledObjEntity(initTemplateConfigRequest, (UserInfo)this.userInfoHolder.get());
        Tuple2 eiterResult = this.templateObjMetadataService.convertSettledTemplateInfo(initTemplateConfigRequest.getTemplateGroupList(), settledObjEntity.getSettledObjId());
        log.info("converted templateObjEnity {}", (Object)JsonUtils.toJson((Object)eiterResult._1));
        return this.templateObjMetadataService.initSettledTemplateConfig(settledObjEntity, (List)eiterResult._1, (List)eiterResult._2);
    }

    private Either<String, Boolean> checkInitTemplateParam(InitSettledTemplateConfigRequest initRequest) {
        if (!SettledTypeEnum.getEnumByValue((Integer)initRequest.getSettledType()).isPresent()) {
            List setttleDescList = EnumUtils.getEnumList(SettledTypeEnum.class).stream().map(SettledTypeEnum::getDesc).collect(Collectors.toList());
            return Either.left((Object)("\u5165\u9a7b\u7c7b\u578b\u4f20\u53c2\u9519\u8bef\uff0c\u4ec5\u652f\u6301" + JsonUtils.toJson(setttleDescList)));
        }
        if (null == initRequest.getTenantId() || initRequest.getTenantId() <= 0L) {
            return Either.left((Object)"\u5165\u9a7b\u79df\u6237\u6765\u6e90Id\u4f20\u53c2\u9519\u8bef");
        }
        if (StringUtils.isBlank((CharSequence)initRequest.getTenantName())) {
            return Either.left((Object)"\u5165\u9a7b\u79df\u6237\u6765\u6e90\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)initRequest.getProductCode())) {
            return Either.left((Object)"\u4ea7\u54c1\u5305\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)initRequest.getSalesbillType())) {
            return Either.left((Object)"\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CfgTemplateSettledObjEntity objEntity = this.settledConfigFacade.queryOneSettledTemplate(initRequest.getSettledType(), initRequest.getTenantId(), initRequest.getProductCode());
        if (null != objEntity) {
            return Either.left((Object)"\u8be5\u6e20\u9053\u6765\u6e90\u7684\u79df\u6237\u4ea7\u54c1\u5305\u5df2\u7ecf\u5165\u9a7b\u8fc7,\u4e0d\u80fd\u91cd\u590d\u5165\u9a7b.");
        }
        for (List templateObjGroup : initRequest.getTemplateGroupList()) {
            for (InitSettledTemplateConfigRequest.CfgTemplateObj templateObj : templateObjGroup) {
                if (StringUtils.isBlank((CharSequence)templateObj.getTemplateObjCode())) {
                    return Either.left((Object)"\u6a21\u7248\u5bf9\u8c61\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!CollectionUtils.isEmpty((Collection)templateObj.getCfgTemplateObjMetadataList())) continue;
                return Either.left((Object)"\u6a21\u7248\u660e\u7ec6\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        return Either.right((Object)true);
    }

    public Either<Tuple2<ErrorCodeEnum, String>, Tuple2<Long, List<SettledTemplateDataVo>>> querySettledTemplateList(SettledTemplateQueryRequest request) {
        int pageNo = 1;
        int pageSize = 20;
        Page page = request.getPage();
        if (Objects.nonNull(page)) {
            pageNo = Optional.ofNullable(page.getPageNo()).orElse(1);
            pageSize = Optional.ofNullable(page.getPageSize()).orElse(20);
        }
        Consumer<CfgTemplateSettledObjExample.Criteria> condition = criteria -> {
            if (!Objects.isNull(request.getSettledType())) {
                criteria.andSettledTypeEqualTo(request.getSettledType());
            }
            if (!Objects.isNull(request.getTenantId())) {
                criteria.andTenantIdEqualTo(request.getTenantId());
            }
            if (StringUtils.isNotBlank((CharSequence)request.getTenantName())) {
                criteria.andTenantNameEqualTo(request.getTenantName());
            }
            if (StringUtils.isNotBlank((CharSequence)request.getSalesbillType())) {
                criteria.andSalesbillTypeEqualTo(request.getSalesbillType());
            }
            criteria.andStatusEqualTo(Integer.valueOf(1));
        };
        List entityList = this.templateObjMetadataService.queryPageByCondition(condition, Integer.valueOf(pageNo), Integer.valueOf(pageSize));
        Long total = this.templateObjMetadataService.countTotalByCondition(condition);
        return Either.right((Object)Tuple.of((Object)total, (Object)this.templateObjMetadataConverter.convertList(entityList)));
    }

    public Either<String, Boolean> batchDeleteSettledTemplate(SettledTemplateDeleteRequest request, Long userId, String userName) {
        if (CollectionUtils.isEmpty((Collection)request.getSettledObjIdList())) {
            return Either.left((Object)"\u5220\u9664\u5165\u9a7b\u6a21\u7248\u8bb0\u5f55\u4f20\u53c2\u9519\u8bef");
        }
        List filteredIdList = request.getSettledObjIdList().stream().filter(r -> Objects.nonNull(r) && r > 0L).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filteredIdList)) {
            return Either.left((Object)"\u5220\u9664\u5165\u9a7b\u6a21\u7248\u8bb0\u5f55\u4f20\u53c2\u9519\u8bef");
        }
        int ret = this.templateObjMetadataService.deleteByCondition(filteredIdList, userId, userName);
        if (ret > 0) {
            return Either.right((Object)true);
        }
        log.info("\u5220\u9664\u5165\u9a7b\u6a21\u7248\u8bb0\u5f55\u5931\u8d25 settledObjIdList {}", (Object)JsonUtils.toJson(filteredIdList));
        return Either.left((Object)"\u5220\u9664\u5165\u9a7b\u6a21\u7248\u8bb0\u5f55\u5931\u8d25");
    }

    public Either<String, String> editSettledTemplate(SettledTemplateEditRequest request) {
        log.info("editSettledTemplate request {}", (Object)JsonUtils.toJson((Object)request));
        Either eitherResult = this.templateObjMetadataService.checkEditTemplateInfoParam(request);
        if (eitherResult.isLeft()) {
            return Either.left((Object)eitherResult.getLeft());
        }
        Tuple5 tupleResult = (Tuple5)eitherResult.get();
        if (CollectionUtils.isEmpty((Collection)((Collection)tupleResult._1)) && CollectionUtils.isEmpty((Collection)((Collection)tupleResult._2)) && CollectionUtils.isEmpty((Collection)((Collection)tupleResult._3)) && (CollectionUtils.isEmpty((Collection)((Collection)tupleResult._4)) || CollectionUtils.isEmpty((Collection)((Collection)tupleResult._5)))) {
            return Either.left((Object)"\u53c2\u6570\u4f20\u9012\u9519\u8bef");
        }
        this.templateObjMetadataService.editTemplateInfo((List)tupleResult._1, (List)tupleResult._2, (List)tupleResult._3, Tuple.of((Object)tupleResult._4, (Object)tupleResult._5));
        return Either.right((Object)"\u7f16\u8f91\u5165\u9a7b\u6a21\u7248\u8bb0\u5f55\u6210\u529f");
    }

    public Either<String, SettledTemplateConifgVo> querySettledTemplateConfigItem(QuerySettledTemplateRequest templateRequest) {
        if (Objects.nonNull(templateRequest.getSettledType()) && !SettledTypeEnum.getEnumByValue((Integer)templateRequest.getSettledType()).isPresent()) {
            List setttleDescList = EnumUtils.getEnumList(SettledTypeEnum.class).stream().map(SettledTypeEnum::getDesc).collect(Collectors.toList());
            return Either.left((Object)("\u5165\u9a7b\u7c7b\u578b\u4f20\u53c2\u9519\u8bef\uff0c\u4ec5\u652f\u6301" + JsonUtils.toJson(setttleDescList)));
        }
        if (null == templateRequest.getTenantId() || templateRequest.getTenantId() <= 0L) {
            return Either.left((Object)"\u5165\u9a7b\u79df\u6237\u6765\u6e90Id\u4f20\u53c2\u9519\u8bef");
        }
        if (StringUtils.isBlank((CharSequence)templateRequest.getProductCode())) {
            return Either.left((Object)"\u4ea7\u54c1\u5305\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CfgTemplateSettledObjEntity settledObjEntity = this.settledConfigFacade.queryOneSettledTemplate(templateRequest.getSettledType(), templateRequest.getTenantId(), templateRequest.getProductCode());
        if (Objects.isNull(settledObjEntity)) {
            return Either.left((Object)"\u672a\u67e5\u8be2\u5230\u5165\u9a7b\u4fe1\u606f");
        }
        return this.templateObjMetadataService.querySettledTemplateConfigItem(settledObjEntity.getSettledObjId(), templateRequest.getIsManual());
    }

    public Either<String, List<SettledSalesbillTypeInfoVo>> queryInitConfigInfo(QueryManualInitConfigRequest request) {
        Either eitherResult = this.checkSettledInfoParam(request);
        if (eitherResult.isRight()) {
            return Either.right((Object)this.dealSettledInfoQuery(request.getSettledInfoList(), request.getSellerTaxNo()));
        }
        eitherResult = this.checkInitConfigParam(request);
        if (eitherResult.isLeft()) {
            return Either.left((Object)eitherResult.getLeft());
        }
        return Either.right((Object)this.dealInitConfigQuery(request.getSalesbillTypeList(), request.getSellerTaxNo()));
    }

    private Either<String, Boolean> checkSettledInfoParam(QueryManualInitConfigRequest request) {
        if (CollectionUtils.isEmpty((Collection)request.getSettledInfoList())) {
            return Either.left((Object)"\u6e20\u9053\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)request.getSellerTaxNo())) {
            return Either.left((Object)"\u9500\u65b9\u516c\u53f8\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (QueryManualInitConfigRequest.SettledInfo r : request.getSettledInfoList()) {
            if (Objects.isNull(r.getChannelTenantId()) || r.getChannelTenantId() <= 0L) {
                return Either.left((Object)"\u6e20\u9053\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)r.getChannelProductCode())) {
                return Either.left((Object)"\u6e20\u9053\u4ea7\u54c1\u5305\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.isBlank((CharSequence)r.getSalesbillType())) continue;
            return Either.left((Object)"\u5355\u636e\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return Either.right((Object)true);
    }

    private List<SettledSalesbillTypeInfoVo> dealSettledInfoQuery(List<QueryManualInitConfigRequest.SettledInfo> settledInfoList, String sellerTaxNo) {
        List billTypeList = settledInfoList.stream().map(QueryManualInitConfigRequest.SettledInfo::getSalesbillType).collect(Collectors.toList());
        List billTypeVoList = this.dealInitConfigQuery(billTypeList, sellerTaxNo);
        HashMap initManualConfigMap = Maps.newHashMap();
        for (QueryManualInitConfigRequest.SettledInfo r : settledInfoList) {
            CfgTemplateSettledObjEntity settledObjEntity = this.settledConfigFacade.queryOneSettledTemplate(null, r.getChannelTenantId(), r.getChannelProductCode());
            if (null == settledObjEntity) {
                initManualConfigMap.put(r.getSalesbillType(), false);
                continue;
            }
            Either eitherResult = this.templateObjMetadataService.querySettledTemplateConfigItem(settledObjEntity.getSettledObjId(), Boolean.valueOf(true));
            if (eitherResult.isLeft()) {
                initManualConfigMap.put(r.getSalesbillType(), false);
                continue;
            }
            initManualConfigMap.put(r.getSalesbillType(), true);
        }
        for (QueryManualInitConfigRequest.SettledInfo r : billTypeVoList) {
            boolean isInitTemplateConfig = initManualConfigMap.getOrDefault(r.getSalesbillType(), false);
            this.setInitedConfig((SettledSalesbillTypeInfoVo)r, isInitTemplateConfig);
        }
        return billTypeVoList;
    }

    private void setInitedConfig(SettledSalesbillTypeInfoVo infoVo, boolean isInitTemplateConfig) {
        Integer initedConfig;
        Integer n = initedConfig = infoVo.getIsSettled() != false ? SettledSalesbillTypeInfoVo.InitedConfigEnum.INIT_CONFIG.value : SettledSalesbillTypeInfoVo.InitedConfigEnum.UN_INIT_CONFIG.value;
        if (!isInitTemplateConfig) {
            initedConfig = SettledSalesbillTypeInfoVo.InitedConfigEnum.NOT_NEED_INIT_CONFIG.value;
        }
        infoVo.setInitedConfig(initedConfig);
    }

    private Either<String, Boolean> checkInitConfigParam(QueryManualInitConfigRequest request) {
        if (CollectionUtils.isEmpty((Collection)request.getSalesbillTypeList())) {
            return Either.left((Object)"\u672a\u67e5\u8be2\u5230\u5df2\u8d2d\u4e70\u6e20\u9053\uff0c\u8bf7\u524d\u5f80\u5e94\u7528\u5546\u5e97\u8d2d\u4e70\uff01");
        }
        List filteredBillTypeList = request.getSalesbillTypeList().stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filteredBillTypeList)) {
            return Either.left((Object)"\u672a\u67e5\u8be2\u5230\u5df2\u8d2d\u4e70\u6e20\u9053\uff0c\u8bf7\u524d\u5f80\u5e94\u7528\u5546\u5e97\u8d2d\u4e70\uff01");
        }
        if (StringUtils.isBlank((CharSequence)request.getSellerTaxNo())) {
            return Either.left((Object)"\u9500\u65b9\u516c\u53f8\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return Either.right((Object)true);
    }

    private List<SettledSalesbillTypeInfoVo> dealInitConfigQuery(List<String> filteredBillTypeList, String sellerTaxNo) {
        CfgConfigExample query2 = new CfgConfigExample();
        query2.createCriteria().andSalesbillTypeIn(filteredBillTypeList).andSellerTaxNoEqualTo(sellerTaxNo).andConfigTypeIn((List)Lists.newArrayList((Object[])new Byte[]{com.xforceplus.seller.config.core.enums.ConfigTypeEnum.INVOICE_INFO_CONFIG.getConfigType().byteValue(), com.xforceplus.seller.config.core.enums.ConfigTypeEnum.INVOICE_MEMBER_CONFIG.getConfigType().byteValue()})).andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        Map<String, Boolean> configMap = this.cfgConfigDataService.selectByExample(query2).stream().collect(Collectors.toMap(CfgConfigEntity::getSalesbillType, r -> true, (a, b) -> a));
        ArrayList billTypeVoList = Lists.newArrayList();
        filteredBillTypeList.forEach(r -> billTypeVoList.add(new SettledSalesbillTypeInfoVo(r, sellerTaxNo, configMap.getOrDefault(r, false), null)));
        return billTypeVoList;
    }

    private String checkParam(ConfigTitleAndIssueInfoAddRequest request) {
        if (StringUtils.isBlank((CharSequence)request.getProductCode())) {
            return "\u4ea7\u54c1\u670d\u52a1\u5305\u4ee3\u7801\u4e0d\u53ef\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)request.getChannel())) {
            return "\u6e20\u9053\u6765\u6e90\u4e0d\u53ef\u4e3a\u7a7a";
        }
        if (Objects.isNull(request.getChannel())) {
            return "\u79df\u6237ID\u4e0d\u53ef\u4e3a\u7a7a";
        }
        return "";
    }

    public ConfigInfoAllInOneFacadeImpl(UserInfoHolder<UserInfo> userInfoHolder, ConfigBizConfigService configBizConfigService, InvoiceInfoRlueParser invoiceInfoRlueParser, IDGenerator idGenerator, MqUtils mqUtils, DeviceApiProxy deviceApiProxy, TemplateObjMetadataService templateObjMetadataService, TemplateObjMetadataConverter templateObjMetadataConverter, CfgConfigDataService cfgConfigDataService, ConfigMetaDataService configMetaDataService, SettledConfigFacade settledConfigFacade) {
        this.userInfoHolder = userInfoHolder;
        this.configBizConfigService = configBizConfigService;
        this.invoiceInfoRlueParser = invoiceInfoRlueParser;
        this.idGenerator = idGenerator;
        this.mqUtils = mqUtils;
        this.deviceApiProxy = deviceApiProxy;
        this.templateObjMetadataService = templateObjMetadataService;
        this.templateObjMetadataConverter = templateObjMetadataConverter;
        this.cfgConfigDataService = cfgConfigDataService;
        this.configMetaDataService = configMetaDataService;
        this.settledConfigFacade = settledConfigFacade;
    }
}

