/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.facade;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserCenterResponse;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserData;
import com.xforceplus.phoenix.infrastructure.usercenter.services.UserCenterUserService;
import com.xforceplus.seller.config.client.model.ConfigIssueInfoEditRequest;
import com.xforceplus.seller.config.client.model.ConfigIssueUserInfoDTO;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.model.MsConfigItemQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigPageDTO;
import com.xforceplus.seller.config.client.model.MsConfigQueryRequest;
import com.xforceplus.seller.config.converters.ConfigConverter;
import com.xforceplus.seller.config.facade.ConfigInfoFacade;
import com.xforceplus.seller.config.models.BusinessExtensionAttribute;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjEntity;
import com.xforceplus.seller.config.repository.model.CfgIssueUserInfoEntity;
import com.xforceplus.seller.config.services.CfgBusinessObjDataService;
import com.xforceplus.seller.config.services.ConfigBizConfigService;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import io.geewit.web.utils.JsonUtils;
import io.vavr.control.Either;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ConfigInfoFacadeImpl
implements ConfigInfoFacade {
    private static final Logger log = LoggerFactory.getLogger(ConfigInfoFacadeImpl.class);
    private final UserInfoHolder<UserInfo> userInfoHolder;
    private final ConfigBizConfigService configBizConfigService;
    private final ConfigConverter configConverter;
    private final IDGenerator idGenerator;
    private final UserCenterUserService userCenterUserService;
    private final CfgBusinessObjDataService cfgBusinessObjDataService;

    public ConfigInfoFacadeImpl(UserInfoHolder<UserInfo> userInfoHolder, ConfigBizConfigService configBizConfigService, ConfigConverter configConverter, IDGenerator idGenerator, UserCenterUserService userCenterUserService, CfgBusinessObjDataService cfgBusinessObjDataService) {
        this.userInfoHolder = userInfoHolder;
        this.configBizConfigService = configBizConfigService;
        this.configConverter = configConverter;
        this.idGenerator = idGenerator;
        this.userCenterUserService = userCenterUserService;
        this.cfgBusinessObjDataService = cfgBusinessObjDataService;
    }

    public Either<String, String> editOrAdd(ConfigIssueInfoEditRequest request) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        CfgIssueUserInfoEntity editEntity = this.configBizConfigService.queryOwnerIssueInfo(Long.valueOf(userInfo.getGroupId()), request.getCompanyTaxNo(), Long.valueOf(userInfo.getUserId()), Long.valueOf(request.getSysOrgId()));
        int ret = 0;
        if (null != editEntity) {
            editEntity.setInvoicerName(request.getInvoicerName());
            editEntity.setCashierName(StringUtils.isEmpty((CharSequence)request.getCashierName()) ? null : request.getCashierName());
            editEntity.setCheckerName(StringUtils.isEmpty((CharSequence)request.getCheckerName()) ? null : request.getCheckerName());
            editEntity.setUpdateTime(new Date());
            ret = this.configBizConfigService.updateIssueUserInfo(editEntity);
        } else {
            ret = this.configBizConfigService.addIssueUserInfo(this.configConverter.convert(request, userInfo, this.idGenerator));
        }
        if (ret > 0) {
            return Either.right((Object)"\u64cd\u4f5c\u6210\u529f");
        }
        return Either.left((Object)"\u64cd\u4f5c\u5931\u8d25");
    }

    public <T> T querySellerIssueInfo(String sellerTaxNo, Long sysOrgId, String salesbillType, Integer configType, T out) {
        List itemBeans = this.configBizConfigService.querySellerIssueInfo(Long.valueOf(((UserInfo)this.userInfoHolder.get()).getGroupId()), sellerTaxNo, sysOrgId, salesbillType, configType);
        Map<String, String> fieldValueMap = null;
        if (CollectionUtils.isNotEmpty((Collection)itemBeans)) {
            fieldValueMap = itemBeans.stream().collect(Collectors.toMap(MsConfigItemBean::getConfigItemName, item -> CollectionUtils.isNotEmpty((Collection)item.getConfigItemValue()) ? (String)item.getConfigItemValue().get(0) : ""));
        }
        if (MapUtils.isNotEmpty(fieldValueMap)) {
            Field[] fields = out.getClass().getDeclaredFields();
            try {
                for (Field f : fields) {
                    f.setAccessible(true);
                    f.set(out, fieldValueMap.get(f.getName()));
                }
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace();
            }
            return out;
        }
        return null;
    }

    public ConfigIssueUserInfoDTO queryOwnerIssueInfo(String sellerTaxNo, Long sysOrgId) {
        return this.configConverter.convert(this.configBizConfigService.queryOwnerIssueInfo(Long.valueOf(((UserInfo)this.userInfoHolder.get()).getGroupId()), sellerTaxNo, Long.valueOf(((UserInfo)this.userInfoHolder.get()).getUserId()), sysOrgId));
    }

    public MsConfigPageDTO queryConfigList(MsConfigQueryRequest request, Long groupId) {
        return this.configBizConfigService.queryConfigList(request, groupId);
    }

    public List<MsConfigItemBean> queryConfigItemList(MsConfigItemQueryRequest request) {
        return this.configBizConfigService.queryConfigItemList(request);
    }

    public int upateConfigItemInfo(Long configItemId, List<String> configItemValues) {
        return this.configBizConfigService.updateConfigItemValue(configItemId, JsonUtils.toJson(configItemValues));
    }

    public Either<String, List<Long>> queryConfigItemIdList(List<String> salesbillTypeList, Integer configType, Long sellerGroupId) {
        return this.configBizConfigService.queryConfigItemIdList(salesbillTypeList, configType, sellerGroupId);
    }

    public int batchUpateConfigItemInfo(List<Long> cfgItemIdList, List<String> configItemValues) {
        return this.configBizConfigService.batchUpdateConfigItemValue(cfgItemIdList, JsonUtils.toJson(configItemValues));
    }

    public Either<String, List<String>> queryChannelSalesbillType(Integer objFlag) {
        List businessExtensionAttributes;
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        UserCenterResponse response2 = this.userCenterUserService.getUserByUserId(userInfo.getGroupId(), userInfo.getUserId(), userInfo.getModules());
        if (!String.valueOf(Response.OK).equals(response2.getCode()) || Objects.isNull(response2.getResult())) {
            return Either.left((Object)"\u67e5\u8be2\u7528\u6237\u6743\u9650\u4fe1\u606f\u5931\u8d25");
        }
        String businessExtensionAttribute = ((UserData)response2.getResult()).getBusinessExtensionAttribute();
        if (StringUtils.isBlank((CharSequence)businessExtensionAttribute)) {
            return Either.left((Object)"\u67e5\u8be2\u7528\u6237\u6743\u9650\u4fe1\u606f\u5931\u8d25");
        }
        ArrayList businessTypeList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)businessExtensionAttribute) && CollectionUtils.isNotEmpty((Collection)(businessExtensionAttributes = JsonUtils.toList((String)businessExtensionAttribute, BusinessExtensionAttribute.class)))) {
            businessTypeList.addAll(businessExtensionAttributes.stream().map(BusinessExtensionAttribute::getObjType).distinct().collect(Collectors.toList()));
        }
        if (CollectionUtils.isEmpty((Collection)businessTypeList)) {
            return Either.left((Object)"\u67e5\u8be2\u7528\u6237\u6743\u9650\u4fe1\u606f\u5931\u8d25");
        }
        List cfgBusinessObjEntities = this.cfgBusinessObjDataService.queryByCondition(criteria -> criteria.andGroupIdEqualTo(Long.valueOf(userInfo.getGroupId())).andObjStatusEqualTo(Integer.valueOf(1)).andObjFlagEqualTo(objFlag));
        List tenantBusinessType = cfgBusinessObjEntities.stream().filter(r -> Objects.nonNull(r.getChannel()) && StringUtils.isNotBlank((CharSequence)r.getChannel()) && Long.parseLong(r.getChannel()) > 0L).map(CfgBusinessObjEntity::getObjName).collect(Collectors.toList());
        return Either.right(businessTypeList.stream().filter(tenantBusinessType::contains).collect(Collectors.toList()));
    }
}

