/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.facade;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.seller.config.client.constant.BusinessSalesBillTypeEnum;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.model.EmailConfigEntity;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.client.model.MsConfigBizBillAttribute;
import com.xforceplus.seller.config.client.model.MsConfigItemQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigQueryRequest;
import com.xforceplus.seller.config.client.parse.bean.InvoiceInfoRuleDTO;
import com.xforceplus.seller.config.client.parse.impl.InvoiceInfoRlueParser;
import com.xforceplus.seller.config.client.util.ReflectUtil;
import com.xforceplus.seller.config.converters.ConfigConverter;
import com.xforceplus.seller.config.converters.ConfigEntityTranslater;
import com.xforceplus.seller.config.facade.ConfigMatchingFacade;
import com.xforceplus.seller.config.repository.model.CfgConfigEntity;
import com.xforceplus.seller.config.services.ConfigBizConfigService;
import com.xforceplus.seller.config.services.ConfigMailRuleDataService;
import com.xforceplus.seller.config.util.CommonTools;
import com.xforceplus.xplatframework.utils.JsonUtils;
import io.vavr.control.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ConfigMatchingFacadeImpl
implements ConfigMatchingFacade {
    private static final Logger log = LoggerFactory.getLogger(ConfigMatchingFacadeImpl.class);
    private final ConfigBizConfigService configBizConfigService;
    private final ConfigMailRuleDataService configMailRuleDataService;
    private final ConfigConverter configConverter;
    private final InvoiceInfoRlueParser invoiceInfoRlueParser;
    private static final List<Function<MsConfigBean, String>> EXT_LIST = Lists.newArrayList((Object[])new Function[]{MsConfigBean::getExt2, MsConfigBean::getExt3, MsConfigBean::getExt4, MsConfigBean::getExt5, MsConfigBean::getExt6, MsConfigBean::getExt7, MsConfigBean::getExt8, MsConfigBean::getExt9, MsConfigBean::getExt10, MsConfigBean::getExt11, MsConfigBean::getExt12, MsConfigBean::getExt13, MsConfigBean::getExt14, MsConfigBean::getExt15, MsConfigBean::getExt16, MsConfigBean::getExt17, MsConfigBean::getExt18, MsConfigBean::getExt19, MsConfigBean::getExt20, MsConfigBean::getExt21, MsConfigBean::getExt22, MsConfigBean::getExt23, MsConfigBean::getExt24, MsConfigBean::getExt25});

    public ConfigMatchingFacadeImpl(ConfigBizConfigService configBizConfigService, ConfigMailRuleDataService configMailRuleDataService, ConfigConverter configConverter, InvoiceInfoRlueParser invoiceInfoRlueParser) {
        this.configBizConfigService = configBizConfigService;
        this.configMailRuleDataService = configMailRuleDataService;
        this.configConverter = configConverter;
        this.invoiceInfoRlueParser = invoiceInfoRlueParser;
    }

    public String getOptimalMatchConfigForEmail(MsConfigQueryRequest msConfigQueryRequest) {
        log.info("\u83b7\u53d6\u53d1\u7968\u5339\u914d\u89c4\u5219\uff0c\u8bf7\u6c42\u53c2\u6570:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigQueryRequest));
        if (null != msConfigQueryRequest && null == msConfigQueryRequest.getStatus()) {
            msConfigQueryRequest.setStatus(Integer.valueOf(1));
        }
        List settingCfgConfigEntityList = this.configBizConfigService.querySettingConfigList(msConfigQueryRequest);
        log.info("getOptimalMatchConfigListWithAttrOfEmail---cfgConfigEntityList:{}", (Object)JsonUtils.writeObjectToFastJson((Object)settingCfgConfigEntityList));
        if (CollectionUtils.isEmpty((Collection)settingCfgConfigEntityList)) {
            log.warn("getOptimalMatchConfigListWithAttrOfEmail \u672a\u5339\u914d\u5230\u90ae\u4ef6\u89c4\u5219, \u8fd4\u56de\u9ed8\u8ba4\u89c4\u5219");
            return this.getMailConfigListResponse(null, msConfigQueryRequest.getInvoiceType());
        }
        MsConfigBean msConfigBean = ConfigEntityTranslater.convertFromMsConfigQueryRequest((MsConfigQueryRequest)msConfigQueryRequest);
        List settingMsConfigBeanList = settingCfgConfigEntityList.stream().map(arg_0 -> this.getMsConfigBean(arg_0)).collect(Collectors.toList());
        List bestMsConfigBeanList = this.getBestMatchConfigList(settingMsConfigBeanList, msConfigBean);
        log.info("getOptimalMatchConfigListWithAttrOfEmail---bestMsConfigBean:{}", (Object)JsonUtils.writeObjectToFastJson((Object)bestMsConfigBeanList));
        if (CollectionUtils.isEmpty((Collection)bestMsConfigBeanList)) {
            log.warn("getOptimalMatchConfigListWithAttrOfEmail bestMsConfigBean\u4e3a\u7a7a, \u8fd4\u56de\u9ed8\u8ba4\u89c4\u5219");
            return this.getMailConfigListResponse(null, msConfigQueryRequest.getInvoiceType());
        }
        return this.getMailConfigListResponse(bestMsConfigBeanList.stream().map(MsConfigBean::getConfigId).collect(Collectors.toList()), msConfigQueryRequest.getInvoiceType());
    }

    public List<InvoiceInfoRuleDTO> getSellerIssueInfoConfig(MsConfigQueryRequest queryRequest) {
        log.info("\u83b7\u53d6\u9500\u65b9\u5f00\u7968\u4fe1\u606frequest:{}", (Object)JsonUtils.writeObjectToFastJson((Object)queryRequest));
        CfgConfigEntity sellerInfoCfg = this.configBizConfigService.queryOneSellerIssueInfo(queryRequest.getSellerGroupId(), queryRequest.getSellerTaxNo(), ConfigTypeEnum.INVOICE_CONFIG_TYPE);
        CfgConfigEntity operatorInfoCfg = this.configBizConfigService.queryOneSellerIssueInfo(queryRequest.getSellerGroupId(), queryRequest.getSellerTaxNo(), ConfigTypeEnum.INVOICE_USER_CONFIG_TYPE);
        return Lists.newArrayList((Object[])new InvoiceInfoRuleDTO[]{this.convert(sellerInfoCfg), this.convert(operatorInfoCfg)});
    }

    private InvoiceInfoRuleDTO convert(CfgConfigEntity cfg) {
        if (null == cfg) {
            return null;
        }
        MsConfigItemQueryRequest request = new MsConfigItemQueryRequest();
        request.setConfigId(String.valueOf(cfg.getConfigId()));
        List configItemList = this.configBizConfigService.queryConfigItemList(request);
        if (CollectionUtils.isNotEmpty((Collection)configItemList)) {
            return this.invoiceInfoRlueParser.parse(configItemList);
        }
        return null;
    }

    public MsConfigBean getMsConfigBean(CfgConfigEntity entity) {
        ArrayList attributes = new ArrayList();
        List attrs = this.configBizConfigService.selectCfgBillAttribute(entity);
        MsConfigBean msConfigBean = ConfigEntityTranslater.convertFromConfigEntity((CfgConfigEntity)entity);
        if (CollectionUtils.isNotEmpty((Collection)attrs)) {
            msConfigBean.setHasAttrClassCfg(true);
            attributes.addAll(attrs.stream().map(attr -> {
                MsConfigBizBillAttribute attribute = new MsConfigBizBillAttribute();
                attribute.setFieldName(attr.getFieldName());
                attribute.setAttrName(attr.getAttrName());
                attribute.setAttrDesc(attr.getAttrDesc());
                attribute.setValue(attr.getValue());
                return attribute;
            }).collect(Collectors.toList()));
        }
        msConfigBean.setAttributes(attributes);
        return msConfigBean;
    }

    private String getMailConfigListResponse(List<Long> configIdList, List<String> invoiceTypeList) {
        ArrayList entityList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(configIdList)) {
            EmailConfigEntity entity = this.configConverter.init();
            entityList.add(entity);
        } else {
            List mailRuleList = this.configMailRuleDataService.queryByConfigIdList(configIdList);
            if (CollectionUtils.isEmpty((Collection)mailRuleList)) {
                EmailConfigEntity entity = this.configConverter.init();
                entityList.add(entity);
            } else {
                entityList.addAll(mailRuleList.stream().map(mailRule -> {
                    EmailConfigEntity entity = this.configConverter.convert(mailRule);
                    if (mailRule.getUseCustomAddress().booleanValue()) {
                        entity.setCustomMails((List)Lists.newArrayList((Object[])mailRule.getCustomMailList().split(";")));
                    }
                    return entity;
                }).collect(Collectors.toList()));
            }
        }
        log.info("getOptimalMatchConfigListWithAttrOfEmail---getMailConfigResponse:{}", (Object)JsonUtils.writeObjectToFastJson((Object)entityList));
        return JsonUtils.writeObjectToFastJson((Object)entityList);
    }

    public List<MsConfigBean> getBestMatchConfigList(List<MsConfigBean> targetMsConfigBeanList, MsConfigBean msConfigBeanFromBill) {
        if (CollectionUtils.isEmpty(targetMsConfigBeanList)) {
            return null;
        }
        Object retMsConfigBean = null;
        Map bean = null;
        try {
            bean = ReflectUtil.bean2map((Object)msConfigBeanFromBill);
        }
        catch (Exception e) {
            log.error("@getBestMatchConfig ", (Throwable)e);
        }
        HashMap bestMatchMap = Maps.newHashMap();
        for (MsConfigBean matchingMsConfigBean : targetMsConfigBeanList) {
            String bBillType;
            Either eitherResult;
            int score = 0;
            boolean match = true;
            List attributes = matchingMsConfigBean.getAttributes();
            if (CollectionUtils.isNotEmpty((Collection)attributes)) {
                int matchCount = 0;
                for (MsConfigBizBillAttribute attr : attributes) {
                    String value = (String)bean.get(attr.getFieldName());
                    if (value == null || !value.equals(attr.getValue())) {
                        match = false;
                        score -= 6;
                        break;
                    }
                    ++matchCount;
                }
                if (!match) continue;
                score += 6 * matchCount;
            }
            if ((eitherResult = (bBillType = matchingMsConfigBean.getBusinessBillType()).equals(BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType()) ? this.matchSellerPurchaserScore(BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType(), matchingMsConfigBean, msConfigBeanFromBill, MsConfigBean::getSellerGroupId, MsConfigBean::getSellerTaxNo, MsConfigBean::getPurchaserGroupId, MsConfigBean::getPurchaserTaxNo) : this.matchSellerPurchaserScore(BusinessSalesBillTypeEnum.AP.getBusinessSalesBillType(), matchingMsConfigBean, msConfigBeanFromBill, MsConfigBean::getPurchaserGroupId, MsConfigBean::getPurchaserTaxNo, MsConfigBean::getSellerGroupId, MsConfigBean::getSellerTaxNo)).isLeft()) continue;
            score += ((Integer)eitherResult.get()).intValue();
            if (!StringUtils.isEmpty((CharSequence)matchingMsConfigBean.getSalesbillType()) && matchingMsConfigBean.getSalesbillType().equals(msConfigBeanFromBill.getSalesbillType())) {
                score += 4;
            } else if (!StringUtils.isEmpty((CharSequence)matchingMsConfigBean.getSalesbillType())) {
                log.info("ARAP---\u9500\u65b9\u96c6\u56e2Id\u76f8\u7b49\u3001\u516c\u53f8\u6709\u503c\u4e14\u76f8\u7b49\u3001\u5b50\u7ec4\u7ec7\u6709\u503c\u4e14\u76f8\u7b49\u3001 \u4e1a\u52a1\u7c7b\u578b\u6709\u503c\u4e14\u4e0d\u7b49\uff1a\u8be5\u89c4\u5219\u4e0d\u4f7f\u7528 configId:{}", (Object)matchingMsConfigBean.getConfigId());
                continue;
            }
            log.info("matched====total size:{}, configId:{}, score:{} : AR|AP:{}", new Object[]{targetMsConfigBeanList.size(), matchingMsConfigBean.getConfigId(), score += this.getScoreByExtFields(matchingMsConfigBean, msConfigBeanFromBill), matchingMsConfigBean.getBusinessBillType()});
            CommonTools.mapPutValue((Map)bestMatchMap, (Object)score, (Object)matchingMsConfigBean);
        }
        log.info("splitConfigRuleMatch--- match result retMsConfigBean===>:{}", (Object)JsonUtils.writeObjectToFastJson(retMsConfigBean));
        return bestMatchMap.entrySet().stream().max(Map.Entry.comparingByKey()).map(Map.Entry::getValue).orElse(null);
    }

    private Either<Boolean, Integer> matchSellerPurchaserScore(String businessBillType, MsConfigBean ruleBean, MsConfigBean requestBean, Function<MsConfigBean, Long> ownerGroupIdFunc, Function<MsConfigBean, String> ownerTaxNoFunc, Function<MsConfigBean, Long> customerGroupIdFunc, Function<MsConfigBean, String> customerTaxNoFunc) {
        String customerContext;
        String ownerContext;
        Long ownerGroupId = ownerGroupIdFunc.apply(ruleBean);
        String ownerTaxNo = ownerTaxNoFunc.apply(ruleBean);
        Long customerGroupId = customerGroupIdFunc.apply(ruleBean);
        String customerTaxNo = customerTaxNoFunc.apply(ruleBean);
        if (BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(businessBillType)) {
            ownerContext = "\u9500\u65b9";
            customerContext = "\u8d2d\u65b9";
        } else {
            ownerContext = "\u8d2d\u65b9";
            customerContext = "\u9500\u65b9";
        }
        int score = 0;
        if (Objects.nonNull(ownerGroupId) && ownerGroupId > 0L && ownerGroupId.equals(ownerGroupIdFunc.apply(requestBean))) {
            score += 2;
        } else {
            log.info("{}---{}\u96c6\u56e2Id \u4e0d\u76f8\u7b49\uff0c\u653e\u5f03\u672c\u6b21\u7684\u5339\u914d\u89c4\u5219\uff0c \u6309\u7b5b\u9009\u6761\u4ef6\uff0c\u4e0d\u53ef\u80fd\u8fd0\u884c\u5230\u8be5\u5206\u652f configId:{}", new Object[]{businessBillType, ownerContext, ruleBean.getConfigId()});
            return Either.left((Object)false);
        }
        if (StringUtils.isNotBlank((CharSequence)ownerTaxNo)) {
            if (ownerTaxNo.equals(ownerTaxNoFunc.apply(requestBean))) {
                score += 160;
            } else {
                log.info("{}---{}\u96c6\u56e2Id\u76f8\u7b49\u3001\u516c\u53f8\u6709\u503c\u4e14\u4e0d\u76f8\u7b49\uff1a\u8be5\u89c4\u5219\u4e0d\u4f7f\u7528 configId:{}", new Object[]{businessBillType, ownerContext, ruleBean.getConfigId()});
                return Either.left((Object)false);
            }
        }
        if (Objects.nonNull(customerGroupId) && customerGroupId > 0L) {
            if (customerGroupId.equals(customerGroupIdFunc.apply(requestBean))) {
                score += 2;
            } else {
                log.info("{}---{}\u96c6\u56e2\u6709\u503c\u4e14\u4e0d\u76f8\u7b49\uff0c\u8be5\u4e2d\u89c4\u5219\u914d\u7f6e\u4e0d\u4f7f\u7528 configId:{}--msConfigBeanFromBill:{}", new Object[]{businessBillType, customerContext, ruleBean.getConfigId(), JsonUtils.writeObjectToFastJson((Object)requestBean)});
                return Either.left((Object)false);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)customerTaxNo)) {
            if (customerTaxNo.equals(customerTaxNoFunc.apply(requestBean))) {
                score += 160;
            } else {
                log.info("{}---{}\u516c\u53f8\u6709\u503c \u4e14 \u4e0d\u76f8\u7b49\u3001\u8be5\u4e2d\u89c4\u5219\u914d\u7f6e\u4e0d\u4f7f\u7528 configId:{}", new Object[]{businessBillType, customerContext, ruleBean.getConfigId()});
                return Either.left((Object)false);
            }
        }
        if (BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(businessBillType)) {
            ++score;
        }
        return Either.right((Object)score);
    }

    private int getScoreByExtFields(MsConfigBean sourceData, MsConfigBean targetData) {
        return EXT_LIST.stream().filter(r -> StringUtils.isNotBlank((CharSequence)((CharSequence)r.apply(targetData))) && ((String)r.apply(targetData)).equals(r.apply(sourceData))).mapToInt(r -> 6).sum();
    }
}

