/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.facade;

import com.xforceplus.phoenix.infrastructure.usercenter.model.CompanyData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserCenterResponse;
import com.xforceplus.phoenix.infrastructure.usercenter.services.UserCenterCompanyService;
import com.xforceplus.seller.config.client.model.MsQueryTerminalRequest;
import com.xforceplus.seller.config.client.model.MsQueryTerminalResponse;
import com.xforceplus.seller.config.client.model.MsTerminalQueryResponseInfo;
import com.xforceplus.seller.config.client.model.SyncTaxPlateGoodsRequest;
import com.xforceplus.seller.config.facade.GoodsFacade;
import com.xforceplus.seller.config.facade.TerminalDeviceFacade;
import com.xforceplus.seller.config.models.MidGoodsData;
import com.xforceplus.seller.config.models.MidGoodsQueryRequest;
import com.xforceplus.seller.config.models.MidGoodsQueryResult;
import com.xforceplus.seller.config.models.MidPlatformResponse;
import com.xforceplus.seller.config.models.SyncTaxWareGoodRequest;
import com.xforceplus.seller.config.services.MidPlateFormService;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Service
public class GoodsFacadeImpl
implements GoodsFacade {
    private static final Logger log = LoggerFactory.getLogger(GoodsFacadeImpl.class);
    private final MidPlateFormService midPlateFormService;
    private final UserInfoHolder<UserInfo> userInfoHolder;
    private final UserCenterCompanyService userCenterCompanyService;
    private final TerminalDeviceFacade terminalDeviceFacade;

    public GoodsFacadeImpl(MidPlateFormService midPlateFormService, UserInfoHolder<UserInfo> userInfoHolder, UserCenterCompanyService userCenterCompanyService, TerminalDeviceFacade terminalDeviceFacade) {
        this.midPlateFormService = midPlateFormService;
        this.userInfoHolder = userInfoHolder;
        this.userCenterCompanyService = userCenterCompanyService;
        this.terminalDeviceFacade = terminalDeviceFacade;
    }

    public Either<String, String> syncTaxPlateGoods(SyncTaxPlateGoodsRequest request) {
        StopWatch stopWatch = new StopWatch();
        String taxNo = request.getTaxNo();
        log.info("syncTaxPlateGoods {}", (Object)taxNo);
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return Either.left((Object)"\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        stopWatch.start("queryCompany");
        UserCenterResponse userCenterResponse = this.userCenterCompanyService.getCompanyByTaxNo(userInfo.getGroupId(), taxNo);
        stopWatch.stop();
        if (!"1".equals(userCenterResponse.getCode()) || Objects.isNull(userCenterResponse.getResult())) {
            return Either.left((Object)"\u6839\u636e\u7a0e\u53f7\u65e0\u6cd5\u67e5\u5230\u516c\u53f8");
        }
        CompanyData companyData = (CompanyData)userCenterResponse.getResult();
        stopWatch.start("queryTerminal");
        MsQueryTerminalRequest msQueryTerminalRequest = new MsQueryTerminalRequest();
        msQueryTerminalRequest.setTaxNo(taxNo);
        msQueryTerminalRequest.setQueryOnline(Boolean.valueOf(true));
        msQueryTerminalRequest.setQueryInventory(Boolean.valueOf(false));
        msQueryTerminalRequest.setLimitByUser(Boolean.valueOf(false));
        MsQueryTerminalResponse terminalResponse = this.terminalDeviceFacade.getTerminalList(msQueryTerminalRequest);
        stopWatch.stop();
        if (!Integer.valueOf(1).equals(terminalResponse.getCode()) || CollectionUtils.isEmpty((Collection)terminalResponse.getResult().getTerminals())) {
            return Either.left((Object)"\u6ca1\u6709\u67e5\u5230\u516c\u53f8\u5173\u8054\u7ec8\u7aef");
        }
        MsTerminalQueryResponseInfo terminal = (MsTerminalQueryResponseInfo)terminalResponse.getResult().getTerminals().get(0);
        if (!Integer.valueOf(1).equals(terminal.getDirectOnlineFlag())) {
            return Either.left((Object)"\u7ec8\u7aef\u4e0d\u5728\u7ebf\uff0c\u65e0\u6cd5\u540c\u6b65\u5546\u54c1\u6570\u636e");
        }
        stopWatch.start("syncGoods");
        SyncTaxWareGoodRequest midRequest = new SyncTaxWareGoodRequest();
        midRequest.setCompanyId(companyData.getCompanyId());
        midRequest.setDeviceNo(terminal.getDeviceNo());
        midRequest.setDeviceUn(terminal.getDeviceUn());
        midRequest.setTerminalUn(terminal.getTerminalUn());
        midRequest.setUserId(Long.valueOf(userInfo.getUserId()));
        midRequest.setUserName(userInfo.getUserName());
        MidPlatformResponse response2 = this.midPlateFormService.syncGoodsFromTaxPlate(midRequest);
        stopWatch.stop();
        if (!"GDCTZZ0600002".equals(response2.getCode()) && !"GDCTZZ0001".equals(response2.getCode())) {
            return Either.left((Object)response2.getMessage());
        }
        log.info("syncTaxPlateGoods {} time:{}", (Object)taxNo, (Object)stopWatch.prettyPrint());
        return Either.right((Object)response2.getMessage());
    }

    public Either<String, Tuple2<Integer, List<MidGoodsData>>> queryGoods(Long tenantId, Integer pageNo, Integer pageSize) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("queryGoods");
        MidGoodsQueryRequest midRequest = new MidGoodsQueryRequest();
        midRequest.setTenantId(tenantId);
        midRequest.setPageNo(pageNo);
        midRequest.setPageSize(pageSize);
        MidPlatformResponse queryResponse = this.midPlateFormService.queryGoods(midRequest);
        stopWatch.stop();
        if (!"GDCTZZ0001".equals(queryResponse.getCode())) {
            return Either.left((Object)queryResponse.getMessage());
        }
        MidGoodsQueryResult result = (MidGoodsQueryResult)queryResponse.getResult();
        log.info("queryGoods time:{}", (Object)stopWatch.prettyPrint());
        return Either.right((Object)Tuple.of((Object)result.getTotal(), (Object)result.getGoodsRecords()));
    }
}

