/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.facade;

import com.xforceplus.seller.config.client.model.TaxNationalCode;
import com.xforceplus.seller.config.client.model.TaxNationalCodeResponse;
import com.xforceplus.seller.config.facade.TaxNationalCodeFacade;
import com.xforceplus.seller.config.services.MidPlateFormService;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TaxNationalCodeFacadeImpl
implements TaxNationalCodeFacade {
    private static final Logger log = LoggerFactory.getLogger(TaxNationalCodeFacadeImpl.class);
    private final MidPlateFormService midPlateFormService;
    private final UserInfoHolder<UserInfo> userInfoHolder;

    public TaxNationalCodeFacadeImpl(MidPlateFormService midPlateFormService, UserInfoHolder<UserInfo> userInfoHolder) {
        this.midPlateFormService = midPlateFormService;
        this.userInfoHolder = userInfoHolder;
    }

    public TaxNationalCode getNationalTaxCode(String goodsTaxNo) {
        if (goodsTaxNo != null && goodsTaxNo.length() < 18) {
            return null;
        }
        List nationalTaxCode = this.midPlateFormService.getNationalTaxCode(goodsTaxNo, "123456", null);
        if (CollectionUtils.isEmpty((Collection)nationalTaxCode)) {
            return null;
        }
        return (TaxNationalCode)nationalTaxCode.get(0);
    }

    public TaxNationalCodeResponse getNationalTaxCodeByTaxCodeName(String taxCodeName) {
        return this.getNationalTaxCodeBy(r -> this.midPlateFormService.getNationalTaxCode(null, r, taxCodeName));
    }

    public TaxNationalCodeResponse getNationalTaxCodeByGoodsTaxNo(String goodTaxNo) {
        return this.getNationalTaxCodeBy(r -> this.midPlateFormService.getNationalTaxCode(goodTaxNo, r, null));
    }

    private TaxNationalCodeResponse getNationalTaxCodeBy(Function<String, List<TaxNationalCode>> getNationalTaxCode) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        String groupId = "123456";
        if (userInfo != null) {
            groupId = String.valueOf(userInfo.getGroupId());
        }
        TaxNationalCodeResponse response2 = new TaxNationalCodeResponse();
        response2.setCode(TaxNationalCodeResponse.OK);
        response2.setMessage("\u67e5\u8be2\u6210\u529f");
        List<TaxNationalCode> nationalTaxCode = getNationalTaxCode.apply(groupId);
        response2.setResult(nationalTaxCode);
        return response2;
    }
}

