/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.facade;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xforceplus.micro.tax.device.contract.model.OnlineDeviceInfo;
import com.xforceplus.micro.tax.device.contract.model.PageInfo;
import com.xforceplus.micro.tax.device.contract.model.QueryTerminalRequest;
import com.xforceplus.micro.tax.device.contract.model.QueryTerminalResponse;
import com.xforceplus.micro.tax.device.contract.model.TerminalQueryInfo;
import com.xforceplus.micro.tax.device.contract.model.TerminalQueryResponseInfo;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.phoenix.infrastructure.usercenter.api.UserCenterApi;
import com.xforceplus.phoenix.infrastructure.usercenter.model.GenerateCertificateRequest;
import com.xforceplus.phoenix.infrastructure.usercenter.model.OrgData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserCenterList;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserCenterResponse;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserQueryParam;
import com.xforceplus.phoenix.infrastructure.usercenter.services.UserCenterUserService;
import com.xforceplus.seller.config.client.constant.AllElectricIssuerIssueTypeEnum;
import com.xforceplus.seller.config.client.constant.AllElectricIssuerOnLineEnum;
import com.xforceplus.seller.config.client.constant.CfgAllElectricIssuerOperateTypeEnum;
import com.xforceplus.seller.config.client.model.AllElectricIssuerInfo;
import com.xforceplus.seller.config.client.model.AllElectricIssuerInfoData;
import com.xforceplus.seller.config.client.model.AllElectricIssuerInfoRecord;
import com.xforceplus.seller.config.client.model.AllElectricIssuerInfoResult;
import com.xforceplus.seller.config.client.model.AllElectricIssuerRecordRequest;
import com.xforceplus.seller.config.client.model.AllElectricIssuerRequest;
import com.xforceplus.seller.config.client.model.AllElectricQualificationData;
import com.xforceplus.seller.config.client.model.CfgAllElectricIssuerRecord;
import com.xforceplus.seller.config.client.model.ConfigAddElectricIssuerInfoRequest;
import com.xforceplus.seller.config.client.model.ConfigAllElectricIssuerInfoRequest;
import com.xforceplus.seller.config.client.model.ConfigDeleteElectricIssuerInfoRequest;
import com.xforceplus.seller.config.client.model.InvoiceTypeInventoryData;
import com.xforceplus.seller.config.client.model.MsConfigUserIssuerRelationData;
import com.xforceplus.seller.config.client.model.MsQueryTerminalRequest;
import com.xforceplus.seller.config.client.model.MsQueryTerminalResponse;
import com.xforceplus.seller.config.client.model.MsTerminalQueryResponseInfo;
import com.xforceplus.seller.config.client.model.MsTerminalQueryResult;
import com.xforceplus.seller.config.client.model.Page;
import com.xforceplus.seller.config.client.model.QueryInventoryRequest;
import com.xforceplus.seller.config.client.model.QueryInventoryResult;
import com.xforceplus.seller.config.client.model.UserRelationData;
import com.xforceplus.seller.config.config.ConfigTerminalProperties;
import com.xforceplus.seller.config.converters.DeviceConverter;
import com.xforceplus.seller.config.converters.TaxWareConverter;
import com.xforceplus.seller.config.converters.UserIssuerRelationConverter;
import com.xforceplus.seller.config.core.enums.DeviceType;
import com.xforceplus.seller.config.core.enums.ErrorCodeEnum;
import com.xforceplus.seller.config.core.enums.InvoiceType;
import com.xforceplus.seller.config.core.enums.TaxDeviceType;
import com.xforceplus.seller.config.core.enums.ValueEnum;
import com.xforceplus.seller.config.facade.TerminalDeviceFacade;
import com.xforceplus.seller.config.infrastructure.client.UserCenterService;
import com.xforceplus.seller.config.infrastructure.helper.DeviceApiProxy;
import com.xforceplus.seller.config.infrastructure.helper.RestTemplateTools;
import com.xforceplus.seller.config.models.BatchQueryQualificatonsRequest;
import com.xforceplus.seller.config.models.BatchQueryQualificatonsResponse;
import com.xforceplus.seller.config.models.CertificateResult;
import com.xforceplus.seller.config.models.CommonResponse;
import com.xforceplus.seller.config.models.GenerateCertificateResponse;
import com.xforceplus.seller.config.models.RestCompanyInfo;
import com.xforceplus.seller.config.models.RestDeviceInfo;
import com.xforceplus.seller.config.models.RestDeviceQueryInfo;
import com.xforceplus.seller.config.models.RestGetDeviceResult;
import com.xforceplus.seller.config.models.RestQueryDeviceRequest;
import com.xforceplus.seller.config.models.RestQueryDeviceResponse;
import com.xforceplus.seller.config.models.RestQueryInventoryRequest;
import com.xforceplus.seller.config.models.RestResponse;
import com.xforceplus.seller.config.models.RestTaxDeviceInfo;
import com.xforceplus.seller.config.repository.dao.CfgAllElectricIssuerRecordDao;
import com.xforceplus.seller.config.repository.dao.CfgUserIssuerRelationDao;
import com.xforceplus.seller.config.repository.dao.CfgUserIssuerRelationInterfaceDao;
import com.xforceplus.seller.config.repository.daoext.CfgUserIssuerRelationExtDao;
import com.xforceplus.seller.config.repository.daoext.CfgUserIssuerRelationInterfaceExtDao;
import com.xforceplus.seller.config.repository.model.CfgAllElectricIssuerRecordEntity;
import com.xforceplus.seller.config.repository.model.CfgAllElectricIssuerRecordExample;
import com.xforceplus.seller.config.repository.model.CfgUserIssuerRelationEntity;
import com.xforceplus.seller.config.repository.model.CfgUserIssuerRelationExample;
import com.xforceplus.seller.config.repository.model.CfgUserIssuerRelationInterfaceEntity;
import com.xforceplus.seller.config.repository.model.CfgUserIssuerRelationInterfaceExample;
import com.xforceplus.seller.config.services.ConfigTerminalService;
import com.xforceplus.seller.config.services.ConfigTerminalServiceImplKt;
import com.xforceplus.seller.config.services.ImportFailRelationIssueServiceImpl;
import com.xforceplus.seller.config.util.AssertUtil;
import com.xforceplus.seller.config.util.CommonTools;
import com.xforceplus.xplatdata.base.BaseEntity;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.apimodel.file.ImportResponse;
import com.xforceplus.xplatframework.apimodel.file.ImportResult;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import io.geewit.web.utils.JsonUtils;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import io.vavr.control.Either;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Service;

@Service
public class TerminalDeviceFacadeImpl
implements TerminalDeviceFacade {
    private static final Logger log = LoggerFactory.getLogger(TerminalDeviceFacadeImpl.class);
    private static final Integer DEFAULT_PAGE_NO = 1;
    private static final Integer DEFAULT_PAGE_SIZE = 9999;
    private final DeviceConverter deviceConverter;
    private final ConfigTerminalProperties configTerminalProperties;
    private final UserCenterService userCenterService;
    private final UserInfoHolder<UserInfo> userInfoHolder;
    private final UserCenterUserService userCenterUserService;
    private final DeviceApiProxy deviceApiProxy;
    private final ConfigTerminalServiceImplKt configTerminalServiceImplKt;
    private final TaxWareConverter taxWareConverter;
    private final RestTemplateTools restTemplateTools;
    private final ConfigTerminalService configTerminalService;
    private final CfgUserIssuerRelationDao cfgUserIssuerRelationDao;
    private final CfgUserIssuerRelationExtDao cfgUserIssuerRelationExtDao;
    private final CfgAllElectricIssuerRecordDao cfgAllElectricIssuerRecordDao;
    private final IDGenerator idGenerator;
    private final UserCenterApi userCenterApi;
    private final ImportFailRelationIssueServiceImpl importFailRelationIssueServiceImpl;
    private final UserIssuerRelationConverter userIssuerRelationConverter;
    private final CfgUserIssuerRelationInterfaceExtDao cfgUserIssuerRelationInterfaceExtDao;
    private final CfgUserIssuerRelationInterfaceDao cfgUserIssuerRelationInterfaceDao;

    public TerminalDeviceFacadeImpl(DeviceConverter deviceConverter, ConfigTerminalProperties configTerminalProperties, UserCenterService userCenterService, UserInfoHolder<UserInfo> userInfoHolder, UserCenterUserService userCenterUserService, DeviceApiProxy deviceApiProxy, ConfigTerminalServiceImplKt configTerminalServiceImplKt, TaxWareConverter taxWareConverter, RestTemplateTools restTemplateTools, @Lazy ConfigTerminalService configTerminalService, CfgUserIssuerRelationDao cfgUserIssuerRelationDao, CfgUserIssuerRelationExtDao cfgUserIssuerRelationExtDao, CfgAllElectricIssuerRecordDao cfgAllElectricIssuerRecordDao, IDGenerator idGenerator, UserCenterApi userCenterApi, ImportFailRelationIssueServiceImpl importFailRelationIssueServiceImpl, UserIssuerRelationConverter userIssuerRelationConverter, CfgUserIssuerRelationInterfaceExtDao cfgUserIssuerRelationInterfaceExtDao, CfgUserIssuerRelationInterfaceDao cfgUserIssuerRelationInterfaceDao) {
        this.deviceConverter = deviceConverter;
        this.configTerminalProperties = configTerminalProperties;
        this.userCenterService = userCenterService;
        this.userInfoHolder = userInfoHolder;
        this.userCenterUserService = userCenterUserService;
        this.deviceApiProxy = deviceApiProxy;
        this.configTerminalServiceImplKt = configTerminalServiceImplKt;
        this.taxWareConverter = taxWareConverter;
        this.restTemplateTools = restTemplateTools;
        this.configTerminalService = configTerminalService;
        this.cfgUserIssuerRelationDao = cfgUserIssuerRelationDao;
        this.cfgUserIssuerRelationExtDao = cfgUserIssuerRelationExtDao;
        this.cfgAllElectricIssuerRecordDao = cfgAllElectricIssuerRecordDao;
        this.idGenerator = idGenerator;
        this.userCenterApi = userCenterApi;
        this.importFailRelationIssueServiceImpl = importFailRelationIssueServiceImpl;
        this.userIssuerRelationConverter = userIssuerRelationConverter;
        this.cfgUserIssuerRelationInterfaceExtDao = cfgUserIssuerRelationInterfaceExtDao;
        this.cfgUserIssuerRelationInterfaceDao = cfgUserIssuerRelationInterfaceDao;
    }

    public MsQueryTerminalResponse getTerminalList(MsQueryTerminalRequest request) {
        log.info("getTerminalList request:{}", (Object)JsonUtils.toJson((Object)request));
        List taxNoList = Optional.ofNullable(request.getTaxNos()).orElse(Lists.newArrayList());
        Optional.ofNullable(request.getTaxNo()).ifPresent(taxNoList::add);
        ArrayList bothCheckTaxNoList = Lists.newArrayList();
        ArrayList terminalCheckTaxNoList = Lists.newArrayList();
        ArrayList deviceCheckTaxNoList = Lists.newArrayList();
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        long groupId = userInfo.getGroupId();
        if (Objects.nonNull(request.getLimitByUser()) && request.getLimitByUser().booleanValue()) {
            if (this.configTerminalProperties.getAuthenticationSwitch().booleanValue()) {
                taxNoList.forEach(r -> {
                    boolean deviceCheck;
                    String terminalCheckResult = this.userCenterService.checkCompanyTerminalSwitch(r, groupId);
                    boolean terminalCheck = terminalCheckResult == null || "1".equals(terminalCheckResult);
                    String deviceCheckResult = this.userCenterService.checkCompanyDeviceSwitch(r, groupId);
                    boolean bl = deviceCheck = deviceCheckResult == null || "1".equals(deviceCheckResult);
                    if (terminalCheck && deviceCheck) {
                        bothCheckTaxNoList.add(r);
                    } else if (terminalCheck) {
                        terminalCheckTaxNoList.add(r);
                    } else if (deviceCheck) {
                        deviceCheckTaxNoList.add(r);
                    }
                });
            } else {
                bothCheckTaxNoList.addAll(taxNoList);
            }
        }
        taxNoList.removeAll(bothCheckTaxNoList);
        taxNoList.removeAll(terminalCheckTaxNoList);
        taxNoList.removeAll(deviceCheckTaxNoList);
        ArrayList resultList = Lists.newArrayList();
        resultList.addAll(this.queryUserOwnedTerminal(request, (List)bothCheckTaxNoList, userInfo, true, true));
        resultList.addAll(this.queryUserOwnedTerminal(request, (List)terminalCheckTaxNoList, userInfo, true, false));
        resultList.addAll(this.queryUserOwnedTerminal(request, (List)deviceCheckTaxNoList, userInfo, false, true));
        resultList.addAll(this.queryAllTerminal(request, taxNoList));
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            MsQueryTerminalResponse response2 = new MsQueryTerminalResponse();
            response2.setCode(Integer.valueOf(0));
            response2.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230\u7ec8\u7aef\u5217\u8868");
            return response2;
        }
        if (!this.configTerminalProperties.getTerminalDeviceInfoSwitch().booleanValue()) {
            this.configTerminalService.setDeviceInfo((List)resultList);
        }
        this.configTerminalService.sortTerminal((List)resultList, 3);
        MsQueryTerminalResponse response3 = new MsQueryTerminalResponse();
        response3.setCode(Integer.valueOf(1));
        response3.setMessage("\u83b7\u53d6\u6210\u529f");
        MsTerminalQueryResult result = new MsTerminalQueryResult();
        result.setTerminals((List)resultList);
        response3.setResult(result);
        return response3;
    }

    private List<MsTerminalQueryResponseInfo> queryAllTerminal(MsQueryTerminalRequest request, List<String> taxNoList) {
        if (CollectionUtils.isEmpty(taxNoList) && CollectionUtils.isEmpty((Collection)request.getTerminalUns()) && StringUtils.isBlank((CharSequence)request.getTerminalNo())) {
            return Lists.newArrayList();
        }
        QueryTerminalRequest restRequest = this.buildRestRequest(request, taxNoList);
        QueryTerminalResponse restResponse = this.deviceApiProxy.deviceTerminalQueryPost(restRequest, null);
        log.info("\u7a0e\u4ef6\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\u4e3a\uff1a{}", (Object)JsonUtils.toJson((Object)restResponse));
        ArrayList resultList = Lists.newArrayList();
        if (Objects.nonNull(restResponse) && "1".equals(restResponse.getCode())) {
            List resourceTerminals = restResponse.getResult().getTerminals();
            List invoiceTypeList = request.getInvoiceType();
            List terminalList = resourceTerminals.stream().filter(terminal -> this.configTerminalServiceImplKt.terminalFilterInvoiceType(terminal, invoiceTypeList)).map(arg_0 -> ((ConfigTerminalServiceImplKt)this.configTerminalServiceImplKt).addTerminals(arg_0)).collect(Collectors.toList());
            resultList.addAll(terminalList);
        }
        return resultList;
    }

    private List<MsTerminalQueryResponseInfo> queryUserOwnedTerminal(MsQueryTerminalRequest request, List<String> taxNoList, UserInfo userInfo, boolean terminalCheck, boolean deviceCheck) {
        long userId;
        if (CollectionUtils.isEmpty(taxNoList)) {
            return Lists.newArrayList();
        }
        long groupId = userInfo.getGroupId();
        UserCenterResponse userResponse = this.userCenterUserService.getUserByUserId(groupId, userId = userInfo.getUserId(), userInfo.getModules());
        if (Objects.isNull(userResponse.getResult())) {
            log.warn("\u8fd0\u8425\u5e73\u53f0\u8fd4\u56de\u7684\u7ec8\u7aef\u5217\u8868\u7ed3\u679c\u4e3a\u7a7a");
            return Lists.newArrayList();
        }
        UserData userResult = (UserData)userResponse.getResult();
        String terminalIdListStr = userResult.getTicketOpeningTerminal();
        String deviceIdListStr = Optional.ofNullable(userResult.getPrintingEquipment()).orElse("");
        log.info("\u8fd0\u8425\u5e73\u53f0\u8fd4\u56de\u7684\u7ec8\u7aef\u5217\u8868\u7ed3\u679c\u4e3a\uff1aterminalIds\uff1a{}\uff0cdeviceIds\uff1a{}", (Object)terminalIdListStr, (Object)deviceIdListStr);
        if (StringUtils.isBlank((CharSequence)terminalIdListStr) && terminalCheck) {
            return Lists.newArrayList();
        }
        boolean usingDeviceIdFlag = true;
        if (terminalCheck) {
            Optional<String> firstTerminalId = Arrays.stream(terminalIdListStr.split(",")).findFirst();
            if (!firstTerminalId.isPresent()) {
                return Lists.newArrayList();
            }
            usingDeviceIdFlag = NumberUtils.isCreatable((String)firstTerminalId.get());
        } else if (deviceCheck) {
            Optional<String> firstDeviceId = Arrays.stream(deviceIdListStr.split(",")).findFirst();
            if (!firstDeviceId.isPresent()) {
                return Lists.newArrayList();
            }
            usingDeviceIdFlag = NumberUtils.isCreatable((String)firstDeviceId.get());
        }
        log.info("\u4f7f\u7528deviceId\u6807\u5fd7: {}", (Object)usingDeviceIdFlag);
        QueryTerminalRequest restRequest = this.buildRestRequest(request, taxNoList);
        TerminalQueryInfo terminalQueryInfo = restRequest.getTerminalInfo();
        if (terminalCheck) {
            if (usingDeviceIdFlag) {
                List terminalIds = Lists.newArrayList((Object[])StringUtils.split((String)terminalIdListStr, (String)",")).stream().map(Long::parseLong).collect(Collectors.toList());
                terminalQueryInfo.setTerminalIds(terminalIds);
            } else {
                ArrayList terminalUns = Lists.newArrayList((Object[])StringUtils.split((String)terminalIdListStr, (String)","));
                if (CollectionUtils.isNotEmpty((Collection)request.getTerminalUns())) {
                    terminalUns = Lists.newArrayList((Iterable)CollectionUtils.intersection((Iterable)terminalUns, (Iterable)request.getTerminalUns()));
                }
                terminalQueryInfo.setTerminalUns((List)terminalUns);
            }
        }
        QueryTerminalResponse restResponse = this.deviceApiProxy.deviceTerminalQueryPost(restRequest, null);
        log.info("\u7a0e\u4ef6\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\u4e3a\uff1a{}", (Object)JsonUtils.toJson((Object)restResponse));
        ArrayList resultList = Lists.newArrayList();
        if (Objects.nonNull(restResponse) && "1".equals(restResponse.getCode())) {
            List invoiceTypeList = request.getInvoiceType();
            List resourceTerminals = restResponse.getResult().getTerminals();
            if (deviceCheck) {
                if (usingDeviceIdFlag) {
                    resultList.addAll(this.configTerminalServiceImplKt.checkResult(deviceIdListStr, resourceTerminals, Long::parseLong, TerminalQueryResponseInfo::getDeviceId, invoiceTypeList));
                } else {
                    resultList.addAll(this.configTerminalServiceImplKt.checkResult(deviceIdListStr, resourceTerminals, r -> r, r -> Optional.ofNullable(r.getOnlineDevice()).map(OnlineDeviceInfo::getDeviceUn).orElse(r.getDeviceUn()), invoiceTypeList));
                }
            } else {
                List terminalList = resourceTerminals.stream().filter(terminal -> this.configTerminalServiceImplKt.terminalFilterInvoiceType(terminal, invoiceTypeList)).map(arg_0 -> ((ConfigTerminalServiceImplKt)this.configTerminalServiceImplKt).addTerminals(arg_0)).collect(Collectors.toList());
                resultList.addAll(terminalList);
            }
        }
        return resultList;
    }

    private QueryTerminalRequest buildRestRequest(MsQueryTerminalRequest request, List<String> taxNoList) {
        MsQueryTerminalRequest copyRequest = this.deviceConverter.copy(request);
        copyRequest.setTaxNo(null);
        copyRequest.setTaxNos(taxNoList);
        if (CollectionUtils.isEmpty((Collection)copyRequest.getSupportService())) {
            copyRequest.setSupportService((List)Lists.newArrayList((Object[])new String[]{"print", "make", "assistant"}));
        }
        TerminalQueryInfo terminalQueryInfo = this.deviceConverter.convert(copyRequest);
        QueryTerminalRequest restRequest = new QueryTerminalRequest();
        restRequest.setTerminalInfo(terminalQueryInfo);
        restRequest.setQueryInventory(Optional.ofNullable(copyRequest.getQueryInventory()).orElse(false));
        restRequest.setQueryServiceState(Optional.ofNullable(copyRequest.getQueryOnline()).orElse(false));
        restRequest.setPageInfo(this.initPageInfo(DEFAULT_PAGE_NO, DEFAULT_PAGE_SIZE));
        return restRequest;
    }

    private PageInfo initPageInfo(Integer pageNo, Integer total) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageNo(pageNo);
        pageInfo.setPageSize(total);
        return pageInfo;
    }

    public Either<String, List<QueryInventoryResult>> queryInventory(QueryInventoryRequest request) {
        log.info("queryInventory request:{}", (Object)JsonUtils.toJson((Object)request));
        Map deviceTypeMap = this.queryInventoryPreDeal(request);
        if (MapUtils.isEmpty((Map)deviceTypeMap)) {
            return Either.left((Object)AssertUtil.formatMsg((String)ErrorCodeEnum.SYSTEM1005.getDescription(), (Object[])new Object[]{"\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a"}));
        }
        ArrayList inventoryList = Lists.newArrayList();
        for (Map.Entry entry : deviceTypeMap.entrySet()) {
            DeviceType deviceType = (DeviceType)entry.getKey();
            request.setDeviceType((String)deviceType.getValue());
            List deviceList = (List)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)request.getTaxNoList())) {
                request.setTaxNoList(deviceList.stream().map(r -> Optional.ofNullable(r.getCompanyInfo()).map(RestCompanyInfo::getTaxNo).orElse(null)).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
            }
            if (CollectionUtils.isEmpty((Collection)request.getDeviceNoList()) || request.getDeviceNoList().stream().noneMatch(StringUtils::isNotBlank)) {
                request.setDeviceNoList(deviceList.stream().map(RestDeviceInfo::getDeviceNo).filter(StringUtils::isNotBlank).collect(Collectors.toList()));
            }
            if (CollectionUtils.isEmpty((Collection)request.getTaxNoList())) {
                return Either.left((Object)AssertUtil.formatMsg((String)ErrorCodeEnum.SYSTEM1005.getDescription(), (Object[])new Object[]{"taxNoList\u4e0d\u80fd\u4e3a\u7a7a"}));
            }
            request.setDeviceType(deviceType.getType());
            if (DeviceType.SERVER == deviceType && CollectionUtils.isEmpty((Collection)request.getInvoiceTypeList())) {
                request.setInvoiceTypeList((List)Lists.newArrayList((Object[])new String[]{InvoiceType.NORMAL.value(), InvoiceType.ELECTRONIC.value(), InvoiceType.SPECIAL.value(), InvoiceType.SPECIAL_ELECTRONIC.value(), InvoiceType.NORMAL_ROLL.value(), InvoiceType.VEHICLE.value()}));
            }
            RestQueryInventoryRequest restRequest = this.taxWareConverter.convert(request);
            inventoryList.addAll(this.deviceApiProxy.queryInventory(restRequest));
        }
        return Either.right(inventoryList.stream().map(r -> {
            if (CollectionUtils.isNotEmpty((Collection)r.getDeviceInventoryList())) {
                return r.getDeviceInventoryList().stream().map(t -> Tuple.of((Object)t.getDeviceNo(), (Object)r.getTaxCode(), (Object)r.getInvoiceType(), (Object)t.getQuantity())).collect(Collectors.toList());
            }
            return Lists.newArrayList();
        }).flatMap(Collection::stream).collect(Collectors.groupingBy(r -> Tuple.of((Object)r._1(), (Object)r._2()), Collectors.mapping(r -> new InvoiceTypeInventoryData((String)r._3(), (Integer)r._4()), Collectors.toList()))).entrySet().stream().map(r -> {
            Tuple2 key = (Tuple2)r.getKey();
            List value = (List)r.getValue();
            Integer totalQuantity = value.stream().mapToInt(t -> Optional.ofNullable(t.getQuantity()).orElse(0)).sum();
            return new QueryInventoryResult((String)key._2(), (String)key._1(), totalQuantity, value);
        }).collect(Collectors.toList()));
    }

    private Map<DeviceType, List<RestDeviceInfo>> queryInventoryPreDeal(QueryInventoryRequest request) {
        Optional deviceTypeOptional = ValueEnum.getEnumByValue(DeviceType.class, (Object)request.getDeviceType());
        ArrayList deviceList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)request.getDeviceNoList()) && request.getDeviceNoList().stream().anyMatch(StringUtils::isNotBlank)) {
            if (CollectionUtils.isEmpty((Collection)request.getTaxNoList()) || !deviceTypeOptional.isPresent()) {
                deviceList.addAll(this.getDeviceListByDeviceNoList(request.getDeviceNoList()));
            }
        } else if (CollectionUtils.isNotEmpty((Collection)request.getDeviceUnList()) && request.getDeviceUnList().stream().anyMatch(StringUtils::isNotBlank)) {
            deviceList.addAll(this.getDeviceListByDeviceUnList(request.getDeviceUnList()));
        }
        Map<Object, Object> deviceTypeTaxNoMap = Maps.newHashMap();
        if (deviceTypeOptional.isPresent()) {
            deviceTypeTaxNoMap.put(deviceTypeOptional.get(), deviceList);
        } else {
            deviceTypeTaxNoMap = deviceList.stream().collect(Collectors.groupingBy(r -> Optional.ofNullable(r.getTaxDeviceInfo()).map(RestTaxDeviceInfo::getTaxDeviceType).filter(t -> ((Integer)TaxDeviceType.BAI_WANG_SERVER.getValue()).equals(t) || ((Integer)TaxDeviceType.HANG_XIN_SERVER.getValue()).equals(t)).map(t -> DeviceType.SERVER).orElse(DeviceType.PLATE)));
        }
        return deviceTypeTaxNoMap;
    }

    private List<RestDeviceInfo> getDeviceListByDeviceUnList(List<String> deviceUnList) {
        RestDeviceQueryInfo queryInfo = new RestDeviceQueryInfo();
        queryInfo.setDeviceUns(deviceUnList);
        return this.getDeviceListByQueryInfo(queryInfo);
    }

    private List<RestDeviceInfo> getDeviceListByDeviceNoList(List<String> deviceNoList) {
        return deviceNoList.parallelStream().map(deviceNo -> {
            RestDeviceQueryInfo queryInfo = new RestDeviceQueryInfo();
            queryInfo.setDeviceNo(deviceNo);
            return this.getDeviceListByQueryInfo(queryInfo);
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<RestDeviceInfo> getDeviceListByQueryInfo(RestDeviceQueryInfo queryInfo) {
        RestQueryDeviceRequest restRequest = new RestQueryDeviceRequest();
        restRequest.setQueryServiceState(Boolean.valueOf(false));
        restRequest.setQueryOriginAccountServiceState(Boolean.valueOf(false));
        restRequest.setPageInfo(this.initPageInfo(DEFAULT_PAGE_NO, DEFAULT_PAGE_SIZE));
        restRequest.setQueryInfo(queryInfo);
        RestQueryDeviceResponse restResponse = this.deviceApiProxy.deviceQueryPost(restRequest);
        if ("1".equals(restResponse.getCode())) {
            return Optional.ofNullable(restResponse.getResult()).map(RestGetDeviceResult::getDevices).orElse(Lists.newArrayList());
        }
        return Lists.newArrayList();
    }

    public RestQueryDeviceResponse getDeviceListByQueryInfo(List<String> deviceUnList, boolean exclusiveOnlineState) {
        RestDeviceQueryInfo queryInfo = new RestDeviceQueryInfo();
        queryInfo.setDeviceUns(deviceUnList);
        RestQueryDeviceRequest restRequest = new RestQueryDeviceRequest();
        if (exclusiveOnlineState) {
            restRequest.setQueryServiceState(Boolean.valueOf(false));
            restRequest.setQueryOriginAccountServiceState(Boolean.valueOf(false));
        }
        restRequest.setPageInfo(this.initPageInfo(DEFAULT_PAGE_NO, DEFAULT_PAGE_SIZE));
        restRequest.setQueryInfo(queryInfo);
        return this.deviceApiProxy.deviceQueryPost(restRequest);
    }

    public Either<String, AllElectricQualificationData> queryAllElectricQualification(Long sellerGroupId, List<String> taxNoList) {
        if (CollectionUtils.isEmpty(taxNoList)) {
            return Either.left((Object)"\u67e5\u8be2\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String subUrl = "/api/device/taxware/{tenantId}/invoice/v1/all-electric/qualifications/{sellerTaxNo}";
        Map map = Sets.newHashSet(taxNoList).parallelStream().filter(StringUtils::isNotBlank).map(taxNo -> {
            RestResponse response2 = this.restTemplateTools.getFromTaxWare(subUrl, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{sellerGroupId, taxNo});
            if ("1".equals(response2.getCode()) && Optional.ofNullable(response2.getResult()).filter(r -> Boolean.TRUE.equals(r.getAllElectricFlag())).isPresent()) {
                return Tuple.of((Object)true, (Object)taxNo);
            }
            return Tuple.of((Object)false, (Object)taxNo);
        }).collect(Collectors.groupingBy(Tuple2::_1, Collectors.mapping(Tuple2::_2, Collectors.toList())));
        return Either.right((Object)new AllElectricQualificationData((List)map.getOrDefault(true, Lists.newArrayList()), (List)map.getOrDefault(false, Lists.newArrayList())));
    }

    public Either<String, AllElectricIssuerInfoData> queryAllElectricIssuerInfo(Long sellerGroupId, String taxNo, List<String> issuerList) {
        RestResponse response2;
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return Either.left((Object)"\u67e5\u8be2\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String subUrl = "/api/device/taxware/{tenantId}/invoice/v1/all-electric/issuers?taxNo={taxNo}";
        if (CollectionUtils.isNotEmpty(issuerList)) {
            subUrl = subUrl + "&issuers={issuers}";
            response2 = this.restTemplateTools.getFromTaxWare(subUrl, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{sellerGroupId, taxNo, StringUtils.join(issuerList, (String)",")});
        } else {
            response2 = this.restTemplateTools.getFromTaxWare(subUrl, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{sellerGroupId, taxNo});
        }
        if ("1".equals(response2.getCode()) && Optional.ofNullable(response2.getResult()).isPresent()) {
            return Either.right((Object)response2.getResult());
        }
        return Either.left((Object)response2.getMessage());
    }

    public Either<String, List<AllElectricIssuerInfoData>> queryAllElectricIssuerInfo(Long sellerGroupId, List<String> taxNoList, String issuer) {
        ArrayList allElectricIssuerInfoDataList = Lists.newArrayList();
        List<String> issuerList = StringUtils.isNotBlank((CharSequence)issuer) ? Collections.singletonList(issuer) : null;
        taxNoList.forEach(r -> {
            Either eitherResult = this.queryAllElectricIssuerInfo(sellerGroupId, r, issuerList);
            if (eitherResult.isRight() && Objects.nonNull(eitherResult.get())) {
                allElectricIssuerInfoDataList.add(eitherResult.get());
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)allElectricIssuerInfoDataList)) {
            return Either.right((Object)allElectricIssuerInfoDataList);
        }
        return Either.left((Object)"\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a.");
    }

    public Either<String, List<AllElectricIssuerInfoRecord>> queryAllElectricIssuerInfoList(AllElectricIssuerRequest issuerRequest) {
        Either eitherResult;
        Either eitherGetAndCheckResult = this.getAndCheckTaxNoList(issuerRequest);
        if (eitherGetAndCheckResult.isLeft()) {
            return Either.left((Object)eitherGetAndCheckResult.getLeft());
        }
        ArrayList searchTaxNoList = (ArrayList)((Tuple3)eitherGetAndCheckResult.get())._1;
        AllElectricIssuerOnLineEnum allElectricIssuerOnLineEnum = (AllElectricIssuerOnLineEnum)((Tuple3)eitherGetAndCheckResult.get())._2;
        Map taxNoToNameMap = (Map)((Tuple3)eitherGetAndCheckResult.get())._3;
        if (searchTaxNoList.size() > 15) {
            return Either.left((Object)"\u8d26\u53f7\u5173\u8054\u7684\u7a0e\u53f7\u8f83\u591a\uff0c\u8bf7\u5148\u9009\u62e9\u9500\u65b9\u516c\u53f8\u518d\u67e5\u8be2");
        }
        try {
            eitherResult = this.queryAllElectricIssuerInfo(Long.valueOf(((UserInfo)this.userInfoHolder.get()).getGroupId()), (List)searchTaxNoList, issuerRequest.getIssuer());
        }
        catch (Exception e) {
            log.error("queryAllElectricIssuerInfoList invoke taxNoList {}", (Object)JsonUtils.toJson((Object)searchTaxNoList), (Object)e);
            return Either.left((Object)("\u7a0e\u53f7[" + JsonUtils.toJson((Object)searchTaxNoList) + "]\u5f00\u7968\u4eba\u4fe1\u606f\u67e5\u8be2\u5931\u8d25"));
        }
        if (eitherResult.isLeft()) {
            return Either.left((Object)eitherResult.getLeft());
        }
        ArrayList recordList = Lists.newArrayList();
        List allElectricIssuerInfoDataList = (List)eitherResult.get();
        if (CollectionUtils.isNotEmpty((Collection)allElectricIssuerInfoDataList)) {
            boolean filterFlag = AllElectricIssuerOnLineEnum.ALL != allElectricIssuerOnLineEnum;
            allElectricIssuerInfoDataList.forEach(r -> {
                List<AllElectricIssuerInfo> filteredIssuerList = r.getIssuers();
                if (filterFlag) {
                    filteredIssuerList = filteredIssuerList.stream().filter(u -> u.getOnlineFlag() == (allElectricIssuerOnLineEnum == AllElectricIssuerOnLineEnum.ON_LINE)).collect(Collectors.toList());
                }
                if (StringUtils.isNotBlank((CharSequence)issuerRequest.getIssuer())) {
                    filteredIssuerList = filteredIssuerList.stream().filter(u -> StringUtils.equals((CharSequence)u.getIssuer(), (CharSequence)issuerRequest.getIssuer())).collect(Collectors.toList());
                }
                filteredIssuerList.forEach(u -> recordList.add(this.toAllElectricIssuerInfoRecord(u.getIssuer(), u.getIssueType(), r.getTaxNo(), taxNoToNameMap.getOrDefault(r.getTaxNo(), ""), u.getOnlineFlag().booleanValue(), Long.valueOf(((UserInfo)this.userInfoHolder.get()).getGroupId()))));
            });
        }
        return Either.right((Object)recordList);
    }

    public Either<String, AllElectricIssuerInfoResult> queryElectricIssuerInfoByPage(AllElectricIssuerRequest issuerRequest) {
        Either eitherIssuerResult;
        Either eitherGetAndCheckResult = this.getAndCheckTaxNoList(issuerRequest);
        if (eitherGetAndCheckResult.isLeft()) {
            return Either.left((Object)eitherGetAndCheckResult.getLeft());
        }
        ArrayList allTaxNoList = (ArrayList)((Tuple3)eitherGetAndCheckResult.get())._1;
        AllElectricIssuerOnLineEnum allElectricIssuerOnLineEnum = (AllElectricIssuerOnLineEnum)((Tuple3)eitherGetAndCheckResult.get())._2;
        Map taxNoToNameMap = (Map)((Tuple3)eitherGetAndCheckResult.get())._3;
        if (this.configTerminalProperties.getUsingTaxwareQualificationFilterFunc().booleanValue()) {
            Either eitherResult = this.batchQueryAllElectricQualification(Long.valueOf(((UserInfo)this.userInfoHolder.get()).getGroupId()), (List)allTaxNoList);
            if (eitherResult.isLeft()) {
                return Either.left((Object)eitherResult.getLeft());
            }
            List hasQualificationTaxNoList = (List)eitherResult.get();
            if (CollectionUtils.isEmpty((Collection)hasQualificationTaxNoList)) {
                return Either.left((Object)"\u6ca1\u627e\u5230\u5f00\u5177\u8d44\u8d28\u7684\u7a0e\u53f7");
            }
            allTaxNoList = Lists.newArrayList((Iterable)hasQualificationTaxNoList);
        }
        Collections.sort(allTaxNoList);
        int pageSize = 20;
        if (null != issuerRequest.getPageSize() && issuerRequest.getPageSize() > 0 && issuerRequest.getPageSize() <= 100) {
            pageSize = issuerRequest.getPageSize();
        }
        int pageIndex = 1;
        if (null != issuerRequest.getPageIndex() && issuerRequest.getPageIndex() > 0) {
            pageIndex = issuerRequest.getPageIndex();
        }
        Tuple2 tupleResult = this.partition((List)allTaxNoList, pageSize, pageIndex - 1);
        List searchTaxNoList = (List)tupleResult._2;
        int totalPages = (Integer)tupleResult._1;
        try {
            eitherIssuerResult = this.queryAllElectricIssuerInfo(Long.valueOf(((UserInfo)this.userInfoHolder.get()).getGroupId()), searchTaxNoList, issuerRequest.getIssuer());
        }
        catch (Exception e) {
            log.error("queryAllElectricIssuerInfoList invoke taxNoList {}", (Object)JsonUtils.toJson((Object)searchTaxNoList), (Object)e);
            return Either.left((Object)("\u7a0e\u53f7[" + JsonUtils.toJson((Object)searchTaxNoList) + "]\u5f00\u7968\u4eba\u4fe1\u606f\u67e5\u8be2\u5931\u8d25"));
        }
        if (eitherIssuerResult.isLeft()) {
            return Either.left((Object)eitherIssuerResult.getLeft());
        }
        ArrayList recordList = Lists.newArrayList();
        List allElectricIssuerInfoDataList = (List)eitherIssuerResult.get();
        if (CollectionUtils.isNotEmpty((Collection)allElectricIssuerInfoDataList)) {
            boolean filterFlag = AllElectricIssuerOnLineEnum.ALL != allElectricIssuerOnLineEnum;
            allElectricIssuerInfoDataList.forEach(r -> {
                List<AllElectricIssuerInfo> filteredIssuerList = r.getIssuers();
                if (filterFlag) {
                    filteredIssuerList = filteredIssuerList.stream().filter(u -> u.getOnlineFlag() == (allElectricIssuerOnLineEnum == AllElectricIssuerOnLineEnum.ON_LINE)).collect(Collectors.toList());
                }
                if (StringUtils.isNotBlank((CharSequence)issuerRequest.getIssuer())) {
                    filteredIssuerList = filteredIssuerList.stream().filter(u -> StringUtils.equals((CharSequence)u.getIssuer(), (CharSequence)issuerRequest.getIssuer())).collect(Collectors.toList());
                }
                filteredIssuerList.forEach(u -> recordList.add(this.toAllElectricIssuerInfoRecord(u.getIssuer(), u.getIssueType(), r.getTaxNo(), taxNoToNameMap.getOrDefault(r.getTaxNo(), ""), u.getOnlineFlag().booleanValue(), Long.valueOf(((UserInfo)this.userInfoHolder.get()).getGroupId()))));
            });
        }
        AllElectricIssuerInfoResult infoResult = new AllElectricIssuerInfoResult();
        infoResult.setAllElectricIssuerInfoRecordList((List)recordList);
        infoResult.setTotalPages(totalPages);
        if (pageIndex > totalPages) {
            pageIndex = totalPages;
        }
        infoResult.setPageIndex(pageIndex);
        return Either.right((Object)infoResult);
    }

    private Either<String, AllElectricIssuerOnLineEnum> toAllElectricIssuerOnLineEnum(Integer onLineState) {
        if (null == onLineState) {
            return Either.right((Object)AllElectricIssuerOnLineEnum.ALL);
        }
        Optional issuerOnLineOptional = com.xforceplus.seller.config.client.constant.ValueEnum.getEnumByValue(AllElectricIssuerOnLineEnum.class, (Object)onLineState);
        if (!issuerOnLineOptional.isPresent()) {
            return Either.left((Object)"\u975e\u6cd5\u7684onLineState");
        }
        return Either.right(issuerOnLineOptional.get());
    }

    private Tuple2<Integer, List<String>> partition(List<String> list, int pageSize, int pageNum) {
        List partition = Lists.partition(list, (int)pageSize);
        int pages = partition.size();
        pageNum = pageNum <= 0 ? 0 : Math.min(pageNum, pages - 1);
        return Tuple.of((Object)pages, partition.get(pageNum));
    }

    private Either<String, Tuple3<ArrayList<String>, AllElectricIssuerOnLineEnum, Map<String, String>>> getAndCheckTaxNoList(AllElectricIssuerRequest issuerRequest) {
        Either eitherResult = this.toAllElectricIssuerOnLineEnum(issuerRequest.getOnLineState());
        if (eitherResult.isLeft()) {
            return Either.left((Object)eitherResult.getLeft());
        }
        AllElectricIssuerOnLineEnum allElectricIssuerOnLineEnum = (AllElectricIssuerOnLineEnum)eitherResult.get();
        UserInfo user = (UserInfo)this.userInfoHolder.get();
        if (user == null) {
            return Either.left((Object)"\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u7684\u767b\u5f55\u4fe1\u606f");
        }
        long tenantId = user.getGroupId();
        ArrayList allTaxNoList = Lists.newArrayList();
        HashMap taxNoToNameMap = Maps.newHashMap();
        if (issuerRequest.getNeedPermission().booleanValue()) {
            UserCenterResponse userReply = this.userCenterUserService.getUserByUserId(tenantId, user.getUserId(), user.getModules());
            Optional.ofNullable(userReply.getResult()).map(UserData::getParentCompanies).ifPresent(orgList -> orgList.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getTaxNum()) && StringUtils.isNotBlank((CharSequence)r.getCompanyName()) && null != r.getOrgType() && 0 != r.getOrgType()).forEach(r -> taxNoToNameMap.put(r.getTaxNum(), r.getCompanyName())));
            if (CollectionUtils.isEmpty((Collection)issuerRequest.getTaxNoList()) && MapUtils.isNotEmpty((Map)taxNoToNameMap)) {
                allTaxNoList.addAll(taxNoToNameMap.keySet());
            } else if (CollectionUtils.isNotEmpty((Collection)issuerRequest.getTaxNoList()) && MapUtils.isNotEmpty((Map)taxNoToNameMap)) {
                List filteredList = issuerRequest.getTaxNoList().stream().filter(taxNoToNameMap::containsKey).collect(Collectors.toList());
                if (!filteredList.isEmpty()) {
                    allTaxNoList.addAll(filteredList);
                }
            }
        } else if (CollectionUtils.isNotEmpty((Collection)issuerRequest.getTaxNoList())) {
            allTaxNoList.addAll(issuerRequest.getTaxNoList().stream().distinct().collect(Collectors.toList()));
        }
        if (CollectionUtils.isEmpty((Collection)allTaxNoList)) {
            return Either.left((Object)"\u62e5\u6709\u6743\u9650\u7684\u516c\u53f8\u7a0e\u53f7\u96c6\u5408\u4e3a\u7a7a,\u8bf7\u6388\u6743\u540e\u67e5\u8be2");
        }
        return Either.right((Object)Tuple.of((Object)allTaxNoList, (Object)allElectricIssuerOnLineEnum, (Object)taxNoToNameMap));
    }

    private AllElectricIssuerInfoRecord toAllElectricIssuerInfoRecord(String issuer, String issueType, String taxNo, String companyName, boolean loginState, Long tenantId) {
        AllElectricIssuerInfoRecord allElectricIssuerInfoRecord = new AllElectricIssuerInfoRecord();
        allElectricIssuerInfoRecord.setIssuer(issuer);
        allElectricIssuerInfoRecord.setTaxNo(taxNo);
        allElectricIssuerInfoRecord.setCompanyName(companyName);
        allElectricIssuerInfoRecord.setIssueType(issueType);
        allElectricIssuerInfoRecord.setLoginState(loginState);
        allElectricIssuerInfoRecord.setUniqueKey(allElectricIssuerInfoRecord.convertUniqueKey(tenantId));
        allElectricIssuerInfoRecord.setStatus(Integer.valueOf(0));
        return allElectricIssuerInfoRecord;
    }

    private String convertIssuerUniqueKey(String taxNo, String issuer, String issueType, Long tenantId) {
        return tenantId + "-" + taxNo + "-" + issuer + "-" + issueType;
    }

    public Either<String, CertificateResult> generateCertificatePost(GenerateCertificateRequest request) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{request.getName(), request.getTaxCode(), request.getAddress(), request.getGroupCode()})) {
            return Either.left((Object)"\u8bf7\u6c42\u751f\u6210\u4f01\u4e1a\u8bc1\u4e66\u7684\u516c\u53f8\u540d\u79f0\u3001\u7a0e\u53f7\u3001\u5730\u5740\u3001\u79df\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        }
        GenerateCertificateResponse response2 = this.deviceApiProxy.generateCerificatePost(request);
        if (!"TXWR000000".equals(response2.getCode())) {
            return Either.left((Object)response2.getMessage());
        }
        return Either.right((Object)response2.getResult());
    }

    public Either<String, List<String>> batchQueryAllElectricQualification(Long sellerGroupId, List<String> taxNoList) {
        if (CollectionUtils.isEmpty(taxNoList)) {
            return Either.left((Object)"\u67e5\u8be2\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (sellerGroupId == null) {
            UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
            sellerGroupId = userInfo.getGroupId();
        }
        String subUrl = "/api/device/taxware/" + sellerGroupId + "/invoice/v1/all-electric/qualifications/batch-query";
        BatchQueryQualificatonsRequest batchQueryQualificatonsRequest = new BatchQueryQualificatonsRequest();
        batchQueryQualificatonsRequest.setTaxNoList(taxNoList);
        BatchQueryQualificatonsResponse batchQueryQualificatonsResponse = (BatchQueryQualificatonsResponse)this.restTemplateTools.postEntity((Object)batchQueryQualificatonsRequest, subUrl, BatchQueryQualificatonsResponse.class);
        if (StringUtils.equals((CharSequence)String.valueOf(Response.OK), (CharSequence)batchQueryQualificatonsResponse.getCode()) && null != batchQueryQualificatonsResponse.getResult()) {
            List<Object> filteredTaxNoList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)batchQueryQualificatonsResponse.getResult().getQualifications())) {
                filteredTaxNoList = batchQueryQualificatonsResponse.getResult().getQualifications().stream().map(BatchQueryQualificatonsResponse.QualificationInfo::getTaxNo).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            }
            return Either.right((Object)filteredTaxNoList);
        }
        return Either.left((Object)batchQueryQualificatonsResponse.getMessage());
    }

    public Either<String, String> addElectricIssuerInfo(ConfigAddElectricIssuerInfoRequest request) {
        Either eitherIssuerResult;
        Either eitherResult;
        UserInfo user = (UserInfo)this.userInfoHolder.get();
        if (user == null) {
            return Either.left((Object)"\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u7684\u767b\u5f55\u4fe1\u606f");
        }
        long tenantId = user.getGroupId();
        String errorMsg = this.checkElectricIssuerParam(request, "add", Long.valueOf(tenantId));
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return Either.left((Object)errorMsg);
        }
        if (this.configTerminalProperties.getUsingTaxwareQualificationFilterFunc().booleanValue()) {
            eitherResult = this.batchQueryAllElectricQualification(Long.valueOf(tenantId), (List)Lists.newArrayList((Object[])new String[]{request.getTaxNo()}));
            if (eitherResult.isLeft()) {
                return Either.left((Object)eitherResult.getLeft());
            }
            List hasQualificationTaxNoList = (List)eitherResult.get();
            if (CollectionUtils.isEmpty((Collection)hasQualificationTaxNoList)) {
                return Either.left((Object)"\u7a0e\u53f7\u6ca1\u6709\u5168\u7535\u5f00\u5177\u8d44\u8d28");
            }
        }
        try {
            eitherResult = this.queryAllElectricIssuerInfo(Long.valueOf(tenantId), request.getTaxNo(), (List)Lists.newArrayList((Object[])new String[]{request.getIssuer()}));
        }
        catch (Exception e) {
            log.error("addElectricIssuerInfo\u2014queryAllElectricIssuerInfo Exception taxNo:{},issuer:{}", new Object[]{request.getTaxNo(), request.getIssuer(), e});
            return Either.left((Object)"\u65b0\u589e\u5f00\u7968\u4eba\u5931\u8d25");
        }
        if (eitherResult.isLeft()) {
            return Either.left((Object)eitherResult.getLeft());
        }
        if (eitherResult.isRight() && Objects.nonNull(eitherResult.get()) && CollectionUtils.isNotEmpty((Collection)((AllElectricIssuerInfoData)eitherResult.get()).getIssuers())) {
            List filteredIssuerList = ((AllElectricIssuerInfoData)eitherResult.get()).getIssuers();
            if (CollectionUtils.isNotEmpty(filteredIssuerList = filteredIssuerList.stream().filter(u -> StringUtils.equals((CharSequence)u.getIssuer(), (CharSequence)request.getIssuer()) && StringUtils.equals((CharSequence)u.getIssueType(), (CharSequence)request.getIssueType())).collect(Collectors.toList()))) {
                return Either.left((Object)"\u6570\u7535\u5f00\u7968\u4eba\u5df2\u5b58\u5728\uff01");
            }
        }
        ConfigAllElectricIssuerInfoRequest restRequest = this.taxWareConverter.convert(request, StringUtils.isBlank((CharSequence)user.getUserName()) ? String.valueOf(user.getUserId()) : user.getUserName());
        try {
            eitherIssuerResult = this.addOrUpdateAllElectricIssuerInfo(Long.valueOf(tenantId), restRequest);
        }
        catch (Exception e) {
            log.error("addElectricIssuerInfoException request{}", (Object)JsonUtils.toJson((Object)restRequest), (Object)e);
            return Either.left((Object)"\u5f00\u7968\u4eba\u4fe1\u606f\u65b0\u589e\u5931\u8d25");
        }
        if (eitherIssuerResult.isLeft()) {
            return Either.left((Object)eitherIssuerResult.getLeft());
        }
        this.insertCfgAllElectricIssuerRecord(request, user, CfgAllElectricIssuerOperateTypeEnum.ADD.getType());
        return Either.right((Object)"\u65b0\u589e\u5f00\u7968\u4eba\u6210\u529f");
    }

    private String checkElectricIssuerParam(ConfigAddElectricIssuerInfoRequest request, String type, Long tenantId) {
        if (Objects.isNull(tenantId)) {
            return "\u79df\u6237ID\u4e0d\u53ef\u4e3a\u7a7a";
        }
        if (Objects.isNull(request)) {
            return "\u8bf7\u6c42\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)request.getCompanyName()) || StringUtils.isBlank((CharSequence)request.getTaxNo())) {
            return "\u9500\u65b9\u516c\u53f8\u540d\u79f0\u6216\u7a0e\u53f7\u4e0d\u53ef\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)request.getIssuer())) {
            return "\u5f00\u7968\u4eba\u4e0d\u53ef\u4e3a\u7a7a";
        }
        if (CommonTools.getStringCharLength((String)request.getIssuer()) > 100) {
            return "\u5f00\u7968\u4eba\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100\u4e2a\u5b57\u7b26";
        }
        if (StringUtils.isBlank((CharSequence)request.getIssueType())) {
            return "\u5168\u7535\u5f00\u7968\u65b9\u5f0f\u4e0d\u53ef\u4e3a\u7a7a";
        }
        Optional issuerOnLineOptional = com.xforceplus.seller.config.client.constant.ValueEnum.getEnumByValue(AllElectricIssuerIssueTypeEnum.class, (Object)request.getIssueType());
        if (!issuerOnLineOptional.isPresent()) {
            return "\u975e\u6cd5\u7684\u5168\u7535\u5f00\u7968\u65b9\u5f0f";
        }
        if ("update".equals(type) && StringUtils.isBlank((CharSequence)request.getUniqueKey())) {
            return "\u552f\u4e00\u6807\u8bc6\u4e0d\u53ef\u4e3a\u7a7a";
        }
        if ("add".equals(type)) {
            request.setUniqueKey(this.convertIssuerUniqueKey(request.getTaxNo(), request.getIssuer(), request.getIssueType(), tenantId));
        }
        return "";
    }

    public Either<String, String> addOrUpdateAllElectricIssuerInfo(Long tenantId, ConfigAllElectricIssuerInfoRequest request) {
        if (Objects.isNull(request)) {
            return Either.left((Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String subUrl = "/api/device/taxware/" + tenantId + "/invoice/v1/all-electric/issuers";
        CommonResponse response2 = this.restTemplateTools.postEntity((Object)request, subUrl, CommonResponse.class);
        if ("1".equals(response2.getCode())) {
            return Either.right((Object)response2.getMessage());
        }
        return Either.left((Object)response2.getMessage());
    }

    private void insertCfgAllElectricIssuerRecord(ConfigAddElectricIssuerInfoRequest request, UserInfo user, int operateType) {
        CfgAllElectricIssuerRecordEntity entity = new CfgAllElectricIssuerRecordEntity();
        entity.setId(Long.valueOf(this.idGenerator.nextId()));
        entity.setUniqueKey(request.getUniqueKey());
        entity.setSellerGroupId(Long.valueOf(user.getGroupId()));
        entity.setCompanyName(request.getCompanyName());
        entity.setCompanyTaxNo(request.getTaxNo());
        entity.setIssuer(request.getIssuer());
        entity.setIssueType(request.getIssueType());
        entity.setOperateType(Integer.valueOf(operateType));
        entity.setOperator(user.getUserName());
        entity.setOperatorId(Long.valueOf(user.getUserId()));
        entity.setOperateTime(new Date());
        this.cfgAllElectricIssuerRecordDao.insert(entity);
    }

    public Either<String, String> updateElectricIssuerInfo(ConfigAddElectricIssuerInfoRequest request) {
        Either eitherIssuerResult;
        UserInfo user = (UserInfo)this.userInfoHolder.get();
        if (user == null) {
            return Either.left((Object)"\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u7684\u767b\u5f55\u4fe1\u606f");
        }
        long tenantId = user.getGroupId();
        String errorMsg = this.checkElectricIssuerParam(request, "update", Long.valueOf(tenantId));
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return Either.left((Object)errorMsg);
        }
        ConfigAllElectricIssuerInfoRequest restRequest = this.taxWareConverter.convert(request, StringUtils.isBlank((CharSequence)user.getUserName()) ? String.valueOf(user.getUserId()) : user.getUserName());
        try {
            eitherIssuerResult = this.addOrUpdateAllElectricIssuerInfo(Long.valueOf(tenantId), restRequest);
        }
        catch (Exception e) {
            log.error("updateElectricIssuerInfoException request{}", (Object)JsonUtils.toJson((Object)restRequest), (Object)e);
            return Either.left((Object)"\u5f00\u7968\u4eba\u4fe1\u606f\u4fee\u6539\u5931\u8d25");
        }
        if (eitherIssuerResult.isLeft()) {
            return Either.left((Object)eitherIssuerResult.getLeft());
        }
        this.insertCfgAllElectricIssuerRecord(request, user, CfgAllElectricIssuerOperateTypeEnum.UPDATE.getType());
        return Either.right((Object)"\u65b0\u589e\u5f00\u7968\u4eba\u6210\u529f");
    }

    public Either<String, String> deleteElectricIssuerInfoList(ConfigDeleteElectricIssuerInfoRequest request) {
        List failList;
        Tuple2 tuple2;
        String errorMsg = this.checkDeleteElectricIssuerParam(request);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return Either.left((Object)errorMsg);
        }
        UserInfo user = (UserInfo)this.userInfoHolder.get();
        if (user == null) {
            return Either.left((Object)"\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u7684\u767b\u5f55\u4fe1\u606f");
        }
        long tenantId = user.getGroupId();
        try {
            tuple2 = this.deleteElectricIssuerInfo(Long.valueOf(tenantId), request, user);
        }
        catch (Exception e) {
            log.error("deleteElectricIssuerInfoList request{}", (Object)JsonUtils.toJson((Object)request), (Object)e);
            return Either.left((Object)"\u5f00\u7968\u4eba\u4fe1\u606f\u5220\u9664\u5931\u8d25");
        }
        List successList = (List)tuple2._2;
        if (CollectionUtils.isNotEmpty((Collection)successList)) {
            successList.forEach(info -> {
                ConfigAddElectricIssuerInfoRequest r = this.taxWareConverter.convert(info);
                this.insertCfgAllElectricIssuerRecord(r, user, CfgAllElectricIssuerOperateTypeEnum.DELETE.getType());
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(failList = (List)tuple2._1))) {
            return Either.left((Object)StringUtils.join((Iterable)failList, (String)"\uff1b"));
        }
        return Either.right((Object)"\u5220\u9664\u5f00\u7968\u4eba\u6210\u529f");
    }

    private String checkDeleteElectricIssuerParam(ConfigDeleteElectricIssuerInfoRequest request) {
        if (Objects.isNull(request) || CollectionUtils.isEmpty((Collection)request.getList())) {
            return "\u8bf7\u6c42\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a";
        }
        if (request.getList().size() > 50) {
            return "\u5220\u9664\u5f00\u7968\u4eba\u6570\u91cf\u4e0d\u53ef\u8d85\u8fc750";
        }
        for (ConfigDeleteElectricIssuerInfoRequest.ConfigDeleteElectricIssuerInfo info : request.getList()) {
            if (StringUtils.isBlank((CharSequence)info.getCompanyName()) || StringUtils.isBlank((CharSequence)info.getTaxNo())) {
                return "\u9500\u65b9\u516c\u53f8\u540d\u79f0\u6216\u7a0e\u53f7\u4e0d\u53ef\u4e3a\u7a7a\uff08\u5f00\u7968\u4eba\uff1a" + info.getIssuer() + "\uff09";
            }
            if (StringUtils.isBlank((CharSequence)info.getIssuer())) {
                return "\u5f00\u7968\u4eba\u4e0d\u53ef\u4e3a\u7a7a\uff08\u9500\u65b9\u516c\u53f8\uff1a" + info.getCompanyName() + "\uff09";
            }
            if (CommonTools.getStringCharLength((String)info.getIssuer()) > 100) {
                return "\u5f00\u7968\u4eba\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100\u4e2a\u5b57\u7b26\uff08\u9500\u65b9\u516c\u53f8\uff1a" + info.getCompanyName() + "\uff09";
            }
            if (StringUtils.isBlank((CharSequence)info.getIssueType())) {
                return "\u5168\u7535\u5f00\u7968\u65b9\u5f0f\u4e0d\u53ef\u4e3a\u7a7a\uff08\u5f00\u7968\u4eba\uff1a" + info.getIssuer() + "\uff0c\u9500\u65b9\u516c\u53f8\uff1a" + info.getCompanyName() + "\uff09";
            }
            Optional issuerOnLineOptional = com.xforceplus.seller.config.client.constant.ValueEnum.getEnumByValue(AllElectricIssuerIssueTypeEnum.class, (Object)info.getIssueType());
            if (!issuerOnLineOptional.isPresent()) {
                return "\u975e\u6cd5\u7684\u5168\u7535\u5f00\u7968\u65b9\u5f0f\uff08\u5f00\u7968\u4eba\uff1a" + info.getIssuer() + "\uff0c\u9500\u65b9\u516c\u53f8\uff1a" + info.getCompanyName() + "\uff09";
            }
            if (!StringUtils.isBlank((CharSequence)info.getUniqueKey())) continue;
            return "\u552f\u4e00\u6807\u8bc6\u4e0d\u53ef\u4e3a\u7a7a";
        }
        return "";
    }

    public Tuple2<List<String>, List<ConfigDeleteElectricIssuerInfoRequest.ConfigDeleteElectricIssuerInfo>> deleteElectricIssuerInfo(Long tenantId, ConfigDeleteElectricIssuerInfoRequest request, UserInfo user) {
        ArrayList failList = Lists.newArrayList();
        ArrayList successList = Lists.newArrayList();
        request.getList().forEach(r -> {
            String subUrl;
            ConfigAllElectricIssuerInfoRequest restRequest = this.taxWareConverter.convert(r, StringUtils.isBlank((CharSequence)user.getUserName()) ? String.valueOf(user.getUserId()) : user.getUserName());
            CommonResponse response2 = this.restTemplateTools.deleteEntity((Object)restRequest, subUrl = "/api/device/taxware/" + tenantId + "/invoice/v1/all-electric/issuers", CommonResponse.class);
            if ("1".equals(response2.getCode())) {
                successList.add(r);
            } else {
                failList.add(r.getCompanyName() + r.getIssuer() + com.xforceplus.seller.config.client.constant.ValueEnum.getEnumByValue(AllElectricIssuerIssueTypeEnum.class, (Object)r.getIssueType()).get() + "\u5220\u9664\u5931\u8d25\uff08" + response2.getMessage() + ")");
            }
        });
        return Tuple.of((Object)failList, (Object)successList);
    }

    public Either<String, List<CfgAllElectricIssuerRecord>> queryAllElectricIssuerRecord(AllElectricIssuerRecordRequest request) {
        if (Objects.isNull(request) || StringUtils.isBlank((CharSequence)request.getUniqueKey())) {
            return Either.left((Object)"\u8bf7\u6c42\u4fe1\u606f\u4e0d\u53ef\u4e3a\u7a7a");
        }
        UserInfo user = (UserInfo)this.userInfoHolder.get();
        if (user == null) {
            return Either.left((Object)"\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u7684\u767b\u5f55\u4fe1\u606f");
        }
        List list = this.getAllElectricIssuerRecords(Long.valueOf(user.getGroupId()), request.getUniqueKey());
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Either.right((Object)Lists.newArrayList());
        }
        List recordList = this.taxWareConverter.convert(list);
        if (CollectionUtils.isEmpty((Collection)recordList)) {
            return Either.right((Object)Lists.newArrayList());
        }
        return Either.right((Object)recordList);
    }

    private List<CfgAllElectricIssuerRecordEntity> getAllElectricIssuerRecords(Long sellerGroupId, String uniqueKey) {
        CfgAllElectricIssuerRecordExample example = new CfgAllElectricIssuerRecordExample();
        example.setOrderByClause("operate_time desc");
        example.createCriteria().andSellerGroupIdEqualTo(sellerGroupId).andUniqueKeyEqualTo(uniqueKey);
        return this.cfgAllElectricIssuerRecordDao.selectByExample(example);
    }

    public Either<String, AllElectricIssuerInfoResult> queryUserRelationByPage(UserRelationData.UserRelationRequest request) {
        UserInfo user = (UserInfo)this.userInfoHolder.get();
        if (user == null) {
            return Either.left((Object)"\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u7684\u767b\u5f55\u4fe1\u606f");
        }
        if (Objects.isNull(request.getUserId()) || request.getUserId() <= 0L) {
            return Either.left((Object)"\u7528\u6237id\u53c2\u6570\u5fc5\u4f20");
        }
        if (Objects.isNull(request.getRelationType())) {
            return Either.left((Object)"\u7ed1\u5b9a\u7c7b\u578b\u5fc5\u4f20\u30100\u30011\u3011");
        }
        CfgUserIssuerRelationExample queryExample = this.buildQueryExample2(request, Long.valueOf(((UserInfo)this.userInfoHolder.get()).getGroupId()));
        Long total = this.cfgUserIssuerRelationDao.countByExample(queryExample);
        Integer pageIndex = Optional.ofNullable(request.getPageIndex()).orElse(1);
        Integer pageSize = Optional.ofNullable(request.getPageSize()).orElse(20);
        queryExample.setOffset(Integer.valueOf((pageIndex - 1) * pageSize));
        queryExample.setLimit(pageSize);
        List relationList = this.cfgUserIssuerRelationDao.selectByExample(queryExample);
        List allElectricIssuerInfoRecordList = this.taxWareConverter.convertAllElectricIssuerInfoRecordList(relationList);
        AllElectricIssuerInfoResult allElectricIssuerInfoResult = new AllElectricIssuerInfoResult();
        allElectricIssuerInfoResult.setPageIndex(pageIndex.intValue());
        allElectricIssuerInfoResult.setTotalPages(total.intValue() / pageSize + (total % (long)pageSize.intValue() == 0L ? 0 : 1));
        allElectricIssuerInfoResult.setAllElectricIssuerInfoRecordList(allElectricIssuerInfoRecordList);
        return Either.right((Object)allElectricIssuerInfoResult);
    }

    private CfgUserIssuerRelationExample buildQueryExample2(UserRelationData.UserRelationRequest request, Long tenantId) {
        CfgUserIssuerRelationExample queryExample = new CfgUserIssuerRelationExample();
        CfgUserIssuerRelationExample.Criteria criteria = queryExample.createCriteria();
        if (Optional.ofNullable(request.getUserId()).orElse(0L) > 0L) {
            criteria.andUserIdEqualTo(request.getUserId());
        }
        if (Optional.ofNullable(tenantId).orElse(0L) > 0L) {
            criteria.andTenantIdEqualTo(tenantId);
        }
        criteria.andRelationTypeEqualTo(Optional.ofNullable(request.getRelationType()).orElse(0));
        if (CollectionUtils.isNotEmpty((Collection)request.getTaxNoList())) {
            criteria.andTaxNoIn(request.getTaxNoList());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getIssuer())) {
            criteria.andIssuerEqualTo(request.getIssuer());
        }
        criteria.andStatusEqualTo(Integer.valueOf(1));
        return queryExample;
    }

    public Either<String, List<UserRelationData.UserRelationInfo>> queryUserRelationList(UserRelationData.UserRelationRequest request) {
        UserInfo user = (UserInfo)this.userInfoHolder.get();
        if (user == null) {
            return Either.left((Object)"\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u7684\u767b\u5f55\u4fe1\u606f");
        }
        if (Objects.isNull(request.getUserId()) || request.getUserId() <= 0L) {
            return Either.left((Object)"\u7528\u6237id\u53c2\u6570\u5fc5\u4f20");
        }
        if (Objects.isNull(request.getRelationType())) {
            return Either.left((Object)"\u7ed1\u5b9a\u7c7b\u578b\u5fc5\u4f20\u30100\u30011\u3011");
        }
        if (CollectionUtils.isEmpty((Collection)request.getTaxNoList())) {
            return Either.left((Object)"\u83b7\u53d6\u79df\u6237\u4e0b\u7528\u6237\u6240\u5c5e\u7a0e\u53f7\u4e3a\u7a7a");
        }
        CfgUserIssuerRelationExample example = new CfgUserIssuerRelationExample();
        example.createCriteria().andUserIdEqualTo(request.getUserId()).andRelationTypeEqualTo(request.getRelationType()).andTaxNoIn(request.getTaxNoList()).andTenantIdEqualTo(Long.valueOf(user.getGroupId())).andStatusEqualTo(Integer.valueOf(1));
        List relationEntityList = this.cfgUserIssuerRelationDao.selectByExample(example);
        return Either.right((Object)this.taxWareConverter.convertList(relationEntityList));
    }

    public Tuple2<List<UserRelationData.UserRelationInfo>, List<UserRelationData.UserRelationErrorInfo>> groupUserRelationList(List<UserRelationData.UserRelationInfo> userRelationInfoList, Long groupId) {
        ArrayList successList = Lists.newArrayList();
        ArrayList failList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(userRelationInfoList)) {
            return Tuple.of((Object)successList, (Object)failList);
        }
        userRelationInfoList.forEach(r -> {
            Optional checkResult = this.checkUserRelationInfo(r);
            if (checkResult.isPresent()) {
                failList.add(this.taxWareConverter.convertRelationErrorInfo(r, (String)checkResult.get()));
            } else {
                r.setTenantId(groupId);
                r.setMobile(Optional.ofNullable(r.getMobile()).orElse(""));
                r.setEmail(Optional.ofNullable(r.getEmail()).orElse(""));
                successList.add(r);
            }
        });
        return Tuple.of((Object)successList, (Object)failList);
    }

    public Either<String, Tuple2<Integer, Integer>> saveUserRelationList(List<UserRelationData.UserRelationInfo> userInfoRelationList) {
        if (CollectionUtils.isEmpty(userInfoRelationList)) {
            return Either.left((Object)"\u4fdd\u5b58\u5173\u7cfb\u8bb0\u5f55\u4e3a\u7a7a");
        }
        List userIdList = userInfoRelationList.stream().map(UserRelationData.UserRelationInfo::getUserId).distinct().collect(Collectors.toList());
        CfgUserIssuerRelationExample example = new CfgUserIssuerRelationExample();
        example.createCriteria().andUserIdIn(userIdList);
        List relationEntityList = this.cfgUserIssuerRelationDao.selectByExample(example);
        ArrayList updateEntityList = Lists.newArrayList();
        Map<String, Long> relationUniqueKeyMap = relationEntityList.stream().collect(Collectors.toMap(r -> String.format("%s-%s", r.getUserId(), r.getUniqueKey()), BaseEntity::getId, (a, b) -> a));
        for (UserRelationData.UserRelationInfo r2 : userInfoRelationList) {
            Long id = relationUniqueKeyMap.getOrDefault(String.format("%s-%s", r2.getUserId(), r2.getUniqueKey()), null);
            if (null == id) continue;
            CfgUserIssuerRelationEntity update2 = new CfgUserIssuerRelationEntity();
            update2.setId(id);
            update2.setStatus(Integer.valueOf(r2.getStatus()));
            update2.setUpdateTime(new Date());
            updateEntityList.add(update2);
        }
        List addList = userInfoRelationList.stream().filter(r -> !relationUniqueKeyMap.containsKey(String.format("%s-%s", r.getUserId(), r.getUniqueKey())) && r.getStatus() == 1).collect(Collectors.toList());
        int addRet = 0;
        if (CollectionUtils.isNotEmpty(addList)) {
            List idList = Arrays.stream(this.idGenerator.nextId(addList.size())).boxed().collect(Collectors.toList());
            List addEntityList = this.taxWareConverter.convertRelationEntityList(addList, idList);
            addRet = this.cfgUserIssuerRelationExtDao.batchInsertUserIssuerRelation(addEntityList);
        }
        int updateRet = 0;
        if (CollectionUtils.isNotEmpty((Collection)updateEntityList)) {
            updateRet = this.cfgUserIssuerRelationExtDao.batchUpdateUserIssuerRelation((List)updateEntityList);
        }
        if (addRet + updateRet > 0) {
            return Either.right((Object)Tuple.of((Object)addRet, (Object)updateRet));
        }
        return Either.left((Object)"\u64cd\u4f5c\u5931\u8d25");
    }

    private Optional<String> checkUserRelationInfo(UserRelationData.UserRelationInfo userRelationInfo) {
        if (Objects.isNull(userRelationInfo)) {
            return Optional.of("\u64cd\u4f5c\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (Objects.isNull(userRelationInfo.getRelationType()) || 0 != userRelationInfo.getRelationType()) {
            return Optional.of("relationType \u53c2\u6570\u4f20\u9012\u9519\u8bef");
        }
        if (Objects.isNull(userRelationInfo.getUserId()) || userRelationInfo.getUserId() <= 0L) {
            return Optional.of("userId \u53c2\u6570\u4f20\u9012\u9519\u8bef");
        }
        if (StringUtils.isBlank((CharSequence)userRelationInfo.getTaxNo())) {
            return Optional.of("taxNo \u53c2\u6570\u4f20\u9012\u9519\u8bef");
        }
        if (userRelationInfo.getStatus() > 1 || userRelationInfo.getStatus() < 0) {
            return Optional.of("status \u53c2\u6570\u4f20\u9012\u9519\u8bef");
        }
        if (StringUtils.isBlank((CharSequence)userRelationInfo.getIssuer())) {
            return Optional.of("issuer \u53c2\u6570\u4f20\u9012\u9519\u8bef");
        }
        if (StringUtils.isBlank((CharSequence)userRelationInfo.getCompanyName())) {
            return Optional.of("companyName \u53c2\u6570\u4f20\u9012\u9519\u8bef");
        }
        if (StringUtils.isBlank((CharSequence)userRelationInfo.getUniqueKey())) {
            return Optional.of("uniqueKey \u53c2\u6570\u4f20\u9012\u9519\u8bef");
        }
        String[] arrayStr = StringUtils.split((String)userRelationInfo.getUserName(), (char)'-');
        if (arrayStr.length == 4 && StringUtils.equals((CharSequence)userRelationInfo.getTaxNo(), (CharSequence)arrayStr[1]) && StringUtils.equals((CharSequence)userRelationInfo.getIssuer(), (CharSequence)arrayStr[2])) {
            return Optional.of("uniqueKey \u53c2\u6570\u4f20\u9012\u9519\u8bef");
        }
        return Optional.empty();
    }

    public void importUserRelationList(List<UserRelationData.ImportUserRelationInfo> importUserRelationInfoList, Map<String, Object> headers) {
        try {
            int upateTotal;
            if (CollectionUtils.isEmpty(importUserRelationInfoList)) {
                return;
            }
            Long groupId = Long.valueOf(headers.get("groupId").toString());
            Long importBatchNo = Long.valueOf(headers.get("importBatchNo").toString());
            importUserRelationInfoList.forEach(r -> r.setId(Long.valueOf(this.idGenerator.nextId())));
            List relationInterfaceEntityList = this.userIssuerRelationConverter.convertImportUserIssuerRelationList(importUserRelationInfoList, importBatchNo);
            this.cfgUserIssuerRelationInterfaceExtDao.batchInsertUserIssuerRelationInterfaceList(relationInterfaceEntityList);
            ArrayList checkErrorList = Lists.newArrayList();
            ArrayList userDataRelationInfoList = Lists.newArrayList();
            for (UserRelationData.ImportUserRelationInfo importUserRelationInfo : importUserRelationInfoList) {
                if (Optional.ofNullable(importUserRelationInfo.getRelationType()).orElse(0) == 0 && !StringUtils.equalsAny((CharSequence)importUserRelationInfo.getIssueType(), (CharSequence[])new CharSequence[]{AllElectricIssuerIssueTypeEnum.NS.getValue(), AllElectricIssuerIssueTypeEnum.DPPT.getValue()})) {
                    checkErrorList.add(Tuple.of((Object)String.format("%s-\u6570\u7535\u5f00\u7968\u65b9\u5f0f\u9519\u8bef,\u53ea\u80fd\u662f\u3010%s\u3001%s\u3011", importUserRelationInfo.getIssueType(), AllElectricIssuerIssueTypeEnum.NS.getValue(), AllElectricIssuerIssueTypeEnum.DPPT.getValue()), (Object)importUserRelationInfo));
                    continue;
                }
                Tuple2 userInfoTuple = this.getUserInfoData(groupId, importUserRelationInfo.getAccountName(), 1, 1);
                if (null == userInfoTuple || CollectionUtils.isEmpty((Collection)((Collection)userInfoTuple._1))) {
                    checkErrorList.add(Tuple.of((Object)String.format("%s-\u8d26\u53f7\u7528\u6237\u4e2d\u5fc3\u4e0d\u5b58\u5728", importUserRelationInfo.getAccountName()), (Object)importUserRelationInfo));
                    continue;
                }
                userDataRelationInfoList.add(Tuple.of(((List)userInfoTuple._1).get(0), (Object)importUserRelationInfo));
            }
            ArrayList userRelationInfoList = Lists.newArrayList();
            for (Tuple2 r2 : userDataRelationInfoList) {
                Optional companyNameOpt = this.getCompanyByUserId(((UserData)r2._1).getId(), ((UserRelationData.ImportUserRelationInfo)r2._2).getTaxNo());
                if (!companyNameOpt.isPresent()) {
                    log.info("importUserRelationList \u6839\u636euserId {} \u548c \u516c\u53f8\u7a0e\u53f7 {} \u67e5\u8be2\u516c\u53f8\u540d\u79f0\u4e0d\u5b58\u5728", (Object)((UserData)r2._1).getId(), (Object)((UserRelationData.ImportUserRelationInfo)r2._2).getTaxNo());
                    checkErrorList.add(Tuple.of((Object)String.format("%s-\u7a0e\u53f7\u7528\u6237\u4e2d\u5fc3\u4e0d\u5b58\u5728", ((UserRelationData.ImportUserRelationInfo)r2._2).getTaxNo()), (Object)r2._2));
                    continue;
                }
                if (!this.filterHasPermission(((UserData)r2._1).getTenantId(), ((UserData)r2._1).getId(), ((UserRelationData.ImportUserRelationInfo)r2._2).getTaxNo()).booleanValue()) {
                    log.info("importUserRelationList \u6839\u636etenantId {} userId {} \u548c taxNo {} \u6821\u9a8c\u7a0e\u53f7\u4e0d\u5c5e\u4e8e\u8be5\u7528\u6237", new Object[]{((UserData)r2._1).getTenantId(), ((UserData)r2._1).getId(), ((UserRelationData.ImportUserRelationInfo)r2._2).getTaxNo()});
                    checkErrorList.add(Tuple.of((Object)String.format("%s-\u6821\u9a8c\u7a0e\u53f7\u4e0d\u5c5e\u4e8e\u8be5\u7528\u6237userId-%s", ((UserRelationData.ImportUserRelationInfo)r2._2).getTaxNo(), ((UserData)r2._1).getId()), (Object)r2._2));
                    continue;
                }
                Either eitherResult = this.queryAllElectricIssuerInfo(((UserData)r2._1).getTenantId(), ((UserRelationData.ImportUserRelationInfo)r2._2).getTaxNo(), (List)Lists.newArrayList((Object[])new String[]{((UserRelationData.ImportUserRelationInfo)r2._2).getIssuer()}));
                if (eitherResult.isLeft() || ((AllElectricIssuerInfoData)eitherResult.get()).getIssuers().stream().noneMatch(issuerInfo -> StringUtils.equals((CharSequence)issuerInfo.getIssuer(), (CharSequence)((UserRelationData.ImportUserRelationInfo)r._2).getIssuer()))) {
                    log.info("importUserRelationList \u6839\u636etenantId {} userId {} \u548c taxNo {}  issuer {} \u5f00\u7968\u4eba\u4e0d\u5c5e\u4e8e\u6b21\u7a0e\u53f7", new Object[]{((UserData)r2._1).getTenantId(), ((UserData)r2._1).getId(), ((UserRelationData.ImportUserRelationInfo)r2._2).getTaxNo(), ((UserRelationData.ImportUserRelationInfo)r2._2).getIssuer()});
                    checkErrorList.add(Tuple.of((Object)String.format("%s-\u6821\u9a8c\u5f00\u7968\u4eba\u4e0d\u5c5e\u4e8e\u8be5\u7a0e\u53f7-%s", ((UserRelationData.ImportUserRelationInfo)r2._2).getIssuer(), ((UserRelationData.ImportUserRelationInfo)r2._2).getTaxNo()), (Object)r2._2));
                    continue;
                }
                String uniqueKey = String.format("%s-%s-%s-%s", ((UserData)r2._1).getTenantId(), ((UserRelationData.ImportUserRelationInfo)r2._2).getTaxNo(), ((UserRelationData.ImportUserRelationInfo)r2._2).getIssuer(), ((UserRelationData.ImportUserRelationInfo)r2._2).getIssueType());
                userRelationInfoList.add(new UserRelationData.UserRelationInfo(((UserRelationData.ImportUserRelationInfo)r2._2).getId(), ((UserData)r2._1).getMobile(), ((UserData)r2._1).getEmail(), ((UserData)r2._1).getId(), ((UserData)r2._1).getUserName(), ((UserData)r2._1).getAccountName(), ((UserData)r2._1).getTenantId(), ((UserRelationData.ImportUserRelationInfo)r2._2).getTaxNo(), Optional.ofNullable(((UserRelationData.ImportUserRelationInfo)r2._2).getRelationType()).orElse(0), ((UserRelationData.ImportUserRelationInfo)r2._2).getStatus().intValue(), ((UserRelationData.ImportUserRelationInfo)r2._2).getIssuer(), ((UserRelationData.ImportUserRelationInfo)r2._2).getIssueType(), (String)companyNameOpt.get(), uniqueKey));
            }
            Tuple2 tuple2 = this.groupUserRelationList((List)userRelationInfoList, groupId);
            Either eitherResult = this.saveUserRelationList((List)tuple2._1);
            int insertTotal = eitherResult.isRight() ? (Integer)((Tuple2)eitherResult.get())._1 : 0;
            int n = upateTotal = eitherResult.isRight() ? (Integer)((Tuple2)eitherResult.get())._2 : 0;
            if (eitherResult.isRight()) {
                this.updateProcessFlag("S", "", ((List)tuple2._1).stream().map(UserRelationData.UserRelationInfo::getId).collect(Collectors.toList()));
            } else {
                this.updateProcessFlag("F", (String)eitherResult.getLeft(), ((List)tuple2._1).stream().map(UserRelationData.UserRelationInfo::getId).collect(Collectors.toList()));
            }
            if (CollectionUtils.isNotEmpty((Collection)checkErrorList)) {
                checkErrorList.forEach(r -> ((List)groupList._2).add(this.taxWareConverter.convertRelationErrorInfo((UserRelationData.ImportUserRelationInfo)r._2, (String)r._1)));
            }
            if (CollectionUtils.isNotEmpty((Collection)((Collection)tuple2._2))) {
                ((List)tuple2._2).forEach(r -> this.updateProcessFlag("F", r.getErrorMsg(), (List)Lists.newArrayList((Object[])new Long[]{r.getId()})));
                log.info("importUserRelationList \u4eba\u5458\u5f00\u7968\u4fe1\u606f\u5173\u7cfb\u5bfc\u5165\u6821\u9a8c\u5931\u8d25 {}", (Object)JsonUtils.toJson((Object)tuple2._2));
                this.importFailRelationIssueServiceImpl.dealFailImportUserRelationList((List)tuple2._2, headers, insertTotal, upateTotal);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Boolean filterHasPermission(Long tenantId, Long userId, String taxNo) {
        UserCenterResponse userReply = this.userCenterUserService.getUserByUserId(tenantId.longValue(), userId.longValue(), null);
        if (null == userReply.getResult() || CollectionUtils.isEmpty((Collection)((UserData)userReply.getResult()).getParentCompanies())) {
            return false;
        }
        return ((UserData)userReply.getResult()).getParentCompanies().stream().anyMatch(r -> StringUtils.isNotBlank((CharSequence)r.getTaxNum()) && StringUtils.equals((CharSequence)r.getTaxNum(), (CharSequence)taxNo) && null != r.getOrgType() && 0 != r.getOrgType());
    }

    private void updateProcessFlag(String processFlag, String processRemark, List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return;
        }
        CfgUserIssuerRelationInterfaceEntity update2 = new CfgUserIssuerRelationInterfaceEntity();
        update2.setProcessFlag(processFlag);
        update2.setProcessRemark(processRemark);
        CfgUserIssuerRelationInterfaceExample updateExample = new CfgUserIssuerRelationInterfaceExample();
        updateExample.createCriteria().andIdIn(idList);
        this.cfgUserIssuerRelationInterfaceDao.updateByExampleSelective(update2, updateExample);
    }

    private Tuple2<List<UserData>, Integer> getUserInfoData(Long tenantId, String accountName, int page, int row) {
        UserQueryParam userQueryParam = new UserQueryParam();
        userQueryParam.setAccountName(accountName);
        userQueryParam.setPage(Integer.valueOf(page));
        userQueryParam.setRow(Integer.valueOf(row));
        UserCenterResponse response2 = this.userCenterApi.getUserByAccountName(tenantId.longValue(), userQueryParam);
        if (!StringUtils.equals((CharSequence)"1", (CharSequence)response2.getCode())) {
            return null;
        }
        List userDataList = Optional.ofNullable(response2.getResult()).map(UserCenterList::getContent).orElse(null);
        if (CollectionUtils.isEmpty((Collection)userDataList)) {
            return null;
        }
        int total = Optional.ofNullable(response2.getResult()).map(UserCenterList::getTotalElements).orElse(0);
        return Tuple.of((Object)userDataList, (Object)total);
    }

    private Optional<String> getCompanyByUserId(Long userId, String taxNo) {
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return Optional.empty();
        }
        UserCenterResponse response2 = null;
        try {
            response2 = this.userCenterApi.getCompanyByUserId(0L, userId.longValue());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (null == response2) {
            return Optional.empty();
        }
        if (!StringUtils.equals((CharSequence)"1", (CharSequence)response2.getCode())) {
            return Optional.empty();
        }
        if (Objects.isNull(response2.getResult())) {
            return Optional.empty();
        }
        if (Objects.isNull(response2.getResult()) || CollectionUtils.isEmpty((Collection)((UserData)response2.getResult()).getParentCompanies())) {
            return Optional.empty();
        }
        return ((UserData)response2.getResult()).getParentCompanies().stream().filter(r -> StringUtils.equals((CharSequence)r.getTaxNum(), (CharSequence)taxNo)).map(r -> Optional.ofNullable(r.getCompanyName()).orElse("")).findFirst();
    }

    public long countUserIssuerRelationByCondition(MsConfigUserIssuerRelationData.MsConfigUserIssuerRelationConditionRequest request) {
        return this.cfgUserIssuerRelationDao.countByExample(this.buildQueryExample(request));
    }

    public List<MsConfigUserIssuerRelationData.UserIssuerRelationVo> queryUserIssuerRelationList(MsConfigUserIssuerRelationData.MsConfigUserIssuerRelationConditionRequest request) {
        int pageNo = 1;
        int pageSize = 20;
        Page page = request.getPage();
        if (Objects.nonNull(page)) {
            pageNo = Optional.ofNullable(page.getPageNo()).orElse(1);
            pageSize = Optional.ofNullable(page.getPageSize()).orElse(20);
        }
        CfgUserIssuerRelationExample queryExample = this.buildQueryExample(request);
        queryExample.setOffset(Integer.valueOf((pageNo - 1) * pageSize));
        queryExample.setLimit(Integer.valueOf(pageSize));
        List relationEntityList = this.cfgUserIssuerRelationDao.selectByExample(queryExample);
        return this.userIssuerRelationConverter.convertUserIssuerRelationList(relationEntityList);
    }

    private CfgUserIssuerRelationExample buildQueryExample(MsConfigUserIssuerRelationData.MsConfigUserIssuerRelationConditionRequest request) {
        CfgUserIssuerRelationExample queryExample = new CfgUserIssuerRelationExample();
        CfgUserIssuerRelationExample.Criteria criteria = queryExample.createCriteria();
        if (Optional.ofNullable(request.getTenantId()).orElse(0L) > 0L) {
            criteria.andTenantIdEqualTo(request.getTenantId());
        }
        if (Optional.ofNullable(request.getUserId()).orElse(0L) > 0L) {
            criteria.andUserIdEqualTo(request.getUserId());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getUserName())) {
            criteria.andUserNameEqualTo(request.getUserName());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getTaxNo())) {
            criteria.andTaxNoEqualTo(request.getTaxNo());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getEmail())) {
            criteria.andEmailEqualTo(request.getEmail());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getMobile())) {
            criteria.andMobileEqualTo(request.getMobile());
        }
        Integer status = Optional.ofNullable(request.getStatus()).orElse(1);
        criteria.andStatusEqualTo(status);
        if (Optional.ofNullable(request.getImportBatchNo()).orElse(0L) > 0L) {
            criteria.andTenantIdEqualTo(request.getImportBatchNo());
        }
        return queryExample;
    }

    public List<String> queryTaxNoListByUserId(Long tenantId, Long userId) {
        UserCenterResponse response2 = this.userCenterApi.getCompanyByUserId(tenantId.longValue(), userId.longValue());
        if (!StringUtils.equals((CharSequence)"1", (CharSequence)response2.getCode())) {
            return Lists.newArrayList();
        }
        if (Objects.isNull(response2.getResult())) {
            return Lists.newArrayList();
        }
        if (Objects.isNull(response2.getResult()) || CollectionUtils.isEmpty((Collection)((UserData)response2.getResult()).getParentCompanies())) {
            return Lists.newArrayList();
        }
        return ((UserData)response2.getResult()).getParentCompanies().stream().map(OrgData::getTaxNum).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
    }

    public ImportResponse queryUserIssuerRelationImportResult(Long importBatchNo) {
        log.info("\u4eba\u5458\u5f00\u7968\u4eba\u7ed1\u5b9a\u5173\u7cfb\u5bfc\u5165\u7ed3\u679c\u8bf7\u6c42:importBatchNo:{}", (Object)importBatchNo);
        ImportResponse importResponse = new ImportResponse();
        importResponse.setCode(Response.OK);
        ImportResult importResult = new ImportResult();
        List list = this.cfgUserIssuerRelationInterfaceExtDao.queryProcessFlagResult(importBatchNo);
        if (CollectionUtils.isEmpty((Collection)list)) {
            importResult.setIsDone(Boolean.valueOf(false));
            importResponse.setResult(importResult);
            return importResponse;
        }
        list.forEach(item -> {
            if ("F".equals(item.get("processFlag"))) {
                importResult.setFail(Optional.ofNullable(item.get("total")).map(String::valueOf).map(Integer::parseInt).orElse(0));
            } else if ("S".equals(item.get("processFlag"))) {
                importResult.setSuccess(Optional.ofNullable(item.get("total")).map(String::valueOf).map(Integer::parseInt).orElse(0));
            }
        });
        importResult.setIsDone(Boolean.valueOf(true));
        importResponse.setResult(importResult);
        importResponse.setCode(Response.OK);
        log.info("\u4eba\u5458\u5f00\u7968\u4eba\u7ed1\u5b9a\u5173\u7cfb\u5bfc\u5165\u7ed3\u679c\u7ed3\u679c importResponse:{}", (Object)JsonUtils.toJson((Object)importResponse));
        return importResponse;
    }
}

