/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.facade.settled;

import com.xforceplus.seller.config.client.constant.StatusEnum;
import com.xforceplus.seller.config.client.model.CreateSettledTemplateConfigRequest;
import com.xforceplus.seller.config.client.model.GetSettledTemplateConfigRequest;
import com.xforceplus.seller.config.client.model.SettledTemplateConifgVo;
import com.xforceplus.seller.config.config.GatewayProperties;
import com.xforceplus.seller.config.facade.settled.SettledConfigFacade;
import com.xforceplus.seller.config.infrastructure.helper.RestTemplateRetryHelper;
import com.xforceplus.seller.config.infrastructure.helper.RestTemplateTools;
import com.xforceplus.seller.config.models.QueryNewSettledConfigRequest;
import com.xforceplus.seller.config.repository.dao.CfgTemplateSettledObjDao;
import com.xforceplus.seller.config.repository.model.CfgTemplateSettledObjEntity;
import com.xforceplus.seller.config.repository.model.CfgTemplateSettledObjExample;
import com.xforceplus.seller.config.services.TemplateObjMetadataService;
import com.xforceplus.seller.config.util.JsonUtils;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Service;

@Service
public class SettledConfigFacadeImpl
implements SettledConfigFacade {
    private static final Logger log = LoggerFactory.getLogger(SettledConfigFacadeImpl.class);
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    private TemplateObjMetadataService templateObjMetadataService;
    @Autowired
    private CfgTemplateSettledObjDao cfgTemplateSettledObjDao;
    @Autowired
    private RestTemplateTools restTemplateTools;
    @Autowired
    private RestTemplateRetryHelper restTemplateRetryHelper;
    @Autowired
    private GatewayProperties gatewayProperties;

    public Either<String, Boolean> createSettledTemplateConfig(CreateSettledTemplateConfigRequest request) {
        log.info("createSettledTemplateConfig {}", (Object)JsonUtils.writeObjectToFastJson((Object)request));
        Either eitherCheckParam = this.checkInitTemplateParam(request);
        if (eitherCheckParam.isLeft()) {
            return eitherCheckParam;
        }
        Tuple2 eiterResult = this.templateObjMetadataService.convertSettledTemplateConfig(request.getTemplateGroupList(), request.getId());
        log.info("createSettledTemplateConfig converted templateObjEnity {}", (Object)JsonUtils.writeObjectToFastJson((Object)eiterResult._1));
        return this.templateObjMetadataService.createSettledTemplateConfig((List)eiterResult._1, (List)eiterResult._2);
    }

    public Either<String, SettledTemplateConifgVo> getSettledTemplateConfig(GetSettledTemplateConfigRequest request) {
        return this.templateObjMetadataService.querySettledTemplateConfigItem(request.getId(), request.getIsManual());
    }

    public CfgTemplateSettledObjEntity queryOneSettledTemplate(Integer settledType, Long tenantId, String productCode) {
        CfgTemplateSettledObjEntity cfgTemplateSettledObjEntity = this.queryNewSettledConfig(settledType, tenantId, productCode);
        if (null != cfgTemplateSettledObjEntity) {
            log.info("\u5165\u9a7b\u914d\u7f6e\u67e5\u8be2\u9002\u914d\u627e\u5230\u914d\u7f6e\u6a21\u7248\u3010\u914d\u7f6e\u5de5\u7a0b\u3011 settledType:{}, tenantId:{}, productCode:{}, settledConfig: {}", new Object[]{settledType, tenantId, productCode, JsonUtils.writeObjectToFastJson((Object)cfgTemplateSettledObjEntity)});
            return cfgTemplateSettledObjEntity;
        }
        cfgTemplateSettledObjEntity = this.templateObjMetadataService.queryOneSettledTemplate(settledType, tenantId, productCode);
        log.info("\u5165\u9a7b\u914d\u7f6e\u67e5\u8be2\u9002\u914d\u627e\u5230\u914d\u7f6e\u6a21\u7248\u3010\u9500\u9879\u914d\u7f6e\u8868\u3011 settledType:{}, tenantId:{}, productCode:{}, settledConfig: {}", new Object[]{settledType, tenantId, productCode, JsonUtils.writeObjectToFastJson((Object)cfgTemplateSettledObjEntity)});
        return cfgTemplateSettledObjEntity;
    }

    private Either<String, Boolean> checkInitTemplateParam(CreateSettledTemplateConfigRequest request) {
        for (List templateObjGroup : request.getTemplateGroupList()) {
            for (CreateSettledTemplateConfigRequest.CfgTemplateObj templateObj : templateObjGroup) {
                if (StringUtils.isBlank((CharSequence)templateObj.getTemplateObjCode())) {
                    return Either.left((Object)"\u6a21\u7248\u5bf9\u8c61\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!CollectionUtils.isEmpty((Collection)templateObj.getCfgTemplateObjMetadataList())) continue;
                return Either.left((Object)"\u6a21\u7248\u660e\u7ec6\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        return Either.right((Object)true);
    }

    public List<CfgTemplateSettledObjEntity> listAllSettledObj(List<Long> idList) {
        CfgTemplateSettledObjExample example = new CfgTemplateSettledObjExample();
        CfgTemplateSettledObjExample.Criteria criteria = example.createCriteria();
        criteria.andStatusEqualTo(StatusEnum.NORMAL.getStatus());
        if (CollectionUtils.isNotEmpty(idList)) {
            criteria.andSettledObjIdIn(idList);
        }
        example.setOrderByClause(" create_time asc");
        return this.cfgTemplateSettledObjDao.selectByExample(example);
    }

    public void syncNewSettledObj(List<CfgTemplateSettledObjEntity> list) {
        for (CfgTemplateSettledObjEntity cfgTemplateSettledObjEntity : list) {
            log.info("\u65b0\u7248\u914d\u7f6e\u5de5\u7a0b\u540c\u6b65\u914d\u7f6e\u6a21\u7248\u6570\u636e: {}", (Object)JsonUtils.writeObjectToFastJson((Object)cfgTemplateSettledObjEntity));
            if (null != this.cfgTemplateSettledObjDao.selectByPrimaryKey(cfgTemplateSettledObjEntity.getSettledObjId())) {
                this.cfgTemplateSettledObjDao.updateByPrimaryKeySelective(cfgTemplateSettledObjEntity);
                continue;
            }
            this.cfgTemplateSettledObjDao.insertSelective(cfgTemplateSettledObjEntity);
        }
    }

    private CfgTemplateSettledObjEntity queryNewSettledConfig(Integer settledType, Long tenantId, String productCode) {
        try {
            log.info("queryNewSettledConfig settledType:{}, tenantId:{}, productCode:{},", new Object[]{settledType, tenantId, productCode});
            QueryNewSettledConfigRequest request = new QueryNewSettledConfigRequest();
            request.setSettledType(settledType);
            request.setTenantId(tenantId);
            request.setProductCode(productCode);
            String subUrl = "api/ant-coop-settled-rule/global/coop/settled-rule/v1/settled-configs/query";
            String url = this.gatewayProperties.getGlobalUrl() + subUrl;
            Response response2 = (Response)this.restTemplateRetryHelper.postWithPaasToken(url, (Object)request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{""});
            if (Objects.nonNull(response2) && Response.OK.equals(response2.getCode())) {
                return (CfgTemplateSettledObjEntity)response2.getResult();
            }
            log.warn("queryNewSettledConfig \u4ece\u5165\u9a7b\u5de5\u7a0b\u672a\u627e\u5230\u914d\u7f6e\u6a21\u7248 settledType:{}, tenantId:{}, productCode:{},", new Object[]{settledType, tenantId, productCode});
        }
        catch (Throwable e) {
            log.warn("queryNewSettledConfig \u4ece\u5165\u9a7b\u5de5\u7a0b\u67e5\u8be2\u914d\u7f6e\u6a21\u7248\u5f02\u5e38: ", e);
        }
        return null;
    }
}

