/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.infrastructure.cache;

import com.google.common.collect.Maps;
import com.xforceplus.phoenix.bill.client.model.LoginRequest;
import com.xforceplus.phoenix.bill.client.model.LoginResponse;
import com.xforceplus.phoenix.infrastructure.usercenter.controllers.UserCenterController;
import com.xforceplus.phoenix.infrastructure.usercenter.model.CompanyData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.OrgData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.TenantData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserCenterResponse;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.constant.StatusEnum;
import com.xforceplus.seller.config.client.model.CustomSorter;
import com.xforceplus.seller.config.client.model.MsBusinessObjMetadataBean;
import com.xforceplus.seller.config.client.model.MsMataDataQueryRequest;
import com.xforceplus.seller.config.client.model.MsMataItemDataQueryRequest;
import com.xforceplus.seller.config.repository.dao.CfgConfigDao;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjMetadataEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigExample;
import com.xforceplus.seller.config.services.ConfigMetaDataService;
import com.xforceplus.seller.config.services.CustomFieldManager;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class LocalCacheManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String CACHE_NAME = "LOCAL_CONFIG_CACHE";
    private static final String LOCAL_META_DATA_FIELD_NAME_DISPLAYNAME = "LOCAL_META_DATA_FIELD_NAME_DISPLAYNAME";
    private static final String GET_ACCESS_TOKEN_KEY = "GET_ACCESS_TOKEN_KEY";
    private static final Integer SUCCESS = 1;
    private static final String SYNCDEVICEAMOUNTLIMITFLAG = "SYNCDEVICEAMOUNTLIMITFLAG";
    private static final String QUERY_TENANT_BY_TENANT_ID = "QUERY_TENANT_BY_TENANT_ID";
    private static final String QUERY_COMPANY_BY_TAX_NO = "QUERY_COMPANY_BY_TAX_NO";
    private static final String QUERY_ORG_BY_ID = "QUERY_ORG_BY_ID";
    private ConfigMetaDataService configMetaDataService;
    private RestTemplate restTemplate;
    private CustomFieldManager customFieldManager;
    private CfgConfigDao cfgConfigDao;
    private UserCenterController userCenterController;

    @Autowired
    public LocalCacheManager(ConfigMetaDataService configMetaDataService, RestTemplate restTemplate, CustomFieldManager customFieldManager, CfgConfigDao cfgConfigDao, UserCenterController userCenterController) {
        this.configMetaDataService = configMetaDataService;
        this.restTemplate = restTemplate;
        this.customFieldManager = customFieldManager;
        this.cfgConfigDao = cfgConfigDao;
        this.userCenterController = userCenterController;
    }

    @Cacheable(cacheNames={"LOCAL_CONFIG_CACHE"})
    public Map<String, MsBusinessObjMetadataBean> queryEffectiveMetaData(Long groupId, String objCode, String objType) {
        MsMataDataQueryRequest request = new MsMataDataQueryRequest();
        request.setGroupId(groupId);
        request.setObjCode(objCode);
        request.setObjType(objType);
        this.logger.info("================queryEffectiveMetaData-{}==============================================", (Object)request);
        List result = this.configMetaDataService.queryEffectiveMetaDataList(request, null);
        if (CollectionUtils.isEmpty((Collection)result)) {
            return null;
        }
        HashMap map = Maps.newHashMap();
        result.forEach(m -> map.put(m.getFieldDisplayName() + "#" + m.getFieldGroupIndex(), m));
        this.logger.info("=================metadataItemResult-{}===========================================", (Object)com.xforceplus.seller.config.util.JsonUtils.writeObjectToFastJson((Object)result));
        return map;
    }

    @Cacheable(cacheNames={"GET_ACCESS_TOKEN_KEY"}, key="#root.methodName+#root.args[0]+#root.args[2]")
    public String getAccessToken(String clientId, String secret, String loginUrl) {
        LoginRequest loginRequest = new LoginRequest(clientId, secret);
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.add("Content-Type", "application/json");
        HttpEntity requestEntity = new HttpEntity((Object)loginRequest, (MultiValueMap)requestHeaders);
        ResponseEntity response2 = this.restTemplate.postForEntity(loginUrl, (Object)requestEntity, LoginResponse.class, new Object[0]);
        this.logger.info("\u83b7\u53d6token\u7ed3\u679c  {}", (Object)JsonUtils.writeObjectToFastJson((Object)response2));
        if (null == response2 || null == response2.getBody()) {
            throw new RuntimeException("\u5f53\u524d\u83b7\u53d6token\u51fa\u73b0\u5f02\u5e38");
        }
        LoginResponse body = (LoginResponse)response2.getBody();
        if (body.getCode() == 1) {
            return body.getData();
        }
        throw new RuntimeException("\u83b7\u53d6token\u51fa\u73b0\u5f02\u5e38");
    }

    @Cacheable(cacheNames={"LOCAL_CONFIG_CACHE"})
    public List<CustomSorter> queryTemplateMetadataBy(String templateObjCode) {
        return this.customFieldManager.queryTemplateCustomSortersBy(templateObjCode);
    }

    @Cacheable(cacheNames={"LOCAL_META_DATA_FIELD_NAME_DISPLAYNAME"})
    public Optional<Map<String, String>> queryFiledNameAndDisplayName(Long groupId, String objName) {
        MsMataItemDataQueryRequest request = new MsMataItemDataQueryRequest();
        request.setGroupId(groupId);
        request.setObjName(objName);
        request.setFieldGroupIndex(Integer.valueOf(0));
        Response response2 = this.configMetaDataService.queryMetaObjMetadata(request);
        this.logger.info("LocalCacheManager#queryMetaData groupId:{},objName:{},response:{}", new Object[]{groupId, objName, response2});
        if (response2.getCode() != 1) {
            return Optional.empty();
        }
        List businessObjMetadataEntityList = (List)response2.getResult();
        Map<String, String> filedNamdAndDisplayNameMap = businessObjMetadataEntityList.stream().filter(u -> StringUtils.isNotEmpty((CharSequence)u.getFieldName()) && u.getFieldName().startsWith("ext") && StringUtils.isNotEmpty((CharSequence)u.getFieldDisplayName())).collect(Collectors.toMap(CfgBusinessObjMetadataEntity::getFieldName, CfgBusinessObjMetadataEntity::getFieldDisplayName));
        return filedNamdAndDisplayNameMap.size() > 0 ? Optional.of(filedNamdAndDisplayNameMap) : Optional.empty();
    }

    public Boolean hasSyncDeviceAmountLimitFlag(String taxNo, List<String> invoiceTypes) {
        CfgConfigExample example = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = example.createCriteria();
        criteria.andConfigTypeEqualTo(Byte.valueOf(ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType().byteValue()));
        criteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        criteria.andInvoiceTypeIn(invoiceTypes);
        criteria.andSellerTaxNoEqualTo(taxNo);
        example.setLimit(Integer.valueOf(1));
        long count = this.cfgConfigDao.countByExample(example);
        this.logger.info("syncDeviceAmountLimitFlag-cacheTaxNos :{},invoiceTypes:{},count:{}", new Object[]{taxNo, com.xforceplus.seller.config.util.JsonUtils.writeObjectToFastJson(invoiceTypes), count});
        return count > 0L;
    }

    @Cacheable(cacheNames={"QUERY_TENANT_BY_TENANT_ID"})
    public UserCenterResponse<TenantData> queryTenantByTenantId(Long tenantId) {
        return this.userCenterController.getTenantByTenantId(tenantId.longValue());
    }

    @Cacheable(cacheNames={"QUERY_COMPANY_BY_TAX_NO"})
    public UserCenterResponse<CompanyData> queryTaxNo(Long sellerGroupId, String sellerTaxNo) {
        return this.userCenterController.getCompanyByTaxNo(sellerGroupId.longValue(), sellerTaxNo);
    }

    @Cacheable(cacheNames={"QUERY_ORG_BY_ID"})
    public UserCenterResponse<OrgData> getOrgById(Long groupId, Long sysOrgId) {
        return this.userCenterController.getOrgById(groupId.longValue(), sysOrgId.longValue());
    }
}

