/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.infrastructure.helper;

import com.google.common.collect.Lists;
import com.xforceplus.micro.tax.device.contract.model.AddDeviceResponse;
import com.xforceplus.micro.tax.device.contract.model.AddTerminalRequest;
import com.xforceplus.micro.tax.device.contract.model.AddTerminalResponse;
import com.xforceplus.micro.tax.device.contract.model.DeviceInfo;
import com.xforceplus.micro.tax.device.contract.model.OnlineDeviceInfo;
import com.xforceplus.micro.tax.device.contract.model.QueryDeviceQualificationsResponse;
import com.xforceplus.micro.tax.device.contract.model.QueryDeviceRequest;
import com.xforceplus.micro.tax.device.contract.model.QueryDeviceResponse;
import com.xforceplus.micro.tax.device.contract.model.QueryTerminalRequest;
import com.xforceplus.micro.tax.device.contract.model.QueryTerminalResponse;
import com.xforceplus.micro.tax.device.contract.model.QueryTerminalResult;
import com.xforceplus.micro.tax.device.contract.model.ResponseHead;
import com.xforceplus.micro.tax.device.contract.model.SendLicenseRequest;
import com.xforceplus.micro.tax.device.contract.model.SendLicenseResponse;
import com.xforceplus.micro.tax.device.contract.model.TerminalQueryResponseInfo;
import com.xforceplus.micro.tax.device.contract.model.UpdateDeviceResponse;
import com.xforceplus.micro.tax.device.contract.model.UpdateDeviceStatusRequest;
import com.xforceplus.micro.tax.device.contract.model.UpdateDeviceStatusResponse;
import com.xforceplus.micro.tax.device.contract.model.UpdateTerminalRequest;
import com.xforceplus.micro.tax.device.contract.model.UpdateTerminalResponse;
import com.xforceplus.micro.tax.device.contract.model.UpdateTerminalStatusRequest;
import com.xforceplus.micro.tax.device.contract.model.UpdateTerminalStatusResponse;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.phoenix.infrastructure.usercenter.model.GenerateCertificateRequest;
import com.xforceplus.seller.config.config.GatewayProperties;
import com.xforceplus.seller.config.converters.DeviceConverter;
import com.xforceplus.seller.config.infrastructure.helper.RestTemplateRetryHelper;
import com.xforceplus.seller.config.infrastructure.helper.RestTemplateTools;
import com.xforceplus.seller.config.models.GenerateCertificateResponse;
import com.xforceplus.seller.config.models.NewCompanyInfo;
import com.xforceplus.seller.config.models.NewGetTerminalRequest;
import com.xforceplus.seller.config.models.NewTerminalQueryInfo;
import com.xforceplus.seller.config.models.RestActiveCodeRequest;
import com.xforceplus.seller.config.models.RestActiveCodeResponse;
import com.xforceplus.seller.config.models.RestAddDeviceRequest;
import com.xforceplus.seller.config.models.RestAddDeviceResponse;
import com.xforceplus.seller.config.models.RestAddTerminalRequest;
import com.xforceplus.seller.config.models.RestAddTerminalResponse;
import com.xforceplus.seller.config.models.RestCancelDeviceStockRequest;
import com.xforceplus.seller.config.models.RestCancelDeviceStockResponse;
import com.xforceplus.seller.config.models.RestCancelExtractRequest;
import com.xforceplus.seller.config.models.RestCancelExtractResponse;
import com.xforceplus.seller.config.models.RestDeviceQualificationRequest;
import com.xforceplus.seller.config.models.RestGetActiveResponse;
import com.xforceplus.seller.config.models.RestGetSubscribeDeviceStockResponse;
import com.xforceplus.seller.config.models.RestGetSubscribeResponse;
import com.xforceplus.seller.config.models.RestGetTerminalResponse;
import com.xforceplus.seller.config.models.RestInventoryData;
import com.xforceplus.seller.config.models.RestInventoryReply;
import com.xforceplus.seller.config.models.RestQueryDeviceRequest;
import com.xforceplus.seller.config.models.RestQueryDeviceResponse;
import com.xforceplus.seller.config.models.RestQueryInventoryRequest;
import com.xforceplus.seller.config.models.RestResponse;
import com.xforceplus.seller.config.models.RestSubscribeDeviceStockRequest;
import com.xforceplus.seller.config.models.RestSubscribeDeviceStockResponse;
import com.xforceplus.seller.config.models.RestSubscribeExtractRequest;
import com.xforceplus.seller.config.models.RestSubscribeExtractResponse;
import com.xforceplus.seller.config.models.RestTerminalQueryResponseInfo;
import com.xforceplus.seller.config.models.RestUpdateDeviceRequest;
import com.xforceplus.seller.config.models.RestUpdateDeviceResponse;
import com.xforceplus.seller.config.models.RestUpdateDeviceStatusRequest;
import com.xforceplus.seller.config.models.RestUpdateDeviceStatusResponse;
import com.xforceplus.seller.config.models.RestUpdateTerminalRequest;
import com.xforceplus.seller.config.models.RestUpdateTerminalResponse;
import com.xforceplus.seller.config.models.RestUpdateTerminalStatusRequest;
import com.xforceplus.seller.config.models.RestUpdateTerminalStatusResponse;
import com.xforceplus.seller.config.models.SendEmailItem;
import com.xforceplus.seller.config.util.BeanMapper;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpStatusCodeException;

@Component
public class DeviceApiProxy {
    private static final Logger logger = LoggerFactory.getLogger(DeviceApiProxy.class);
    public static final String SUCESS = "1";
    @Autowired
    RestTemplateTools restTemplateTools;
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    private IDGenerator idGenerator;
    @Autowired
    private DeviceConverter deviceConverter;
    @Autowired
    private RestTemplateRetryHelper restTemplateRetryHelper;
    @Autowired
    private GatewayProperties gatewayProperties;

    public UserInfo getUserInfo() {
        UserInfo userInfo = new UserInfo();
        userInfo.setGroupId(2L);
        return userInfo;
    }

    public AddDeviceResponse deviceAddPost(RestAddDeviceRequest addDeviceRequest) {
        AddDeviceResponse addDeviceResponse = null;
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        Long groupId = userInfo.getGroupId();
        String subUrl = "/taxware/v1/hardware/devices";
        addDeviceResponse = new AddDeviceResponse();
        RestAddDeviceResponse restAddDeviceResponse = (RestAddDeviceResponse)this.restTemplateTools.postEntity((Object)addDeviceRequest, groupId, subUrl, RestAddDeviceResponse.class);
        this.convertAddDeviceResponse(restAddDeviceResponse, addDeviceResponse);
        return addDeviceResponse;
    }

    public UpdateDeviceResponse deviceUpdatePost(RestUpdateDeviceRequest updateDeviceRequest) {
        UpdateDeviceResponse updateDeviceResponse = null;
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        Long groupId = userInfo.getGroupId();
        String subUrl = "/taxware/v1/hardware/devices";
        RestUpdateDeviceResponse restUpdateDeviceResponse = (RestUpdateDeviceResponse)this.restTemplateTools.putEntity((Object)updateDeviceRequest, groupId, subUrl, RestUpdateDeviceResponse.class);
        updateDeviceResponse = new UpdateDeviceResponse();
        this.convertUpdateDeviceResponse(restUpdateDeviceResponse, updateDeviceResponse);
        return updateDeviceResponse;
    }

    public UpdateDeviceStatusResponse deviceUpdateStatusPost(UpdateDeviceStatusRequest updateStatusRequest) {
        UpdateDeviceStatusResponse updateStatusResponse = null;
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        Long groupId = userInfo.getGroupId();
        String subUrl = "/taxware/v1/hardware/devices";
        RestUpdateDeviceStatusRequest restUpdateDeviceStatusRequest = new RestUpdateDeviceStatusRequest();
        this.convertUpdateDeviceStatusRequest(updateStatusRequest, restUpdateDeviceStatusRequest);
        RestUpdateDeviceStatusResponse restUpdateDeviceStatusResponse = (RestUpdateDeviceStatusResponse)this.restTemplateTools.patchEntity((Object)restUpdateDeviceStatusRequest, groupId, subUrl, RestUpdateDeviceStatusResponse.class);
        updateStatusResponse = new UpdateDeviceStatusResponse();
        this.convertUpdateDeviceStatusResponse(restUpdateDeviceStatusResponse, updateStatusResponse);
        return updateStatusResponse;
    }

    public QueryDeviceResponse deviceQueryPost(QueryDeviceRequest destinationRequest) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        long groupId = 0L;
        if (userInfo != null) {
            groupId = userInfo.getGroupId();
        }
        return this.deviceQueryPost2(destinationRequest, Long.valueOf(groupId), null);
    }

    public QueryDeviceResponse deviceQueryPost(QueryDeviceRequest destinationRequest, Long groupId, List<String> taxNos) {
        if (groupId == null) {
            UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
            groupId = userInfo.getGroupId();
        }
        return this.deviceQueryPost2(destinationRequest, groupId, taxNos);
    }

    private QueryDeviceResponse deviceQueryPost2(QueryDeviceRequest destinationRequest, Long groupId, List<String> taxNos) {
        String subUrl = "/taxware/v1/hardware/devices/query";
        RestQueryDeviceRequest restQueryDeviceRequest = this.deviceConverter.convertQueryRequestToRest(destinationRequest);
        String serialNo = String.valueOf(this.idGenerator.nextId());
        logger.info("\u67e5\u8be2\u8bbe\u5907\u8bf7\u6c42\u6d41\u6c34\u53f7:{}", (Object)serialNo);
        restQueryDeviceRequest.setSerialNo(serialNo);
        if (taxNos != null && restQueryDeviceRequest.getQueryInfo().getCompanyInfo() != null) {
            restQueryDeviceRequest.getQueryInfo().getCompanyInfo().setTaxNos(taxNos);
        }
        RestQueryDeviceResponse restQueryDeviceResponse = (RestQueryDeviceResponse)this.restTemplateTools.postEntity((Object)restQueryDeviceRequest, groupId, subUrl, RestQueryDeviceResponse.class);
        QueryDeviceResponse queryDeviceResponse = new QueryDeviceResponse();
        this.convertQueryDeviceToResponse(restQueryDeviceResponse, queryDeviceResponse);
        return queryDeviceResponse;
    }

    public RestQueryDeviceResponse deviceQueryPost(RestQueryDeviceRequest destinationRequest) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        Long groupId = 0L;
        if (userInfo != null) {
            groupId = userInfo.getGroupId();
        }
        String subUrl = "/taxware/v1/hardware/devices/query";
        RestQueryDeviceResponse restQueryDeviceResponse = (RestQueryDeviceResponse)this.restTemplateTools.postEntity((Object)destinationRequest, groupId, subUrl, RestQueryDeviceResponse.class);
        return restQueryDeviceResponse;
    }

    public AddTerminalResponse deviceTerminalAddPost(AddTerminalRequest destinationRequest, Long groupId) {
        if (groupId == null) {
            UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
            groupId = userInfo.getGroupId();
        }
        String subUrl = "/taxware/v1/hardware/terminals";
        RestAddTerminalRequest restAddTerminalRequest = new RestAddTerminalRequest();
        this.convertAddTerminalRequest(destinationRequest, restAddTerminalRequest);
        RestAddTerminalResponse restAddTerminalResponse = (RestAddTerminalResponse)this.restTemplateTools.postEntity((Object)restAddTerminalRequest, groupId, subUrl, RestAddTerminalResponse.class);
        AddTerminalResponse addTerminalResponse = new AddTerminalResponse();
        this.convertAddTerminalResponse(restAddTerminalResponse, addTerminalResponse);
        return addTerminalResponse;
    }

    public UpdateTerminalStatusResponse deviceTerminalUpdateStatusPost(UpdateTerminalStatusRequest destinationRequest) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        Long groupId = userInfo.getGroupId();
        String subUrl = "/taxware/v1/hardware/terminals";
        RestUpdateTerminalStatusRequest restUpdateTerminalStatusRequest = new RestUpdateTerminalStatusRequest();
        this.convertUpdateTerminalStatusRequest(destinationRequest, restUpdateTerminalStatusRequest);
        RestUpdateTerminalStatusResponse restUpdateTerminalStatusResponse = (RestUpdateTerminalStatusResponse)this.restTemplateTools.patchEntity((Object)restUpdateTerminalStatusRequest, groupId, subUrl, RestUpdateTerminalStatusResponse.class);
        UpdateTerminalStatusResponse sourceResponse = new UpdateTerminalStatusResponse();
        this.convertUpdateTerminalStatusResponse(restUpdateTerminalStatusResponse, sourceResponse);
        return sourceResponse;
    }

    public UpdateTerminalResponse deviceTerminalUpdatePost(UpdateTerminalRequest destinationRequest, Long groupId) {
        if (groupId == null) {
            UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
            groupId = userInfo.getGroupId();
        }
        String subUrl = "/taxware/v1/hardware/terminals";
        RestUpdateTerminalRequest restUpdateTerminalRequest = new RestUpdateTerminalRequest();
        this.convertUpdateTerminalRequest(destinationRequest, restUpdateTerminalRequest);
        RestUpdateTerminalResponse restUpdateTerminalResponse = (RestUpdateTerminalResponse)this.restTemplateTools.putEntity((Object)restUpdateTerminalRequest, groupId, subUrl, RestUpdateTerminalResponse.class);
        UpdateTerminalResponse sourceResponse = new UpdateTerminalResponse();
        this.convertUpdateTerminalResponse(restUpdateTerminalResponse, sourceResponse);
        return sourceResponse;
    }

    public QueryTerminalResponse deviceTerminalQueryPost(QueryTerminalRequest request, Long groupId) {
        if (groupId == null) {
            UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
            groupId = userInfo.getGroupId();
        }
        String subUrl = "/taxware/v1/hardware/terminals/query";
        QueryTerminalResponse queryTerminalResponse = (QueryTerminalResponse)this.restTemplateTools.postEntity((Object)request, groupId, subUrl, QueryTerminalResponse.class);
        return queryTerminalResponse;
    }

    public QueryTerminalResponse deviceTerminalQueryPost(QueryTerminalRequest request, Long groupId, List<String> userCompanyTaxNos) {
        if (groupId == null) {
            UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
            groupId = userInfo.getGroupId();
        }
        String subUrl = "/taxware/v1/hardware/terminals/query";
        NewGetTerminalRequest restGetTerminalRequest = this.generateGetTerminalRequest(request, userCompanyTaxNos);
        logger.info("deviceTerminalQueryPost restGetTerminalRequest:{}", (Object)com.xforceplus.seller.config.util.JsonUtils.writeObjectToFastJson((Object)request));
        RestGetTerminalResponse restGetTerminalResponse = (RestGetTerminalResponse)this.restTemplateTools.postEntity((Object)restGetTerminalRequest, groupId, subUrl, RestGetTerminalResponse.class);
        QueryTerminalResponse queryTerminalResponse = new QueryTerminalResponse();
        this.convertGetTerminalToRestResponse(restGetTerminalResponse, queryTerminalResponse);
        return queryTerminalResponse;
    }

    public SendLicenseResponse deviceLicenseSendPost(SendLicenseRequest destinationRequest) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        Long groupId = 0L;
        if (userInfo != null) {
            groupId = userInfo.getGroupId();
        }
        String subUrl = "/taxware/v1/hardware/terminal/license-key/send";
        String adaptpath = "api/device/global";
        String path = this.gatewayProperties.getGlobalUrl() + adaptpath + subUrl;
        RestActiveCodeRequest restSendActiveCodeRequest = new RestActiveCodeRequest();
        this.convertSendActiveCodeToRestRequest(destinationRequest, restSendActiveCodeRequest);
        RestActiveCodeResponse restActvieCodeResponse = (RestActiveCodeResponse)this.restTemplateTools.postEntity((Object)restSendActiveCodeRequest, groupId, path, RestActiveCodeResponse.class);
        SendLicenseResponse sourceResponse = new SendLicenseResponse();
        this.convertActiveCodeToRestResponse(restActvieCodeResponse, sourceResponse);
        return sourceResponse;
    }

    private void convertActiveCodeToRestResponse(RestActiveCodeResponse restActvieCodeResponse, SendLicenseResponse sourceResponse) {
        ResponseHead responseHead = new ResponseHead();
        if (SUCESS.equals(restActvieCodeResponse.getCode())) {
            responseHead.setCode(Integer.valueOf(1));
            responseHead.setTraceId(restActvieCodeResponse.getTraceId());
            sourceResponse.setHead(responseHead);
        } else {
            responseHead.setCode(Integer.valueOf(-1));
            responseHead.setMessage(restActvieCodeResponse.getMessage());
            responseHead.setTraceId(restActvieCodeResponse.getTraceId());
            sourceResponse.setHead(responseHead);
        }
    }

    private void convertSendActiveCodeToRestRequest(SendLicenseRequest destinationRequest, RestActiveCodeRequest restSendActiveCodeRequest) {
        ArrayList sendList = Lists.newArrayList();
        String receiverEmail = destinationRequest.getReceiverEmail();
        String[] split = receiverEmail.split(",");
        for (int i = 0; i < split.length; ++i) {
            String email = split[i];
            SendEmailItem emailItem = new SendEmailItem();
            emailItem.setReceiverEmail(email);
            emailItem.setTerminalUn(destinationRequest.getUn());
            sendList.add(emailItem);
        }
        restSendActiveCodeRequest.setSendLicenseList((List)sendList);
    }

    private void convertGetTerminalToRestResponse(RestGetTerminalResponse restGetTerminalResponse, QueryTerminalResponse queryTerminalResponse) {
        if (SUCESS.equals(restGetTerminalResponse.getCode())) {
            queryTerminalResponse.setCode(SUCESS);
            ArrayList<TerminalQueryResponseInfo> terminals = new ArrayList<TerminalQueryResponseInfo>();
            if (restGetTerminalResponse.getResult() != null) {
                List list = restGetTerminalResponse.getResult().getTerminals();
                for (RestTerminalQueryResponseInfo info : list) {
                    TerminalQueryResponseInfo terminalQueryResponseInfo = new TerminalQueryResponseInfo();
                    BeanUtils.copyProperties((Object)info, (Object)terminalQueryResponseInfo);
                    if (info.getOnlineDevice() != null) {
                        OnlineDeviceInfo onlineDeviceInfo = new OnlineDeviceInfo();
                        onlineDeviceInfo.setDeviceUn(info.getOnlineDevice().getDeviceUn());
                        terminalQueryResponseInfo.setOnlineDevice(onlineDeviceInfo);
                    }
                    terminals.add(terminalQueryResponseInfo);
                }
            }
            QueryTerminalResult result = new QueryTerminalResult();
            result.setTerminals(terminals);
            result.setPageInfo(restGetTerminalResponse.getResult().getPageInfo());
            queryTerminalResponse.setResult(result);
        } else {
            queryTerminalResponse.setMessage(restGetTerminalResponse == null ? "\u67e5\u8be2\u9519\u8bef" : restGetTerminalResponse.getMessage());
            queryTerminalResponse.setCode("-1");
        }
    }

    private NewGetTerminalRequest generateGetTerminalRequest(QueryTerminalRequest request, List<String> userCompanyTaxNos) {
        NewTerminalQueryInfo terminalQueryInfo;
        NewGetTerminalRequest getTerminalRequest = new NewGetTerminalRequest();
        BeanMapper.copy((Object)request, (Object)getTerminalRequest);
        String serialNo = String.valueOf(this.idGenerator.nextId());
        logger.info("\u67e5\u8be2\u8bbe\u5907\u8bf7\u6c42\u6d41\u6c34\u53f7:{}", (Object)serialNo);
        getTerminalRequest.setSerialNo(serialNo);
        if (getTerminalRequest.getTerminalInfo() == null) {
            getTerminalRequest.setTerminalInfo(new NewTerminalQueryInfo());
        }
        if ((terminalQueryInfo = getTerminalRequest.getTerminalInfo()).getCompanyInfo() == null) {
            terminalQueryInfo.setCompanyInfo(new NewCompanyInfo());
        }
        NewCompanyInfo companyInfo = terminalQueryInfo.getCompanyInfo();
        companyInfo.setTaxNos(userCompanyTaxNos);
        return getTerminalRequest;
    }

    private void convertAddDeviceResponse(RestAddDeviceResponse restAddDeviceResponse, AddDeviceResponse addDeviceResponse) {
        ResponseHead responseHead = new ResponseHead();
        if (SUCESS.equals(restAddDeviceResponse.getCode())) {
            addDeviceResponse.setDeviceUn(restAddDeviceResponse.getResult().getDeviceUn());
            responseHead.setCode(Integer.valueOf(1));
            responseHead.setTraceId(restAddDeviceResponse.getResult().getTraceId());
            addDeviceResponse.setHead(responseHead);
        } else {
            responseHead.setCode(Integer.valueOf(-1));
            responseHead.setMessage(restAddDeviceResponse == null ? "\u65b0\u589e\u8bbe\u5907\u51fa\u9519\uff01" : restAddDeviceResponse.getMessage());
            addDeviceResponse.setHead(responseHead);
        }
    }

    private void convertUpdateDeviceResponse(RestUpdateDeviceResponse restUpdateDeviceResponse, UpdateDeviceResponse updateDeviceResponse) {
        ResponseHead responseHead = new ResponseHead();
        if (SUCESS.equals(restUpdateDeviceResponse.getCode())) {
            responseHead.setCode(Integer.valueOf(1));
            responseHead.setMessage("\u4fee\u6539\u6210\u529f");
            responseHead.setTraceId(restUpdateDeviceResponse.getResult().getTraceId());
            updateDeviceResponse.setHead(responseHead);
        } else {
            responseHead.setCode(Integer.valueOf(-1));
            responseHead.setMessage(restUpdateDeviceResponse != null ? restUpdateDeviceResponse.getMessage() : "\u4fee\u6539\u51fa\u9519");
            responseHead.setTraceId(restUpdateDeviceResponse.getTraceId());
            updateDeviceResponse.setHead(responseHead);
        }
    }

    private void convertQueryDeviceToResponse(RestQueryDeviceResponse restQueryDeviceResponse, QueryDeviceResponse queryDeviceResponse) {
        ResponseHead responseHead = new ResponseHead();
        if (SUCESS.equals(restQueryDeviceResponse.getCode())) {
            responseHead.setCode(Integer.valueOf(1));
            responseHead.setMessage("\u67e5\u8be2\u6210\u529f");
            responseHead.setTraceId(restQueryDeviceResponse.getResult().getTraceId());
            List restDeviceInfos = restQueryDeviceResponse.getResult().getDevices();
            if (restDeviceInfos != null && restDeviceInfos.size() > 0) {
                ArrayList devices = new ArrayList();
                restDeviceInfos.stream().forEach(restDeviceInfo -> {
                    DeviceInfo deviceInfo = new DeviceInfo();
                    BeanMapper.copy((Object)restDeviceInfo, (Object)deviceInfo);
                    devices.add(deviceInfo);
                });
                queryDeviceResponse.setDevices(devices);
            }
            queryDeviceResponse.setOnlineDeviceUns(restQueryDeviceResponse.getResult().getOnlineDeviceUns());
            queryDeviceResponse.setOriginAccountOnlineDeviceUns(restQueryDeviceResponse.getResult().getOriginAccountOnlineDeviceUns());
            queryDeviceResponse.setPageInfo(restQueryDeviceResponse.getResult().getPageInfo());
            queryDeviceResponse.setOnlineDeviceIds((List)Lists.newArrayList());
            queryDeviceResponse.setOriginAccountOnlineDeviceUns((List)Lists.newArrayList());
            queryDeviceResponse.setHead(responseHead);
        } else {
            responseHead.setCode(Integer.valueOf(-1));
            responseHead.setMessage("\u67e5\u8be2\u5931\u8d25");
            queryDeviceResponse.setHead(responseHead);
        }
    }

    private void convertAddTerminalResponse(RestAddTerminalResponse restAddTerminalResponse, AddTerminalResponse addTerminalResponse) {
        ResponseHead responseHead = new ResponseHead();
        if (SUCESS.equals(restAddTerminalResponse.getCode())) {
            responseHead.setCode(Integer.valueOf(1));
            responseHead.setMessage("");
            addTerminalResponse.setHead(responseHead);
            addTerminalResponse.setTerminalUn(restAddTerminalResponse.getResult().getTerminalUn());
        } else {
            responseHead.setCode(Integer.valueOf(-1));
            responseHead.setMessage(restAddTerminalResponse.getMessage());
            responseHead.setTraceId(restAddTerminalResponse.getTraceId());
            addTerminalResponse.setHead(responseHead);
        }
    }

    private void convertAddTerminalRequest(AddTerminalRequest destinationRequest, RestAddTerminalRequest restAddTerminalRequest) {
        String serialNo = String.valueOf(this.idGenerator.nextId());
        logger.info("\u65b0\u589e\u7ec8\u7aef\u8bf7\u6c42\u6d41\u6c34\u53f7:{}", (Object)serialNo);
        restAddTerminalRequest.setSerialNo(serialNo);
        restAddTerminalRequest.setLicenseInfo(destinationRequest.getLicenseInfo());
        restAddTerminalRequest.setTerminalInfo(destinationRequest.getTerminalInfo());
    }

    private void convertUpdateTerminalResponse(RestUpdateTerminalResponse restUpdateTerminalResponse, UpdateTerminalResponse updateTerminalResponse) {
        ResponseHead responseHead = new ResponseHead();
        if (SUCESS.equals(restUpdateTerminalResponse.getCode())) {
            responseHead.setCode(Integer.valueOf(1));
            responseHead.setMessage("\u4fee\u6539\u6210\u529f\uff01");
            updateTerminalResponse.setHead(responseHead);
        } else {
            responseHead.setCode(Integer.valueOf(-1));
            responseHead.setMessage(restUpdateTerminalResponse.getMessage());
            updateTerminalResponse.setHead(responseHead);
        }
    }

    private void convertUpdateTerminalRequest(UpdateTerminalRequest destinationRequest, RestUpdateTerminalRequest restUpdateTerminalRequest) {
        restUpdateTerminalRequest.setTerminalInfo(destinationRequest.getTerminalInfo());
        String serialNo = String.valueOf(this.idGenerator.nextId());
        logger.info("\u4fee\u6539\u7ec8\u7aef\u8bf7\u6c42\u6d41\u6c34\u53f7:{}", (Object)serialNo);
        restUpdateTerminalRequest.setSerialNo(serialNo);
    }

    private void convertUpdateDeviceStatusResponse(RestUpdateDeviceStatusResponse restUpdateDeviceStatusResponse, UpdateDeviceStatusResponse updateStatusResponse) {
        ResponseHead responseHead = new ResponseHead();
        if (SUCESS.equals(restUpdateDeviceStatusResponse.getCode())) {
            responseHead.setCode(Integer.valueOf(1));
            responseHead.setMessage("\u66f4\u65b0\u6210\u529f\uff01");
            updateStatusResponse.setHead(responseHead);
        } else {
            responseHead.setCode(Integer.valueOf(-1));
            responseHead.setMessage(restUpdateDeviceStatusResponse.getMessage());
            updateStatusResponse.setHead(responseHead);
        }
    }

    private void convertUpdateDeviceStatusRequest(UpdateDeviceStatusRequest updateStatusRequest, RestUpdateDeviceStatusRequest restUpdateDeviceStatusRequest) {
        restUpdateDeviceStatusRequest.setDeviceUns(updateStatusRequest.getDeviceUns());
        restUpdateDeviceStatusRequest.setDeviceId(updateStatusRequest.getDeviceId());
        restUpdateDeviceStatusRequest.setFromSystem(updateStatusRequest.getFromSystem());
        restUpdateDeviceStatusRequest.setLicenseInfo(updateStatusRequest.getLicenseInfo());
        restUpdateDeviceStatusRequest.setOperateInfo(updateStatusRequest.getOperateInfo());
        restUpdateDeviceStatusRequest.setRemark(updateStatusRequest.getRemark());
        restUpdateDeviceStatusRequest.setStatus(updateStatusRequest.getStatus());
        String serialNo = String.valueOf(this.idGenerator.nextId());
        logger.info("\u66f4\u65b0\u8bbe\u5907\u8bf7\u6c42\u6d41\u6c34\u53f7:{}", (Object)serialNo);
        restUpdateDeviceStatusRequest.setSerialNo(serialNo);
    }

    private void convertUpdateTerminalStatusResponse(RestUpdateTerminalStatusResponse restUpdateTerminalStatusResponse, UpdateTerminalStatusResponse sourceResponse) {
        ResponseHead responseHead = new ResponseHead();
        if (SUCESS.equals(restUpdateTerminalStatusResponse.getCode())) {
            responseHead.setCode(Integer.valueOf(1));
            responseHead.setMessage("\u4fee\u6539\u72b6\u6001\u6210\u529f");
            sourceResponse.setHead(responseHead);
        } else {
            responseHead.setCode(Integer.valueOf(-1));
            responseHead.setMessage(restUpdateTerminalStatusResponse.getMessage());
            sourceResponse.setHead(responseHead);
        }
    }

    private void convertUpdateTerminalStatusRequest(UpdateTerminalStatusRequest destinationRequest, RestUpdateTerminalStatusRequest restUpdateTerminalStatusRequest) {
        restUpdateTerminalStatusRequest.setFromSystem(destinationRequest.getFromSystem());
        restUpdateTerminalStatusRequest.setLicenseInfo(destinationRequest.getLicenseInfo());
        restUpdateTerminalStatusRequest.setOperateInfo(destinationRequest.getOperateInfo());
        restUpdateTerminalStatusRequest.setStatus(destinationRequest.getStatus());
        restUpdateTerminalStatusRequest.setTerminalUns(destinationRequest.getTerminalUns());
        restUpdateTerminalStatusRequest.setTerminalId(destinationRequest.getTerminalId());
        String serialNo = String.valueOf(this.idGenerator.nextId());
        logger.info("\u4fee\u6539\u7ec8\u7aef\u72b6\u6001\u8bf7\u6c42\u6d41\u6c34\u53f7:{}", (Object)serialNo);
        restUpdateTerminalStatusRequest.setSerialNo(serialNo);
    }

    public RestGetActiveResponse getActiveCode(String uns) {
        long groupId = 0L;
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        if (userInfo != null) {
            groupId = userInfo.getGroupId();
        }
        String subUrl = "/taxware/v1/hardware/terminal/license-key/query?terminalUns=";
        String[] split = uns.split(",");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            String s = split[i];
            if (i != split.length - 1) {
                stringBuilder.append(s).append(",");
                continue;
            }
            stringBuilder.append(s);
        }
        subUrl = subUrl + stringBuilder.toString();
        String adaptpath = "api/device/global";
        String path = this.gatewayProperties.getGlobalUrl() + adaptpath + subUrl;
        RestGetActiveResponse restGetActiveResponse = (RestGetActiveResponse)this.restTemplateTools.getEntity(null, Long.valueOf(groupId), path, RestGetActiveResponse.class);
        return restGetActiveResponse;
    }

    public RestSubscribeExtractResponse extractSubscribe(RestSubscribeExtractRequest request) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        Long groupId = userInfo.getGroupId();
        String subUrl = "/taxware/v1/hardware/device/extract-subscribe";
        RestSubscribeExtractResponse response2 = (RestSubscribeExtractResponse)this.restTemplateTools.postEntity((Object)request, groupId, subUrl, RestSubscribeExtractResponse.class);
        return response2;
    }

    public RestGetSubscribeResponse getGetSubscribeInfo(int extractType, String extractValue) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        Long groupId = userInfo.getGroupId();
        String subUrl = "/taxware/v1/hardware/device/extract-subscribe?extractType=" + extractType + "&extractValue=" + extractValue;
        RestGetSubscribeResponse response2 = (RestGetSubscribeResponse)this.restTemplateTools.getEntity(null, groupId, subUrl, RestGetSubscribeResponse.class);
        return response2;
    }

    public RestCancelExtractResponse cancelExtractSubscribe(RestCancelExtractRequest request) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        Long groupId = userInfo.getGroupId();
        String subUrl = "/taxware/v1/hardware/device/extract-subscribe";
        RestCancelExtractResponse response2 = (RestCancelExtractResponse)this.restTemplateTools.putEntity((Object)request, groupId, subUrl, RestCancelExtractResponse.class);
        return response2;
    }

    public RestSubscribeDeviceStockResponse deviceStockSubscribe(RestSubscribeDeviceStockRequest request) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        Long groupId = userInfo.getGroupId();
        String subUrl = "/taxware/v1/hardware/device-stock-subscribe";
        RestSubscribeDeviceStockResponse response2 = (RestSubscribeDeviceStockResponse)this.restTemplateTools.postEntity((Object)request, groupId, subUrl, RestSubscribeDeviceStockResponse.class);
        return response2;
    }

    public RestGetSubscribeDeviceStockResponse getDeviceStockSubscribeInfo(String deviceUn) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        if (userInfo == null) {
            RestGetSubscribeDeviceStockResponse inventoryResponse = new RestGetSubscribeDeviceStockResponse();
            inventoryResponse.setCode("0");
            return inventoryResponse;
        }
        Long groupId = userInfo.getGroupId();
        String subUrl = "/taxware/v1/hardware/device-stock-subscribe?deviceUn=" + deviceUn;
        RestGetSubscribeDeviceStockResponse response2 = (RestGetSubscribeDeviceStockResponse)this.restTemplateTools.getEntity(null, groupId, subUrl, RestGetSubscribeDeviceStockResponse.class);
        return response2;
    }

    public RestCancelDeviceStockResponse cancelInventorySubscribe(RestCancelDeviceStockRequest request) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        Long groupId = userInfo.getGroupId();
        String subUrl = "/taxware/v1/hardware/device-stock-subscribe";
        RestCancelDeviceStockResponse response2 = (RestCancelDeviceStockResponse)this.restTemplateTools.deleteEntity((Object)request, groupId, subUrl, RestCancelDeviceStockResponse.class);
        return response2;
    }

    public QueryDeviceQualificationsResponse getDeviceQualifications(RestDeviceQualificationRequest request, Long groupId) {
        if (StringUtils.isBlank((String)request.getTaxCodes())) {
            return null;
        }
        String subUrl = this.gatewayProperties.getGlobalUrl() + "api/device/" + groupId + "/taxware/v1/device/device-qualifications" + "?taxCodes=" + request.getTaxCodes();
        if (StringUtils.isNotBlank((String)request.getDeviceNos())) {
            subUrl = subUrl + "&deviceNos=" + request.getDeviceNos();
        }
        if (StringUtils.isNotBlank((String)request.getMis())) {
            subUrl = subUrl + "&mis=" + request.getMis();
        }
        QueryDeviceQualificationsResponse response2 = (QueryDeviceQualificationsResponse)this.restTemplateTools.getEntity(null, groupId, subUrl, QueryDeviceQualificationsResponse.class);
        return response2;
    }

    public List<RestInventoryData> queryInventory(RestQueryInventoryRequest request) {
        String subUrl = "api/device/{tenantCode}/taxware/v2/device/blank-invoices/inventories";
        try {
            ArrayList param = Lists.newArrayList();
            this.buildGetParam("invoiceServiceType", request.getInvoiceServiceType(), (List)param);
            this.buildGetParam("taxCodes", request.getTaxCodes(), (List)param);
            this.buildGetParam("deviceNos", request.getDeviceNos(), (List)param);
            this.buildGetParam("invoiceTypes", request.getInvoiceTypes(), (List)param);
            this.buildGetParam("terminalNo", request.getTerminalNo(), (List)param);
            String url = this.gatewayProperties.getGlobalUrl() + subUrl + "?" + String.join((CharSequence)"&", param);
            RestResponse body = (RestResponse)this.restTemplateRetryHelper.getEntity(url, this.restTemplateTools.getHeader(), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{((UserInfo)this.userInfoHolder.get()).getGroupId()}).getBody();
            logger.info("queryInventory reply:{}", (Object)JsonUtils.writeObjectToJson((Object)body));
            if (body != null && "TXWR000000".equals(body.getCode())) {
                return Optional.ofNullable(body.getResult()).map(RestInventoryReply::getInventoryList).orElse(Lists.newArrayList());
            }
        }
        catch (HttpStatusCodeException e) {
            logger.error("queryInventory fail:{}, {}", new Object[]{e.getMessage(), e.getResponseBodyAsString(), e});
        }
        catch (Exception e) {
            logger.error("queryInventory exception: {}", (Object)e.getMessage(), (Object)e);
        }
        return Lists.newArrayList();
    }

    private void buildGetParam(String key, String value, List<String> param) {
        if (StringUtils.isNotBlank((String)value)) {
            param.add(String.format("%s=%s", key, value));
        }
    }

    public GenerateCertificateResponse generateCerificatePost(GenerateCertificateRequest request) {
        String subUrl = "/global/taxware/v1/cherry/certificate/generate";
        logger.info("generateCerificatePost request: {} ", (Object)com.xforceplus.seller.config.util.JsonUtils.writeObjectToFastJson((Object)request));
        GenerateCertificateResponse response2 = (GenerateCertificateResponse)this.restTemplateTools.postCherryEntity((Object)request, subUrl, GenerateCertificateResponse.class);
        logger.info("generateCerificatePost response: {} ", (Object)com.xforceplus.seller.config.util.JsonUtils.writeObjectToFastJson((Object)response2));
        return response2;
    }
}

