/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.infrastructure.helper;

import com.xforceplus.seller.config.config.GatewayProperties;
import com.xforceplus.seller.config.infrastructure.cache.LocalCacheManager;
import com.xforceplus.seller.config.models.BusiTypeAndUserRelationResponse;
import com.xforceplus.seller.config.models.CommonResponse;
import com.xforceplus.seller.config.models.UserInfoFromUserCenterResponse;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;

@Component
public class RestTemplateRetryHelper {
    private static final Logger log = LoggerFactory.getLogger(RestTemplateRetryHelper.class);
    @Value(value="${rest.template.connect.timeout:30000}")
    private int connectTimeout;
    @Value(value="${rest.template.read.timeout:180000}")
    private int readTimeout;
    private final RestTemplate redditFeignRestTemplate;
    private final RestTemplate restTemplate;
    private final LocalCacheManager localCacheManager;
    private final GatewayProperties gatewayProperties;

    public RestTemplateRetryHelper(RestTemplate restTemplate, LocalCacheManager localCacheManager, GatewayProperties gatewayProperties) {
        this.restTemplate = restTemplate;
        this.localCacheManager = localCacheManager;
        this.gatewayProperties = gatewayProperties;
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setConnectTimeout(this.connectTimeout);
        requestFactory.setReadTimeout(this.readTimeout);
        requestFactory.setBufferRequestBody(false);
        this.redditFeignRestTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        List list = this.redditFeignRestTemplate.getMessageConverters();
        for (HttpMessageConverter httpMessageConverter : list) {
            if (!(httpMessageConverter instanceof StringHttpMessageConverter)) continue;
            ((StringHttpMessageConverter)httpMessageConverter).setDefaultCharset(Charset.forName("UTF8"));
            break;
        }
    }

    @Retryable(value={Exception.class}, backoff=@Backoff(delay=500L))
    public <T> ResponseEntity<T> postEntity(String url, String requestJson, HttpHeaders header, Class<T> responseClass) {
        HttpEntity requestEntity = new HttpEntity((Object)requestJson, (MultiValueMap)header);
        log.info("post\u8bf7\u6c42\u7a0e\u4ef6url:{}", (Object)url);
        log.info("\u8bf7\u6c42\u7a0e\u4ef6:\r\n{}", (Object)com.xforceplus.seller.config.util.JsonUtils.writeObjectToFastJson((Object)requestEntity));
        ResponseEntity responseEntity = this.redditFeignRestTemplate.postForEntity(url, (Object)requestEntity, responseClass, new Object[0]);
        if (!Optional.of(responseEntity).map(HttpEntity::getBody).isPresent()) {
            log.error("\u8bf7\u6c42\u7a0e\u4ef6\u7ed3\u679c\u5f02\u5e38 url {}, req {},header {}", new Object[]{url, requestJson, com.xforceplus.seller.config.util.JsonUtils.writeObjectToFastJson((Object)header)});
            throw new HttpServerErrorException(HttpStatus.BAD_REQUEST, "\u7a0e\u4ef6\u8bf7\u6c42\u5f02\u5e38");
        }
        return responseEntity;
    }

    @Retryable(value={Exception.class}, backoff=@Backoff(delay=500L))
    public <T, R extends CommonResponse> R postCherryEntity(String url, T request, HttpHeaders header, Class<R> tClass) {
        log.info("post cherry\u8bf7\u6c42\u7a0e\u4ef6url:{} request:{}", (Object)url, (Object)com.xforceplus.seller.config.util.JsonUtils.writeObjectToFastJson(request));
        HttpEntity requestEntity = new HttpEntity((Object)com.xforceplus.seller.config.util.JsonUtils.writeObjectToFastJson(request), (MultiValueMap)header);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, tClass, new Object[0]);
        CommonResponse body = (CommonResponse)responseEntity.getBody();
        log.info("traceId:{}", (Object)body.getTraceId());
        return (R)body;
    }

    @Retryable(value={Exception.class}, backoff=@Backoff(delay=500L))
    public <T, R> ResponseEntity<T> putEntity(String url, R request, HttpHeaders header, Class<T> responseClass) {
        log.info("put\u8bf7\u6c42\u7a0e\u4ef6url:{}", (Object)url);
        log.info("\u8bf7\u6c42\u7a0e\u4ef6:\r\n{}", (Object)com.xforceplus.seller.config.util.JsonUtils.writeObjectToFastJson(request));
        HttpEntity requestEntity = new HttpEntity(request, (MultiValueMap)header);
        return this.restTemplate.exchange(url, HttpMethod.PUT, requestEntity, responseClass, new Object[0]);
    }

    @Retryable(value={Exception.class}, backoff=@Backoff(delay=500L))
    public <T, R> ResponseEntity<T> patchEntity(String url, R request, HttpHeaders header, Class<T> responseClass) {
        log.info("patch\u8bf7\u6c42\u7a0e\u4ef6url:{}", (Object)url);
        String requestJson = com.xforceplus.seller.config.util.JsonUtils.writeObjectToFastJson(request);
        log.info("\u8bf7\u6c42\u7a0e\u4ef6:\r\n{}", (Object)requestJson);
        HttpEntity requestEntity = new HttpEntity(request, (MultiValueMap)header);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.PATCH, requestEntity, responseClass, new Object[0]);
        if (!Optional.of(responseEntity).map(HttpEntity::getBody).isPresent()) {
            log.error("\u8bf7\u6c42\u7a0e\u4ef6\u7ed3\u679c\u5f02\u5e38 req {},header {}", (Object)requestJson, (Object)com.xforceplus.seller.config.util.JsonUtils.writeObjectToFastJson((Object)header));
            throw new HttpServerErrorException(HttpStatus.BAD_REQUEST, "\u7a0e\u4ef6\u8bf7\u6c42\u5f02\u5e38");
        }
        return responseEntity;
    }

    @Retryable(value={Exception.class}, backoff=@Backoff(delay=500L))
    public <T, R> ResponseEntity<T> getEntity(String url, R request, HttpHeaders header, Class<T> responseClass) {
        log.info("get\u8bf7\u6c42\u7a0e\u4ef6url:{}", (Object)url);
        String requestJson = com.xforceplus.seller.config.util.JsonUtils.writeObjectToFastJson(request);
        log.info("\u8bf7\u6c42\u7a0e\u4ef6:\r\n{}", (Object)requestJson);
        HttpEntity requestEntity = new HttpEntity(request, (MultiValueMap)header);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, responseClass, new Object[0]);
        if (!Optional.of(responseEntity).map(HttpEntity::getBody).isPresent()) {
            log.error("\u8bf7\u6c42\u7a0e\u4ef6\u7ed3\u679c\u5f02\u5e38 req {},header {}", (Object)requestJson, (Object)com.xforceplus.seller.config.util.JsonUtils.writeObjectToFastJson((Object)header));
            throw new HttpServerErrorException(HttpStatus.BAD_REQUEST, "\u7a0e\u4ef6\u8bf7\u6c42\u5f02\u5e38");
        }
        return responseEntity;
    }

    @Retryable(value={Exception.class}, backoff=@Backoff(delay=500L))
    public <R> ResponseEntity<R> getEntity(String url, HttpHeaders header, ParameterizedTypeReference<R> responseClass, Object ... uriVariables) {
        log.info("get\u8bf7\u6c42\u7a0e\u4ef6url:{}", (Object)url);
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)header);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, responseClass, uriVariables);
        if (!Optional.of(responseEntity).map(HttpEntity::getBody).isPresent()) {
            log.error("\u8bf7\u6c42\u7a0e\u4ef6\u7ed3\u679c\u5f02\u5e38header {}", (Object)com.xforceplus.seller.config.util.JsonUtils.writeObjectToFastJson((Object)header));
            throw new HttpServerErrorException(HttpStatus.BAD_REQUEST, "\u7a0e\u4ef6\u8bf7\u6c42\u5f02\u5e38");
        }
        return responseEntity;
    }

    @Retryable(value={Exception.class}, backoff=@Backoff(delay=500L))
    public <T, R> ResponseEntity<T> deleteEntity(String url, R request, HttpHeaders header, Class<T> responseClass) {
        log.info("delete\u8bf7\u6c42\u7a0e\u4ef6url:{}", (Object)url);
        String requestJson = com.xforceplus.seller.config.util.JsonUtils.writeObjectToFastJson(request);
        log.info("\u8bf7\u6c42\u7a0e\u4ef6:\r\n{}", (Object)requestJson);
        HttpEntity requestEntity = new HttpEntity(request, (MultiValueMap)header);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.DELETE, requestEntity, responseClass, new Object[0]);
        if (!Optional.of(responseEntity).map(HttpEntity::getBody).isPresent()) {
            log.error("\u8bf7\u6c42\u7a0e\u4ef6\u7ed3\u679c\u5f02\u5e38 req {},header {}", (Object)requestJson, (Object)com.xforceplus.seller.config.util.JsonUtils.writeObjectToFastJson((Object)header));
            throw new HttpServerErrorException(HttpStatus.BAD_REQUEST, "\u7a0e\u4ef6\u8bf7\u6c42\u5f02\u5e38");
        }
        return responseEntity;
    }

    @Retryable(value={Exception.class}, backoff=@Backoff(delay=500L))
    public <T, R> R postWithUserCenterToken(String subUrl, T request, Class<R> responseClass, Object ... params) {
        String url = this.gatewayProperties.getMessageUrl() + subUrl;
        HttpHeaders headers = this.getUserCenterHeader();
        HttpEntity httpEntity = new HttpEntity(request, (MultiValueMap)headers);
        log.info("postWithUserCenterToken url:{}, request:{}", (Object)url, (Object)com.xforceplus.seller.config.util.JsonUtils.writeObjectToFastJson(request));
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, responseClass, params);
        log.info("postWithUserCenterToken responseEntity:{}", (Object)com.xforceplus.seller.config.util.JsonUtils.writeObjectToFastJson((Object)responseEntity));
        return (R)responseEntity.getBody();
    }

    @Retryable(value={Exception.class}, backoff=@Backoff(delay=500L))
    public <R> R getWithPaasToken(String url, Class<R> responseClass, Object ... params) {
        HttpHeaders headers = this.getPaasHeader();
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        log.info("postWithUserCenterToken url:{}, params:{}", (Object)url, (Object)com.xforceplus.seller.config.util.JsonUtils.writeObjectToFastJson((Object)params));
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, responseClass, params);
        log.info("postWithUserCenterToken responseEntity:{}", (Object)com.xforceplus.seller.config.util.JsonUtils.writeObjectToFastJson((Object)responseEntity));
        return (R)responseEntity.getBody();
    }

    @Retryable(value={Exception.class}, backoff=@Backoff(delay=500L))
    public <R> R getWithPaasToken(String url, ParameterizedTypeReference<R> responseClass, Object ... params) {
        HttpHeaders headers = this.getPaasHeader();
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        log.info("postWithUserCenterToken url:{}, params:{}", (Object)url, (Object)com.xforceplus.seller.config.util.JsonUtils.writeObjectToFastJson((Object)params));
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, responseClass, params);
        log.info("postWithUserCenterToken responseEntity:{}", (Object)com.xforceplus.seller.config.util.JsonUtils.writeObjectToFastJson((Object)responseEntity));
        return (R)responseEntity.getBody();
    }

    @Retryable(value={Exception.class}, backoff=@Backoff(delay=500L))
    public <T, R> R postWithPaasToken(String url, T request, ParameterizedTypeReference<R> responseClass, Object ... params) {
        HttpHeaders headers = this.getPaasHeader();
        HttpEntity httpEntity = new HttpEntity(request, (MultiValueMap)headers);
        log.info("postWithPaasToken url:{}, request:{}", (Object)url, (Object)com.xforceplus.seller.config.util.JsonUtils.writeObjectToFastJson(request));
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, responseClass, params);
        log.info("postWithPaasToken responseEntity:{}", (Object)com.xforceplus.seller.config.util.JsonUtils.writeObjectToFastJson((Object)responseEntity));
        return (R)responseEntity.getBody();
    }

    public HttpHeaders getUserCenterHeader() {
        return this.getHeader(() -> this.localCacheManager.getAccessToken(this.gatewayProperties.getMessageClientId(), this.gatewayProperties.getMessageSecret(), this.gatewayProperties.getMessageLoginUrl()));
    }

    public HttpHeaders getPaasHeader() {
        return this.getHeader(() -> this.localCacheManager.getAccessToken(this.gatewayProperties.getClientId(), this.gatewayProperties.getSecret(), this.gatewayProperties.getLoginUrl()));
    }

    public HttpHeaders getHeader(Supplier<String> tokenSupplier) {
        String token = tokenSupplier.get();
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.add("Content-Type", "application/json");
        requestHeaders.add("x-app-token", token);
        return requestHeaders;
    }

    public <T, R extends BusiTypeAndUserRelationResponse> R putForUserCenter(String subUrl, String groupId, String userId, T request, Class<R> responseClass, String methodName) {
        String url = this.gatewayProperties.getGlobalUrl() + subUrl;
        log.info("{}\u7684put\u8bf7\u6c42\u7edf\u4e00\u95e8\u6237url:{}, groupId:{}, userId:{},request:{}", new Object[]{methodName, url, groupId, userId, JsonUtils.writeObjectToFastJson(request)});
        HttpEntity requestEntity = new HttpEntity((Object)JsonUtils.writeObjectToFastJson(request), (MultiValueMap)this.getPaasHeader());
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.PUT, requestEntity, responseClass, new Object[]{groupId, userId});
        BusiTypeAndUserRelationResponse body = (BusiTypeAndUserRelationResponse)responseEntity.getBody();
        return (R)body;
    }

    @Retryable(value={Exception.class}, backoff=@Backoff(delay=500L))
    public <R extends UserInfoFromUserCenterResponse> R getForUserCenter(String url, Class<R> responseClass, String methodName) {
        url = this.gatewayProperties.getGlobalUrl() + url;
        log.info("{}\u7684get\u8bf7\u6c42url:{}", (Object)methodName, (Object)url);
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.getUserCenterHeader());
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, responseClass, new Object[0]);
        return (R)((UserInfoFromUserCenterResponse)responseEntity.getBody());
    }
}

