/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.infrastructure.helper;

import com.xforceplus.seller.config.config.GatewayProperties;
import com.xforceplus.seller.config.infrastructure.cache.LocalCacheManager;
import com.xforceplus.seller.config.infrastructure.helper.RestTemplateRetryHelper;
import com.xforceplus.seller.config.models.BusiTypeAndUserRelationResponse;
import com.xforceplus.seller.config.models.CommonResponse;
import com.xforceplus.seller.config.models.RestResponse;
import com.xforceplus.seller.config.models.UserInfoFromUserCenterResponse;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpStatusCodeException;

@Component
public class RestTemplateTools {
    private static final Logger logger = LoggerFactory.getLogger(RestTemplateTools.class);
    @Autowired
    private LocalCacheManager localCacheManager;
    @Value(value="${goods.base.url:http://paas-t.xforceplus.com/api/}")
    private String goodsBaseUrl;
    private final RestTemplateRetryHelper restTemplateRetryHelper;
    private final GatewayProperties gatewayProperties;

    public RestTemplateTools(RestTemplateRetryHelper restTemplateRetryHelper, GatewayProperties gatewayProperties) {
        this.restTemplateRetryHelper = restTemplateRetryHelper;
        this.gatewayProperties = gatewayProperties;
    }

    public <T extends CommonResponse> T postEntity(Object req, Long groupId, String subUrl, Class<T> tClass) {
        String url = subUrl;
        if (!subUrl.startsWith("http")) {
            url = this.gatewayProperties.getBaseUrl() + groupId + subUrl;
        }
        String reqStr = com.xforceplus.seller.config.util.JsonUtils.writeObjectToFastJson((Object)req);
        try {
            HttpHeaders header = this.getHeader();
            logger.info("\u8bf7\u6c42\u7a0e\u4ef6\u7ed3\u679ctResponseEntity url {}  reqStr {}", (Object)url, (Object)reqStr);
            ResponseEntity tResponseEntity = this.restTemplateRetryHelper.postEntity(url, reqStr, header, tClass);
            logger.info("\u8bf7\u6c42\u7a0e\u4ef6\u7ed3\u679ctResponseEntity {}", (Object)com.xforceplus.seller.config.util.JsonUtils.writeObjectToFastJson((Object)tResponseEntity));
            CommonResponse body = (CommonResponse)tResponseEntity.getBody();
            body.setCode("1");
            return (T)body;
        }
        catch (Exception e) {
            return (T)this.getFailResponse(tClass, e, subUrl);
        }
    }

    public <T extends CommonResponse> T postEntity(Object req, String subUrl, Class<T> tClass) {
        String url = subUrl;
        if (!subUrl.startsWith("http")) {
            url = this.gatewayProperties.getGlobalUrl() + subUrl;
        }
        String reqStr = com.xforceplus.seller.config.util.JsonUtils.writeObjectToFastJson((Object)req);
        try {
            HttpHeaders header = this.getHeader();
            logger.info("\u8bf7\u6c42\u7a0e\u4ef6\u7ed3\u679ctResponseEntity url {}  reqStr {}", (Object)url, (Object)reqStr);
            ResponseEntity tResponseEntity = this.restTemplateRetryHelper.postEntity(url, reqStr, header, tClass);
            logger.info("\u8bf7\u6c42\u7a0e\u4ef6\u7ed3\u679ctResponseEntity {}", (Object)com.xforceplus.seller.config.util.JsonUtils.writeObjectToFastJson((Object)tResponseEntity));
            CommonResponse body = (CommonResponse)tResponseEntity.getBody();
            body.setCode("1");
            return (T)body;
        }
        catch (Exception e) {
            return (T)this.getFailResponse(tClass, e, subUrl);
        }
    }

    public <T, R extends CommonResponse> R postCherryEntity(T req, String subUrl, Class<R> tClass) {
        String url = this.gatewayProperties.getCherryUrl() + subUrl;
        try {
            return (R)this.restTemplateRetryHelper.postCherryEntity(url, req, this.getHeader(), tClass);
        }
        catch (HttpStatusCodeException e) {
            return (R)this.getFailResponse(tClass, (Exception)((Object)e), subUrl);
        }
    }

    public <T extends CommonResponse> T putEntity(Object req, Long groupId, String subUrl, Class<T> tClass) {
        String req_url = this.gatewayProperties.getBaseUrl() + groupId + subUrl;
        try {
            ResponseEntity exchange2 = this.restTemplateRetryHelper.putEntity(req_url, req, this.getHeader(), tClass);
            CommonResponse body = (CommonResponse)exchange2.getBody();
            body.setCode("1");
            return (T)body;
        }
        catch (Exception e) {
            return (T)this.getFailResponse(tClass, e, subUrl);
        }
    }

    public <T extends CommonResponse> T patchEntity(Object req, Long groupId, String subUrl, Class<T> tClass) {
        String req_url = this.gatewayProperties.getBaseUrl() + groupId + subUrl;
        try {
            ResponseEntity exchange2 = this.restTemplateRetryHelper.patchEntity(req_url, req, this.getHeader(), tClass);
            CommonResponse body = (CommonResponse)exchange2.getBody();
            body.setCode("1");
            return (T)body;
        }
        catch (Exception e) {
            return (T)this.getFailResponse(tClass, e, subUrl);
        }
    }

    public <T extends CommonResponse> T getEntity(Object req, Long groupId, String subUrl, Class<T> tClass) {
        String req_url = subUrl;
        if (!subUrl.startsWith("http")) {
            req_url = this.gatewayProperties.getBaseUrl() + groupId + subUrl;
        }
        try {
            ResponseEntity exchange2 = this.restTemplateRetryHelper.getEntity(req_url, req, this.getHeader(), tClass);
            CommonResponse body = (CommonResponse)exchange2.getBody();
            body.setCode("1");
            return (T)body;
        }
        catch (Exception e) {
            return (T)this.getFailResponse(tClass, e, subUrl);
        }
    }

    public <T extends CommonResponse> T deleteEntity(Object req, Long groupId, String subUrl, Class<T> tClass) {
        String req_url = subUrl;
        if (!subUrl.startsWith("http")) {
            req_url = this.gatewayProperties.getBaseUrl() + groupId + subUrl;
        }
        try {
            ResponseEntity exchange2 = this.restTemplateRetryHelper.deleteEntity(req_url, req, this.getHeader(), tClass);
            CommonResponse body = (CommonResponse)exchange2.getBody();
            body.setCode("1");
            return (T)body;
        }
        catch (Exception e) {
            return (T)this.getFailResponse(tClass, e, subUrl);
        }
    }

    public <T extends CommonResponse> T deleteEntity(Object req, String subUrl, Class<T> tClass) {
        String url = subUrl;
        if (!subUrl.startsWith("http")) {
            url = this.gatewayProperties.getGlobalUrl() + subUrl;
        }
        try {
            ResponseEntity exchange2 = this.restTemplateRetryHelper.deleteEntity(url, req, this.getHeader(), tClass);
            CommonResponse body = (CommonResponse)exchange2.getBody();
            body.setCode("1");
            return (T)body;
        }
        catch (Exception e) {
            return (T)this.getFailResponse(tClass, e, subUrl);
        }
    }

    public <T extends CommonResponse> T getFailResponse(Class<T> tClass, Exception e, String req_url) {
        try {
            CommonResponse t = (CommonResponse)tClass.newInstance();
            if (e instanceof HttpStatusCodeException) {
                String data = ((HttpStatusCodeException)((Object)e)).getResponseBodyAsString();
                CommonResponse commonResponse = (CommonResponse)com.xforceplus.seller.config.util.JsonUtils.writeFastJsonToObject((String)data, CommonResponse.class);
                if (Objects.nonNull(commonResponse)) {
                    t.setCode(commonResponse.getCode());
                    t.setMessage(commonResponse.getMessage());
                    t.setTraceId(commonResponse.getTraceId());
                }
                logger.info("\u8bf7\u6c42\u7a0e\u4ef6url:{},\u5931\u8d25\u539f\u56e0:{}", (Object)req_url, (Object)e.getMessage());
            } else {
                logger.error("\u8bf7\u6c42\u7a0e\u4ef6url\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                t.setCode("-1");
                t.setMessage(e.getMessage());
            }
            return (T)t;
        }
        catch (InstantiationException e1) {
            logger.error("\u8f6c\u6362\u5931\u8d25\u6d88\u606f\u5f02\u5e38InstantiationException", (Throwable)e);
        }
        catch (IllegalAccessException e1) {
            logger.error("\u8f6c\u6362\u5931\u8d25\u6d88\u606f\u5f02\u5e38IllegalAccessException", (Throwable)e);
        }
        return null;
    }

    public HttpHeaders getHeader() {
        return this.restTemplateRetryHelper.getHeader(() -> this.localCacheManager.getAccessToken(this.gatewayProperties.getClientId(), this.gatewayProperties.getSecret(), this.gatewayProperties.getLoginUrl()));
    }

    public String getTaxCodeUrl(String subUrl) {
        return this.goodsBaseUrl + subUrl;
    }

    public <T, R> RestResponse<R> getFromTaxWare(String subUrl, ParameterizedTypeReference<RestResponse<R>> responseClass, Object ... urlVariable) {
        String url = subUrl;
        if (!subUrl.startsWith("http")) {
            url = this.gatewayProperties.getGlobalUrl() + subUrl;
        }
        try {
            ResponseEntity exchange2 = this.restTemplateRetryHelper.getEntity(url, this.getHeader(), responseClass, urlVariable);
            return (RestResponse)exchange2.getBody();
        }
        catch (Exception e) {
            return this.getFailResponse(e, subUrl);
        }
    }

    public <R> RestResponse<R> getFailResponse(Exception e, String reqUrl) {
        try {
            RestResponse t = new RestResponse();
            if (e instanceof HttpStatusCodeException) {
                String data = ((HttpStatusCodeException)((Object)e)).getResponseBodyAsString();
                CommonResponse commonResponse = (CommonResponse)com.xforceplus.seller.config.util.JsonUtils.writeFastJsonToObject((String)data, CommonResponse.class);
                if (Objects.nonNull(commonResponse)) {
                    t.setCode(commonResponse.getCode());
                    t.setMessage(commonResponse.getMessage());
                    t.setTraceId(commonResponse.getTraceId());
                }
                logger.info("\u8bf7\u6c42\u7a0e\u4ef6url:{},\u5931\u8d25\u539f\u56e0:{}", (Object)reqUrl, (Object)e.getMessage());
            } else {
                logger.error("\u8bf7\u6c42\u7a0e\u4ef6url\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                t.setCode("-1");
                t.setMessage(e.getMessage());
            }
            return t;
        }
        catch (Exception e1) {
            logger.error("\u8f6c\u6362\u5931\u8d25\u6d88\u606f\u5f02\u5e38InstantiationException", (Throwable)e);
            return null;
        }
    }

    public <T, R extends BusiTypeAndUserRelationResponse> R putEntity(T req, String groupId, String userId, String subUrl, Class<R> responseClass) {
        try {
            return (R)this.restTemplateRetryHelper.putForUserCenter(subUrl, groupId, userId, req, responseClass, "putEntity");
        }
        catch (HttpStatusCodeException e) {
            logger.error("putEntity exception: {}, {}, {}", new Object[]{JsonUtils.writeObjectToJson(req), e.getMessage(), e});
            return null;
        }
    }

    public <T extends UserInfoFromUserCenterResponse> T getFromUserCenter(String url, Class<T> tClass) {
        try {
            return (T)this.restTemplateRetryHelper.getForUserCenter(url, tClass, "getEntity");
        }
        catch (HttpStatusCodeException e) {
            logger.error("getForUserCenter exception: {}, {}, {}", new Object[]{url, e.getMessage(), e});
            return null;
        }
    }
}

