/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.infrastructure.job;

import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.seller.config.config.GatewayProperties;
import com.xforceplus.seller.config.config.InventorySendEmailProperties;
import com.xforceplus.seller.config.converters.InventoryConfigConverter;
import com.xforceplus.seller.config.infrastructure.helper.RestTemplateRetryHelper;
import com.xforceplus.seller.config.models.MsEmailRequest;
import com.xforceplus.seller.config.models.MsMailResponse;
import com.xforceplus.seller.config.repository.model.CfgConfigInventoryReceiverEntity;
import com.xforceplus.seller.config.repository.model.LogNoticeEventEntity;
import com.xforceplus.seller.config.services.ConfigLogDataService;
import com.xforceplus.seller.config.util.JsonUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SendInvoiceMailService {
    private static final Logger log = LoggerFactory.getLogger(SendInvoiceMailService.class);
    private final IDGenerator idGenerator;
    private final InventoryConfigConverter inventoryConfigConverter;
    private final InventorySendEmailProperties inventorySendEmailProperties;
    private final RestTemplateRetryHelper restTemplateRetryHelper;
    private final GatewayProperties gatewayProperties;
    private final ConfigLogDataService configLogDataService;

    public SendInvoiceMailService(InventoryConfigConverter inventoryConfigConverter, InventorySendEmailProperties inventorySendEmailProperties, RestTemplateRetryHelper restTemplateRetryHelper, GatewayProperties gatewayProperties, ConfigLogDataService configLogDataService, IDGenerator idGenerator) {
        this.inventoryConfigConverter = inventoryConfigConverter;
        this.inventorySendEmailProperties = inventorySendEmailProperties;
        this.restTemplateRetryHelper = restTemplateRetryHelper;
        this.gatewayProperties = gatewayProperties;
        this.configLogDataService = configLogDataService;
        this.idGenerator = idGenerator;
    }

    private boolean sendMail(MsEmailRequest request) {
        request.setAppId(this.gatewayProperties.getAppId());
        request.setTenantId(Long.valueOf(0L));
        log.info("\u5b9a\u65f6\u53d1\u9001\u90ae\u4ef6\u8bf7\u6c42\u4e2d\u53f0:{}", (Object)JsonUtils.writeObjectToFastJson((Object)request));
        String subUrl = "/{tenantId}/message/v1/email";
        try {
            MsMailResponse response2 = (MsMailResponse)this.restTemplateRetryHelper.postWithUserCenterToken(subUrl, (Object)request, MsMailResponse.class, new Object[]{0L});
            log.info("\u90ae\u4ef6\u53d1\u9001\u8fd4\u56de\u7ed3\u679c:{}", (Object)JsonUtils.writeObjectToFastJson((Object)response2));
            if (1 == response2.getCode() && CollectionUtils.isNotEmpty((Collection)request.getReceiverList())) {
                this.configLogDataService.batchInsert(request.getReceiverList().stream().map(receiver -> {
                    LogNoticeEventEntity entity = new LogNoticeEventEntity();
                    entity.setId(Long.valueOf(this.idGenerator.nextId()));
                    entity.setBatchNo(request.getBatchNo());
                    entity.setChannel("mail");
                    entity.setCreateTime(new Date());
                    entity.setReceiver(receiver.getReceiver());
                    return entity;
                }).collect(Collectors.toList()));
                return true;
            }
        }
        catch (Exception e) {
            log.error("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25, bean: {}, \u5f02\u5e38\u8be6\u60c5:{}", new Object[]{request, e.getMessage(), e});
        }
        return false;
    }

    public boolean sendInventoryWarnEmail(String companyName, Map<String, Object> properties, List<CfgConfigInventoryReceiverEntity> receiverEntityList) {
        MsEmailRequest request = new MsEmailRequest();
        request.setReceiverList(this.inventoryConfigConverter.convertReceiver(receiverEntityList));
        request.setSenderName(this.inventorySendEmailProperties.getSenderName());
        request.setSubject(companyName + "\u53d1\u7968\u5e93\u5b58\u7528\u5c3d\u9884\u8b66");
        request.setTemplateCode(this.inventorySendEmailProperties.getTemplateCode());
        request.setProps(properties);
        return this.sendMail(request);
    }
}

