/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.listeners;

import com.xforceplus.micro.tax.device.contract.model.QualificationInfo;
import com.xforceplus.seller.config.task.handler.DeviceAmountLimitHandler;
import com.xforceplus.seller.config.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeviceAmountLimitListener {
    private static final Logger logger = LoggerFactory.getLogger(DeviceAmountLimitListener.class);
    @Autowired
    private DeviceAmountLimitHandler deviceAmountLimitHandler;

    @RabbitListener(queuesToDeclare={@Queue(value="taxware_device_qualifications")}, concurrency="3", errorHandler="mqErrorHandler")
    public void handleMsg(Message message) {
        try {
            String data = new String(message.getBody());
            QualificationInfo info = (QualificationInfo)JsonUtils.writeFastJsonToObject((String)data, QualificationInfo.class);
            this.deviceAmountLimitHandler.updateSplitLimit(info);
        }
        catch (Exception e) {
            logger.error("\u5f00\u5361\u540c\u6b65\u9650\u989d\u5f02\u5e38", (Throwable)e);
        }
    }
}

