/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.listeners;

import com.xforceplus.micro.tax.device.contract.model.GoodsRequest;
import com.xforceplus.phoenix.infrastructure.usercenter.controllers.UserCenterController;
import com.xforceplus.phoenix.infrastructure.usercenter.model.CompanyData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserCenterResponse;
import com.xforceplus.phoenix.sqs.SQSSender;
import com.xforceplus.seller.config.util.CommonTools;
import com.xforceplus.seller.config.util.JsonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.wicp.tams.common.Result;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GoodsImportListener {
    private static final Logger logger = LoggerFactory.getLogger(GoodsImportListener.class);
    @Autowired
    private UserCenterController userCenterController;

    @RabbitListener(queuesToDeclare={@Queue(value="phoenix.sku.import")}, concurrency="3", errorHandler="mqErrorHandler")
    public void handleMsg(Message message) {
        try {
            Map headers = message.getMessageProperties().getHeaders();
            String data = new String(message.getBody());
            String msg = this.convertGoods(data);
            String importBatchNo = String.valueOf(headers.get("importBatchNo"));
            HashMap<String, String> property = new HashMap<String, String>();
            property.put("opUserName", String.valueOf(headers.get("userName")));
            property.put("opUserId", String.valueOf(headers.get("userId")));
            property.put("tenantId", String.valueOf(headers.get("groupId")));
            property.put("messageId", importBatchNo);
            property.put("isCover", "1");
            property.put("appId", "20");
            logger.info("\u5546\u54c1\u5bfc\u5165\uff0c\u8f6c\u6362\u524dsku:{},headers:{}\uff0c\u8f6c\u6362\u540egoods:{},properties:{}", new Object[]{data, JsonUtils.writeObjectToFastJson((Object)headers), msg, JsonUtils.writeObjectToFastJson(property)});
            Result result = SQSSender.sendStrMsg((String)"goods-manager-import-deal", (String)msg, property, (boolean)true);
            if (!result.isSuc()) {
                throw new RuntimeException("\u5546\u54c1\u629b\u5165\u4e2d\u53f0sqs\u5931\u8d25\uff0cbatchNo:" + importBatchNo);
            }
            logger.info("\u5546\u54c1\u5bfc\u5165\u6210\u529f\uff0cbatchNo:{},messageId:{}", (Object)importBatchNo, (Object)result.getMessage());
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u5546\u54c1\u5931\u8d25", (Throwable)e);
        }
    }

    private String convertGoods(String data) {
        List goods = JsonUtils.writeFastJsonToListObject((String)data, GoodsRequest.class);
        ArrayList requestMap = new ArrayList();
        goods.stream().forEach(v -> {
            if (!CommonTools.isEmpty((String)v.getCoopGoodsNo())) {
                v.setCoopTaxCode(v.getTaxCode());
                v.setCoopTaxcodeName(v.getTaxcodeName());
                v.setCoopTaxcodeShortName(v.getTaxcodeShortName());
                v.setCoopTaxPre(v.getTaxPre());
                v.setCoopTaxPreCon(v.getTaxPreCon());
                v.setCoopZeroTax(v.getZeroTax());
                v.setCoopTaxRate(v.getTaxRate());
                v.setCoopSpecification(v.getSpecification());
                v.setCoopPriceMethod(v.getPriceMethod());
                v.setCoopUnitPrice(v.getUnitPrice());
                v.setCoopQuantityUnit(v.getQuantityUnit());
                v.setQuantityUnit("");
                v.setUnitPrice("");
                v.setPriceMethod("");
                v.setSpecification("");
                v.setTaxcodeName("");
                v.setTaxCode("");
                v.setTaxRate("");
                v.setTaxPre("");
                v.setTaxcodeShortName("");
                v.setTaxPreCon("");
                v.setZeroTax("");
            }
            if (!CommonTools.isEmpty((String)v.getCompanyTaxNo())) {
                UserCenterResponse companyDataResponse = this.userCenterController.getCompanyByTaxNo(0L, v.getCompanyTaxNo());
                Optional.ofNullable(companyDataResponse.getResult()).map(CompanyData::getCompanyId).ifPresent(arg_0 -> ((GoodsRequest)v).setCompanyId(arg_0));
            }
            Map map = JsonUtils.writeFastJsonToMap((String)JsonUtils.writeObjectToFastJson((Object)v));
            map.entrySet().removeIf(entry -> StringUtils.equals((CharSequence)String.valueOf(entry.getValue()), (CharSequence)""));
            requestMap.add(map);
        });
        return JsonUtils.writeObjectToFastJson(requestMap);
    }
}

