/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.listeners;

import com.xforceplus.seller.config.listeners.InventoryConfigImportListener;
import com.xforceplus.seller.config.models.OriginInventoryConfigImportData;
import com.xforceplus.seller.config.services.ConfigInventoryService;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/xforceplus/seller/config/listeners/InventoryConfigImportListener;", "", "configInventoryService", "Lcom/xforceplus/seller/config/services/ConfigInventoryService;", "(Lcom/xforceplus/seller/config/services/ConfigInventoryService;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "onMessage", "", "message", "Lorg/springframework/amqp/core/Message;", "seller-config-service"})
public class InventoryConfigImportListener {
    @NotNull
    private final ConfigInventoryService configInventoryService;
    private final Logger log;

    public InventoryConfigImportListener(@NotNull ConfigInventoryService configInventoryService) {
        Intrinsics.checkNotNullParameter((Object)configInventoryService, (String)"configInventoryService");
        this.configInventoryService = configInventoryService;
        this.log = LoggerFactory.getLogger(InventoryConfigImportListener.class);
    }

    @RabbitListener(queuesToDeclare={@Queue(value="phoenix.inventory.config.import")}, errorHandler="mqErrorHandler")
    public void onMessage(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        byte[] byArray = message.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"message.body");
        byte[] byArray2 = byArray;
        String body = new String(byArray2, Charsets.UTF_8);
        Map headers = message.getMessageProperties().getHeaders();
        this.log.info("\u5e93\u5b58\u9884\u8b66\u89c4\u5219\u5bfc\u5165 " + body + ", " + JsonUtils.writeObjectToJson((Object)headers));
        try {
            List list = JsonUtils.writeJsonToListObject((String)body, OriginInventoryConfigImportData.class);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"writeJsonToListObject(bo\u2026igImportData::class.java)");
            Sequence dataList2 = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)onMessage.dataList.1.INSTANCE));
            Intrinsics.checkNotNullExpressionValue((Object)headers, (String)"headers");
            this.configInventoryService.importInventoryConfig(dataList2, headers);
        }
        catch (Exception e) {
            this.log.error("\u5e93\u5b58\u9884\u8b66\u89c4\u5219\u5bfc\u5165\u5904\u7406\u5f02\u5e38 " + e.getMessage() + ", " + e);
        }
    }
}

