/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.listeners;

import com.xforceplus.seller.config.models.TitleConfig;
import com.xforceplus.seller.config.services.ImportConfigServiceImpl;
import com.xforceplus.seller.config.util.JsonUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MultiTitleConfigImportListener {
    private static final Logger logger = LoggerFactory.getLogger(MultiTitleConfigImportListener.class);
    @Autowired
    ImportConfigServiceImpl importConfigServiceImpl;

    @RabbitListener(queuesToDeclare={@Queue(value="phoenix.multiTitle.config.import")}, errorHandler="mqErrorHandler")
    public void handleMsg(Message message) {
        try {
            String body = new String(message.getBody());
            Map headers = message.getMessageProperties().getHeaders();
            headers.put("configType", "12");
            logger.info("\u4e00\u5bf9\u591a\u62ac\u5934\u89c4\u5219\u5bfc\u5165:{},,,header:{}", (Object)body, (Object)headers);
            List list = JsonUtils.writeFastJsonToListObject((String)body, TitleConfig.class);
            logger.info("\u4e00\u5bf9\u591a\u62ac\u5934\u89c4\u5219\u5bfc\u5165 list:{}", (Object)JsonUtils.writeObjectToFastJson((Object)list));
            this.importConfigServiceImpl.importMultiTitleConfig(list, headers);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u5f00\u7968\u62ac\u5934\u89c4\u5219\u5931\u8d25", (Throwable)e);
        }
    }
}

