/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.listeners;

import com.xforceplus.seller.config.models.PersonConfig;
import com.xforceplus.seller.config.services.importservice.PersonImportService;
import com.xforceplus.seller.config.util.JsonUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PersonConfigImportListener {
    private static final Logger logger = LoggerFactory.getLogger(PersonConfigImportListener.class);
    @Autowired
    private PersonImportService personImportService;

    @RabbitListener(queuesToDeclare={@Queue(value="phoenix.person.config.import")}, errorHandler="mqErrorHandler")
    public void handleMsg(Message message) {
        long importBatchNo = 0L;
        try {
            String body = new String(message.getBody());
            Map headers = message.getMessageProperties().getHeaders();
            importBatchNo = Long.parseLong(String.valueOf(headers.get("importBatchNo")));
            headers.put("configType", "4");
            logger.info("\u7968\u9762\u4eba\u89c4\u5219\u5bfc\u5165.batchNo:{},body:{},header:{}", new Object[]{importBatchNo, body, headers});
            List list = JsonUtils.writeFastJsonToListObject((String)body, PersonConfig.class);
            this.personImportService.doImport(list, headers);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u7968\u9762\u4eba\u4fe1\u606f\u5931\u8d25 batchNo:" + importBatchNo + e.getMessage(), (Throwable)e);
        }
    }
}

