/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.listeners;

import com.xforceplus.seller.config.models.SellerBusinessConfig;
import com.xforceplus.seller.config.services.ImportConfigServiceImpl;
import com.xforceplus.seller.config.util.JsonUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SellerBusinessConfigImportListener {
    private static final Logger logger = LoggerFactory.getLogger(SellerBusinessConfigImportListener.class);
    @Autowired
    ImportConfigServiceImpl importConfigServiceImpl;

    @RabbitListener(queuesToDeclare={@Queue(value="phoenix.seller.business.file.import")}, errorHandler="mqErrorHandler")
    public void handleMsg(Message message) {
        long batchNo = 0L;
        try {
            String body = new String(message.getBody());
            Map headers = message.getMessageProperties().getHeaders();
            batchNo = Optional.ofNullable(headers.get("importBatchNo")).map(String::valueOf).map(Long::valueOf).orElse(0L);
            logger.info("\u9500\u9879\u4e1a\u52a1\u89c4\u5219\u5bfc\u5165\u76d1\u542cbatchNo:{},body:{},header:{}", new Object[]{batchNo, body, headers});
            headers.put("configType", "6");
            List list = JsonUtils.writeFastJsonToListObject((String)body, SellerBusinessConfig.class);
            this.importConfigServiceImpl.importSellerBusinessConfig(list, headers);
        }
        catch (Exception e) {
            logger.error("\u9500\u9879\u4e1a\u52a1\u89c4\u5219\u5bfc\u5165\u76d1\u542c\u5f02\u5e38batchNo:" + batchNo, (Throwable)e);
        }
    }
}

