/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.listeners;

import com.xforceplus.seller.config.models.SplitConfig;
import com.xforceplus.seller.config.services.importservice.SplitRuleImportService;
import com.xforceplus.seller.config.util.JsonUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SplitConfigImportListener {
    private static final Logger logger = LoggerFactory.getLogger(SplitConfigImportListener.class);
    @Autowired
    private SplitRuleImportService splitRuleImportService;

    @RabbitListener(queuesToDeclare={@Queue(value="phoenix.split.config.import")}, errorHandler="mqErrorHandler")
    public void handleMsg(Message message) {
        long importBatchNo = 0L;
        try {
            String body = new String(message.getBody());
            Map headers = message.getMessageProperties().getHeaders();
            importBatchNo = Long.parseLong(String.valueOf(headers.get("importBatchNo")));
            logger.info("\u62c6\u7968\u89c4\u5219\u5bfc\u5165.batchNo:{},body:{},header:{}", new Object[]{importBatchNo, body, headers});
            headers.put("configType", "1");
            List list = JsonUtils.writeFastJsonToListObject((String)body, SplitConfig.class);
            this.splitRuleImportService.doImport(list, headers);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u62c6\u7968\u89c4\u5219\u5931\u8d25batchNo:" + importBatchNo + e.getMessage(), (Throwable)e);
        }
    }
}

