/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.listeners;

import com.xforceplus.seller.config.models.TitleConfig;
import com.xforceplus.seller.config.services.importservice.TitleImportService;
import com.xforceplus.seller.config.util.JsonUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TitleConfigImportListener {
    private static final Logger log = LoggerFactory.getLogger(TitleConfigImportListener.class);
    @Autowired
    private TitleImportService titleImportService;

    @RabbitListener(queuesToDeclare={@Queue(value="phoenix.title.personConfig.import")}, errorHandler="mqErrorHandler")
    public void handleMsg(Message message) {
        long importBatchNo = 0L;
        try {
            String body = new String(message.getBody());
            Map headers = message.getMessageProperties().getHeaders();
            importBatchNo = Long.parseLong(String.valueOf(headers.get("importBatchNo")));
            log.info("\u62ac\u5934\u89c4\u5219\u5bfc\u5165.batchNo:{},body:{},header:{}", new Object[]{importBatchNo, body, headers});
            headers.put("configType", "3");
            List list = JsonUtils.writeFastJsonToListObject((String)body, TitleConfig.class);
            this.titleImportService.doImport(list, headers);
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u5f00\u7968\u62ac\u5934\u89c4\u5219\u5931\u8d25batchNo:" + importBatchNo + e.getMessage(), (Throwable)e);
        }
    }
}

