/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.listeners;

import com.xforceplus.seller.config.client.model.UserRelationData;
import com.xforceplus.seller.config.facade.TerminalDeviceFacade;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserRelationImportListener {
    private static final Logger log = LoggerFactory.getLogger(UserRelationImportListener.class);
    @Autowired
    private TerminalDeviceFacade terminalDeviceFacade;

    @RabbitListener(queuesToDeclare={@Queue(value="phoenix.relation.terminal.import")}, errorHandler="mqErrorHandler")
    public void handleMsg(Message message) {
        try {
            String body = new String(message.getBody());
            Map headers = message.getMessageProperties().getHeaders();
            log.info("\u4eba\u5458\u5f00\u7968\u4fe1\u606f\u5173\u7cfb\u5bfc\u5165:{},headers:{}", (Object)body, (Object)JsonUtils.writeObjectToJson((Object)headers));
            List list = JsonUtils.writeJsonToListObject((String)body, UserRelationData.ImportUserRelationInfo.class);
            this.terminalDeviceFacade.importUserRelationList(list, headers);
        }
        catch (Exception e) {
            log.error("\u4eba\u5458\u5f00\u7968\u4fe1\u606f\u5173\u7cfb\u5bfc\u5165", (Throwable)e);
        }
    }
}

