/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.repository.daoext;

import com.google.common.collect.Maps;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.constant.StatusEnum;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.client.model.MsConfigBizBillAttribute;
import com.xforceplus.seller.config.repository.dao.CfgConfigBillAttributeDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigDao;
import com.xforceplus.seller.config.repository.model.CfgConfigBillAttributeEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigBillAttributeExample;
import com.xforceplus.seller.config.repository.model.CfgConfigEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigExample;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CfgExtDaoService {
    @Autowired
    private CfgConfigDao cfgConfigDao;
    @Autowired
    private CfgConfigBillAttributeDao cfgConfigBillAttributeDao;

    public Long checkExist(MsConfigBean msConfigBean) {
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = cfgConfigExample.createCriteria();
        criteria.andConfigTypeEqualTo(Byte.valueOf(msConfigBean.getConfigType().byteValue()));
        if (msConfigBean.getConfigType().equals(ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType())) {
            String invoiceType = msConfigBean.getInvoiceType();
            criteria.andInvoiceTypeEqualTo(invoiceType);
        }
        criteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        String salesbillType = StringUtils.isEmpty((CharSequence)msConfigBean.getSalesbillType()) ? "" : msConfigBean.getSalesbillType();
        criteria.andSalesbillTypeEqualTo(salesbillType);
        criteria.andBusinessBillTypeEqualTo(msConfigBean.getBusinessBillType());
        String sellerTaxNo = msConfigBean.getSellerTaxNo();
        criteria.andSellerTaxNoEqualTo(StringUtils.isBlank((CharSequence)sellerTaxNo) ? "" : sellerTaxNo);
        String purchaserTaxNo = msConfigBean.getPurchaserTaxNo();
        criteria.andPurchaserTaxNoEqualTo(StringUtils.isBlank((CharSequence)purchaserTaxNo) ? "" : purchaserTaxNo);
        criteria.andSysOrgIdEqualTo(Optional.ofNullable(msConfigBean.getSysOrgId()).orElse(0L));
        List cfgConfigEntities = this.cfgConfigDao.selectByExample(cfgConfigExample);
        if (cfgConfigEntities.size() == 1) {
            Long configId = ((CfgConfigEntity)cfgConfigEntities.get(0)).getConfigId();
            List paramAttributeList = msConfigBean.getAttributes();
            CfgConfigBillAttributeExample cfgConfigBillAttributeExample = new CfgConfigBillAttributeExample();
            cfgConfigBillAttributeExample.createCriteria().andConfigIdEqualTo(configId).andStatusEqualTo(Integer.valueOf(1));
            List dbAttributeList = this.cfgConfigBillAttributeDao.selectByExample(cfgConfigBillAttributeExample);
            boolean compareRet = this.compareAttributeList(paramAttributeList, dbAttributeList);
            if (compareRet) {
                return configId;
            }
            return null;
        }
        if (cfgConfigEntities.size() > 1) {
            return null;
        }
        return null;
    }

    private boolean compareAttributeList(List<MsConfigBizBillAttribute> paramAttributeList, List<CfgConfigBillAttributeEntity> dbAttributeList) {
        int dbSize;
        int paramSize;
        Map<Object, Object> paramAttributeMap = Maps.newHashMap();
        Map<Object, Object> dbAttributeMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(paramAttributeList)) {
            paramAttributeMap = paramAttributeList.stream().collect(Collectors.toMap(MsConfigBizBillAttribute::getFieldName, item -> item));
        }
        if (!CollectionUtils.isEmpty(dbAttributeList)) {
            dbAttributeMap = dbAttributeList.stream().collect(Collectors.toMap(CfgConfigBillAttributeEntity::getFieldName, item -> item));
        }
        if ((paramSize = paramAttributeMap.size()) == (dbSize = dbAttributeMap.size()) && dbSize == 0) {
            return true;
        }
        if (paramSize == dbSize && dbSize > 0) {
            for (Map.Entry<Object, Object> entry : paramAttributeMap.entrySet()) {
                String paramKey = (String)entry.getKey();
                MsConfigBizBillAttribute paramAttribute = (MsConfigBizBillAttribute)entry.getValue();
                CfgConfigBillAttributeEntity dbAttribute = (CfgConfigBillAttributeEntity)dbAttributeMap.get(paramKey);
                if (!Objects.isNull(dbAttribute) && paramAttribute.getValue().equals(dbAttribute.getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

