/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services;

import com.xforceplus.seller.config.client.model.AlipayAppInfoDTO;
import com.xforceplus.seller.config.client.model.AppTemplatesDTO;
import com.xforceplus.seller.config.core.enums.AlipayAppStatus;
import com.xforceplus.seller.config.core.enums.AlipayAppType;
import com.xforceplus.seller.config.repository.dao.Cfg3rdAlipayAuthDao;
import com.xforceplus.seller.config.repository.model.Cfg3rdAlipayAuthEntity;
import com.xforceplus.seller.config.repository.model.Cfg3rdAlipayAuthExample;
import com.xforceplus.seller.config.repository.model.Cfg3rdAlipayAuthWithBLOBs;
import com.xforceplus.seller.config.util.JsonUtils;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class Cfg3rdAlipayAuthService {
    private final Cfg3rdAlipayAuthDao cfg3rdAlipayAuthDao;

    public Cfg3rdAlipayAuthWithBLOBs getByAppId(String appId) {
        Cfg3rdAlipayAuthExample example = new Cfg3rdAlipayAuthExample();
        example.createCriteria().andAppIdEqualTo(appId).andIsDeletedEqualTo(Boolean.valueOf(false));
        return this.cfg3rdAlipayAuthDao.selectOneByExample(example);
    }

    public Cfg3rdAlipayAuthWithBLOBs findByThirdPartyCode(String thirdPartyCode, AlipayAppType appType) {
        Cfg3rdAlipayAuthExample example = new Cfg3rdAlipayAuthExample();
        example.createCriteria().andThirdPartyCodeEqualTo(thirdPartyCode).andTypeEqualTo(Integer.valueOf(appType.code)).andIsDeletedEqualTo(Boolean.valueOf(false));
        return this.cfg3rdAlipayAuthDao.selectOneByExample(example);
    }

    public List<Cfg3rdAlipayAuthWithBLOBs> findByThirdPartyCodes(List<String> thirdPartyCodes, AlipayAppType appType) {
        Cfg3rdAlipayAuthExample example = new Cfg3rdAlipayAuthExample();
        example.createCriteria().andThirdPartyCodeIn(thirdPartyCodes).andTypeEqualTo(Integer.valueOf(appType.code)).andIsDeletedEqualTo(Boolean.valueOf(false));
        return this.cfg3rdAlipayAuthDao.selectByExampleWithBLOBs(example);
    }

    public void unauthorized(String appId, Date unauthorizedTime) {
        Cfg3rdAlipayAuthExample example = new Cfg3rdAlipayAuthExample();
        example.createCriteria().andAppIdEqualTo(appId).andIsDeletedEqualTo(Boolean.valueOf(false));
        Cfg3rdAlipayAuthWithBLOBs entity = new Cfg3rdAlipayAuthWithBLOBs();
        entity.setStatus(Integer.valueOf(AlipayAppStatus.UNAUTHORIZED.code));
        entity.setUnauthorizedTime(unauthorizedTime);
        this.cfg3rdAlipayAuthDao.updateByExample((Cfg3rdAlipayAuthEntity)entity, example);
    }

    public void insert(Cfg3rdAlipayAuthWithBLOBs cfg3rdAlipayAuthWithBLOBs) {
        this.cfg3rdAlipayAuthDao.insert(cfg3rdAlipayAuthWithBLOBs);
    }

    public void updateAuthorized(Long id, String authToken, String refreshToken, Date expiresTime, Date reExpiresTime, List<String> funcInfo, AlipayAppInfoDTO baseInfo) {
        Cfg3rdAlipayAuthWithBLOBs entity = new Cfg3rdAlipayAuthWithBLOBs();
        entity.setId(id);
        entity.setAuthToken(authToken);
        entity.setRefreshToken(refreshToken);
        entity.setExpiresTime(expiresTime);
        entity.setReExpiresTime(reExpiresTime);
        entity.setFuncInfo(JsonUtils.writeObjectToFastJson(funcInfo));
        entity.setBaseInfo(JsonUtils.writeObjectToFastJson((Object)baseInfo));
        entity.setStatus(Integer.valueOf(AlipayAppStatus.AUTHORIZED.code));
        this.cfg3rdAlipayAuthDao.updateByPrimaryKeySelective(entity);
    }

    public void refreshToken(Long id, String authToken, String refreshToken, Date expiresTime, Date reExpiresTime) {
        Cfg3rdAlipayAuthWithBLOBs entity = new Cfg3rdAlipayAuthWithBLOBs();
        entity.setId(id);
        entity.setAuthToken(authToken);
        entity.setRefreshToken(refreshToken);
        entity.setExpiresTime(expiresTime);
        entity.setReExpiresTime(reExpiresTime);
        this.cfg3rdAlipayAuthDao.updateByPrimaryKeySelective(entity);
    }

    public void updateTemplates(String appId, AppTemplatesDTO appTemplatesDTO) {
        Cfg3rdAlipayAuthExample example = new Cfg3rdAlipayAuthExample();
        example.createCriteria().andAppIdEqualTo(appId).andIsDeletedEqualTo(Boolean.valueOf(false));
        Cfg3rdAlipayAuthWithBLOBs entity = new Cfg3rdAlipayAuthWithBLOBs();
        entity.setTemplates(JsonUtils.writeObjectToFastJson((Object)appTemplatesDTO));
        this.cfg3rdAlipayAuthDao.updateByExampleWithBLOBs(entity, example);
    }

    public void bindThirdPartyCode(long id, String thirdPartyCode) {
        Cfg3rdAlipayAuthWithBLOBs entity = new Cfg3rdAlipayAuthWithBLOBs();
        entity.setId(Long.valueOf(id));
        entity.setThirdPartyCode(thirdPartyCode);
        this.cfg3rdAlipayAuthDao.updateByPrimaryKeySelective(entity);
    }

    public Cfg3rdAlipayAuthService(Cfg3rdAlipayAuthDao cfg3rdAlipayAuthDao) {
        this.cfg3rdAlipayAuthDao = cfg3rdAlipayAuthDao;
    }
}

