/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services;

import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.seller.config.client.model.AppTemplatesDTO;
import com.xforceplus.seller.config.client.model.AuthFuncInfo;
import com.xforceplus.seller.config.client.model.AuthorizerInfo;
import com.xforceplus.seller.config.core.enums.WxAppStatus;
import com.xforceplus.seller.config.core.enums.WxAppType;
import com.xforceplus.seller.config.repository.dao.Cfg3rdWxAuthDao;
import com.xforceplus.seller.config.repository.model.Cfg3rdWxAuthExample;
import com.xforceplus.seller.config.repository.model.Cfg3rdWxAuthWithBLOBs;
import com.xforceplus.seller.config.util.JsonUtils;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class Cfg3rdWxAuthService {
    private final Cfg3rdWxAuthDao cfg3rdWxAuthDao;
    private final IDGenerator idGenerator;

    public Cfg3rdWxAuthWithBLOBs getByAppId(String appId) {
        Cfg3rdWxAuthExample example = new Cfg3rdWxAuthExample();
        example.createCriteria().andAppIdEqualTo(appId).andIsDeletedEqualTo(Boolean.valueOf(false));
        return this.cfg3rdWxAuthDao.selectOneByExample(example);
    }

    public Cfg3rdWxAuthWithBLOBs findByThirdPartyCode(String thirdPartyCode, WxAppType type) {
        Cfg3rdWxAuthExample example = new Cfg3rdWxAuthExample();
        example.createCriteria().andThirdPartyCodeEqualTo(thirdPartyCode).andTypeEqualTo(Integer.valueOf(type.code)).andIsDeletedEqualTo(Boolean.valueOf(false));
        return this.cfg3rdWxAuthDao.selectOneByExample(example);
    }

    public List<Cfg3rdWxAuthWithBLOBs> findByThirdPartyCodes(List<String> thirdPartyCodes, WxAppType type) {
        Cfg3rdWxAuthExample example = new Cfg3rdWxAuthExample();
        example.createCriteria().andThirdPartyCodeIn(thirdPartyCodes).andTypeEqualTo(Integer.valueOf(type.code)).andIsDeletedEqualTo(Boolean.valueOf(false));
        return this.cfg3rdWxAuthDao.selectByExampleWithBLOBs(example);
    }

    public void unauthorized(Long id, Date unauthorizedTime) {
        Cfg3rdWxAuthWithBLOBs entity = new Cfg3rdWxAuthWithBLOBs();
        entity.setId(id);
        entity.setStatus(Integer.valueOf(WxAppStatus.UNAUTHORIZED.code));
        entity.setUnauthorizedTime(unauthorizedTime);
        this.cfg3rdWxAuthDao.updateByPrimaryKeySelective(entity);
    }

    public void authorized(Long id, String accessToken, String refreshToken, Date expiresTime, List<AuthFuncInfo> funcInfo, AuthorizerInfo baseInfo, WxAppType appType) {
        Cfg3rdWxAuthWithBLOBs entity = new Cfg3rdWxAuthWithBLOBs();
        entity.setId(id);
        entity.setAccessToken(accessToken);
        entity.setRefreshToken(refreshToken);
        entity.setExpiresTime(expiresTime);
        entity.setFuncInfo(JsonUtils.writeObjectToFastJson(funcInfo));
        entity.setBaseInfo(JsonUtils.writeObjectToFastJson((Object)baseInfo));
        entity.setType(Integer.valueOf(appType.code));
        entity.setStatus(Integer.valueOf(WxAppStatus.AUTHORIZED.code));
        this.cfg3rdWxAuthDao.updateByPrimaryKeySelective(entity);
    }

    public void insert(Cfg3rdWxAuthWithBLOBs cfg3rdWxAuthWithBLOBs) {
        cfg3rdWxAuthWithBLOBs.setId(Long.valueOf(this.idGenerator.nextId()));
        this.cfg3rdWxAuthDao.insert(cfg3rdWxAuthWithBLOBs);
    }

    public void refreshToken(Long id, String accessToken, String refreshToken, Date expiresTime) {
        Cfg3rdWxAuthWithBLOBs entity = new Cfg3rdWxAuthWithBLOBs();
        entity.setId(id);
        entity.setAccessToken(accessToken);
        entity.setRefreshToken(refreshToken);
        entity.setExpiresTime(expiresTime);
        this.cfg3rdWxAuthDao.updateByPrimaryKeySelective(entity);
    }

    public void updateTemplates(Long id, AppTemplatesDTO appTemplatesDTO) {
        Cfg3rdWxAuthWithBLOBs entity = new Cfg3rdWxAuthWithBLOBs();
        entity.setId(id);
        entity.setTemplates(JsonUtils.writeObjectToFastJson((Object)appTemplatesDTO));
        this.cfg3rdWxAuthDao.updateByPrimaryKeySelective(entity);
    }

    public void bindThirdPartyCode(long id, String thirdPartyCode) {
        Cfg3rdWxAuthWithBLOBs entity = new Cfg3rdWxAuthWithBLOBs();
        entity.setId(Long.valueOf(id));
        entity.setThirdPartyCode(thirdPartyCode);
        this.cfg3rdWxAuthDao.updateByPrimaryKeySelective(entity);
    }

    public void updateSPappid(String appId, String sPappid) {
        Cfg3rdWxAuthExample example = new Cfg3rdWxAuthExample();
        example.createCriteria().andAppIdEqualTo(appId).andIsDeletedEqualTo(Boolean.valueOf(false));
        Cfg3rdWxAuthWithBLOBs entity = new Cfg3rdWxAuthWithBLOBs();
        entity.setsPappid(sPappid);
        this.cfg3rdWxAuthDao.updateByExampleSelective(entity, example);
    }

    public Cfg3rdWxAuthService(Cfg3rdWxAuthDao cfg3rdWxAuthDao, IDGenerator idGenerator) {
        this.cfg3rdWxAuthDao = cfg3rdWxAuthDao;
        this.idGenerator = idGenerator;
    }
}

