/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services;

import com.xforceplus.seller.config.repository.dao.CfgConfigDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigItemDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigItemTempDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigTempDao;
import com.xforceplus.seller.config.repository.daoext.CfgConfigExtDao;
import com.xforceplus.seller.config.repository.model.CfgConfigEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigExample;
import com.xforceplus.seller.config.repository.model.CfgConfigItemEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigItemExample;
import com.xforceplus.seller.config.repository.model.CfgConfigItemTempEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigItemTempExample;
import com.xforceplus.seller.config.repository.model.CfgConfigTempEntity;
import com.xforceplus.seller.config.services.CfgConfigDataService;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class CfgConfigDataServiceImpl
implements CfgConfigDataService {
    private final CfgConfigExtDao cfgConfigExtDao;
    private final CfgConfigDao cfgConfigDao;
    private final CfgConfigTempDao cfgConfigTempDao;
    private final CfgConfigItemDao cfgConfigItemDao;
    private final CfgConfigItemTempDao cfgConfigItemTempDao;

    public CfgConfigDataServiceImpl(CfgConfigExtDao cfgConfigExtDao, CfgConfigDao cfgConfigDao, CfgConfigTempDao cfgConfigTempDao, CfgConfigItemDao cfgConfigItemDao, CfgConfigItemTempDao cfgConfigItemTempDao) {
        this.cfgConfigExtDao = cfgConfigExtDao;
        this.cfgConfigDao = cfgConfigDao;
        this.cfgConfigTempDao = cfgConfigTempDao;
        this.cfgConfigItemDao = cfgConfigItemDao;
        this.cfgConfigItemTempDao = cfgConfigItemTempDao;
    }

    public CfgConfigEntity queryById(Long id) {
        return this.cfgConfigDao.selectByPrimaryKey(id);
    }

    public CfgConfigTempEntity queryTempById(Long id) {
        return this.cfgConfigTempDao.selectByPrimaryKey(id);
    }

    public List<CfgConfigItemEntity> queryByParentId(Long parentId) {
        CfgConfigItemExample example = new CfgConfigItemExample();
        example.createCriteria().andConfigIdEqualTo(parentId);
        return this.cfgConfigItemDao.selectByExample(example);
    }

    public List<CfgConfigItemTempEntity> queryTempByParentId(Long parentId) {
        CfgConfigItemTempExample example = new CfgConfigItemTempExample();
        example.createCriteria().andConfigIdEqualTo(parentId);
        return this.cfgConfigItemTempDao.selectByExample(example);
    }

    public <T> List<T> queryFieldsByCondition(Consumer<CfgConfigExample.Criteria> condition, List<String> fields, Function<CfgConfigEntity, T> convertFunc) {
        CfgConfigExample example = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = example.createCriteria();
        condition.accept(criteria);
        return this.cfgConfigExtDao.selectFieldsByExample(example, fields).stream().map(convertFunc).distinct().collect(Collectors.toList());
    }

    public List<CfgConfigItemEntity> queryItemByConfigIdList(List<Long> configIdList, String configItemName) {
        CfgConfigItemExample example = new CfgConfigItemExample();
        example.createCriteria().andConfigIdIn(configIdList).andConfigItemNameEqualTo(configItemName);
        return this.cfgConfigItemDao.selectByExample(example);
    }

    public List<CfgConfigEntity> selectByExample(CfgConfigExample example) {
        return this.cfgConfigDao.selectByExample(example);
    }
}

