/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xforceplus.micro.tax.device.contract.model.LimitInfo;
import com.xforceplus.micro.tax.device.contract.model.QualificationInfo;
import com.xforceplus.micro.tax.device.contract.model.QueryDeviceQualificationsResponse;
import com.xforceplus.phoenix.casm.model.MsCasInfo;
import com.xforceplus.phoenix.casm.model.MsCasInfoModel;
import com.xforceplus.phoenix.casm.model.MsListCasRequest;
import com.xforceplus.phoenix.casm.model.MsListCasResult;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.phoenix.infrastructure.usercenter.controllers.UserCenterController;
import com.xforceplus.phoenix.infrastructure.usercenter.model.CompanyData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.CompanyTenant;
import com.xforceplus.phoenix.infrastructure.usercenter.model.OrgData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserCenterResponse;
import com.xforceplus.phoenix.infrastructure.usercenter.services.UserCenterOrgService;
import com.xforceplus.seller.config.client.constant.BusinessSalesBillTypeEnum;
import com.xforceplus.seller.config.client.constant.CasmTypeEnum;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.constant.SalesListPrintEnum;
import com.xforceplus.seller.config.client.constant.StatusEnum;
import com.xforceplus.seller.config.client.matchparser.impl.ConfigMatchParserImpl;
import com.xforceplus.seller.config.client.model.ConfigApiModel;
import com.xforceplus.seller.config.client.model.EmailConfigEntity;
import com.xforceplus.seller.config.client.model.MsBusinessObjMetadataBean;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.client.model.MsConfigBizBillAttribute;
import com.xforceplus.seller.config.client.model.MsConfigDeleteRequstWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigItemAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigItemBatchQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.model.MsConfigItemQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigItemTempBean;
import com.xforceplus.seller.config.client.model.MsConfigMailRule;
import com.xforceplus.seller.config.client.model.MsConfigMailRuleResponse;
import com.xforceplus.seller.config.client.model.MsConfigPageDTO;
import com.xforceplus.seller.config.client.model.MsConfigQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigQueryRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsEnumBean;
import com.xforceplus.seller.config.client.model.MsMataDataQueryRequest;
import com.xforceplus.seller.config.client.model.MsResponse;
import com.xforceplus.seller.config.client.model.MsTmpConfigAddRequest;
import com.xforceplus.seller.config.client.parse.bean.InvoiceSplitrRuleDTO;
import com.xforceplus.seller.config.client.parse.bean.SysInfoRuleDTO;
import com.xforceplus.seller.config.client.parse.impl.InvoiceSplitParser;
import com.xforceplus.seller.config.client.parse.impl.SysInfoRuleParser;
import com.xforceplus.seller.config.common.xxlJobResponse.JobGroupPageListResult;
import com.xforceplus.seller.config.common.xxlJobResponse.XxlJobGroup;
import com.xforceplus.seller.config.config.TaxWareInvoiceRemarkLengthProperties;
import com.xforceplus.seller.config.converters.CfgConfigBillAttributeEntityMapper;
import com.xforceplus.seller.config.converters.ConfigEntityTranslater;
import com.xforceplus.seller.config.converters.ConfigItemEntityTranslator;
import com.xforceplus.seller.config.converters.ExamapleTranslater;
import com.xforceplus.seller.config.core.constants.ConstantValue;
import com.xforceplus.seller.config.core.enums.BusinessBillType;
import com.xforceplus.seller.config.core.enums.ConfigErrorEnum;
import com.xforceplus.seller.config.core.enums.GenerateCronJobEnum;
import com.xforceplus.seller.config.core.enums.InvoiceType;
import com.xforceplus.seller.config.core.enums.InvoiceTypeEnum;
import com.xforceplus.seller.config.core.enums.TaxInvoiceSource;
import com.xforceplus.seller.config.core.enums.TaxWareRemarkDeviceType;
import com.xforceplus.seller.config.core.enums.TaxWareRemarkIssueType;
import com.xforceplus.seller.config.core.enums.ValueEnum;
import com.xforceplus.seller.config.exception.CompanyQueryException;
import com.xforceplus.seller.config.exception.ConfigCreateException;
import com.xforceplus.seller.config.exception.ConfigExsitException;
import com.xforceplus.seller.config.exception.ConfigItemRequiredException;
import com.xforceplus.seller.config.exception.InvoiceSplitConfigException;
import com.xforceplus.seller.config.exception.ThridPartyInvokeException;
import com.xforceplus.seller.config.exception.TipsException;
import com.xforceplus.seller.config.infrastructure.client.CasmClient;
import com.xforceplus.seller.config.infrastructure.helper.DeviceApiProxy;
import com.xforceplus.seller.config.model.ConfigRuleRedisKey;
import com.xforceplus.seller.config.models.RestDeviceQualificationRequest;
import com.xforceplus.seller.config.repository.dao.CfgConfigDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigItemDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigItemTempDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigJobDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigMailRuleDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigTempDao;
import com.xforceplus.seller.config.repository.dao.CfgIssueUserInfoDao;
import com.xforceplus.seller.config.repository.dao.CfgTemplateObjDao;
import com.xforceplus.seller.config.repository.dao.CfgTemplateObjMetadataDao;
import com.xforceplus.seller.config.repository.daoext.CfgConfigBillAttributeExtDao;
import com.xforceplus.seller.config.repository.daoext.CfgConfigExtDao;
import com.xforceplus.seller.config.repository.daoext.ConfigItemExtDao;
import com.xforceplus.seller.config.repository.model.CfgConfigBillAttributeEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigBillAttributeExample;
import com.xforceplus.seller.config.repository.model.CfgConfigEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigExample;
import com.xforceplus.seller.config.repository.model.CfgConfigItemEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigItemExample;
import com.xforceplus.seller.config.repository.model.CfgConfigItemTempEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigItemTempExample;
import com.xforceplus.seller.config.repository.model.CfgConfigJobEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigJobExample;
import com.xforceplus.seller.config.repository.model.CfgConfigMailRuleEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigMailRuleExample;
import com.xforceplus.seller.config.repository.model.CfgConfigTempEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigTempExample;
import com.xforceplus.seller.config.repository.model.CfgIssueUserInfoEntity;
import com.xforceplus.seller.config.repository.model.CfgIssueUserInfoExample;
import com.xforceplus.seller.config.repository.model.CfgTemplateObjEntity;
import com.xforceplus.seller.config.repository.model.CfgTemplateObjExample;
import com.xforceplus.seller.config.repository.model.CfgTemplateObjMetadataExample;
import com.xforceplus.seller.config.repository.model.modelext.CfgConfigExtExample;
import com.xforceplus.seller.config.services.CfgConfigDataService;
import com.xforceplus.seller.config.services.ConfigBizConfigService;
import com.xforceplus.seller.config.services.ConfigCompanyService;
import com.xforceplus.seller.config.services.ConfigMetaDataService;
import com.xforceplus.seller.config.services.QueryConfigService;
import com.xforceplus.seller.config.util.BeanMapper;
import com.xforceplus.seller.config.util.CommonTools;
import com.xforceplus.seller.config.util.DingDingUtils;
import com.xforceplus.seller.config.util.StringUtil;
import com.xforceplus.seller.config.util.XxlJobUtil;
import com.xforceplus.seller.enums.OrgType;
import com.xforceplus.xplatframework.apimodel.BaseResponse;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatframework.utils.JsonUtils;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Tuple4;
import io.vavr.control.Either;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.elasticsearch.common.Strings;
import org.jetbrains.annotations.Nullable;
import org.redisson.api.RMapCache;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ConfigBizConfigService {
    private static final Logger logger = LoggerFactory.getLogger(ConfigBizConfigService.class);
    public static final String AUTO_MAKEOUT_SUFFIX = "-AutoMakeout";
    public static final String RED_FLUSH_SUFFIX = "-RedFlush";
    private final CfgConfigDao cfgConfigDao;
    private final CfgConfigItemDao cfgConfigItemDao;
    private final CfgConfigTempDao cfgConfigTempDao;
    private final CfgConfigItemTempDao cfgConfigItemTempDao;
    private final IDGenerator generator;
    private final CfgTemplateObjDao cfgTemplateObjDao;
    private final CfgTemplateObjMetadataDao cfgTemplateObjMetadataDao;
    private final ConfigItemExtDao configItemExtDao;
    private final CfgConfigExtDao cfgConfigExtDao;
    private final ConfigMetaDataService configMetaDataService;
    private final ConfigMatchParserImpl configMatchParserImpl;
    private final CfgConfigBillAttributeExtDao cfgConfigBillAttributeExtDao;
    private final CfgConfigMailRuleDao cfgConfigMailRuleDao;
    private final CfgConfigJobDao cfgConfigJobDao;
    private final UserInfoHolder<UserInfo> userInfoHolder;
    private final CasmClient casmClient;
    private final UserCenterController userCenterController;
    private final TaxWareInvoiceRemarkLengthProperties taxWareInvoiceRemarkLengthProperties;
    private final SysInfoRuleParser sysInfoRuleParser;
    private final DeviceApiProxy deviceApiProxy;
    private final RedissonClient redissonClient;
    private final CfgIssueUserInfoDao cfgIssueUserInfoDao;
    private final UserCenterOrgService userCenterOrgService;
    private final CfgConfigBillAttributeEntityMapper cfgConfigBillAttributeEntityMapper;
    private final ConfigCompanyService configCompanyService;
    private final CfgConfigDataService cfgConfigDataService;
    private final QueryConfigService queryConfigService;
    public static final String AUTO_MAKEOUT_JOB = "virtualInvoiceAutoSplitAndMakeoutJob";
    public static final String AUTO_REDFLUSH_JOB = "virtualInvoiceAutoRedFlushJob";
    @Value(value="${xxl.job.admin.addresses:http\\://localhost:8080/xxl-job-admin}")
    private String adminAddresses;
    @Value(value="${xxl.job.admin.userName:admin}")
    private String xxlUserName;
    @Value(value="${xxl.job.admin.password:123456}")
    private String xxlPassword;
    @Value(value="${mail.template.no:AUTO_INVOICE_MAIL}")
    private String mailTemplateNo;
    @Value(value="${default.sales.list.max.row:0}")
    private int DEFAULT_SALES_LOW_LIST_MAX_ROW;
    @Value(value="${elec.sales.list.max.row:2000}")
    private int ELEC_SALES_UP_LIST_MAX_ROW;
    @Value(value="${hx.bw.sales.list.max.row:2000}")
    private int HX_BW_SALES_UP_LIST_MAX_ROW;
    @Value(value="#{'${config.simple.match.tenant-id:0}'.split(',')}")
    private List<Long> matchTenantIds;
    @Value(value="${default.warn.max.size.row:100}")
    private int maxSizeRow;
    @Autowired
    DingDingUtils dingDingUtils;
    private static final String QIAN_NIU_CHANNEL_INVOICER_INFO = "\u5343\u725b\u6e20\u9053\u7968\u9762\u4eba\u5458";
    private static final String QIAN_NIU_CHANNEL_TITLE = "\u5343\u725b\u6e20\u9053\u5f00\u7968\u62ac\u5934";

    @Autowired
    public ConfigBizConfigService(CfgConfigDao cfgConfigDao, CfgConfigItemDao cfgConfigItemDao, CfgConfigTempDao cfgConfigTempDao, CfgConfigItemTempDao cfgConfigItemTempDao, IDGenerator generator, CfgTemplateObjDao cfgTemplateObjDao, CfgTemplateObjMetadataDao cfgTemplateObjMetadataDao, ConfigItemExtDao configItemExtDao, CfgConfigExtDao cfgConfigExtDao, ConfigMetaDataService configMetaDataService, ConfigMatchParserImpl configMatchParserImpl, CfgConfigBillAttributeExtDao cfgConfigBillAttributeExtDao, CfgConfigMailRuleDao cfgConfigMailRuleDao, CfgConfigJobDao cfgConfigJobDao, UserInfoHolder<UserInfo> userInfoHolder, CasmClient casmClient, UserCenterController userCenterController, TaxWareInvoiceRemarkLengthProperties taxWareInvoiceRemarkLengthProperties, SysInfoRuleParser sysInfoRuleParser, DeviceApiProxy deviceApiProxy, RedissonClient redissonClient, CfgIssueUserInfoDao cfgIssueUserInfoDao, UserCenterOrgService userCenterOrgService, CfgConfigBillAttributeEntityMapper cfgConfigBillAttributeEntityMapper, ConfigCompanyService configCompanyService, CfgConfigDataService cfgConfigDataService, QueryConfigService queryConfigService) {
        this.cfgConfigDao = cfgConfigDao;
        this.cfgConfigItemDao = cfgConfigItemDao;
        this.cfgConfigTempDao = cfgConfigTempDao;
        this.cfgConfigItemTempDao = cfgConfigItemTempDao;
        this.generator = generator;
        this.cfgTemplateObjDao = cfgTemplateObjDao;
        this.cfgTemplateObjMetadataDao = cfgTemplateObjMetadataDao;
        this.configItemExtDao = configItemExtDao;
        this.cfgConfigExtDao = cfgConfigExtDao;
        this.configMetaDataService = configMetaDataService;
        this.configMatchParserImpl = configMatchParserImpl;
        this.cfgConfigJobDao = cfgConfigJobDao;
        this.cfgConfigBillAttributeExtDao = cfgConfigBillAttributeExtDao;
        this.cfgConfigMailRuleDao = cfgConfigMailRuleDao;
        this.userInfoHolder = userInfoHolder;
        this.casmClient = casmClient;
        this.userCenterController = userCenterController;
        this.taxWareInvoiceRemarkLengthProperties = taxWareInvoiceRemarkLengthProperties;
        this.sysInfoRuleParser = sysInfoRuleParser;
        this.deviceApiProxy = deviceApiProxy;
        this.redissonClient = redissonClient;
        this.cfgIssueUserInfoDao = cfgIssueUserInfoDao;
        this.userCenterOrgService = userCenterOrgService;
        this.cfgConfigBillAttributeEntityMapper = cfgConfigBillAttributeEntityMapper;
        this.configCompanyService = configCompanyService;
        this.cfgConfigDataService = cfgConfigDataService;
        this.queryConfigService = queryConfigService;
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteCfgConfig(MsConfigDeleteRequstWithUserInfo msConfigDeleteRequest, Long userId) throws IOException {
        List configIdList = msConfigDeleteRequest.getConfigIdList();
        if (CollectionUtils.isEmpty((Collection)configIdList)) {
            return 1;
        }
        configIdList = configIdList.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (ConfigTypeEnum.INVOICE_MAIL_RULE_CONFIG_TYPE.getConfigType().equals(msConfigDeleteRequest.getConfigType())) {
            List list = this.getPreCancelMailCfgs(configIdList);
        }
        CfgConfigExtExample cfgConfigExtExample = new CfgConfigExtExample();
        cfgConfigExtExample.setConfigIdList(configIdList);
        cfgConfigExtExample.setPreStatus(StatusEnum.NORMAL.getStatus());
        cfgConfigExtExample.setAfterStatus(StatusEnum.DELETE.getStatus());
        cfgConfigExtExample.setCreateUser(userId);
        cfgConfigExtExample.setUpdateTime(new Timestamp(System.currentTimeMillis()));
        int affected = this.cfgConfigExtDao.deleteCfgConfigEntityByIds(cfgConfigExtExample);
        this.deleteXxlJob(configIdList);
        if (affected != configIdList.size()) {
            throw new RuntimeException("\u5220\u9664\u89c4\u5219\u5931\u8d25.");
        }
        return 1;
    }

    private List<CfgConfigMailRuleEntity> getPreCancelMailCfgs(List<Long> configIdList) {
        CfgConfigMailRuleExample example = new CfgConfigMailRuleExample();
        example.createCriteria().andConfigIdIn(configIdList).andStatusEqualTo(ConstantValue.STATUS_ACTIVE);
        return this.cfgConfigMailRuleDao.selectByExample(example);
    }

    private void deleteXxlJob(List<Long> configIdList) throws IOException {
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        cfgConfigExample.createCriteria().andConfigIdIn(configIdList);
        List cfgConfigEntities = this.cfgConfigDao.selectByExample(cfgConfigExample);
        List targetConfigs = cfgConfigEntities.stream().filter(a -> ConfigTypeEnum.VIRTUAL_INVOICE_AUTO_TYPE.getConfigType().equals(Integer.parseInt(String.valueOf(a.getConfigType())))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(targetConfigs)) {
            return;
        }
        List cfgIds = targetConfigs.stream().map(CfgConfigEntity::getConfigId).collect(Collectors.toList());
        CfgConfigJobExample cfgConfigJobExample = new CfgConfigJobExample();
        cfgConfigJobExample.createCriteria().andConfigIdIn(cfgIds).andJobStatusEqualTo(StatusEnum.NORMAL.getStatus());
        List cfgConfigJobEntities = this.cfgConfigJobDao.selectByExample(cfgConfigJobExample);
        XxlJobUtil.login((String)this.adminAddresses, (String)this.xxlUserName, (String)this.xxlPassword);
        for (CfgConfigJobEntity cfgConfigJobEntity : cfgConfigJobEntities) {
            cfgConfigJobEntity.setJobStatus(StatusEnum.DELETE.getStatus());
            this.cfgConfigJobDao.updateByPrimaryKey(cfgConfigJobEntity);
            XxlJobUtil.deleteJob((String)this.adminAddresses, (int)cfgConfigJobEntity.getJobId());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Response addCfgConfig(MsConfigAddRequestWithUserInfo msConfigAddRequestWithUserInfo, String ... channels) {
        logger.info("addCfgConfigAndItem msConfigAddRequestWithUserInfo===>{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigAddRequestWithUserInfo));
        Response response2 = Response.failed((String)"");
        List msConfigBeanList = msConfigAddRequestWithUserInfo.getItemDTOList();
        if (CollectionUtils.isEmpty((Collection)msConfigBeanList)) {
            response2.setMessage("\u89c4\u5219\u914d\u7f6e\u9879\u4e0d\u80fd\u4e3a\u7a7a.");
            return response2;
        }
        MsConfigBean msConfigBean = (MsConfigBean)msConfigBeanList.get(0);
        if (Objects.equals(ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType(), msConfigBean.getConfigType())) {
            if (StringUtils.isEmpty((CharSequence)msConfigBean.getTaxInvoiceSource())) {
                response2.setMessage("\u56fd\u7a0e\u53d1\u7968\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a.");
                return response2;
            }
            if (Arrays.stream(TaxInvoiceSource.values()).noneMatch(it -> it.getValue().equals(msConfigBean.getTaxInvoiceSource()))) {
                response2.setMessage("\u56fd\u7a0e\u53d1\u7968\u6765\u6e90\u679a\u4e3e\u8303\u56f4\u662f qd \u6216\u8005 sk");
                return response2;
            }
            this.getInvoiceLimit(msConfigAddRequestWithUserInfo.getUserInfo().getGroupId(), msConfigBean);
        }
        if (ConfigTypeEnum.VIRTUAL_INVOICE_AUTO_TYPE.getConfigType().equals(msConfigBean.getConfigType())) {
            msConfigBean.setBusinessBillType(BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType());
        }
        if (ConfigTypeEnum.DISCOUNT_RATE_CONFIG_TYPE.getConfigType().equals(msConfigBean.getConfigType())) {
            msConfigBean.setBusinessBillType(BusinessSalesBillTypeEnum.AP.getBusinessSalesBillType());
        }
        String businessBillType = msConfigBean.getBusinessBillType();
        if (!BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(businessBillType) && !BusinessSalesBillTypeEnum.AP.getBusinessSalesBillType().equals(businessBillType)) {
            response2.setMessage(ConfigErrorEnum.CONFIG_META_DATA_CHECK_ERROR.message());
            return response2;
        }
        MsCommonUserInfo userInfo = msConfigAddRequestWithUserInfo.getUserInfo();
        if (BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(msConfigBean.getBusinessBillType())) {
            msConfigBean.setSellerGroupId(userInfo.getGroupId());
        } else {
            msConfigBean.setPurchaserGroupId(userInfo.getGroupId());
        }
        this.fillCompanyInfo(msConfigBean, userInfo);
        this.fillOrgInfo(msConfigBean, userInfo);
        logger.info("addCfgConfigAndItem msConfigBean2==========>{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigBean));
        logger.info("msConfigBean.getConfigId()==========>{}", (Object)msConfigBean.getConfigId());
        if (null == msConfigBean.getConfigId() || msConfigBean.getConfigId() == 0L) {
            if (ConfigTypeEnum.DISCOUNT_RATE_CONFIG_TYPE.getConfigType().equals(msConfigBean.getConfigType())) {
                msConfigBean.setConfigId(this.queryConfigService.queryConfigId(userInfo.getGroupId().longValue(), msConfigBean.getPurchaserTaxNo(), msConfigBean.getSellerTaxNo()));
                logger.info("msConfigBean.getConfigId()==========>{}", (Object)msConfigBean.getConfigId());
            } else {
                boolean ruleExists = this.queryInvoiceConfigRuleExists(msConfigBean);
                if (ruleExists && !ConfigTypeEnum.INVOICE_MAIL_RULE_CONFIG_TYPE.getConfigType().equals(msConfigBean.getConfigType())) {
                    response2.setMessage("\u89c4\u5219\u5df2\u5b58\u5728.");
                    return response2;
                }
            }
        }
        this.checkBusinessConfig(msConfigBean, channels);
        this.checkConfigItemRequired(msConfigBean);
        Long configId = this.addOrUpdateCfgConfig(msConfigBean, userInfo);
        List msConfigItemBeans = msConfigBean.getItemList();
        boolean isUpdateOperation = configId.equals(msConfigBean.getConfigId());
        logger.info("isUpdateOperation ==========>{}", (Object)isUpdateOperation);
        int configType = msConfigBean.getConfigType();
        if (ConfigTypeEnum.INVOICE_MAIL_RULE_CONFIG_TYPE.getConfigType() == configType) {
            ConfigBizConfigService proxy = (ConfigBizConfigService)AopContext.currentProxy();
            try {
                proxy.addOrUpdateMailRuleConfigAndRegisterTask(configId, msConfigBean, userInfo, isUpdateOperation);
            }
            catch (Exception e) {
                logger.error("@addCfgConfig.addMailRuleConfigAndRegisterTask error : ", (Throwable)e);
                throw new RuntimeException("\u4fdd\u5b58\u90ae\u4ef6\u89c4\u5219\u51fa\u73b0\u5f02\u5e38");
            }
            response2.setCode(Response.OK);
            response2.setMessage("mail notice configuration saved.");
        }
        if (ConfigTypeEnum.DISCOUNT_RATE_CONFIG_TYPE.getConfigType().equals(msConfigBean.getConfigType())) {
            this.convertDiscountItem(msConfigItemBeans);
        }
        if (isUpdateOperation) {
            if (ConfigTypeEnum.DISCOUNT_RATE_CONFIG_TYPE.getConfigType().equals(msConfigBean.getConfigType())) {
                this.updateConfigItemByConfigId(configId, msConfigItemBeans, channels);
            } else {
                this.configItemExtDao.deleteConfigItemByConfigId(configId);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)msConfigItemBeans)) {
            MsConfigItemAddRequestWithUserInfo msConfigItemAddRequest = new MsConfigItemAddRequestWithUserInfo();
            msConfigItemAddRequest.setItemDTOList(msConfigItemBeans);
            msConfigItemAddRequest.setConfigId(configId);
            msConfigItemAddRequest.setUserInfo(userInfo);
            this.addCfgConfigItem(msConfigItemAddRequest, msConfigBean, channels);
        }
        try {
            response2 = this.handleVirtualInvoiceAutoConfig(msConfigBean, configId);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (Response.Fail.equals(response2.getCode())) {
            throw new TipsException(response2.getMessage());
        }
        response2.setCode(Response.OK);
        response2.setMessage("\u6dfb\u52a0\u6210\u529f.");
        List attributes = msConfigBean.getAttributes();
        if (!CollectionUtils.isEmpty((Collection)attributes)) {
            if (isUpdateOperation) {
                this.updateConfigBizBillAttributes(configId, msConfigBean);
            } else {
                this.addConfigBizBillAttributes(configId, msConfigBean);
            }
        }
        response2.setCode(Response.OK);
        response2.setMessage("\u6dfb\u52a0\u6210\u529f.");
        return response2;
    }

    private void getInvoiceLimit(Long groupId, MsConfigBean msConfigBean) {
        String taxNo;
        boolean hasLimit = msConfigBean.getItemList().stream().filter(it -> it.getConfigItemName().equals("invoiceLimit")).findFirst().map(MsConfigItemBean::getConfigItemValue).map(it -> CollectionUtils.isNotEmpty((Collection)it) && !it.contains("null")).orElse(false);
        MsConfigItemBean priceMethodExists = msConfigBean.getItemList().stream().filter(it -> it.getConfigItemName().equals("priceMethod")).findFirst().orElse(null);
        boolean withoutTax = Optional.of(priceMethodExists).map(it -> it.getConfigItemValue()).filter(CollectionUtils::isNotEmpty).map(it -> "0".equals(it.get(0))).orElse(true);
        if (!hasLimit && !TaxInvoiceSource.QD.getValue().equals(msConfigBean.getTaxInvoiceSource()) && StringUtils.isNotEmpty((CharSequence)(taxNo = msConfigBean.getSellerTaxNo()))) {
            BigDecimal limit;
            CompanyData companyData = this.getCompanyInvoiceLimit(groupId, taxNo);
            switch (msConfigBean.getInvoiceType()) {
                case "c": {
                    limit = companyData.getCquota();
                    break;
                }
                case "s": {
                    limit = companyData.getSquota();
                    break;
                }
                case "ce": {
                    limit = companyData.getCeQuota();
                    break;
                }
                case "se": {
                    limit = companyData.getSeQuota();
                    break;
                }
                case "ju": {
                    limit = companyData.getJuQuota();
                    break;
                }
                case "v": {
                    limit = companyData.getVehicleLimit();
                    break;
                }
                default: {
                    limit = null;
                }
            }
            logger.info("getInvoiceLimit: {}", (Object)limit);
            if (limit != null && !limit.equals("0") && withoutTax) {
                MsConfigItemBean bean = new MsConfigItemBean();
                bean.setConfigItemDisplayName("\u5f00\u7968\u9650\u989d");
                bean.setConfigItemName("invoiceLimit");
                bean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{limit.toPlainString()}));
                msConfigBean.getItemList().add(bean);
                if (priceMethodExists == null) {
                    MsConfigItemBean priceMethod = new MsConfigItemBean();
                    bean.setConfigItemDisplayName("\u4ef7\u683c\u65b9\u5f0f");
                    bean.setConfigItemName("priceMethod");
                    bean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{"0"}));
                    msConfigBean.getItemList().add(priceMethod);
                }
            }
        }
    }

    public CompanyData getCompanyInvoiceLimit(Long tenantId, String taxNoLike) {
        try {
            UserCenterResponse response2 = this.userCenterController.getCompanyByTaxNo(tenantId.longValue(), taxNoLike);
            return (CompanyData)response2.getResult();
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7528\u6237\u4fe1\u606fV2\u63a5\u53e3\u5f02\u5e38\uff1a", (Throwable)e);
            return null;
        }
    }

    private void convertDiscountItem(List<MsConfigItemBean> msConfigItemBeans) {
        msConfigItemBeans.forEach(configItemBean -> {
            String itemValue = (String)configItemBean.getConfigItemValue().get(1);
            BigDecimal discount = new BigDecimal(itemValue).divide(new BigDecimal("100"));
            configItemBean.getConfigItemValue().set(1, discount.toString());
        });
    }

    private void updateConfigItemByConfigId(Long configId, List<MsConfigItemBean> msConfigItemBeans, String[] channels) {
        List itemIds;
        CfgConfigItemExample configItemExample = new CfgConfigItemExample();
        configItemExample.createCriteria().andConfigIdEqualTo(configId).andStatusEqualTo(Integer.valueOf(1));
        List entities = this.cfgConfigItemDao.selectByExample(configItemExample);
        Set updateValues = msConfigItemBeans.stream().map(it -> JSON.toJSONString((Object)it.getConfigItemValue())).collect(Collectors.toSet());
        if ((Objects.isNull(channels) || channels.length == 0) && CollectionUtils.isNotEmpty(itemIds = entities.stream().filter(it -> !updateValues.contains(it.getConfigItemValue())).map(it -> it.getConfigItemId()).collect(Collectors.toList()))) {
            this.deleteDiscountItem(itemIds);
        }
        Set existValues = entities.stream().map(it -> it.getConfigItemValue()).collect(Collectors.toSet());
        Iterator<MsConfigItemBean> iterator = msConfigItemBeans.iterator();
        while (iterator.hasNext()) {
            MsConfigItemBean bean = iterator.next();
            if (!existValues.contains(JSON.toJSONString((Object)bean.getConfigItemValue()))) continue;
            iterator.remove();
        }
    }

    private void deleteDiscountItem(List<Long> itemIds) {
        CfgConfigItemEntity cfgConfigItemEntity = new CfgConfigItemEntity();
        cfgConfigItemEntity.setStatus(StatusEnum.DELETE.getStatus());
        CfgConfigItemExample configItemExample = new CfgConfigItemExample();
        configItemExample.createCriteria().andConfigItemIdIn(itemIds);
        this.cfgConfigItemDao.updateByExampleSelective(cfgConfigItemEntity, configItemExample);
    }

    @Transactional(rollbackFor={Exception.class})
    public Long addOrUpdateMailRuleConfigAndRegisterTask(Long configId, MsConfigBean msConfigBean, MsCommonUserInfo userInfo, boolean isUpdateOp) throws Exception {
        MsConfigMailRule mailRule = msConfigBean.getMailRule();
        logger.info("addOrUpdateMailRuleConfigAndRegisterTask model: ", (Object)StringUtil.describeBean((Object)mailRule));
        CfgConfigMailRuleEntity entity = new CfgConfigMailRuleEntity();
        BeanMapper.copy((Object)mailRule, (Object)entity);
        entity.setCreateUser(userInfo.getUserId());
        entity.setCreateTime(new Date());
        entity.setConfigId(configId);
        entity.setPickUcAddress(Boolean.valueOf(mailRule.isPickUCAddress()));
        entity.setMailTemplateNo(this.mailTemplateNo);
        entity.setStatus(Integer.valueOf(1));
        if (isUpdateOp) {
            CfgConfigExample cfgExample = new CfgConfigExample();
            cfgExample.createCriteria().andConfigIdEqualTo(configId).andStatusEqualTo(Byte.valueOf(ConstantValue.STATUS_ACTIVE.byteValue()));
            Long count = this.cfgConfigDao.countByExample(cfgExample);
            if (0L == count) {
                throw new RuntimeException("\u66f4\u65b0\u65f6\u6ca1\u6709\u5339\u914d\u5230\u4efb\u4f55\u89c4\u5219.");
            }
            CfgConfigMailRuleExample example = new CfgConfigMailRuleExample();
            example.createCriteria().andConfigIdEqualTo(configId).andStatusEqualTo(ConstantValue.STATUS_ACTIVE);
            List list = this.cfgConfigMailRuleDao.selectByExample(example);
            if (CollectionUtils.isEmpty((Collection)list)) {
                throw new RuntimeException("\u66f4\u65b0\u65f6\u6ca1\u6709\u5339\u914d\u5230\u4efb\u4f55\u90ae\u4ef6\u89c4\u5219.");
            }
            CfgConfigMailRuleEntity update2 = new CfgConfigMailRuleEntity();
            update2.setStatus(ConstantValue.STATUS_DEL);
            this.cfgConfigMailRuleDao.updateByExampleSelective(update2, example);
            this.cfgConfigMailRuleDao.insertSelective(entity);
        } else {
            this.cfgConfigMailRuleDao.insertSelective(entity);
            logger.info("@addMailRuleConfigAndRegisterTask \u4fdd\u5b58\u90ae\u4ef6\u63a8\u9001\u89c4\u5219 , entity", (Object)StringUtil.describeBean((Object)entity));
        }
        return entity.getId();
    }

    public void addConfigBizBillAttributes(Long configId, MsConfigBean msConfigBean) {
        if (CollectionUtils.isEmpty((Collection)msConfigBean.getAttributes())) {
            return;
        }
        String bizBillType = msConfigBean.getBusinessBillType();
        String salesBillType = msConfigBean.getSalesbillType();
        Long finalGroupId = BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(bizBillType) ? msConfigBean.getSellerGroupId() : msConfigBean.getPurchaserGroupId();
        msConfigBean.getAttributes().forEach(attr -> {
            CfgConfigBillAttributeEntity entity = new CfgConfigBillAttributeEntity();
            entity.setConfigId(configId);
            entity.setGroupId(finalGroupId);
            entity.setBusinessBillType(bizBillType);
            entity.setSalesbillType(salesBillType);
            entity.setAttrName(attr.getAttrName());
            if ("ext".equals(attr.getFieldName()) && "\u7a7a\u503c\uff08\u7279\u6307\u503c\u4e3a\u7a7a\u7684\u6570\u636e\uff09".equals(attr.getAttrName())) {
                entity.setValue("");
            } else {
                entity.setValue(attr.getValue());
            }
            entity.setFieldName(attr.getFieldName());
            entity.setFieldValue(attr.getFieldValue());
            entity.setAttrDesc(StringUtil.fillEmpty((String)attr.getAttrDesc()));
            entity.setStatus(ConstantValue.STATUS_ACTIVE);
            entity.setCreateTime(new Date());
            this.cfgConfigBillAttributeExtDao.insertSelective(entity);
        });
    }

    public void updateConfigBizBillAttributes(Long configId, MsConfigBean msConfigBean) {
        CfgConfigBillAttributeExample example = new CfgConfigBillAttributeExample();
        example.createCriteria().andConfigIdEqualTo(configId).andStatusEqualTo(ConstantValue.STATUS_ACTIVE);
        CfgConfigBillAttributeEntity updateRecord = new CfgConfigBillAttributeEntity();
        updateRecord.setStatus(ConstantValue.STATUS_DEL);
        this.cfgConfigBillAttributeExtDao.updateByExampleSelective(updateRecord, example);
        this.addConfigBizBillAttributes(configId, msConfigBean);
    }

    private Response handleVirtualInvoiceAutoConfig(MsConfigBean msConfigBean, Long configId) throws IOException {
        if (!ConfigTypeEnum.VIRTUAL_INVOICE_AUTO_TYPE.getConfigType().equals(msConfigBean.getConfigType())) {
            return Response.ok((String)"\u975e\u865a\u62df\u53d1\u7968\u65e0\u9700\u4fdd\u5b58xxl-job\u8ba1\u5212");
        }
        Response saveResponse = null;
        List msConfigItemBeans = msConfigBean.getItemList();
        HashMap itemMap = Maps.newHashMap();
        msConfigItemBeans.forEach(a -> itemMap.put(a.getConfigItemName(), a.getConfigItemValue()));
        String billJobGroups = XxlJobUtil.getJobGroups((String)this.adminAddresses, (String)"bill-service", null);
        if (Strings.isEmpty((CharSequence)billJobGroups)) {
            return Response.failed((String)"xxl-job\u4e2d\u672a\u67e5\u8be2\u5230bill\u6267\u884c\u5668");
        }
        String invoiceJobGroups = XxlJobUtil.getJobGroups((String)this.adminAddresses, (String)"invoice-service", null);
        if (Strings.isEmpty((CharSequence)invoiceJobGroups)) {
            return Response.failed((String)"xxl-job\u4e2d\u672a\u67e5\u8be2\u5230invoice-service\u6267\u884c\u5668");
        }
        JobGroupPageListResult jobGroupPageListResult = (JobGroupPageListResult)JsonUtils.writeFastJsonToObject((String)billJobGroups, JobGroupPageListResult.class);
        if (CollectionUtils.isEmpty((Collection)jobGroupPageListResult.getData())) {
            return Response.failed((String)"xxl-job\u4e2d\u672a\u67e5\u8be2\u5230bill\u6267\u884c\u5668");
        }
        JobGroupPageListResult invoiceJobGroupPageListResult = (JobGroupPageListResult)JsonUtils.writeFastJsonToObject((String)invoiceJobGroups, JobGroupPageListResult.class);
        if (CollectionUtils.isEmpty((Collection)invoiceJobGroupPageListResult.getData())) {
            return Response.failed((String)"xxl-job\u4e2d\u672a\u67e5\u8be2\u5230invoice-service\u6267\u884c\u5668");
        }
        int billExecutorId = ((XxlJobGroup)jobGroupPageListResult.getData().get(0)).getId();
        int invoiceServiceExecutorId = ((XxlJobGroup)invoiceJobGroupPageListResult.getData().get(0)).getId();
        boolean isMakeout = false;
        boolean isRedFlush = false;
        if (this.isChecked((List)itemMap.get("isMakeout"))) {
            isMakeout = true;
            if (this.isChecked((List)itemMap.get("dailyAutoMakeoutFlag"))) {
                saveResponse = this.generateAutoInvoiceXxlScheduler(Integer.valueOf(GenerateCronJobEnum.DAILY_SCHEDULER.getType()), null, (List)itemMap.get("dailyAutoMakeoutTime"), msConfigBean, "virtualInvoiceAutoSplitAndMakeoutJob", configId, billExecutorId);
            } else if (this.isChecked((List)itemMap.get("monthlyAutoMakeoutFlag"))) {
                saveResponse = this.generateAutoInvoiceXxlScheduler(Integer.valueOf(GenerateCronJobEnum.MONTHLY_SCHEDULER.getType()), (List)itemMap.get("monthlyAutoMakeoutDate"), (List)itemMap.get("monthlyAutoMakeoutTime"), msConfigBean, "virtualInvoiceAutoSplitAndMakeoutJob", configId, billExecutorId);
            } else if (this.isChecked((List)itemMap.get("lastDayOfMonthAutoMakeoutFlag"))) {
                saveResponse = this.generateAutoInvoiceXxlScheduler(Integer.valueOf(GenerateCronJobEnum.LAST_DAY_OF_MONTH.getType()), null, (List)itemMap.get("lastDayOfMonthAutoMakeoutTime"), msConfigBean, "virtualInvoiceAutoSplitAndMakeoutJob", configId, billExecutorId);
            }
            if (Response.Fail.equals(saveResponse.getCode())) {
                return saveResponse;
            }
            this.maintainConfigJob(msConfigBean, configId, saveResponse, 1, "-AutoMakeout");
        } else if (!this.isChecked((List)itemMap.get("isMakeout"))) {
            isMakeout = false;
            this.deleteJobAndXxlJob(configId, 1);
        }
        if (this.isChecked((List)itemMap.get("isRedFlush"))) {
            isRedFlush = true;
            if (this.isChecked((List)itemMap.get("dailyRedFlushoutFlag"))) {
                saveResponse = this.generateAutoInvoiceXxlScheduler(Integer.valueOf(GenerateCronJobEnum.DAILY_SCHEDULER.getType()), null, (List)itemMap.get("dailyRedFlushoutTime"), msConfigBean, "virtualInvoiceAutoRedFlushJob", configId, billExecutorId);
            } else if (this.isChecked((List)itemMap.get("monthlyRedFlushoutFlag"))) {
                saveResponse = this.generateAutoInvoiceXxlScheduler(Integer.valueOf(GenerateCronJobEnum.MONTHLY_SCHEDULER.getType()), (List)itemMap.get("monthlyRedFlushoutDate"), (List)itemMap.get("monthlyRedFlushoutTime"), msConfigBean, "virtualInvoiceAutoRedFlushJob", configId, billExecutorId);
            } else if (this.isChecked((List)itemMap.get("lastDayOfMonthRedFlushoutFlag"))) {
                saveResponse = this.generateAutoInvoiceXxlScheduler(Integer.valueOf(GenerateCronJobEnum.LAST_DAY_OF_MONTH.getType()), null, (List)itemMap.get("lastDayOfMonthRedFlushoutTime"), msConfigBean, "virtualInvoiceAutoRedFlushJob", configId, billExecutorId);
            }
            this.maintainConfigJob(msConfigBean, configId, saveResponse, 2, "-RedFlush");
        } else if (!this.isChecked((List)itemMap.get("isRedFlush"))) {
            isRedFlush = false;
            this.deleteJobAndXxlJob(configId, 2);
        }
        if (!isMakeout && !isRedFlush) {
            saveResponse = Response.ok((String)"\u672a\u5f00\u542f\u81ea\u52a8\u5f00\u5177\u548c\u81ea\u52a8\u7ea2\u51b2");
        }
        return saveResponse;
    }

    private void deleteJobAndXxlJob(Long configId, int jobType) throws IOException {
        CfgConfigJobExample cfgConfigJobExample = new CfgConfigJobExample();
        cfgConfigJobExample.createCriteria().andConfigIdEqualTo(configId).andJobStatusEqualTo(StatusEnum.NORMAL.getStatus()).andJobTypeEqualTo(Integer.valueOf(jobType));
        List cfgConfigJobEntities = this.cfgConfigJobDao.selectByExample(cfgConfigJobExample);
        for (CfgConfigJobEntity cfgConfigJobEntity : cfgConfigJobEntities) {
            cfgConfigJobEntity.setJobStatus(StatusEnum.DELETE.getStatus());
            this.cfgConfigJobDao.updateByPrimaryKey(cfgConfigJobEntity);
            XxlJobUtil.deleteJob((String)this.adminAddresses, (int)cfgConfigJobEntity.getJobId());
        }
    }

    private void maintainConfigJob(MsConfigBean msConfigBean, Long configId, Response saveResponse, int i, String s) {
        if (null != saveResponse && Response.OK.equals(saveResponse.getCode()) && null != saveResponse.getResult()) {
            Integer autoMakeId = Integer.parseInt(String.valueOf(saveResponse.getResult()));
            CfgConfigJobExample cfgConfigJobExample = new CfgConfigJobExample();
            CfgConfigJobExample.Criteria criteria = cfgConfigJobExample.createCriteria();
            criteria.andConfigIdEqualTo(configId);
            criteria.andJobTypeEqualTo(Integer.valueOf(i));
            criteria.andJobStatusEqualTo(StatusEnum.NORMAL.getStatus());
            CfgConfigJobEntity cfgConfigJobEntity = this.cfgConfigJobDao.selectOneByExample(cfgConfigJobExample);
            if (Objects.isNull(cfgConfigJobEntity)) {
                this.cfgConfigJobDao.insert(new CfgConfigJobEntity(autoMakeId, configId, Integer.valueOf(i), msConfigBean.getConfigName() + s, StatusEnum.NORMAL.getStatus()));
            }
        }
    }

    private String getCronExpr(Integer type, List<String> date, List<String> time) throws TipsException {
        StringBuilder cronExpr = new StringBuilder();
        cronExpr.append("0 ");
        String setTime = time.get(0);
        if (Strings.isNullOrEmpty((String)setTime)) {
            throw new TipsException("xxl-job\u4efb\u52a1\u521b\u5efa\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] hourAndMinute = setTime.split(":");
        cronExpr.append(hourAndMinute[1]).append(" ").append(hourAndMinute[0]).append(" ");
        switch (type) {
            case 1: {
                cronExpr.append("* * ?");
                break;
            }
            case 2: {
                if (CollectionUtils.isEmpty(date)) {
                    logger.error("virtual invoice, cannot create monthly xxljob if Date is empty");
                    throw new TipsException("xxl-job\u4efb\u52a1\u521b\u5efa\u5931\u8d25\uff0c\u6bcf\u6708\u5b9a\u65f6\u6267\u884c\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
                }
                String setDay = date.get(0);
                cronExpr.append(setDay).append(" ").append("* ?");
                break;
            }
            case 3: {
                cronExpr.append("L * ?");
                break;
            }
        }
        logger.info("cronExpr:{}", (Object)cronExpr);
        return cronExpr.toString();
    }

    private Response generateAutoInvoiceXxlScheduler(Integer type, List<String> date, List<String> time, MsConfigBean msConfigBean, String javaBeanHandler, Long savedConfigId, int executorId) throws IOException {
        if (CollectionUtils.isEmpty(time)) {
            logger.error("virtual invoice, cannot create xxljob if time is empty");
            return Response.failed((String)"xxl-job\u4efb\u52a1\u521b\u5efa\u5931\u8d25\uff0c\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (GenerateCronJobEnum.MONTHLY_SCHEDULER.getType() == type.intValue() && CollectionUtils.isEmpty(date)) {
            logger.error("virtual invoice, cannot create xxljob if time is empty");
            return Response.failed((String)"xxl-job\u4efb\u52a1\u521b\u5efa\u5931\u8d25\uff0c\u6309\u6708\u6267\u884c\u65f6\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String cronExpr = this.getCronExpr(type, date, time);
        try {
            Thread.currentThread();
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        JSONObject requestInfo = this.getAutoJsonInfo(msConfigBean.getConfigName(), cronExpr, executorId, javaBeanHandler, savedConfigId);
        Long configId = msConfigBean.getConfigId();
        String jobId = "0";
        JSONObject saveResponse = null;
        if (Objects.nonNull(configId)) {
            CfgConfigJobExample cfgConfigJobExample = new CfgConfigJobExample();
            CfgConfigJobExample.Criteria criteria = cfgConfigJobExample.createCriteria();
            criteria.andConfigIdEqualTo(configId);
            if ("virtualInvoiceAutoSplitAndMakeoutJob".equals(javaBeanHandler)) {
                criteria.andJobTypeEqualTo(Integer.valueOf(1));
            } else if ("virtualInvoiceAutoRedFlushJob".equals(javaBeanHandler)) {
                criteria.andJobTypeEqualTo(Integer.valueOf(2));
            }
            criteria.andJobStatusEqualTo(StatusEnum.NORMAL.getStatus());
            CfgConfigJobEntity cfgConfigJobEntity = this.cfgConfigJobDao.selectOneByExample(cfgConfigJobExample);
            if (null == cfgConfigJobEntity) {
                saveResponse = XxlJobUtil.addJob((String)this.adminAddresses, (JSONObject)requestInfo);
            } else {
                requestInfo.put("id", (Object)String.valueOf(cfgConfigJobEntity.getJobId()));
                jobId = String.valueOf(cfgConfigJobEntity.getJobId());
                saveResponse = XxlJobUtil.updateJob((String)this.adminAddresses, (JSONObject)requestInfo);
            }
        } else {
            saveResponse = XxlJobUtil.addJob((String)this.adminAddresses, (JSONObject)requestInfo);
        }
        if (null == saveResponse) {
            return Response.failed((String)"\u8c03\u7528xxl-job api\u63a5\u53e3\u5931\u8d25\uff01");
        }
        if (saveResponse.containsKey((Object)"code") && 200 == saveResponse.getInteger("code")) {
            logger.info("\u6dfb\u52a0/\u66f4\u65b0\u6210\u529f\uff0crequestInfo\uff1a{}", (Object)JsonUtils.writeObjectToFastJson((Object)requestInfo));
            if ("0".equals(jobId) && !Strings.isNullOrEmpty((String)saveResponse.getString("content"))) {
                jobId = saveResponse.getString("content");
            }
        } else {
            return Response.failed((String)"\u6dfb\u52a0/\u66f4\u65b0\u5931\u8d25\uff0c\u8c03\u7528xxl-job api\u63a5\u53e3\u5931\u8d25\uff01");
        }
        JSONObject startResponse = XxlJobUtil.startJob((String)this.adminAddresses, (int)Integer.parseInt(jobId));
        if (startResponse.containsKey((Object)"code") && 200 == startResponse.getInteger("code")) {
            logger.info("\u542f\u52a8\u6210\u529f\uff0crequestInfo\uff1a{}", (Object)JsonUtils.writeObjectToFastJson((Object)startResponse));
            return Response.ok((String)"\u4fdd\u5b58\u5e76\u542f\u52a8\u6210\u529f", (Object)jobId);
        }
        return Response.failed((String)"\u542f\u52a8\u5931\u8d25\uff0c\u8c03\u7528api\u63a5\u53e3\u5931\u8d25\uff01");
    }

    private JSONObject getAutoJsonInfo(String configName, String cronExpr, int executorId, String javaBeanHandler, Long savedConfigId) {
        JSONObject requestInfo = new JSONObject();
        requestInfo.put("jobGroup", (Object)executorId);
        configName = "virtualInvoiceAutoSplitAndMakeoutJob".equals(javaBeanHandler) ? configName + "-AutoMakeout" : configName + "-RedFlush";
        requestInfo.put("jobDesc", (Object)configName);
        requestInfo.put("executorRouteStrategy", (Object)"FIRST");
        requestInfo.put("jobCron", (Object)cronExpr);
        requestInfo.put("glueType", (Object)"BEAN");
        requestInfo.put("executorHandler", (Object)javaBeanHandler);
        requestInfo.put("executorBlockStrategy", (Object)"SERIAL_EXECUTION");
        requestInfo.put("executorTimeout", (Object)0);
        requestInfo.put("executorFailRetryCount", (Object)1);
        requestInfo.put("author", (Object)"Admin");
        requestInfo.put("executorParam", (Object)String.valueOf(savedConfigId));
        return requestInfo;
    }

    private boolean isChecked(List<String> toCheckEntry) {
        boolean isCheck = false;
        if (!CollectionUtils.isEmpty(toCheckEntry)) {
            String s;
            switch (s = toCheckEntry.get(0)) {
                case "true": 
                case "True": {
                    isCheck = true;
                    break;
                }
                case "false": 
                case "False": {
                    isCheck = false;
                    break;
                }
            }
        }
        return isCheck;
    }

    private Long addOrUpdateCfgConfig(MsConfigBean msConfigBean, MsCommonUserInfo userInfo) {
        Long configId = msConfigBean.getConfigId();
        CfgConfigEntity entity = ConfigEntityTranslater.convertFromMsConfigBean((MsConfigBean)msConfigBean);
        entity.setUpdateTime(new Date());
        if (configId == null || configId == 0L) {
            int result;
            configId = this.generator.nextId();
            entity.setConfigId(configId);
            entity.setStatus(StatusEnum.NORMAL.getStatus());
            entity.setCreateTime(entity.getUpdateTime());
            entity.setCreateUser(userInfo.getUserId());
            try {
                result = this.cfgConfigDao.insertSelective(entity);
            }
            catch (DuplicateKeyException exception) {
                throw new ConfigExsitException();
            }
            if (result < 1) {
                throw new ConfigCreateException();
            }
            return configId;
        }
        try {
            this.cfgConfigDao.updateByPrimaryKeySelective(entity);
        }
        catch (DuplicateKeyException exception) {
            throw new ConfigExsitException();
        }
        return entity.getConfigId();
    }

    @Transactional(rollbackFor={Exception.class})
    public int addCfgConfigItem(MsConfigItemAddRequestWithUserInfo msConfigItemAddRequest, MsConfigBean temp, String ... channels) {
        int result;
        boolean defaultAssociationCondition;
        List msConfigItemBeans = msConfigItemAddRequest.getItemDTOList();
        if (ConfigTypeEnum.BILL_MERGE_TYPE.getConfigType().intValue() == temp.getConfigType().intValue() && !(defaultAssociationCondition = msConfigItemBeans.stream().anyMatch(item -> item.getConfigItemName().equals("defaultAssociationCondition")))) {
            CfgTemplateObjExample cfgTemplateObjExample = new CfgTemplateObjExample();
            cfgTemplateObjExample.createCriteria().andTemplateObjCodeEqualTo(ConfigTypeEnum.BILL_MERGE_TYPE.getObjCode()).andStatusEqualTo(Integer.valueOf(1));
            CfgTemplateObjEntity cfgTemplateObjEntity = this.cfgTemplateObjDao.selectOneByExample(cfgTemplateObjExample);
            if (cfgTemplateObjEntity != null) {
                CfgTemplateObjMetadataExample cfgTemplateObjMetadataExample = new CfgTemplateObjMetadataExample();
                ArrayList<String> fieldNames = new ArrayList<String>(2);
                fieldNames.add("defaultAssociationCondition");
                fieldNames.add("defaultMergerCondition");
                cfgTemplateObjMetadataExample.createCriteria().andBusinessObjIdEqualTo(cfgTemplateObjEntity.getTemplateObjId()).andFieldNameIn(fieldNames);
                List list = this.cfgTemplateObjMetadataDao.selectByExample(cfgTemplateObjMetadataExample);
                List finalMsConfigItemBeans = msConfigItemBeans;
                list.forEach(m -> {
                    MsConfigItemBean msConfigItemBean = new MsConfigItemBean();
                    msConfigItemBean.setConfigItemName(m.getFieldName());
                    msConfigItemBean.setConfigItemDisplayName(m.getFieldDisplayName());
                    String fieldEnumValue = m.getFieldEnumValue();
                    ArrayList defaultValues = new ArrayList();
                    List msEnumBeans = JsonUtils.writeJsonToListObject((String)fieldEnumValue, MsEnumBean.class);
                    msEnumBeans.forEach(item -> defaultValues.add(item.getValue()));
                    msConfigItemBean.setConfigItemValue(defaultValues);
                    finalMsConfigItemBeans.add(msConfigItemBean);
                });
                msConfigItemBeans = finalMsConfigItemBeans;
            }
        }
        if (ConfigTypeEnum.SYS_CONFIG_TYPE.getConfigType().intValue() == temp.getConfigType().intValue()) {
            List list = msConfigItemAddRequest.getItemDTOList();
            for (MsConfigItemBean msConfigItemBean : list) {
                if ("billTolerance".equals(msConfigItemBean.getConfigItemName())) {
                    try {
                        if (!CollectionUtils.isEmpty((Collection)msConfigItemBean.getConfigItemValue())) {
                            if (Strings.isNullOrEmpty((String)((String)msConfigItemBean.getConfigItemValue().get(0)))) break;
                            BigDecimal balance = new BigDecimal((String)msConfigItemBean.getConfigItemValue().get(0));
                            if (balance.compareTo(BigDecimal.ZERO) < 0) {
                                throw new RuntimeException("\u4e1a\u52a1\u5355\u5bb9\u5dee\u4e0d\u5141\u8bb8\u4e3a\u8d1f\u6570");
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        logger.error("\u5bb9\u5dee\u683c\u5f0f\u5316\u9519\u8bef", (Throwable)e);
                    }
                }
                if (!"qdVoucherControl".equals(msConfigItemBean.getConfigItemName()) || !CollectionUtils.isEmpty((Collection)msConfigItemBean.getConfigItemValue()) && (msConfigItemBean.getConfigItemValue().size() != 1 || !StringUtils.isBlank((CharSequence)((CharSequence)msConfigItemBean.getConfigItemValue().get(0))) && !((String)msConfigItemBean.getConfigItemValue().get(0)).equals("null"))) continue;
                throw new RuntimeException("\u5168\u7535\u7535\u7968\u6e90\u6587\u4ef6\u7c7b\u578b\u5fc5\u987b\u914d\u7f6e");
            }
        }
        boolean checkAmountLimit = true;
        if (Objects.nonNull(channels)) {
            checkAmountLimit = Arrays.stream(channels).noneMatch(channel -> "qianniu".equals(channel));
        }
        Long configId = msConfigItemAddRequest.getConfigId();
        MsCommonUserInfo userInfo = msConfigItemAddRequest.getUserInfo();
        ArrayList insertEntityList = Lists.newArrayList();
        for (MsConfigItemBean configItemBean : msConfigItemBeans) {
            String value;
            List list;
            Long id = configItemBean.getConfigItemId();
            if (configId == null || configId == 0L) {
                return 0;
            }
            if ("invoiceLimit".equals(configItemBean.getConfigItemName()) && temp != null && checkAmountLimit && !CollectionUtils.isEmpty((Collection)(list = configItemBean.getConfigItemValue())) && !CommonTools.isEmpty((String)(value = (String)list.get(0)))) {
                this.checkLimitAmt(temp, value);
            }
            if ("priceScale".equals(configItemBean.getConfigItemName()) && !CollectionUtils.isEmpty((Collection)(list = configItemBean.getConfigItemValue())) && !CommonTools.isEmpty((String)(value = (String)list.get(0)))) {
                if (!value.matches("^\\d+$")) {
                    throw new RuntimeException("\u5355\u4ef7\u4f4d\u6570\u5fc5\u987b\u662f\u6b63\u6574\u6570");
                }
                if (Integer.parseInt(value) <= 0 || Integer.parseInt(value) > 15) {
                    throw new RuntimeException("\u5355\u4ef7\u4f4d\u6570\u5927\u4e8e0\u5c0f\u4e8e\u6216\u7b49\u4e8e15");
                }
            }
            if ("discountRateLimit".equals(configItemBean.getConfigItemName()) && !CollectionUtils.isEmpty((Collection)(list = configItemBean.getConfigItemValue())) && !CommonTools.isEmpty((String)(value = (String)list.get(0)))) {
                if (!value.matches("^\\d+$")) {
                    throw new RuntimeException("\u6298\u6263\u7387\u9608\u503c\u533a\u95f4[0,100]");
                }
                if (Integer.parseInt(value) < 0 || Integer.parseInt(value) > 100) {
                    throw new RuntimeException("\u6298\u6263\u7387\u9608\u503c\u533a\u95f4[0,100],\u5f53\u524d\u8bbe\u7f6e\u503c" + value);
                }
            }
            CfgConfigItemEntity cfgConfigItemEntity = ConfigItemEntityTranslator.convertFromMsConfigItemBean((MsConfigItemBean)configItemBean);
            if (ConfigTypeEnum.DISCOUNT_RATE_CONFIG_TYPE.getConfigType().equals(temp.getConfigType())) {
                cfgConfigItemEntity.setStatus(StatusEnum.NORMAL.getStatus());
            }
            cfgConfigItemEntity.setUpdateUser(userInfo.getUserId());
            cfgConfigItemEntity.setUpdateTime(new Date());
            if (id == null || id == 0L) {
                id = this.generator.nextId();
                cfgConfigItemEntity.setConfigItemId(id);
                cfgConfigItemEntity.setConfigId(configId);
                cfgConfigItemEntity.setCreateTime(cfgConfigItemEntity.getUpdateTime());
                cfgConfigItemEntity.setCreateUser(cfgConfigItemEntity.getUpdateUser());
                insertEntityList.add(cfgConfigItemEntity);
                continue;
            }
            int result2 = this.cfgConfigItemDao.updateByPrimaryKeySelective(cfgConfigItemEntity);
            if (result2 >= 1) continue;
            throw new ConfigCreateException();
        }
        if (!CollectionUtils.isEmpty((Collection)insertEntityList) && (result = this.configItemExtDao.batchInsert((List)insertEntityList)) < insertEntityList.size()) {
            throw new ConfigCreateException();
        }
        return 1;
    }

    public Response getOptimalMatchConfig(MsConfigQueryRequest msConfigQueryRequest) {
        List settingCfgConfigEntityList;
        if (null != msConfigQueryRequest && null == msConfigQueryRequest.getStatus()) {
            msConfigQueryRequest.setStatus(Integer.valueOf(1));
        }
        if (CollectionUtils.isEmpty((Collection)(settingCfgConfigEntityList = this.querySettingConfigList(msConfigQueryRequest)))) {
            CfgConfigEntity defaultCfgConfigEntity = this.queryDefaultConfig(msConfigQueryRequest);
            if (defaultCfgConfigEntity == null) {
                return Response.failed((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e");
            }
            MsConfigBean defaultMsConfigBean = ConfigEntityTranslater.convertFromConfigEntity((CfgConfigEntity)defaultCfgConfigEntity);
            defaultMsConfigBean.setDefaultRule(true);
            return this.fillConfigItemList2ConfigBean(defaultMsConfigBean);
        }
        MsConfigBean msConfigBean = ConfigEntityTranslater.convertFromMsConfigQueryRequest((MsConfigQueryRequest)msConfigQueryRequest);
        List settingMsConfigBeanList = settingCfgConfigEntityList.stream().map(item -> ConfigEntityTranslater.convertFromConfigEntity((CfgConfigEntity)item)).collect(Collectors.toList());
        MsConfigBean bestMsConfigBean = this.configMatchParserImpl.getBestMatchConfig(settingMsConfigBeanList, msConfigBean);
        if (logger.isInfoEnabled()) {
            logger.info("getOptimalMatchConfig---bestMsConfigBean:{}", (Object)JsonUtils.writeObjectToFastJson((Object)bestMsConfigBean));
        }
        if (null == bestMsConfigBean) {
            CfgConfigEntity defaultCfgConfigEntity = this.queryDefaultConfig(msConfigQueryRequest);
            MsConfigBean defaultMsConfigBean = ConfigEntityTranslater.convertFromConfigEntity((CfgConfigEntity)defaultCfgConfigEntity);
            return this.fillConfigItemList2ConfigBean(defaultMsConfigBean);
        }
        return this.fillConfigItemList2ConfigBean(bestMsConfigBean);
    }

    public Response getOriginalCfgs(MsConfigQueryRequest msConfigQueryRequest) {
        Response response2 = new Response();
        ArrayList<MsConfigBean> configs = new ArrayList<MsConfigBean>();
        MsConfigBean defaultMsConfigBean = null;
        logger.info("\u83b7\u53d6\u53d1\u7968\u5339\u914d\u89c4\u5219\uff0c\u8bf7\u6c42\u53c2\u6570:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigQueryRequest));
        if (null != msConfigQueryRequest && null == msConfigQueryRequest.getStatus()) {
            msConfigQueryRequest.setStatus(Integer.valueOf(1));
        }
        List settingCfgConfigEntityList = this.querySettingConfigList(msConfigQueryRequest);
        logger.info("@getConfigBean settingCfgConfigEntityList: " + StringUtil.describeBean((Object)settingCfgConfigEntityList));
        CfgConfigEntity defaultCfgConfigEntity = this.queryDefaultConfig(msConfigQueryRequest);
        defaultMsConfigBean = ConfigEntityTranslater.convertFromConfigEntity((CfgConfigEntity)defaultCfgConfigEntity);
        logger.info("getOptimalMatchConfig---defaultMsConfigBean:{}", (Object)JsonUtils.writeObjectToFastJson((Object)defaultMsConfigBean));
        defaultMsConfigBean = this.fillDefaultConfigBean(defaultMsConfigBean);
        configs.add(defaultMsConfigBean);
        if (!CollectionUtils.isEmpty((Collection)settingCfgConfigEntityList)) {
            for (CfgConfigEntity entity : settingCfgConfigEntityList) {
                MsConfigBean config = this.getConfigBean(entity, msConfigQueryRequest);
                SysInfoRuleDTO ruleDTO = this.sysInfoRuleParser.parse(config.getItemList());
                config.setSysInfoRuleDTO(ruleDTO);
                configs.add(config);
            }
        }
        response2.setCode(Response.OK);
        response2.setResult((Object)JsonUtils.writeObjectToFastJson(configs));
        return response2;
    }

    public Response getOriginalMatchedCfgs(MsConfigQueryRequest msConfigQueryRequest) {
        Response response2 = new Response();
        ArrayList<MsConfigBean> configs = new ArrayList<MsConfigBean>();
        MsConfigBean defaultMsConfigBean = null;
        logger.info("\u83b7\u53d6\u53d1\u7968\u5339\u914d\u89c4\u5219\uff0c\u8bf7\u6c42\u53c2\u6570:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigQueryRequest));
        if (null != msConfigQueryRequest && null == msConfigQueryRequest.getStatus()) {
            msConfigQueryRequest.setStatus(Integer.valueOf(1));
        }
        List settingCfgConfigEntityList = this.queryMatchedSettingConfigList(msConfigQueryRequest);
        logger.info("@getConfigBean settingCfgConfigEntityList: " + StringUtil.describeBean((Object)settingCfgConfigEntityList));
        boolean addDefault = false;
        if (!CollectionUtils.isEmpty((Collection)settingCfgConfigEntityList)) {
            int i = settingCfgConfigEntityList.size();
            int j = 0;
            for (CfgConfigEntity entity : settingCfgConfigEntityList) {
                MsConfigBean config = this.getConfigBean(entity, msConfigQueryRequest);
                if (ConfigTypeEnum.BILL_MERGE_TYPE.getConfigType().equals(msConfigQueryRequest.getConfigType()) && BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(msConfigQueryRequest.getBusinessBillType())) {
                    config.setPurchaserGroupId(entity.getPurchaserGroupId());
                    config.setPurchaserTaxNo(entity.getPurchaserTaxNo());
                }
                if (null != config.getAttributes() && !CollectionUtils.isEmpty((Collection)config.getAttributes())) {
                    ++j;
                }
                SysInfoRuleDTO ruleDTO = this.sysInfoRuleParser.parse(config.getItemList());
                config.setSysInfoRuleDTO(ruleDTO);
                configs.add(config);
            }
            if (i == j) {
                addDefault = true;
            }
        } else if (CollectionUtils.isEmpty((Collection)settingCfgConfigEntityList)) {
            addDefault = true;
        }
        if (addDefault) {
            CfgConfigEntity defaultCfgConfigEntity = this.queryDefaultConfig(msConfigQueryRequest);
            defaultMsConfigBean = ConfigEntityTranslater.convertFromConfigEntity((CfgConfigEntity)defaultCfgConfigEntity);
            logger.info("getOriginalMatchedCfgs---defaultMsConfigBean:{}", (Object)JsonUtils.writeObjectToFastJson((Object)defaultMsConfigBean));
            defaultMsConfigBean = this.fillDefaultConfigBean(defaultMsConfigBean);
            configs.add(defaultMsConfigBean);
        }
        response2.setCode(Response.OK);
        response2.setResult((Object)JsonUtils.writeObjectToFastJson(configs));
        return response2;
    }

    private MsConfigBean fillDefaultConfigBean(MsConfigBean msConfigBean) {
        MsConfigItemQueryRequest request = new MsConfigItemQueryRequest();
        request.setConfigId(String.valueOf(msConfigBean.getConfigId()));
        List configItemList = this.queryConfigItemList(request);
        SysInfoRuleDTO ruleDTO = this.sysInfoRuleParser.parse(configItemList);
        if (logger.isInfoEnabled()) {
            logger.info("getOptimalMatchConfig--itemList:{}", (Object)JsonUtils.writeObjectToFastJson((Object)configItemList));
        }
        msConfigBean.setItemList(configItemList);
        msConfigBean.setSysInfoRuleDTO(ruleDTO);
        msConfigBean.setDefaultRule(true);
        return msConfigBean;
    }

    private MsConfigBean getConfigBean(CfgConfigEntity entity, MsConfigQueryRequest msConfigQueryRequest) {
        if (null != msConfigQueryRequest && null == msConfigQueryRequest.getStatus()) {
            msConfigQueryRequest.setStatus(Integer.valueOf(1));
        }
        MsConfigBean msConfigBean = ConfigEntityTranslater.convertFromMsConfigQueryRequest((MsConfigQueryRequest)msConfigQueryRequest);
        msConfigBean.setConfigId(entity.getConfigId());
        if (msConfigBean.getSellerTaxNo() == null) {
            msConfigBean.setSellerTaxNo(entity.getSellerTaxNo());
        }
        if (msConfigBean.getPurchaserTaxNo() == null) {
            msConfigBean.setPurchaserTaxNo(entity.getPurchaserTaxNo());
        }
        if (Objects.equals(entity.getSalesbillType(), "")) {
            msConfigBean.setSalesbillType("");
        }
        List list = this.queryConfigItems(entity.getConfigId());
        msConfigBean.setItemList(list);
        logger.info("@getConfigBean MsConfigItemBean.list: " + StringUtil.describeBean((Object)list));
        List attributes = this.queryAttributeList(entity.getConfigId());
        if (!CollectionUtils.isEmpty((Collection)attributes)) {
            msConfigBean.setHasAttrClassCfg(true);
            msConfigBean.setAttributes(attributes);
        }
        return msConfigBean;
    }

    private List<MsConfigBizBillAttribute> queryAttributeList(Long configId) {
        CfgConfigBillAttributeExample example = new CfgConfigBillAttributeExample();
        example.createCriteria().andConfigIdEqualTo(configId).andStatusEqualTo(ConstantValue.STATUS_ACTIVE);
        List attrs = this.cfgConfigBillAttributeExtDao.selectByExample(example);
        return BeanMapper.mapList((Collection)attrs, MsConfigBizBillAttribute.class);
    }

    public Response getOptimalMatchConfigWithAttr(MsConfigQueryRequest msConfigQueryRequest) {
        List settingMsConfigBeanList;
        logger.info("get seller config rules :{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigQueryRequest));
        if (null != msConfigQueryRequest && null == msConfigQueryRequest.getStatus()) {
            msConfigQueryRequest.setStatus(Integer.valueOf(1));
        }
        MsConfigBean msConfigBean = ConfigEntityTranslater.convertFromMsConfigQueryRequest((MsConfigQueryRequest)msConfigQueryRequest);
        if (ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType().equals(msConfigQueryRequest.getConfigType())) {
            Either eitherResult = this.withRedisQueryConfigOrReturn(msConfigQueryRequest, msConfigBean);
            if (eitherResult.isLeft()) {
                return (Response)eitherResult.getLeft();
            }
            settingMsConfigBeanList = (List)eitherResult.get();
        } else {
            Either eitherResult = this.queryConfigOrReturn(msConfigQueryRequest);
            if (eitherResult.isLeft()) {
                return (Response)eitherResult.getLeft();
            }
            settingMsConfigBeanList = (List)eitherResult.get();
        }
        MsConfigBean bestMsConfigBean = this.configMatchParserImpl.getBestMatchConfig(settingMsConfigBeanList, msConfigBean);
        logger.info("getOptimalMatchConfig---bestMsConfigBean:{}", (Object)(bestMsConfigBean != null ? bestMsConfigBean.getConfigId() : null));
        if (null == bestMsConfigBean) {
            CfgConfigEntity defaultCfgConfigEntity = this.queryDefaultConfig(msConfigQueryRequest);
            MsConfigBean defaultMsConfigBean = ConfigEntityTranslater.convertFromConfigEntity((CfgConfigEntity)defaultCfgConfigEntity);
            return this.fillConfigItems(defaultMsConfigBean);
        }
        return this.fillConfigItems(bestMsConfigBean);
    }

    private Either<Response, List<MsConfigBean>> withRedisQueryConfigOrReturn(MsConfigQueryRequest msConfigQueryRequest, MsConfigBean msConfigBean) {
        String mapCacheKey;
        RMapCache mapCache = this.redissonClient.getMapCache("seller:config:bestMatchRule");
        String configJson = (String)mapCache.get((Object)(mapCacheKey = this.getConfigRuleRedisKey(msConfigBean)));
        List settingMsConfigBeanList = Optional.ofNullable(configJson).map(json -> {
            try {
                logger.info("withRedisQueryConfigOrReturn\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6:{}", json);
                return JsonUtils.writeJsonToListObject((String)json, MsConfigBean.class);
            }
            catch (Exception e) {
                logger.error("withRedisQueryConfigOrReturn convertJsonError:{}", (Object)e.getMessage(), (Object)e);
                return null;
            }
        }).orElse(null);
        if (CollectionUtils.isEmpty((Collection)settingMsConfigBeanList)) {
            List settingCfgConfigEntityList = this.querySettingConfigList(msConfigQueryRequest);
            logger.info("getOptimalMatchConfigWithAttr---cfgConfigEntityList:{}", (Object)JsonUtils.writeObjectToFastJson((Object)settingCfgConfigEntityList));
            if (CollectionUtils.isEmpty((Collection)settingCfgConfigEntityList)) {
                CfgConfigEntity defaultCfgConfigEntity = this.queryDefaultConfig(msConfigQueryRequest);
                MsConfigBean defaultMsConfigBean = ConfigEntityTranslater.convertFromConfigEntity((CfgConfigEntity)defaultCfgConfigEntity);
                logger.info("getOptimalMatchConfigWithAttr---defaultMsConfigBean:{}", (Object)JsonUtils.writeObjectToFastJson((Object)defaultMsConfigBean));
                return Either.left((Object)this.fillConfigItems(defaultMsConfigBean));
            }
            settingMsConfigBeanList = settingCfgConfigEntityList.stream().map(arg_0 -> this.getMsConfigBean(arg_0)).collect(Collectors.toList());
            mapCache.put((Object)mapCacheKey, (Object)JsonUtils.writeObjectToJson(settingMsConfigBeanList), 120L, TimeUnit.SECONDS);
        }
        return Either.right((Object)settingMsConfigBeanList);
    }

    private String getConfigRuleRedisKey(MsConfigBean bean) {
        String taxInvoiceSource = StringUtils.isEmpty((CharSequence)bean.getTaxInvoiceSource()) ? "" : bean.getTaxInvoiceSource();
        ConfigRuleRedisKey key = new ConfigRuleRedisKey(bean.getSellerGroupId(), bean.getSellerTaxNo(), bean.getPurchaserGroupId(), bean.getPurchaserTaxNo(), bean.getSalesbillType(), bean.getInvoiceType(), bean.getConfigType(), taxInvoiceSource);
        return JsonUtils.writeObjectToJson((Object)key);
    }

    private Either<Response, List<MsConfigBean>> queryConfigOrReturn(MsConfigQueryRequest msConfigQueryRequest) {
        List settingCfgConfigEntityList = this.querySettingConfigList(msConfigQueryRequest);
        if (CollectionUtils.isEmpty((Collection)settingCfgConfigEntityList)) {
            CfgConfigEntity defaultCfgConfigEntity = this.queryDefaultConfig(msConfigQueryRequest);
            MsConfigBean defaultMsConfigBean = ConfigEntityTranslater.convertFromConfigEntity((CfgConfigEntity)defaultCfgConfigEntity);
            return Either.left((Object)this.fillConfigItems(defaultMsConfigBean));
        }
        List settingMsConfigBeanList = settingCfgConfigEntityList.stream().map(arg_0 -> this.getMsConfigBean(arg_0)).collect(Collectors.toList());
        return Either.right(settingMsConfigBeanList);
    }

    public MsConfigBean getOptimalMatchConfigWithAttrNew(MsConfigQueryRequest msConfigQueryRequest) {
        logger.info("\u83b7\u53d6\u53d1\u7968\u5339\u914d\u89c4\u5219\uff0c\u8bf7\u6c42\u53c2\u6570:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigQueryRequest));
        if (null != msConfigQueryRequest && null == msConfigQueryRequest.getStatus()) {
            msConfigQueryRequest.setStatus(Integer.valueOf(1));
        }
        List settingCfgConfigEntityList = this.querySettingConfigList(msConfigQueryRequest);
        logger.info("getOptimalMatchConfigWithAttr---cfgConfigEntityList:{}", (Object)JsonUtils.writeObjectToFastJson((Object)settingCfgConfigEntityList));
        String sellerTaxNo = msConfigQueryRequest.getSellerTaxNo();
        String purchaserTaxNo = msConfigQueryRequest.getPurchaserTaxNo();
        settingCfgConfigEntityList = settingCfgConfigEntityList.stream().filter(r -> {
            if (StringUtils.isNotBlank((CharSequence)sellerTaxNo) ? StringUtils.isNotBlank((CharSequence)r.getSellerTaxNo()) && !sellerTaxNo.equals(r.getSellerTaxNo()) : StringUtils.isNotBlank((CharSequence)r.getSellerTaxNo())) {
                return false;
            }
            if (StringUtils.isNotBlank((CharSequence)purchaserTaxNo)) {
                return StringUtils.isBlank((CharSequence)r.getPurchaserTaxNo()) || purchaserTaxNo.equals(r.getPurchaserTaxNo());
            }
            return StringUtils.isBlank((CharSequence)r.getPurchaserTaxNo());
        }).collect(Collectors.toList());
        MsConfigBean resultBean = Optional.ofNullable(settingCfgConfigEntityList).filter(CollectionUtils::isNotEmpty).map(configList -> {
            MsConfigBean msConfigBean = ConfigEntityTranslater.convertFromMsConfigQueryRequest((MsConfigQueryRequest)msConfigQueryRequest);
            List settingMsConfigBeanList = configList.stream().map(arg_0 -> this.getMsConfigBean(arg_0)).collect(Collectors.toList());
            MsConfigBean bestMsConfigBean = this.configMatchParserImpl.getBestMatchConfig(settingMsConfigBeanList, msConfigBean);
            logger.info("getOptimalMatchConfig---bestMsConfigBean:{}", (Object)JsonUtils.writeObjectToFastJson((Object)bestMsConfigBean));
            return bestMsConfigBean;
        }).orElseGet(() -> {
            CfgConfigEntity defaultCfgConfigEntity = this.queryDefaultConfig(msConfigQueryRequest);
            MsConfigBean defaultMsConfigBean = ConfigEntityTranslater.convertFromConfigEntity((CfgConfigEntity)defaultCfgConfigEntity);
            logger.info("getOptimalMatchConfigWithAttr---defaultMsConfigBean:{}", (Object)JsonUtils.writeObjectToFastJson((Object)defaultMsConfigBean));
            return defaultMsConfigBean;
        });
        return this.fillConfigItemsNew(resultBean);
    }

    public MsConfigBean getMsConfigBean(CfgConfigEntity entity) {
        ArrayList attributes = new ArrayList();
        List attrs = this.selectCfgBillAttribute(entity);
        MsConfigBean msConfigBean = ConfigEntityTranslater.convertFromConfigEntity((CfgConfigEntity)entity);
        if (!CollectionUtils.isEmpty((Collection)attrs)) {
            msConfigBean.setHasAttrClassCfg(true);
            attrs.stream().forEach(attr -> {
                MsConfigBizBillAttribute attribute = new MsConfigBizBillAttribute();
                attribute.setFieldName(attr.getFieldName());
                attribute.setAttrName(attr.getAttrName());
                attribute.setAttrDesc(attr.getAttrDesc());
                attribute.setValue(attr.getValue());
                attributes.add(attribute);
            });
        }
        msConfigBean.setAttributes(attributes);
        return msConfigBean;
    }

    public List<CfgConfigBillAttributeEntity> selectCfgBillAttribute(CfgConfigEntity config) {
        CfgConfigBillAttributeExample example = new CfgConfigBillAttributeExample();
        CfgConfigBillAttributeExample.Criteria criteria = example.createCriteria();
        criteria.andConfigIdEqualTo(config.getConfigId()).andStatusEqualTo(ConstantValue.STATUS_ACTIVE);
        if (StringUtils.isNotEmpty((CharSequence)config.getBusinessBillType())) {
            criteria.andBusinessBillTypeEqualTo(config.getBusinessBillType());
        }
        if (StringUtils.isNotEmpty((CharSequence)config.getSalesbillType())) {
            criteria.andSalesbillTypeEqualTo(config.getSalesbillType());
        }
        return this.cfgConfigBillAttributeExtDao.selectByExample(example);
    }

    private List<MsConfigItemBean> queryConfigItems(Long configId) {
        MsConfigItemQueryRequest request = new MsConfigItemQueryRequest();
        request.setConfigId(String.valueOf(configId));
        return this.queryConfigItemList(request);
    }

    private Response fillConfigItems(MsConfigBean msConfigBean) {
        Response response2 = new Response();
        if (null != msConfigBean) {
            MsConfigItemQueryRequest request = new MsConfigItemQueryRequest();
            request.setConfigId(String.valueOf(msConfigBean.getConfigId()));
            List configItemList = this.queryConfigItemList(request);
            if (logger.isInfoEnabled()) {
                logger.info("getOptimalMatchConfig--itemList:{}", (Object)JsonUtils.writeObjectToFastJson((Object)configItemList));
            }
            this.buildQDConfigItem(msConfigBean.getConfigType(), msConfigBean.getTaxInvoiceSource(), msConfigBean.getConfigId()).ifPresent(configItemList::add);
            msConfigBean.setItemList(configItemList);
            response2.setCode(Response.OK);
            response2.setResult((Object)JsonUtils.writeObjectToFastJson((Object)configItemList));
        } else {
            response2.setCode(Response.Fail);
        }
        return response2;
    }

    private Optional<MsConfigItemBean> buildQDConfigItem(Integer configType, String taxInvoiceSource, Long configId) {
        if (ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType().equals(configType) && TaxInvoiceSource.QD.getValue().equals(taxInvoiceSource)) {
            MsConfigItemBean msConfigItemBean = new MsConfigItemBean();
            msConfigItemBean.setConfigId(configId);
            msConfigItemBean.setConfigItemName("taxInvoiceSource");
            msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{TaxInvoiceSource.QD.getValue()}));
            return Optional.of(msConfigItemBean);
        }
        return Optional.empty();
    }

    private MsConfigBean fillConfigItemsNew(MsConfigBean msConfigBean) {
        if (null != msConfigBean) {
            MsConfigItemQueryRequest request = new MsConfigItemQueryRequest();
            request.setConfigId(String.valueOf(msConfigBean.getConfigId()));
            List configItemList = this.queryConfigItemList(request);
            if (logger.isInfoEnabled()) {
                logger.info("getOptimalMatchConfig--itemList:{}", (Object)JsonUtils.writeObjectToFastJson((Object)configItemList));
            }
            msConfigBean.setItemList(configItemList);
            return msConfigBean;
        }
        return null;
    }

    private Response fillConfigItemList2ConfigBean(MsConfigBean msConfigBean) {
        Response response2 = new Response();
        if (null != msConfigBean) {
            MsConfigItemQueryRequest request = new MsConfigItemQueryRequest();
            request.setConfigId(String.valueOf(msConfigBean.getConfigId()));
            List configItemList = this.queryConfigItemList(request);
            if (logger.isInfoEnabled()) {
                logger.info("getOptimalMatchConfig--itemList:{}", (Object)JsonUtils.writeObjectToFastJson((Object)configItemList));
            }
            response2.setCode(Response.OK);
            response2.setResult((Object)JsonUtils.writeObjectToFastJson((Object)configItemList));
        } else {
            response2.setCode(Response.Fail);
        }
        return response2;
    }

    public List<CfgConfigEntity> querySettingConfigList(MsConfigQueryRequest msConfigQueryRequest) {
        List cfgConfigEntityList;
        switch (1.$SwitchMap$com$xforceplus$seller$config$client$constant$ConfigTypeEnum[ConfigTypeEnum.of((Integer)msConfigQueryRequest.getConfigType()).ordinal()]) {
            case 1: 
            case 2: {
                cfgConfigEntityList = this.querySettingSplitConfigByAROrAP(msConfigQueryRequest);
                break;
            }
            case 3: {
                cfgConfigEntityList = this.querySettingGroupMergeConfigByAROrAP(msConfigQueryRequest);
                break;
            }
            case 4: {
                cfgConfigEntityList = this.queryMergeConfig(msConfigQueryRequest);
                break;
            }
            case 5: 
            case 6: {
                cfgConfigEntityList = this.querySettingInvoiceConfigARorAP(msConfigQueryRequest);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                cfgConfigEntityList = this.querySettingSysConfigByAROrAP(msConfigQueryRequest);
                break;
            }
            case 10: {
                cfgConfigEntityList = this.querySettingMailConfigByAROrAP(msConfigQueryRequest);
                break;
            }
            case 11: {
                cfgConfigEntityList = this.querySettingSplitConfigByAROrAP(msConfigQueryRequest);
                break;
            }
            default: {
                cfgConfigEntityList = this.querySettingConfig(msConfigQueryRequest);
            }
        }
        return cfgConfigEntityList;
    }

    private List<CfgConfigEntity> queryMatchedSettingConfigList(MsConfigQueryRequest msConfigQueryRequest) {
        List cfgConfigEntityList;
        logger.debug("querySettingConfigList----msConfigQueryRequest:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigQueryRequest));
        switch (1.$SwitchMap$com$xforceplus$seller$config$client$constant$ConfigTypeEnum[ConfigTypeEnum.of((Integer)msConfigQueryRequest.getConfigType()).ordinal()]) {
            case 1: 
            case 2: {
                cfgConfigEntityList = this.querySettingSplitConfigByARAndAP(msConfigQueryRequest);
                break;
            }
            case 3: 
            case 4: {
                cfgConfigEntityList = this.querySettingGroupMergeConfigByARAndAP(msConfigQueryRequest);
                break;
            }
            case 5: 
            case 6: {
                cfgConfigEntityList = this.querySettingInvoiceConfigARorAP(msConfigQueryRequest);
                break;
            }
            case 7: {
                cfgConfigEntityList = this.querySettingSysConfigByAROrAP(msConfigQueryRequest);
                break;
            }
            default: {
                cfgConfigEntityList = this.querySettingConfig(msConfigQueryRequest);
            }
        }
        return cfgConfigEntityList;
    }

    public CfgConfigEntity queryOneSellerIssueInfo(Long sellerGroupId, String sellerTaxNo, ConfigTypeEnum configTypeEnum) {
        CfgConfigExample queryOneExample = new CfgConfigExample();
        queryOneExample.createCriteria().andSellerGroupIdEqualTo(sellerGroupId).andSellerTaxNoEqualTo(sellerTaxNo).andConfigTypeEqualTo(Byte.valueOf(configTypeEnum.getConfigType().byteValue())).andBusinessBillTypeEqualTo(BusinessBillType.AR.value()).andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        return this.cfgConfigDao.selectOneByExample(queryOneExample);
    }

    private CfgConfigEntity queryDefaultConfig(MsConfigQueryRequest msConfigQueryRequest) {
        CfgConfigEntity cfgConfigEntity;
        switch (1.$SwitchMap$com$xforceplus$seller$config$client$constant$ConfigTypeEnum[ConfigTypeEnum.of((Integer)msConfigQueryRequest.getConfigType()).ordinal()]) {
            case 1: {
                String taxInvoiceSource = TaxInvoiceSource.SK.getValue();
                if (StringUtils.isNotEmpty((CharSequence)msConfigQueryRequest.getTaxInvoiceSource())) {
                    taxInvoiceSource = msConfigQueryRequest.getTaxInvoiceSource();
                }
                cfgConfigEntity = this.queryDefaultSplitConfig((String)msConfigQueryRequest.getInvoiceType().get(0), taxInvoiceSource);
                break;
            }
            case 2: {
                cfgConfigEntity = this.queryDefaultInvoiceMatchBillConfig((String)msConfigQueryRequest.getInvoiceType().get(0));
                break;
            }
            case 5: 
            case 6: {
                cfgConfigEntity = this.queryDefaultInvoiceConfig(msConfigQueryRequest.getBusinessBillType());
                break;
            }
            default: {
                cfgConfigEntity = this.queryDefaultConfig(msConfigQueryRequest.getConfigType());
            }
        }
        return cfgConfigEntity;
    }

    private CfgConfigEntity queryDefaultConfig(Integer configType) {
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = cfgConfigExample.createCriteria();
        criteria.andSellerGroupIdEqualTo(Long.valueOf(0L));
        criteria.andPurchaserGroupIdEqualTo(Long.valueOf(0L));
        criteria.andConfigTypeEqualTo(Byte.valueOf(configType.byteValue()));
        criteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        return this.cfgConfigDao.selectOneByExample(cfgConfigExample);
    }

    private CfgConfigEntity queryDefaultSplitConfig(String invoiceType, String taxInvoiceSource) {
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = cfgConfigExample.createCriteria();
        criteria.andSellerGroupIdEqualTo(Long.valueOf(0L));
        criteria.andPurchaserGroupIdEqualTo(Long.valueOf(0L));
        criteria.andConfigTypeEqualTo(Byte.valueOf(ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType().byteValue()));
        criteria.andInvoiceTypeEqualTo(invoiceType);
        criteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        criteria.andTaxInvoiceSourceEqualTo(taxInvoiceSource);
        return this.cfgConfigDao.selectOneByExample(cfgConfigExample);
    }

    private CfgConfigEntity queryDefaultInvoiceMatchBillConfig(String invoiceType) {
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = cfgConfigExample.createCriteria();
        criteria.andSellerGroupIdEqualTo(Long.valueOf(0L));
        criteria.andPurchaserGroupIdEqualTo(Long.valueOf(0L));
        criteria.andConfigTypeEqualTo(Byte.valueOf(ConfigTypeEnum.BILL_INVOICE_MATCH_TYPE.getConfigType().byteValue()));
        criteria.andInvoiceTypeEqualTo(invoiceType);
        criteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        return this.cfgConfigDao.selectOneByExample(cfgConfigExample);
    }

    private CfgConfigEntity queryDefaultInvoiceConfig(String businessBillType) {
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = cfgConfigExample.createCriteria();
        criteria.andSellerGroupIdEqualTo(Long.valueOf(0L));
        criteria.andPurchaserGroupIdEqualTo(Long.valueOf(0L));
        criteria.andConfigTypeEqualTo(Byte.valueOf(ConfigTypeEnum.INVOICE_CONFIG_TYPE.getConfigType().byteValue()));
        criteria.andBusinessBillTypeEqualTo(businessBillType);
        criteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        return this.cfgConfigDao.selectOneByExample(cfgConfigExample);
    }

    private List<CfgConfigEntity> querySettingSplitConfigByAROrAP(MsConfigQueryRequest msConfigQueryRequest) {
        logger.info("\u83b7\u53d6\u5339\u914d\u89c4\u5219>>>");
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        if (msConfigQueryRequest.getSellerGroupId() != null) {
            CfgConfigExample.Criteria criteriaAR = cfgConfigExample.createCriteria();
            ConfigBizConfigService.buildARGroupId((MsConfigQueryRequest)msConfigQueryRequest, (CfgConfigExample.Criteria)criteriaAR);
            if (StringUtils.isNotEmpty((CharSequence)msConfigQueryRequest.getSellerTaxNo())) {
                criteriaAR.andSellerTaxNoEqualTo(msConfigQueryRequest.getSellerTaxNo());
            }
            CfgConfigExample.Criteria criteriaARTenatId = cfgConfigExample.createCriteria();
            ConfigBizConfigService.buildARGroupId((MsConfigQueryRequest)msConfigQueryRequest, (CfgConfigExample.Criteria)criteriaARTenatId);
            criteriaARTenatId.andSellerTaxNoEqualTo("");
            cfgConfigExample.or(criteriaARTenatId);
        }
        if (msConfigQueryRequest.getPurchaserGroupId() != null && msConfigQueryRequest.getPurchaserGroupId() != 0L) {
            CfgConfigExample.Criteria criteriaAP = cfgConfigExample.createCriteria();
            ConfigBizConfigService.buildSpiltAP((MsConfigQueryRequest)msConfigQueryRequest, (CfgConfigExample.Criteria)criteriaAP);
            if (StringUtils.isNotEmpty((CharSequence)msConfigQueryRequest.getPurchaserTaxNo())) {
                criteriaAP.andPurchaserTaxNoEqualTo(msConfigQueryRequest.getPurchaserTaxNo());
            }
            CfgConfigExample.Criteria criteriaAPTenant = cfgConfigExample.createCriteria();
            criteriaAPTenant.andPurchaserTaxNoEqualTo("");
            ConfigBizConfigService.buildSpiltAP((MsConfigQueryRequest)msConfigQueryRequest, (CfgConfigExample.Criteria)criteriaAPTenant);
            if (msConfigQueryRequest.getSellerGroupId() != null) {
                cfgConfigExample.or(criteriaAP);
                cfgConfigExample.or(criteriaAPTenant);
            }
        }
        return this.cfgConfigDao.selectByExample(cfgConfigExample);
    }

    private static void buildSpiltAP(MsConfigQueryRequest msConfigQueryRequest, CfgConfigExample.Criteria criteriaAP) {
        criteriaAP.andPurchaserGroupIdEqualTo(msConfigQueryRequest.getPurchaserGroupId());
        criteriaAP.andConfigTypeEqualTo(Byte.valueOf(msConfigQueryRequest.getConfigType().byteValue()));
        criteriaAP.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        criteriaAP.andSalesbillTypeIn((List)Lists.newArrayList((Object[])new String[]{"", msConfigQueryRequest.getSalesbillType()}));
        criteriaAP.andInvoiceTypeEqualTo((String)msConfigQueryRequest.getInvoiceType().get(0));
        if (ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType() == msConfigQueryRequest.getConfigType() && StringUtils.isNotEmpty((CharSequence)msConfigQueryRequest.getTaxInvoiceSource())) {
            criteriaAP.andTaxInvoiceSourceEqualTo(msConfigQueryRequest.getTaxInvoiceSource());
        }
    }

    private static void buildARGroupId(MsConfigQueryRequest msConfigQueryRequest, CfgConfigExample.Criteria criteriaAR) {
        criteriaAR.andSellerGroupIdEqualTo(msConfigQueryRequest.getSellerGroupId());
        criteriaAR.andConfigTypeEqualTo(Byte.valueOf(msConfigQueryRequest.getConfigType().byteValue()));
        criteriaAR.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        criteriaAR.andSalesbillTypeIn((List)Lists.newArrayList((Object[])new String[]{"", msConfigQueryRequest.getSalesbillType()}));
        criteriaAR.andInvoiceTypeEqualTo((String)msConfigQueryRequest.getInvoiceType().get(0));
        if (ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType() == msConfigQueryRequest.getConfigType() && StringUtils.isNotEmpty((CharSequence)msConfigQueryRequest.getTaxInvoiceSource())) {
            criteriaAR.andTaxInvoiceSourceEqualTo(msConfigQueryRequest.getTaxInvoiceSource());
        }
    }

    private List<CfgConfigEntity> querySettingSplitConfigByARAndAP(MsConfigQueryRequest msConfigQueryRequest) {
        logger.info("\u83b7\u53d6\u5339\u914d\u89c4\u5219>>>");
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = cfgConfigExample.createCriteria();
        StringUtil.appendCriteriaNotNull(x$0 -> criteria.andSellerTaxNoEqualTo(x$0), (Object)msConfigQueryRequest.getSellerTaxNo());
        StringUtil.appendCriteriaNotNull(x$0 -> criteria.andSellerGroupIdEqualTo(x$0), (Object)msConfigQueryRequest.getSellerGroupId());
        StringUtil.appendCriteriaNotNull(x$0 -> criteria.andPurchaserGroupIdEqualTo(x$0), (Object)msConfigQueryRequest.getPurchaserGroupId());
        StringUtil.appendCriteriaNotNull(x$0 -> criteria.andPurchaserTaxNoEqualTo(x$0), (Object)msConfigQueryRequest.getPurchaserTaxNo());
        if (null != msConfigQueryRequest.getConfigType()) {
            StringUtil.appendCriteriaNotNull(x$0 -> criteria.andConfigTypeEqualTo(x$0), (Object)msConfigQueryRequest.getConfigType().byteValue());
        }
        StringUtil.appendCriteriaNotNull(x$0 -> criteria.andStatusEqualTo(x$0), (Object)StatusEnum.NORMAL.getStatus().byteValue());
        StringUtil.appendCriteriaNotNull(x$0 -> criteria.andSalesbillTypeEqualTo(x$0), (Object)msConfigQueryRequest.getSalesbillType());
        if (!CollectionUtils.isEmpty((Collection)msConfigQueryRequest.getInvoiceType())) {
            StringUtil.appendCriteriaNotNull(x$0 -> criteria.andInvoiceTypeIn(x$0), (Object)msConfigQueryRequest.getInvoiceType());
        }
        return this.cfgConfigDao.selectByExample(cfgConfigExample);
    }

    private List<CfgConfigEntity> querySettingGroupMergeConfigByAROrAP(MsConfigQueryRequest msConfigQueryRequest) {
        CfgConfigExample groupMergeExample = new CfgConfigExample();
        if (msConfigQueryRequest.getSellerGroupId() != null) {
            CfgConfigExample.Criteria groupCriteriaAR = groupMergeExample.createCriteria();
            groupCriteriaAR.andSellerGroupIdEqualTo(msConfigQueryRequest.getSellerGroupId());
            groupCriteriaAR.andConfigTypeEqualTo(Byte.valueOf(msConfigQueryRequest.getConfigType().byteValue()));
            groupCriteriaAR.andStatusEqualTo(Byte.valueOf(msConfigQueryRequest.getStatus().byteValue()));
        }
        if (msConfigQueryRequest.getPurchaserGroupId() != null) {
            CfgConfigExample.Criteria groupCriteriaAP = groupMergeExample.createCriteria();
            groupCriteriaAP.andPurchaserGroupIdEqualTo(msConfigQueryRequest.getPurchaserGroupId());
            groupCriteriaAP.andStatusEqualTo(Byte.valueOf(msConfigQueryRequest.getStatus().byteValue()));
            groupCriteriaAP.andConfigTypeEqualTo(Byte.valueOf(msConfigQueryRequest.getConfigType().byteValue()));
            if (msConfigQueryRequest.getSellerGroupId() != null) {
                groupMergeExample.or(groupCriteriaAP);
            }
        }
        return this.cfgConfigDao.selectByExample(groupMergeExample);
    }

    private List<CfgConfigEntity> queryMergeConfig(MsConfigQueryRequest request) {
        CfgConfigExample example = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = example.createCriteria();
        criteria.andStatusEqualTo(Byte.valueOf(request.getStatus().byteValue())).andConfigTypeEqualTo(Byte.valueOf(request.getConfigType().byteValue()));
        Optional.ofNullable(request.getSellerGroupId()).ifPresent(r -> criteria.andSellerGroupIdIn((List)Lists.newArrayList((Object[])new Long[]{r, 0L})));
        Optional.ofNullable(request.getPurchaserGroupId()).ifPresent(r -> criteria.andPurchaserGroupIdIn((List)Lists.newArrayList((Object[])new Long[]{r, 0L})));
        Optional.ofNullable(request.getSellerTaxNo()).ifPresent(r -> criteria.andSellerTaxNoIn((List)Lists.newArrayList((Object[])new String[]{r, ""})));
        Optional.ofNullable(request.getPurchaserTaxNo()).ifPresent(r -> criteria.andPurchaserTaxNoIn((List)Lists.newArrayList((Object[])new String[]{r, ""})));
        Optional.ofNullable(request.getSalesbillType()).ifPresent(r -> criteria.andSalesbillTypeIn((List)Lists.newArrayList((Object[])new String[]{r, ""})));
        Optional.ofNullable(request.getBusinessBillType()).ifPresent(r -> criteria.andBusinessBillTypeIn((List)Lists.newArrayList((Object[])new String[]{r, ""})));
        return this.cfgConfigDao.selectByExample(example);
    }

    private List<CfgConfigEntity> querySettingGroupMergeConfigByARAndAP(MsConfigQueryRequest msConfigQueryRequest) {
        if (msConfigQueryRequest.getSellerGroupId() != null && msConfigQueryRequest.getPurchaserGroupId() != null && 0L == msConfigQueryRequest.getPurchaserGroupId() && 0L == msConfigQueryRequest.getSellerGroupId()) {
            return null;
        }
        String orderByClause = null == msConfigQueryRequest.getBusinessBillType() || BusinessBillType.AR.value().equalsIgnoreCase(msConfigQueryRequest.getBusinessBillType()) ? "seller_tax_no desc, purchaser_tax_no desc" : "purchaser_tax_no desc, seller_tax_no desc";
        List ruleListForAR = this.getRuleList(msConfigQueryRequest, orderByClause);
        if (!CollectionUtils.isEmpty((Collection)ruleListForAR)) {
            CfgConfigEntity entity = (CfgConfigEntity)ruleListForAR.get(0);
            Tuple4 key = Tuple.of((Object)entity.getSellerGroupId(), (Object)entity.getSellerTaxNo(), (Object)entity.getPurchaserGroupId(), (Object)entity.getPurchaserTaxNo());
            return ruleListForAR.stream().filter(r -> key.equals((Object)Tuple.of((Object)r.getSellerGroupId(), (Object)r.getSellerTaxNo(), (Object)r.getPurchaserGroupId(), (Object)r.getPurchaserTaxNo()))).collect(Collectors.toList());
        }
        return null;
    }

    private CfgConfigExample.Criteria getCommonCriteria(MsConfigQueryRequest msConfigQueryRequest, CfgConfigExample example) {
        CfgConfigExample.Criteria exampleCriteria = example.createCriteria();
        if (null != msConfigQueryRequest.getConfigType()) {
            exampleCriteria.andConfigTypeEqualTo(Byte.valueOf(msConfigQueryRequest.getConfigType().byteValue()));
        }
        if (null != msConfigQueryRequest.getStatus()) {
            exampleCriteria.andStatusEqualTo(Byte.valueOf(msConfigQueryRequest.getStatus().byteValue()));
        }
        if (null != msConfigQueryRequest.getSalesbillType()) {
            exampleCriteria.andSalesbillTypeEqualTo(msConfigQueryRequest.getSalesbillType());
        }
        if (null != msConfigQueryRequest.getBusinessBillType()) {
            exampleCriteria.andBusinessBillTypeEqualTo(msConfigQueryRequest.getBusinessBillType());
        }
        return exampleCriteria;
    }

    private List<CfgConfigEntity> querySettingSysConfigByAROrAP(MsConfigQueryRequest msConfigQueryRequest) {
        CfgConfigExample configExample = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = configExample.createCriteria();
        if (msConfigQueryRequest.getBusinessBillType() != null) {
            if (BusinessBillType.AR.value().equals(msConfigQueryRequest.getBusinessBillType())) {
                criteria.andSellerGroupIdEqualTo(Long.valueOf(msConfigQueryRequest.getSellerGroupId() == null ? 0L : msConfigQueryRequest.getSellerGroupId()));
            } else {
                criteria.andPurchaserGroupIdEqualTo(Long.valueOf(msConfigQueryRequest.getPurchaserGroupId() == null ? 0L : msConfigQueryRequest.getPurchaserGroupId()));
            }
            criteria.andBusinessBillTypeEqualTo(msConfigQueryRequest.getBusinessBillType());
        } else {
            criteria.andSellerGroupIdEqualTo(Long.valueOf(msConfigQueryRequest.getSellerGroupId() == null ? 0L : msConfigQueryRequest.getSellerGroupId()));
            criteria.andPurchaserGroupIdEqualTo(Long.valueOf(msConfigQueryRequest.getPurchaserGroupId() == null ? 0L : msConfigQueryRequest.getPurchaserGroupId()));
        }
        criteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        criteria.andConfigTypeEqualTo(Byte.valueOf(msConfigQueryRequest.getConfigType().byteValue()));
        criteria.andSalesbillTypeIn((List)Lists.newArrayList((Object[])new String[]{"", msConfigQueryRequest.getSalesbillType()}));
        return this.cfgConfigDao.selectByExample(configExample);
    }

    private List<CfgConfigEntity> querySettingMailConfigByAROrAP(MsConfigQueryRequest msConfigQueryRequest) {
        CfgConfigExample configExample = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = configExample.createCriteria();
        CfgConfigEntity cfgConfigEntity = new CfgConfigEntity();
        if (msConfigQueryRequest.getBusinessBillType() != null) {
            if (BusinessBillType.AR.value().equals(msConfigQueryRequest.getBusinessBillType())) {
                cfgConfigEntity.setSellerGroupId(Long.valueOf(msConfigQueryRequest.getSellerGroupId() == null ? 0L : msConfigQueryRequest.getSellerGroupId()));
            } else {
                cfgConfigEntity.setPurchaserGroupId(Long.valueOf(msConfigQueryRequest.getPurchaserGroupId() == null ? 0L : msConfigQueryRequest.getPurchaserGroupId()));
            }
            cfgConfigEntity.setBusinessBillType(msConfigQueryRequest.getBusinessBillType());
        } else {
            cfgConfigEntity.setSellerGroupId(Long.valueOf(msConfigQueryRequest.getSellerGroupId() == null ? 0L : msConfigQueryRequest.getSellerGroupId()));
            cfgConfigEntity.setPurchaserGroupId(Long.valueOf(msConfigQueryRequest.getPurchaserGroupId() == null ? 0L : msConfigQueryRequest.getPurchaserGroupId()));
        }
        cfgConfigEntity.setStatus(StatusEnum.NORMAL.getStatus());
        cfgConfigEntity.setConfigType(ConfigTypeEnum.INVOICE_MAIL_RULE_CONFIG_TYPE.getConfigType());
        ArrayList salesbillTypeList = Lists.newArrayList((Object[])new String[]{"", msConfigQueryRequest.getSalesbillType()});
        return this.cfgConfigExtDao.innerJoinMailQueryConfig(cfgConfigEntity, (List)salesbillTypeList, msConfigQueryRequest.getInvoiceType());
    }

    private List<CfgConfigEntity> querySettingInvoiceConfigARorAP(MsConfigQueryRequest msConfigQueryRequest) {
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        CfgConfigExample.Criteria invoiceCriteria = cfgConfigExample.createCriteria();
        if (StringUtils.equals((CharSequence)msConfigQueryRequest.getBusinessBillType(), (CharSequence)BusinessBillType.AP.value())) {
            invoiceCriteria.andPurchaserGroupIdEqualTo(msConfigQueryRequest.getPurchaserGroupId() != null ? msConfigQueryRequest.getPurchaserGroupId() : Long.valueOf(0L));
        } else {
            invoiceCriteria.andSellerGroupIdEqualTo(msConfigQueryRequest.getSellerGroupId() != null ? msConfigQueryRequest.getSellerGroupId() : Long.valueOf(0L));
        }
        invoiceCriteria.andConfigTypeEqualTo(Byte.valueOf(msConfigQueryRequest.getConfigType().byteValue()));
        invoiceCriteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        invoiceCriteria.andSalesbillTypeIn((List)Lists.newArrayList((Object[])new String[]{"", msConfigQueryRequest.getSalesbillType()}));
        if (msConfigQueryRequest.getSellerGroupId() != null && this.matchTenantIds.contains(msConfigQueryRequest.getSellerGroupId()) && (msConfigQueryRequest.getConfigType() == 3 || msConfigQueryRequest.getConfigType() == 4) && StringUtils.isNotEmpty((CharSequence)msConfigQueryRequest.getSellerTaxNo())) {
            invoiceCriteria.andSellerTaxNoEqualTo(msConfigQueryRequest.getSellerTaxNo());
        }
        List cfgConfigEntities = this.cfgConfigDao.selectByExample(cfgConfigExample);
        if (msConfigQueryRequest.getSellerGroupId() != null && !this.matchTenantIds.contains(msConfigQueryRequest.getSellerGroupId()) && CollectionUtils.isNotEmpty((Collection)cfgConfigEntities) && cfgConfigEntities.size() > this.maxSizeRow) {
            this.dingDingUtils.sendMsgMarkDownWarn(String.valueOf(msConfigQueryRequest.getConfigType()), "\u5339\u914d\u6761\u6570\u5927\u4e8e:" + this.maxSizeRow, "", JsonUtils.writeObjectToFastJson((Object)msConfigQueryRequest), "");
        }
        return cfgConfigEntities;
    }

    private List<CfgConfigEntity> querySettingConfig(MsConfigQueryRequest msConfigQueryRequest) {
        CfgConfigExample settingConfigExample = new CfgConfigExample();
        CfgConfigExample.Criteria settingCriteria = settingConfigExample.createCriteria();
        if (msConfigQueryRequest.getSellerGroupId() != null) {
            settingCriteria.andSellerGroupIdEqualTo(msConfigQueryRequest.getSellerGroupId());
        }
        if (msConfigQueryRequest.getPurchaserGroupId() != null) {
            settingCriteria.andPurchaserGroupIdEqualTo(msConfigQueryRequest.getPurchaserGroupId());
        }
        if (StringUtils.isNotEmpty((CharSequence)msConfigQueryRequest.getSellerTaxNo())) {
            settingCriteria.andSellerTaxNoEqualTo(msConfigQueryRequest.getSellerTaxNo());
        }
        if (StringUtils.isNotEmpty((CharSequence)msConfigQueryRequest.getPurchaserTaxNo())) {
            settingCriteria.andPurchaserTaxNoEqualTo(msConfigQueryRequest.getPurchaserTaxNo());
        }
        if (msConfigQueryRequest.getConfigType().intValue() == ConfigTypeEnum.INVOICE_OPERRATIOON_CONFIG_TYPE.getConfigType().intValue() && msConfigQueryRequest.getInvoiceType() != null && !msConfigQueryRequest.getInvoiceType().isEmpty()) {
            settingCriteria.andInvoiceTypeIn(msConfigQueryRequest.getInvoiceType());
        }
        if (StringUtils.isEmpty((CharSequence)msConfigQueryRequest.getSellerTaxNo()) && StringUtils.isEmpty((CharSequence)msConfigQueryRequest.getPurchaserTaxNo()) && null == msConfigQueryRequest.getSellerGroupId() && null == msConfigQueryRequest.getPurchaserGroupId()) {
            return new ArrayList<CfgConfigEntity>();
        }
        settingCriteria.andConfigTypeEqualTo(Byte.valueOf(msConfigQueryRequest.getConfigType().byteValue()));
        settingCriteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        settingCriteria.andSalesbillTypeIn((List)Lists.newArrayList((Object[])new String[]{"", msConfigQueryRequest.getSalesbillType()}));
        logger.info("@querySettingConfig criteria : " + StringUtil.describeBean((Object)settingCriteria));
        return this.cfgConfigDao.selectByExample(settingConfigExample);
    }

    public MsConfigPageDTO queryConfigList(MsConfigQueryRequest msConfigBean, Long groupId) {
        logger.info("queryConfigList {} groupId {}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigBean), (Object)groupId);
        MsConfigPageDTO msConfigPageDTO = new MsConfigPageDTO();
        CfgConfigExample example = ExamapleTranslater.createConfigExampleByRequest((MsConfigQueryRequest)msConfigBean, (Long)groupId);
        example.setLimit(Integer.valueOf(msConfigBean.getPageSize() == null || msConfigBean.getPageSize() == 0 ? 10 : msConfigBean.getPageSize()));
        example.setOffset(this.getOffset(msConfigBean));
        List cfgConfigEntities = this.cfgConfigDao.selectByExample(example);
        Long count = this.cfgConfigDao.countByExample(example);
        msConfigPageDTO.setPageNo(msConfigBean.getPageNo());
        msConfigPageDTO.setTotal(Integer.valueOf(count.intValue()));
        List result = cfgConfigEntities.stream().map(ConfigEntityTranslater::convertFromConfigEntity).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(result)) {
            this.embodyConfigBizBillAttributes(result);
        }
        msConfigPageDTO.setItemDTOList(result);
        return msConfigPageDTO;
    }

    public MsConfigPageDTO queryConfigListByIds(List<Long> configIds, Long groupId) {
        logger.info("queryConfigList {} groupId {}", (Object)JsonUtils.writeObjectToFastJson(configIds), (Object)groupId);
        MsConfigPageDTO msConfigPageDTO = new MsConfigPageDTO();
        CfgConfigExample example = new CfgConfigExample();
        example.createCriteria().andConfigIdIn(configIds);
        List cfgConfigEntities = this.cfgConfigDao.selectByExample(example);
        Long count = this.cfgConfigDao.countByExample(example);
        msConfigPageDTO.setPageNo(Integer.valueOf(1));
        msConfigPageDTO.setTotal(Integer.valueOf(count.intValue()));
        List result = cfgConfigEntities.stream().map(ConfigEntityTranslater::convertFromConfigEntity).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(result)) {
            this.embodyConfigBizBillAttributes(result);
        }
        msConfigPageDTO.setItemDTOList(result);
        return msConfigPageDTO;
    }

    public void embodyConfigBizBillAttributes(List<MsConfigBean> msConfigBeanTmps) {
        Map<Long, List<MsConfigBean>> msConfigBeanMap = msConfigBeanTmps.stream().collect(Collectors.groupingBy(MsConfigBean::getConfigId));
        CfgConfigBillAttributeExample example = new CfgConfigBillAttributeExample();
        example.createCriteria().andConfigIdIn(msConfigBeanMap.keySet().stream().collect(Collectors.toList())).andStatusEqualTo(ConstantValue.STATUS_ACTIVE);
        List queryCfgConfigBillAttributes = this.cfgConfigBillAttributeExtDao.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)queryCfgConfigBillAttributes)) {
            return;
        }
        Map<Long, List<CfgConfigBillAttributeEntity>> cfgConfigBillAttributeMap = queryCfgConfigBillAttributes.stream().collect(Collectors.groupingBy(CfgConfigBillAttributeEntity::getConfigId));
        cfgConfigBillAttributeMap.entrySet().stream().forEach(entry -> {
            MsConfigBean msConfigBean = (MsConfigBean)((List)msConfigBeanMap.get(entry.getKey())).get(0);
            List cfgConfigBillAttributes = (List)entry.getValue();
            List attributes = cfgConfigBillAttributes.stream().filter(it -> this.validateMsConfigBean(it, msConfigBean)).map(arg_0 -> ((CfgConfigBillAttributeEntityMapper)this.cfgConfigBillAttributeEntityMapper).convertCfgConfigBillAttributeEntity(arg_0)).collect(Collectors.toList());
            msConfigBean.setAttributes(attributes);
        });
    }

    public Boolean validateMsConfigBean(CfgConfigBillAttributeEntity cfgConfigBillAttributeEntity, MsConfigBean msConfigBean) {
        Long groupId;
        if (Optional.ofNullable(cfgConfigBillAttributeEntity.getBusinessBillType()).map(it -> !it.equals(msConfigBean.getBusinessBillType())).orElse(true).booleanValue() || Optional.ofNullable(cfgConfigBillAttributeEntity.getSalesbillType()).map(it -> !it.equals(msConfigBean.getSalesbillType())).orElse(true).booleanValue()) {
            return false;
        }
        Long l = groupId = BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(msConfigBean.getBusinessBillType()) ? msConfigBean.getSellerGroupId() : msConfigBean.getPurchaserGroupId();
        if (Objects.isNull(groupId) || !groupId.equals(cfgConfigBillAttributeEntity.getGroupId())) {
            return false;
        }
        return true;
    }

    private List<MsConfigBizBillAttribute> getConfigBizBillAttributes(MsConfigBean msConfigBeanTmp) {
        ArrayList<MsConfigBizBillAttribute> attributes = new ArrayList<MsConfigBizBillAttribute>();
        Long configId = msConfigBeanTmp.getConfigId();
        String bizBillType = msConfigBeanTmp.getBusinessBillType();
        String salesBillType = msConfigBeanTmp.getSalesbillType();
        Long groupId = null;
        groupId = BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(bizBillType) ? msConfigBeanTmp.getSellerGroupId() : msConfigBeanTmp.getPurchaserGroupId();
        CfgConfigBillAttributeExample example = new CfgConfigBillAttributeExample();
        example.createCriteria().andConfigIdEqualTo(configId).andSalesbillTypeEqualTo(salesBillType).andGroupIdEqualTo(groupId).andBusinessBillTypeEqualTo(bizBillType).andStatusEqualTo(ConstantValue.STATUS_ACTIVE);
        List attributeEntities = this.cfgConfigBillAttributeExtDao.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)attributeEntities)) {
            return attributes;
        }
        attributeEntities.stream().forEach(attr -> {
            MsConfigBizBillAttribute attribute = new MsConfigBizBillAttribute();
            attribute.setFieldName(attr.getFieldName());
            attribute.setFieldValue(attr.getFieldValue());
            attribute.setAttrName(attr.getAttrName());
            attribute.setAttrDesc(attr.getAttrDesc());
            attribute.setValue(attr.getValue());
            attributes.add(attribute);
        });
        return attributes;
    }

    public Integer queryConfigCount(MsConfigQueryRequest msConfigBean, Long groupId) {
        CfgConfigExample example = ExamapleTranslater.createConfigExampleByRequest((MsConfigQueryRequest)msConfigBean, (Long)groupId);
        Long count = this.cfgConfigDao.countByExample(example);
        return count.intValue();
    }

    public List<MsConfigItemBean> queryConfigItemList(MsConfigItemQueryRequest cfgConfigItemRequest) {
        logger.info("queryConfigItemList===========cfgConfigItemRequest:{}", (Object)JsonUtils.writeObjectToFastJson((Object)cfgConfigItemRequest));
        Long configId = Long.valueOf(cfgConfigItemRequest.getConfigId());
        CfgConfigEntity config = this.cfgConfigDataService.queryById(configId);
        ArrayList<MsConfigItemBean> result = new ArrayList<MsConfigItemBean>();
        if (Objects.nonNull(config)) {
            List cfgConfigItemEntityList = this.cfgConfigDataService.queryByParentId(configId);
            if (CollectionUtils.isNotEmpty((Collection)cfgConfigItemEntityList)) {
                result.addAll(cfgConfigItemEntityList.stream().map(ConfigItemEntityTranslator::convertFromConfigItemEntity).collect(Collectors.toList()));
                this.buildQDConfigItem(config.getConfigType(), config.getTaxInvoiceSource(), configId).ifPresent(result::add);
            }
        } else {
            CfgConfigTempEntity tempConfig = this.cfgConfigDataService.queryTempById(configId);
            if (Objects.nonNull(tempConfig)) {
                List cfgConfigItemTempEntities = this.cfgConfigDataService.queryTempByParentId(configId);
                result.addAll(cfgConfigItemTempEntities.stream().map(ConfigItemEntityTranslator::convertFromConfigItemTempEntity).collect(Collectors.toList()));
                this.buildQDConfigItem(ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType(), tempConfig.getTaxInvoiceSource(), configId).ifPresent(result::add);
            }
        }
        return result;
    }

    public List<MsConfigItemBean> batchQueryConfigItemList(MsConfigItemBatchQueryRequest cfgConfigItemRequest) {
        logger.info("queryConfigItemList===========cfgConfigItemRequest:{}", (Object)JsonUtils.writeObjectToFastJson((Object)cfgConfigItemRequest));
        CfgConfigItemExample cfgConfigItemExample = new CfgConfigItemExample();
        ArrayList<MsConfigItemBean> result = new ArrayList<MsConfigItemBean>();
        List allIds = cfgConfigItemRequest.getConfigIds();
        if (CollectionUtils.isEmpty((Collection)allIds)) {
            return result;
        }
        cfgConfigItemExample.createCriteria().andConfigIdIn(allIds);
        List cfgConfigItemEntityList = this.cfgConfigItemDao.selectByExample(cfgConfigItemExample);
        ArrayList<Long> configIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty((Collection)cfgConfigItemEntityList)) {
            for (Object cfgConfigItemEntity : cfgConfigItemEntityList) {
                MsConfigItemBean msConfigItemBean = ConfigItemEntityTranslator.convertFromConfigItemEntity((CfgConfigItemEntity)cfgConfigItemEntity);
                result.add(msConfigItemBean);
                configIds.add(cfgConfigItemEntity.getConfigId());
            }
        }
        List<Long> tempConfigIds = new ArrayList();
        if (configIds.size() > 0) {
            for (Long id : allIds) {
                if (configIds.contains(id)) continue;
                tempConfigIds.add(id);
            }
        } else {
            tempConfigIds = allIds;
        }
        if (!CollectionUtils.isEmpty(tempConfigIds)) {
            CfgConfigItemTempExample cfgConfigTempExample = new CfgConfigItemTempExample();
            cfgConfigTempExample.createCriteria().andConfigIdIn(tempConfigIds);
            List cfgConfigItemTempEntities = this.cfgConfigItemTempDao.selectByExample(cfgConfigTempExample);
            if (!CollectionUtils.isEmpty((Collection)cfgConfigItemTempEntities)) {
                for (CfgConfigItemTempEntity cfgConfigItemEntity : cfgConfigItemTempEntities) {
                    MsConfigItemBean msConfigItemBean = ConfigItemEntityTranslator.convertFromConfigItemTempEntity((CfgConfigItemTempEntity)cfgConfigItemEntity);
                    result.add(msConfigItemBean);
                }
            }
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long queryTempConfigItemList(MsTmpConfigAddRequest msTmpConfigQueryRequest) {
        List list = msTmpConfigQueryRequest.getEntityList();
        if (StringUtils.isNotBlank((CharSequence)msTmpConfigQueryRequest.getTaxInvoiceSource()) && TaxInvoiceSource.QD.getValue().equals(msTmpConfigQueryRequest.getTaxInvoiceSource())) {
            this.modifySplitRuleForQd(list);
        }
        logger.info("cfg_config_temp md5 lists====={}, {}", (Object)JsonUtils.writeObjectToFastJson((Object)list), (Object)msTmpConfigQueryRequest.getTaxInvoiceSource());
        String md5 = this.getMD5TempConfigItem(list, msTmpConfigQueryRequest.getTaxInvoiceSource());
        logger.info("cfg_config_temp md5======{}", (Object)md5);
        CfgConfigTempExample example = new CfgConfigTempExample();
        example.createCriteria().andMd5EqualTo(md5);
        List configTempEntityList = this.cfgConfigTempDao.selectByExample(example);
        logger.info("cfgConfigTempDao selectByExample ======{}", (Object)JsonUtils.writeObjectToFastJson((Object)configTempEntityList));
        if (CollectionUtils.isEmpty((Collection)configTempEntityList)) {
            MsConfigBean msConfigBean = new MsConfigBean();
            msConfigBean.setConfigType(msTmpConfigQueryRequest.getConfigType());
            msConfigBean.setInvoiceType(msTmpConfigQueryRequest.getInvoiceType());
            msConfigBean.setSellerTaxNo(msTmpConfigQueryRequest.getSellerTaxNo());
            msConfigBean.setBusinessBillType(msTmpConfigQueryRequest.getBusinessBillType());
            msConfigBean.setTaxInvoiceSource(msTmpConfigQueryRequest.getTaxInvoiceSource());
            this.checkTmpInvoiceInfo(list, msConfigBean);
            CfgConfigTempEntity cfgConfigTempEntity = new CfgConfigTempEntity();
            Long id = this.generator.nextId();
            cfgConfigTempEntity.setConfigId(id);
            cfgConfigTempEntity.setMd5(md5);
            cfgConfigTempEntity.setUserId(msTmpConfigQueryRequest.getUserId());
            cfgConfigTempEntity.setCreateTime(new Date());
            cfgConfigTempEntity.setConfigName(UUID.randomUUID().toString());
            cfgConfigTempEntity.setUpdateTime(cfgConfigTempEntity.getCreateTime());
            cfgConfigTempEntity.setTaxInvoiceSource(msTmpConfigQueryRequest.getTaxInvoiceSource());
            this.cfgConfigTempDao.insert(cfgConfigTempEntity);
            for (MsConfigItemTempBean bean : list) {
                CfgConfigItemTempEntity cfgConfigItemTempEntity = ExamapleTranslater.tempBeanConvert2ItemTempEntity((MsConfigItemTempBean)bean, (Long)id);
                cfgConfigItemTempEntity.setCreateUser(msTmpConfigQueryRequest.getUserId());
                cfgConfigItemTempEntity.setCreateTime(new Date());
                cfgConfigItemTempEntity.setUpdateTime(cfgConfigItemTempEntity.getCreateTime());
                cfgConfigItemTempEntity.setUpdateUser(msTmpConfigQueryRequest.getUserId());
                cfgConfigItemTempEntity.setConfigItemId(Long.valueOf(this.generator.nextId()));
                this.cfgConfigItemTempDao.insert(cfgConfigItemTempEntity);
            }
            return id;
        }
        return ((CfgConfigTempEntity)configTempEntityList.get(0)).getConfigId();
    }

    private String getMD5TempConfigItem(List<MsConfigItemTempBean> msConfigItemTempBeanList, String taxInvoiceSource) {
        Map<String, List> configItemTempBeanMap = msConfigItemTempBeanList.stream().collect(Collectors.toMap(MsConfigItemTempBean::getConfigItemName, MsConfigItemTempBean::getConfigItemValue, (a, b) -> a));
        configItemTempBeanMap.put("taxInvoiceSource", Lists.newArrayList((Object[])new String[]{taxInvoiceSource}));
        StringBuffer buffer = new StringBuffer();
        configItemTempBeanMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(orderedBean -> buffer.append((String)orderedBean.getKey()).append(orderedBean.getValue()));
        return DigestUtils.md5Hex((String)buffer.toString());
    }

    private boolean queryInvoiceConfigRuleExists(MsConfigBean msConfigBean) {
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = cfgConfigExample.createCriteria();
        criteria.andConfigTypeEqualTo(Byte.valueOf(msConfigBean.getConfigType().byteValue()));
        if (msConfigBean.getConfigType().equals(ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType()) || msConfigBean.getConfigType().equals(ConfigTypeEnum.BILL_INVOICE_MATCH_TYPE.getConfigType()) || msConfigBean.getConfigType().equals(ConfigTypeEnum.INVOICE_MAIL_RULE_CONFIG_TYPE.getConfigType()) || msConfigBean.getConfigType().equals(ConfigTypeEnum.INVOICE_OPERRATIOON_CONFIG_TYPE.getConfigType())) {
            String invoiceType = msConfigBean.getInvoiceType();
            criteria.andInvoiceTypeEqualTo(invoiceType);
        }
        if (msConfigBean.getConfigType().equals(ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType())) {
            criteria.andTaxInvoiceSourceEqualTo(msConfigBean.getTaxInvoiceSource());
        }
        criteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        String salesbillType = StringUtils.isEmpty((CharSequence)msConfigBean.getSalesbillType()) ? "" : msConfigBean.getSalesbillType();
        criteria.andSalesbillTypeEqualTo(salesbillType);
        criteria.andBusinessBillTypeEqualTo(msConfigBean.getBusinessBillType());
        Long groupId = null;
        if (BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(msConfigBean.getBusinessBillType())) {
            Long sellerGroupId = msConfigBean.getSellerGroupId();
            criteria.andSellerGroupIdEqualTo(sellerGroupId);
            String sellerTaxNo = msConfigBean.getSellerTaxNo();
            criteria.andSellerTaxNoEqualTo(StringUtils.isBlank((CharSequence)sellerTaxNo) ? "" : sellerTaxNo);
            criteria.andSysOrgIdEqualTo(Optional.ofNullable(msConfigBean.getSysOrgId()).orElse(0L));
            Long purchaserGroupId = msConfigBean.getPurchaserGroupId();
            criteria.andPurchaserGroupIdEqualTo(Long.valueOf(purchaserGroupId == null ? 0L : purchaserGroupId));
            String purchaserTaxNo = msConfigBean.getPurchaserTaxNo();
            criteria.andPurchaserTaxNoEqualTo(StringUtils.isBlank((CharSequence)purchaserTaxNo) ? "" : purchaserTaxNo);
            groupId = sellerGroupId;
        } else {
            Long purchaserGroupId = msConfigBean.getPurchaserGroupId();
            criteria.andPurchaserGroupIdEqualTo(purchaserGroupId);
            String purchaserTaxNo = msConfigBean.getPurchaserTaxNo();
            criteria.andPurchaserTaxNoEqualTo(StringUtils.isBlank((CharSequence)purchaserTaxNo) ? "" : purchaserTaxNo);
            Long sellerGroupId = msConfigBean.getSellerGroupId();
            criteria.andSellerGroupIdEqualTo(Long.valueOf(sellerGroupId == null ? 0L : sellerGroupId));
            String sellerTaxNo = msConfigBean.getSellerTaxNo();
            criteria.andSellerTaxNoEqualTo(StringUtils.isBlank((CharSequence)sellerTaxNo) ? "" : sellerTaxNo);
            groupId = purchaserGroupId;
        }
        List cfgs = this.cfgConfigDao.selectByExample(cfgConfigExample);
        if (cfgs.size() == 0) {
            return false;
        }
        logger.info("seller config msBean {}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigBean));
        CfgConfigExample countCfgConfigExample = new CfgConfigExample();
        CfgConfigExample.Criteria countCriteria = cfgConfigExample.createCriteria();
        countCriteria.andStatusEqualTo(Byte.valueOf((byte)1));
        if (BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(msConfigBean.getBusinessBillType())) {
            if (StringUtils.isEmpty((CharSequence)msConfigBean.getSellerTaxNo())) {
                countCriteria.andSellerGroupIdEqualTo(msConfigBean.getSellerGroupId());
                countCriteria.andSellerTaxNoEqualTo("");
                countCriteria.andPurchaserGroupIdEqualTo(Long.valueOf(0L));
                countCriteria.andPurchaserTaxNoEqualTo("");
                countCriteria.andSalesbillTypeEqualTo(salesbillType);
            } else if (StringUtils.isNotEmpty((CharSequence)msConfigBean.getSellerTaxNo()) && StringUtils.isEmpty((CharSequence)msConfigBean.getPurchaserTaxNo())) {
                countCriteria.andSellerGroupIdEqualTo(msConfigBean.getSellerGroupId());
                countCriteria.andSellerTaxNoEqualTo(msConfigBean.getSellerTaxNo());
                countCriteria.andPurchaserGroupIdEqualTo(Long.valueOf(0L));
                countCriteria.andPurchaserTaxNoEqualTo("");
                countCriteria.andSalesbillTypeEqualTo(salesbillType);
            }
        } else if (StringUtils.isEmpty((CharSequence)msConfigBean.getPurchaserTaxNo())) {
            countCriteria.andSellerGroupIdEqualTo(Long.valueOf(0L));
            countCriteria.andSellerTaxNoEqualTo("");
            countCriteria.andPurchaserGroupIdEqualTo(msConfigBean.getPurchaserGroupId());
            countCriteria.andPurchaserTaxNoEqualTo("");
            countCriteria.andSalesbillTypeEqualTo(salesbillType);
        } else if (StringUtils.isNotEmpty((CharSequence)msConfigBean.getPurchaserTaxNo()) && StringUtils.isEmpty((CharSequence)msConfigBean.getSellerTaxNo())) {
            countCriteria.andSellerGroupIdEqualTo(Long.valueOf(0L));
            countCriteria.andSellerTaxNoEqualTo("");
            countCriteria.andPurchaserGroupIdEqualTo(msConfigBean.getPurchaserGroupId());
            countCriteria.andPurchaserTaxNoEqualTo(msConfigBean.getPurchaserTaxNo());
            countCriteria.andSalesbillTypeEqualTo(salesbillType);
        }
        if (ConfigTypeEnum.DISCOUNT_RATE_CONFIG_TYPE.getConfigType().equals(msConfigBean.getConfigType())) {
            CfgConfigEntity cfgConfig = this.cfgConfigDao.selectOneByExample(countCfgConfigExample);
            if (cfgConfig != null) {
                msConfigBean.setConfigId(cfgConfig.getConfigId());
            }
            return true;
        }
        long count = this.cfgConfigDao.countByExample(countCfgConfigExample);
        if (count == 0L) {
            return false;
        }
        String bizBillType = msConfigBean.getBusinessBillType();
        String salesBillType = msConfigBean.getSalesbillType();
        List attributes = msConfigBean.getAttributes();
        logger.info("@queryInvoiceConfigRuleExists current query config attributes: " + StringUtil.describeBean((Object)attributes));
        if (CollectionUtils.isEmpty((Collection)attributes)) {
            return true;
        }
        for (CfgConfigEntity config : cfgs) {
            List billAttributeEntities = this.selectCfgBillAttribute(config.getConfigId());
            if (attributes.size() != billAttributeEntities.size()) continue;
            for (MsConfigBizBillAttribute attribute : attributes) {
                String field = attribute.getFieldName();
                String attr = attribute.getAttrName();
                String value = attribute.getValue();
                boolean propMatch = false;
                for (CfgConfigBillAttributeEntity cfg : billAttributeEntities) {
                    if (StringUtils.equals((CharSequence)field, (CharSequence)cfg.getFieldName()) && StringUtils.equals((CharSequence)attr, (CharSequence)cfg.getAttrName()) && StringUtils.equals((CharSequence)value, (CharSequence)cfg.getValue())) {
                        logger.info("@queryInvoiceConfigRuleExists \u5b50\u5c5e\u6027\u5339\u914d: " + StringUtil.appendKV((String[])new String[]{cfg.getConfigId().toString(), field, attr, value}));
                        propMatch = true;
                        continue;
                    }
                    logger.info("@queryInvoiceConfigRuleExists \u5b50\u5c5e\u6027\u4e0d\u5339\u914d: " + StringUtil.appendKV((String[])new String[]{cfg.getConfigId().toString(), field, attr, value}));
                    propMatch = false;
                    break;
                }
                if (!propMatch) continue;
                return true;
            }
        }
        return false;
    }

    private List<CfgConfigBillAttributeEntity> selectCfgBillAttribute(Long configId) {
        CfgConfigBillAttributeExample example = new CfgConfigBillAttributeExample();
        example.createCriteria().andConfigIdEqualTo(configId).andStatusEqualTo(ConstantValue.STATUS_ACTIVE);
        return this.cfgConfigBillAttributeExtDao.selectByExample(example);
    }

    private Integer getOffset(MsConfigQueryRequest msConfigBean) {
        Integer pageNo = msConfigBean.getPageNo();
        Integer pageSize = msConfigBean.getPageSize();
        if (pageNo == null || pageNo == 0) {
            pageNo = 1;
        }
        if (pageSize == null || pageSize == 0) {
            pageSize = 10;
        }
        return (pageNo - 1) * pageSize;
    }

    private MsConfigBean fillCompanyInfo(MsConfigBean msConfigBean, MsCommonUserInfo userInfo) {
        String purchaserTaxNo;
        Long groupId = userInfo.getGroupId();
        String sellerTaxNo = msConfigBean.getSellerTaxNo();
        if (!StringUtils.isEmpty((CharSequence)sellerTaxNo)) {
            if (BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(msConfigBean.getBusinessBillType())) {
                CompanyData companyData = this.companyInfoQuery(groupId, sellerTaxNo);
                msConfigBean.setSellerNo(String.valueOf(companyData.getCompanyId()));
                msConfigBean.setSellerName(companyData.getCompanyName());
                List tenants2 = companyData.getTenants();
                if (!CollectionUtils.isEmpty((Collection)tenants2) && tenants2.stream().noneMatch(r -> Long.valueOf(r.getTenantId()).equals(groupId))) {
                    logger.error("\u67e5\u8be2\u516c\u53f8,\u7a0e\u53f7:{}\u5bf9\u5e94\u7684\u96c6\u56e2id\u4e3a\u3010{}\u3011\u4e0e\u5f53\u524d\u767b\u5f55\u7684\u96c6\u56e2\u3010{}\u3011\u4e0d\u4e00\u81f4", new Object[]{sellerTaxNo, ((CompanyTenant)tenants2.get(0)).getTenantId(), groupId});
                    throw new ThridPartyInvokeException("\u521b\u5efa\u65b9\u662fAR\u65f6,\u7a0e\u53f7:" + sellerTaxNo + "\u5bf9\u5e94\u7684\u96c6\u56e2id\u4e3a\u3010" + ((CompanyTenant)tenants2.get(0)).getTenantId() + "\u3011\u4e0e\u5f53\u524d\u767b\u5f55\u4eba\u7684\u96c6\u56e2\u3010" + groupId + "\u3011\u4e0d\u4e00\u81f4");
                }
            } else {
                List casInfos = this.queryCompanyInfoFromCasm(sellerTaxNo, CasmTypeEnum.SUPPLIER, userInfo);
                if (!CollectionUtils.isEmpty((Collection)casInfos)) {
                    MsCasInfo casInfo = (MsCasInfo)casInfos.get(0);
                    msConfigBean.setSellerGroupId(Long.valueOf(0L));
                    msConfigBean.setSellerName(casInfo.getEnterpriseName());
                    msConfigBean.setSellerNo("");
                    try {
                        CompanyData companyData = this.companyInfoQuery(groupId, sellerTaxNo);
                        msConfigBean.setSellerNo(String.valueOf(companyData.getCompanyId()));
                        msConfigBean.setSellerGroupId(Optional.ofNullable(companyData.getHostTenantId()).filter(r -> r != 0L).orElse(Optional.ofNullable(companyData.getTenants()).flatMap(tenants -> tenants.stream().findFirst().map(CompanyTenant::getTenantId)).orElse(0L)));
                    }
                    catch (Exception e) {
                        logger.error("\u67e5\u8be2\u516c\u53f8\u4fe1\u606f\u5931\u8d25", (Throwable)e);
                    }
                } else {
                    String msg = "\u5f53\u524d\u7a0e\u53f7:\u3010" + sellerTaxNo + "\u3011\u6ca1\u6709\u67e5\u8be2\u5230\u4f9b\u5e94\u5546\u4fe1\u606f";
                    logger.error(msg);
                    throw new CompanyQueryException(msg);
                }
            }
        }
        if (!StringUtils.isEmpty((CharSequence)(purchaserTaxNo = msConfigBean.getPurchaserTaxNo()))) {
            if (BusinessSalesBillTypeEnum.AP.getBusinessSalesBillType().equals(msConfigBean.getBusinessBillType())) {
                CompanyData companyData = this.companyInfoQuery(groupId, purchaserTaxNo);
                msConfigBean.setPurchaserNo(String.valueOf(companyData.getCompanyId()));
                msConfigBean.setPurchaserName(companyData.getCompanyName());
                List tenants3 = companyData.getTenants();
                if (!CollectionUtils.isEmpty((Collection)tenants3) && tenants3.stream().noneMatch(r -> Long.valueOf(r.getTenantId()).equals(groupId))) {
                    logger.error("\u521b\u5efa\u65b9\u662fAP\u65f6,\u67e5\u8be2\u516c\u53f8,\u7a0e\u53f7:{}\u5bf9\u5e94\u7684\u96c6\u56e2id\u4e3a\u3010{}\u3011\u4e0e\u5f53\u524d\u767b\u5f55\u7684\u96c6\u56e2\u3010{}\u3011\u4e0d\u4e00\u81f4", new Object[]{purchaserTaxNo, ((CompanyTenant)tenants3.get(0)).getTenantId(), groupId});
                    throw new ThridPartyInvokeException("\u521b\u5efa\u65b9\u662fAP\u65f6,\u7a0e\u53f7:" + purchaserTaxNo + "\u5bf9\u5e94\u7684\u96c6\u56e2id\u4e3a\u3010" + ((CompanyTenant)tenants3.get(0)).getTenantId() + "\u3011\u4e0e\u5f53\u524d\u767b\u5f55\u4eba\u7684\u96c6\u56e2\u3010" + groupId + "\u3011\u4e0d\u4e00\u81f4");
                }
            } else {
                List casInfos = this.queryCompanyInfoFromCasm(purchaserTaxNo, CasmTypeEnum.CUSTOMER, userInfo);
                if (!CollectionUtils.isEmpty((Collection)casInfos)) {
                    MsCasInfo casInfo = (MsCasInfo)casInfos.get(0);
                    msConfigBean.setPurchaserGroupId(Long.valueOf(0L));
                    msConfigBean.setPurchaserName(casInfo.getEnterpriseName());
                    msConfigBean.setPurchaserNo("");
                    try {
                        CompanyData companyData = this.companyInfoQuery(groupId, purchaserTaxNo);
                        msConfigBean.setPurchaserNo(String.valueOf(companyData.getCompanyId()));
                        msConfigBean.setPurchaserGroupId(Optional.ofNullable(companyData.getHostTenantId()).filter(r -> r != 0L).orElse(Optional.ofNullable(companyData.getTenants()).flatMap(tenants -> tenants.stream().findFirst().map(CompanyTenant::getTenantId)).orElse(0L)));
                    }
                    catch (Exception e) {
                        logger.error("\u67e5\u8be2\u516c\u53f8\u4fe1\u606f\u5931\u8d25", (Throwable)e);
                    }
                } else {
                    String msg = "\u5f53\u524d\u7a0e\u53f7:\u3010" + purchaserTaxNo + "\u3011\u6ca1\u6709\u67e5\u8be2\u5230\u5ba2\u6237\u4fe1\u606f";
                    logger.error(msg);
                    throw new CompanyQueryException(msg);
                }
            }
        }
        return msConfigBean;
    }

    private MsConfigBean fillOrgInfo(MsConfigBean msConfigBean, MsCommonUserInfo userInfo) {
        Long groupId = userInfo.getGroupId();
        Long sysOrgId = msConfigBean.getSysOrgId();
        if (Objects.nonNull(sysOrgId) && sysOrgId > 0L) {
            OrgData companyData;
            UserCenterResponse orgDataResponse = this.userCenterOrgService.getOrgById(groupId.longValue(), sysOrgId.longValue());
            OrgData orgData = (OrgData)orgDataResponse.getResult();
            if (Objects.isNull(orgData)) {
                return msConfigBean;
            }
            if (OrgType.Company.value().equals(orgData.getOrgType())) {
                companyData = orgData;
            } else {
                companyData = this.configCompanyService.getParentCompanyInfo((Map)Maps.newHashMap(), orgData.getParentId(), groupId);
                if (Objects.isNull(companyData) || !OrgType.Company.value().equals(companyData.getOrgType())) {
                    return msConfigBean;
                }
            }
            if (BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(msConfigBean.getBusinessBillType())) {
                msConfigBean.setSellerName(orgData.getOrgName());
                msConfigBean.setSellerTaxNo(companyData.getTaxNum());
            } else {
                msConfigBean.setPurchaserName(orgData.getOrgName());
                msConfigBean.setPurchaserTaxNo(companyData.getTaxNum());
            }
        }
        return msConfigBean;
    }

    public CompanyData companyInfoQuery(Long tenantId, String taxNo) {
        UserCenterResponse reply2 = this.userCenterController.getCompanyByTaxNo(tenantId.longValue(), taxNo);
        if (!"1".equals(reply2.getCode()) || reply2.getResult() == null) {
            String msg = "\u5f53\u524d\u7a0e\u53f7:\u3010" + taxNo + "\u3011\u6ca1\u6709\u67e5\u8be2\u5230\u516c\u53f8\u4fe1\u606f";
            logger.error(msg);
            throw new CompanyQueryException(msg);
        }
        logger.info("companyInfoQuery:{}", (Object)JsonUtils.writeObjectToJson((Object)reply2.getResult()));
        return (CompanyData)reply2.getResult();
    }

    private List<MsCasInfo> queryCompanyInfoFromCasm(String taxNo, CasmTypeEnum type, MsCommonUserInfo userInfo) {
        MsCasInfoModel casInfoModel;
        MsListCasRequest casRequest = new MsListCasRequest();
        casRequest.setCurrentPage(Integer.valueOf(1));
        casRequest.setPageSize(Integer.valueOf(1000));
        casRequest.setParam(taxNo);
        casRequest.setParamType(Integer.valueOf(3));
        casRequest.setGroupid(userInfo.getGroupId());
        casRequest.setOperatorId(userInfo.getUserId());
        casRequest.setCasType(Integer.valueOf(type.getTypeValue()));
        logger.info("sellerconfig\u67e5\u8be2\u5ba2\u5546\u4fe1\u606f:{}", (Object)JsonUtils.writeObjectToJson((Object)casRequest));
        MsListCasResult casResult = this.casmClient.listCas(casRequest);
        logger.info("\u67e5\u8be2\u5ba2\u5546\u4fe1\u606f\u8fd4\u56de\u7ed3\u679c:{}", (Object)JsonUtils.writeObjectToJson((Object)casResult));
        if (casResult != null && casResult.getCode().equals(Response.OK) && (casInfoModel = casResult.getResult()) != null) {
            return casInfoModel.getCasInfos();
        }
        return new ArrayList<MsCasInfo>();
    }

    private boolean checkTmpInvoiceInfo(List<MsConfigItemTempBean> list, MsConfigBean msConfigBean) {
        List msConfigItemBeans = list.stream().filter(Objects::nonNull).map(entry -> ConfigItemEntityTranslator.convertFromMsConfigItemTempBean((MsConfigItemTempBean)entry)).collect(Collectors.toList());
        return this.checkConfigItem(msConfigItemBeans, msConfigBean, new String[0]);
    }

    private boolean checkConfigItem(List<MsConfigItemBean> msConfigItemBeans, MsConfigBean msConfigBean, String ... channels) {
        Integer taxDeviceTypeOrdinal;
        Optional deviceTypeOptional;
        BigDecimal maxDiscountRate;
        logger.debug("checkConfigItem msConfigItemBeans ======{},invoiceTypeStr:{},sellerTaxNo:{}", new Object[]{JsonUtils.writeObjectToFastJson(msConfigItemBeans), msConfigBean.getInvoiceType(), msConfigBean.getSellerTaxNo()});
        InvoiceSplitrRuleDTO invoiceSplitrRuleDTO = new InvoiceSplitParser().parse(msConfigItemBeans);
        msConfigBean.setItemList(msConfigItemBeans);
        if ((StringUtils.isEmpty((CharSequence)msConfigBean.getTaxInvoiceSource()) || TaxInvoiceSource.SK.getValue().equals(msConfigBean.getTaxInvoiceSource())) && null == invoiceSplitrRuleDTO.getInvoiceLimit()) {
            throw new InvoiceSplitConfigException("\u9650\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((StringUtils.isEmpty((CharSequence)msConfigBean.getTaxInvoiceSource()) || TaxInvoiceSource.SK.getValue().equals(msConfigBean.getTaxInvoiceSource())) && null == invoiceSplitrRuleDTO.getInvoiceItemMaxRow()) {
            throw new InvoiceSplitConfigException("\u53d1\u7968\u6700\u5927\u884c\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean checkAmountLimit = true;
        if (Objects.nonNull(channels)) {
            checkAmountLimit = Arrays.stream(channels).noneMatch(channel -> "qianniu".equals(channel));
        }
        if (invoiceSplitrRuleDTO.getInvoiceLimit() != null && checkAmountLimit) {
            this.checkLimitAmt(msConfigBean, invoiceSplitrRuleDTO.getInvoiceLimit().toString());
        }
        Integer invoiceMaxRow = invoiceSplitrRuleDTO.getInvoiceItemMaxRow();
        Integer salesListMaxRow = invoiceSplitrRuleDTO.getSalesListMaxRow();
        String saleListOpt = invoiceSplitrRuleDTO.getSaleListOption();
        String taxDeviceType = invoiceSplitrRuleDTO.getTaxDeviceType();
        BigDecimal taxAmountAllowMax = invoiceSplitrRuleDTO.getTaxAmountAllowMax();
        BigDecimal discountRate = invoiceSplitrRuleDTO.getBizBillDiscountRate();
        if (discountRate.compareTo(maxDiscountRate = new BigDecimal(1)) > 0 || discountRate.compareTo(BigDecimal.ZERO) < 0) {
            throw new InvoiceSplitConfigException("\u6298\u6263\u7387\u914d\u7f6e\u503c\u5408\u7406\u8303\u56f4 0% ~ 100% \u6216\u8005 0 ~ 1");
        }
        if (taxAmountAllowMax != null && taxAmountAllowMax.compareTo(new BigDecimal(1.26)) > 0) {
            throw new InvoiceSplitConfigException("\u6700\u5927\u7a0e\u989d\u5bb9\u5dee\u5408\u7406\u8303\u56f4\u4e3a0.01-1.26\u4e4b\u95f4\u7684\u4e24\u4f4d\u5c0f\u6570");
        }
        InvoiceTypeEnum invoiceType = (InvoiceTypeEnum)ValueEnum.getEnumByValue(InvoiceTypeEnum.class, (Object)msConfigBean.getInvoiceType()).orElseThrow(() -> new RuntimeException("\u4e0d\u5b58\u5728\u5bf9\u5e94\u7c7b\u578b\u7684\u7968"));
        logger.info("checkConfigItem invoiceType:{}, saleListOpt:{}, invoiceMaxRow:{}, salesListMaxRow:{}", new Object[]{invoiceType.getValue(), saleListOpt, invoiceMaxRow, salesListMaxRow});
        Boolean isSk = true;
        if (StringUtils.isNotBlank((CharSequence)msConfigBean.getTaxInvoiceSource()) && TaxInvoiceSource.QD.getValue().equals(msConfigBean.getTaxInvoiceSource())) {
            isSk = false;
        }
        if (isSk.booleanValue() && (invoiceType == InvoiceTypeEnum.ELECTRONIC || invoiceType == InvoiceTypeEnum.ELECTRIC_SPECIAL_INVOICE)) {
            if (invoiceMaxRow < 1 || invoiceMaxRow > 8) {
                throw new InvoiceSplitConfigException("\u7535\u7968\u62c6\u7968\u89c4\u5219\uff0c\u7968\u9762\u6700\u5927\u884c\u6570\u53ea\u80fd\u662f 1 \u81f38");
            }
            if (!(SalesListPrintEnum.NOT_PRINT_SALES_LIST.getSalesListOpt().equals(saleListOpt) || salesListMaxRow > this.DEFAULT_SALES_LOW_LIST_MAX_ROW && salesListMaxRow <= this.ELEC_SALES_UP_LIST_MAX_ROW)) {
                throw new InvoiceSplitConfigException("\u7535\u7968\u62c6\u7968\u89c4\u5219\uff0c\u6253\u5370\u9500\u8d27\u6e05\u5355\u9009\u9879\uff0c\u9500\u8d27\u6e05\u5355\u6700\u5927\u884c\u6570\u53ea\u80fd\u662f 1\u81f32000\u884c");
            }
        } else if (isSk.booleanValue() && (invoiceType == InvoiceTypeEnum.NORMAL || invoiceType == InvoiceTypeEnum.SPECIAL)) {
            if (SalesListPrintEnum.NOT_PRINT_SALES_LIST.getSalesListOpt().equals(saleListOpt)) {
                if (invoiceMaxRow < 1 || invoiceMaxRow > 8) {
                    throw new InvoiceSplitConfigException("\u666e\u7968/\u4e13\u7968\u62c6\u7968\u89c4\u5219\uff0c\u4e0d\u6253\u5370\u9500\u8d27\u6e05\u5355\u9009\u9879\uff0c\u7968\u9762\u6700\u5927\u884c\u6570\u53ea\u80fd\u662f 1 \u81f38");
                }
            } else {
                if (invoiceMaxRow <= 0 || invoiceMaxRow > 8) {
                    throw new InvoiceSplitConfigException("\u666e\u7968/\u4e13\u7968\u62c6\u7968\u89c4\u5219\uff0c\u6253\u5370\u9500\u8d27\u6e05\u5355\u9009\u9879\uff0c\u7968\u9762\u6700\u5927\u884c\u6570\u53ea\u80fd\u662f 1\u81f38");
                }
                if (salesListMaxRow <= this.DEFAULT_SALES_LOW_LIST_MAX_ROW || salesListMaxRow > this.HX_BW_SALES_UP_LIST_MAX_ROW) {
                    throw new InvoiceSplitConfigException("\u666e\u7968/\u4e13\u7968\u62c6\u7968\u89c4\u5219\uff0c\u9500\u8d27\u6e05\u5355\u6700\u5927\u884c\u6570\u53ea\u80fd\u662f 1 \u81f3 2000.");
                }
            }
        }
        if (!(deviceTypeOptional = ValueEnum.getEnumByOrdinal(TaxWareRemarkDeviceType.class, (Integer)(taxDeviceTypeOrdinal = Integer.valueOf(NumberUtils.toInt((String)taxDeviceType, (int)-1))))).isPresent() && isSk.booleanValue()) {
            throw new InvoiceSplitConfigException("\u7a0e\u63a7\u8bbe\u5907\u7c7b\u578b\u4e3a\u5fc5\u586b\u9879");
        }
        Integer limitRemarkLength = 200;
        TaxWareRemarkDeviceType deviceTypeEnum = TaxWareRemarkDeviceType.DEFAULT;
        if (isSk.booleanValue()) {
            deviceTypeEnum = (TaxWareRemarkDeviceType)deviceTypeOptional.get();
            limitRemarkLength = this.taxWareInvoiceRemarkLengthProperties.getRemarkLength(invoiceType, TaxWareRemarkIssueType.BLUE, deviceTypeEnum);
        } else if (invoiceType == InvoiceTypeEnum.NORMAL || invoiceType == InvoiceTypeEnum.SPECIAL) {
            limitRemarkLength = 230;
        }
        Integer customRemarkSize = invoiceSplitrRuleDTO.getCustomRemarkSize();
        if (customRemarkSize != null) {
            if (customRemarkSize <= 0) {
                throw new InvoiceSplitConfigException("\u81ea\u5b9a\u4e49\u5907\u6ce8\u957f\u5ea6\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6574\u6570");
            }
            if (customRemarkSize > limitRemarkLength) {
                throw new InvoiceSplitConfigException(String.format("\u53d1\u7968\u7c7b\u578b\u4e3a%s,\u8bbe\u5907\u7c7b\u578b\u4e3a%s,\u81ea\u5b9a\u4e49\u5907\u6ce8\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7%d\u4e2a\u5b57\u8282", invoiceType.getDescription(), deviceTypeEnum.getDescription(), limitRemarkLength));
            }
        }
        return true;
    }

    private boolean checkBusinessConfig(MsConfigBean msConfigBean, String ... channels) {
        ConfigTypeEnum configTypeEnum = ConfigTypeEnum.of((Integer)msConfigBean.getConfigType());
        switch (1.$SwitchMap$com$xforceplus$seller$config$client$constant$ConfigTypeEnum[configTypeEnum.ordinal()]) {
            case 1: {
                return this.checkInvoiceSplitConfig(msConfigBean, channels);
            }
            case 6: {
                return this.checkInvoiceUserConfig(msConfigBean);
            }
            case 12: {
                return this.checkDiscountRateConfig(msConfigBean);
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    private boolean checkDiscountRateConfig(MsConfigBean msConfigBean) {
        List msConfigItemBeanList = msConfigBean.getItemList();
        logger.info("checkDiscountRateConfig---msConfigItemBeanList:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigItemBeanList));
        if (CollectionUtils.isEmpty((Collection)msConfigItemBeanList) || msConfigItemBeanList.stream().map(it -> it.getConfigItemValue()).anyMatch(it -> CollectionUtils.isEmpty((Collection)it) || it.size() < 2)) {
            throw new ConfigCreateException("\u6298\u6263\u7387\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a,\u56de\u6b3e\u5468\u671f\u548c\u6298\u6263\u7387\u5fc5\u586b");
        }
        if (msConfigItemBeanList.size() > 10) {
            throw new ConfigCreateException("\u540c\u4e2a\u8d2d\u9500\u5bf9\u7684\u6298\u6263\u7387\u914d\u7f6e\u4e0d\u80fd\u8d85\u8fc710\u6761");
        }
        msConfigItemBeanList.stream().map(it -> (String)it.getConfigItemValue().get(0)).forEach(it -> {
            try {
                Integer days = Integer.valueOf(it);
                if (days <= 0) {
                    throw new NumberFormatException();
                }
            }
            catch (Exception e) {
                throw new ConfigCreateException("\u56de\u6b3e\u5468\u671f\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6574\u6570");
            }
        });
        msConfigItemBeanList.stream().map(it -> (String)it.getConfigItemValue().get(1)).forEach(it -> {
            try {
                BigDecimal discount = new BigDecimal((String)it);
                if (discount.compareTo(BigDecimal.ZERO) < 0 || discount.compareTo(new BigDecimal(100)) > 0 || discount.scale() > 2) {
                    throw new NumberFormatException();
                }
            }
            catch (Exception e) {
                throw new ConfigCreateException("\u6298\u6263\u7387\u5fc5\u987b\u4e3a\u5927\u4e8e0\u5c0f\u4e8e100\u7684\u6570\u5b57,\u6700\u591a\u652f\u6301\u4e24\u4f4d\u5c0f\u6570");
            }
        });
        if (msConfigItemBeanList.stream().map(it -> it.getConfigItemValue()).map(it -> (String)it.get(0) + "-" + (String)it.get(1)).distinct().collect(Collectors.toList()).size() < msConfigItemBeanList.size()) {
            throw new ConfigCreateException("\u552f\u4e00\u6027\u6821\u9a8c,\u56de\u6b3e\u5468\u671f\u548c\u6298\u6263\u7387\u7684\u7ec4\u5408\u4e0d\u80fd\u91cd\u590d");
        }
        return true;
    }

    private boolean checkInvoiceSplitConfig(MsConfigBean msConfigBean, String ... channels) {
        Integer configType = msConfigBean.getConfigType();
        String invoiceTypeStr = msConfigBean.getInvoiceType();
        ConfigTypeEnum configTypeEnum = ConfigTypeEnum.getConfigTypeByValue((Integer)configType);
        List msConfigItemBeans = msConfigBean.getItemList();
        if (configTypeEnum == ConfigTypeEnum.SPLIT_CONFIG_TYPE) {
            return this.checkConfigItem(msConfigItemBeans, msConfigBean, channels);
        }
        return true;
    }

    private boolean checkInvoiceUserConfig(MsConfigBean msConfigBean) {
        List msConfigItemBeanList = msConfigBean.getItemList();
        logger.info("checkInvoiceUserConfig---msConfigItemBeanList:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigItemBeanList));
        if (CollectionUtils.isEmpty((Collection)msConfigItemBeanList)) {
            throw new ConfigCreateException("\u7968\u9762\u4eba\u5458\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        MsMataDataQueryRequest msMataDataQueryRequest = new MsMataDataQueryRequest();
        msMataDataQueryRequest.setObjCode("invoiceMemberInfoConfig");
        msMataDataQueryRequest.setObjType(msConfigBean.getSalesbillType());
        List msBusinessObjMetadataBeanList = this.configMetaDataService.queryTemplateMetaDataList(msMataDataQueryRequest);
        if (CollectionUtils.isEmpty((Collection)msBusinessObjMetadataBeanList)) {
            throw new ConfigCreateException("\u7968\u9762\u4eba\u5458\u6821\u9a8c\u4fe1\u606f\u52a0\u8f7d\u5931\u8d25.");
        }
        HashMap validateFieldLengthMap = Maps.newHashMap();
        msBusinessObjMetadataBeanList.forEach(item -> validateFieldLengthMap.put(item.getFieldName(), item));
        logger.info("checkInvoiceUserConfig---validateFieldLengthMap:{}", (Object)JsonUtils.writeObjectToFastJson((Object)validateFieldLengthMap));
        int flag = 0;
        for (MsConfigItemBean msConfigItemBean : msConfigItemBeanList) {
            MsBusinessObjMetadataBean item2 = (MsBusinessObjMetadataBean)validateFieldLengthMap.get(msConfigItemBean.getConfigItemName());
            Integer fieldLength = item2 == null ? 0 : item2.getFieldLength();
            fieldLength = fieldLength == null ? 0 : fieldLength;
            if (CollectionUtils.isEmpty((Collection)msConfigItemBean.getConfigItemValue())) {
                throw new ConfigCreateException("\u7968\u9762\u4eba\u5458\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a.");
            }
            String fieldValue = (String)msConfigItemBean.getConfigItemValue().get(0);
            logger.info("checkInvoiceUserConfig---fieldName:{},fieldValue:{}, length:{}, validateLength:{}", new Object[]{msConfigItemBean.getConfigItemName(), fieldValue.length(), fieldValue, fieldLength});
            if (item2.getFieldRequired() != null && item2.getFieldRequired() == 1 && StringUtils.isEmpty((CharSequence)fieldValue)) {
                throw new ConfigCreateException("\u7968\u9762\u4eba\u5458\u4fe1\u606f\u3010" + item2.getFieldDisplayName() + "\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.isNotBlank((CharSequence)fieldValue)) continue;
            ++flag;
            if (fieldLength <= 0 || fieldValue.length() <= fieldLength) continue;
            throw new ConfigCreateException("\u7968\u9762\u4eba\u5458\u4fe1\u606f\u3010" + item2.getFieldDisplayName() + "\u3011\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e" + fieldLength);
        }
        if (flag == 0) {
            throw new ConfigCreateException("\u7968\u9762\u4eba\u5458\u4fe1\u606f\u6240\u6709\u5b57\u6bb5\u4e0d\u53ef\u90fd\u4e3a\u7a7a");
        }
        return true;
    }

    private boolean checkConfigItemRequired(MsConfigBean msConfigBean) {
        List unRequiredFiledList = this.unRequiredFiledList();
        logger.info("unRequiredFiledList {}", (Object)JsonUtils.writeObjectToFastJson((Object)unRequiredFiledList));
        List msConfigItemBeanList = msConfigBean.getItemList();
        for (MsConfigItemBean msConfigItemBean : msConfigItemBeanList) {
            String fieldName = msConfigItemBean.getConfigItemName();
            List itemValue = msConfigItemBean.getConfigItemValue();
            if (StringUtils.isNotEmpty((CharSequence)msConfigBean.getTaxInvoiceSource()) && TaxInvoiceSource.QD.getValue().equals(msConfigBean.getTaxInvoiceSource())) {
                unRequiredFiledList.add("invoiceLimit");
                unRequiredFiledList.add("invoiceItemMaxRow");
                InvoiceTypeEnum invoiceType = (InvoiceTypeEnum)ValueEnum.getEnumByValue(InvoiceTypeEnum.class, (Object)msConfigBean.getInvoiceType()).orElseThrow(() -> new RuntimeException("\u4e0d\u5b58\u5728\u5bf9\u5e94\u7c7b\u578b\u7684\u7968"));
                if (invoiceType == InvoiceTypeEnum.ELECTRONIC || invoiceType == InvoiceTypeEnum.ELECTRIC_SPECIAL_INVOICE) {
                    unRequiredFiledList.add("saleListOption");
                    unRequiredFiledList.add("salesListMaxRow");
                }
                if (fieldName.equals("invoiceLimit") && (CollectionUtils.isEmpty((Collection)itemValue) || StringUtils.isEmpty((CharSequence)((CharSequence)itemValue.get(0))))) {
                    itemValue.clear();
                    itemValue.add("99999999999.99");
                    msConfigItemBean.setConfigItemValue(itemValue);
                }
            }
            if (unRequiredFiledList.contains(fieldName) || !CollectionUtils.isEmpty((Collection)itemValue)) continue;
            String configItemDisplayName = msConfigItemBean.getConfigItemDisplayName();
            if (StringUtils.isEmpty((CharSequence)configItemDisplayName)) {
                if ("splitFiledList".equals(fieldName)) {
                    configItemDisplayName = "\u62c6\u5206\u5b57\u6bb5";
                } else if ("invoiceRemarkFiledList".equals(fieldName)) {
                    configItemDisplayName = "\u5907\u6ce8\u5b57\u6bb5";
                }
            }
            if (StringUtils.isEmpty((CharSequence)configItemDisplayName)) {
                configItemDisplayName = "\u914d\u7f6e";
            }
            logger.info("not empty check fieldName {} itemValue {}", (Object)fieldName, (Object)itemValue);
            ConfigItemRequiredException configItemRequiredException = new ConfigItemRequiredException();
            String message = String.format(configItemRequiredException.getMessage(), configItemDisplayName);
            throw new ConfigItemRequiredException(message);
        }
        return true;
    }

    private List<String> unRequiredFiledList() {
        CfgTemplateObjExample cfgTemplateObjExample = new CfgTemplateObjExample();
        cfgTemplateObjExample.createCriteria().andTemplateObjCodeEqualTo("unRequiredFiledsList").andStatusEqualTo(Integer.valueOf(1));
        List cfgTemplateObjEntities = this.cfgTemplateObjDao.selectByExample(cfgTemplateObjExample);
        if (CollectionUtils.isEmpty((Collection)cfgTemplateObjEntities)) {
            return Lists.newArrayList();
        }
        CfgTemplateObjEntity cfgTemplateObjEntity = (CfgTemplateObjEntity)cfgTemplateObjEntities.get(0);
        Long busObjId = cfgTemplateObjEntity.getTemplateObjId();
        CfgTemplateObjMetadataExample cfgTemplateObjMetadataExample = new CfgTemplateObjMetadataExample();
        cfgTemplateObjMetadataExample.createCriteria().andBusinessObjIdEqualTo(busObjId);
        List cfgTemplateObjMetadataEntities = this.cfgTemplateObjMetadataDao.selectByExample(cfgTemplateObjMetadataExample);
        if (CollectionUtils.isEmpty((Collection)cfgTemplateObjMetadataEntities)) {
            return Lists.newArrayList();
        }
        return cfgTemplateObjMetadataEntities.stream().filter(Objects::nonNull).map(entry -> entry.getFieldName()).collect(Collectors.toList());
    }

    private void checkLimitAmt(MsConfigBean tmp, String value) {
        logger.info("checkLimitAmt--tmp:{} value:{}", (Object)tmp, (Object)value);
        if (StringUtils.isNotEmpty((CharSequence)tmp.getTaxInvoiceSource()) && TaxInvoiceSource.QD.getValue().equals(tmp.getTaxInvoiceSource())) {
            return;
        }
        if (!CommonTools.isEmpty((String)tmp.getSellerTaxNo()) && ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType().intValue() == tmp.getConfigType().intValue() && BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(tmp.getBusinessBillType())) {
            Long groupId = Optional.ofNullable(this.userInfoHolder.get()).map(UserInfo::getGroupId).orElse(1L);
            BigDecimal singleAmountLimit = this.getSingleAmountLimit(tmp, groupId);
            logger.info("\u7a0e\u68c0\u7684\u9650\u989d\u5927\u5c0f:{}", (Object)singleAmountLimit);
            boolean taxInclusive = tmp.getItemList().stream().filter(item -> "priceMethod".equalsIgnoreCase(item.getConfigItemName())).findFirst().map(item -> CollectionUtils.isNotEmpty((Collection)item.getConfigItemValue()) && item.getConfigItemValue().contains("1")).orElse(false);
            Tuple2 limit = null;
            if (singleAmountLimit != null) {
                limit = new Tuple2((Object)singleAmountLimit, (Object)"\u7a0e\u76d8");
            }
            if (limit != null) {
                this.checkLimit(tmp, taxInclusive, (String)limit._2, value, (BigDecimal)limit._1, taxInclusive ? ((BigDecimal)limit._1).multiply(new BigDecimal("1.13")) : (BigDecimal)limit._1);
            }
        }
    }

    private void checkLimit(MsConfigBean tmp, boolean taxInclusive, String company, String actualValue, BigDecimal limit, BigDecimal maxLimit) {
        if (InvoiceType.NORMAL.value().equals(tmp.getInvoiceType()) || InvoiceType.SPECIAL.value().equals(tmp.getInvoiceType()) || InvoiceType.ELECTRONIC.value().equals(tmp.getInvoiceType()) || InvoiceType.NORMAL_ROLL.value().equals(tmp.getInvoiceType()) || InvoiceType.SPECIAL_ELECTRONIC.value().equals(tmp.getInvoiceType())) {
            BigDecimal decimalValue = new BigDecimal(actualValue);
            if (decimalValue.compareTo(BigDecimal.ZERO) != 1) {
                logger.info("\u5f00\u7968\u9650\u989d\u53ea\u80fd\u5927\u4e8e0");
                throw new RuntimeException("\u5f00\u7968\u9650\u989d\u53ea\u80fd\u5927\u4e8e0");
            }
            if (decimalValue.compareTo(maxLimit) == 1) {
                StringBuilder msg = new StringBuilder("\u5f00\u7968\u9650\u989d\u4e0d\u80fd\u8d85\u8fc7\u5f53\u524d");
                msg.append(company).append("\u7684\u5f00\u7968\u9650\u989d\uff0c\u9650\u989d\u4e3a\u3010").append(limit.toPlainString());
                msg.append("\u3011\uff0c\u53ef\u652f\u6301\u7684\u6700\u5927");
                if (!taxInclusive) {
                    msg.append("\u4e0d");
                }
                msg.append("\u542b\u7a0e\u9650\u989d\u4e3a\u3010").append(maxLimit.toPlainString());
                msg.append("\u3011\uff0c\u5b9e\u9645\u4f20\u5165");
                if (!taxInclusive) {
                    msg.append("\u4e0d");
                }
                msg.append("\u542b\u7a0e\u9650\u989d\u4e3a\u3010").append(decimalValue.toPlainString()).append("\u3011");
                logger.info(msg.toString());
                throw new RuntimeException(msg.toString());
            }
        }
    }

    @Nullable
    public BigDecimal getSingleAmountLimit(MsConfigBean tmp, Long groupId) {
        Optional<QualificationInfo> qualificationInfo;
        Optional<Object> limitInfoOptional = Optional.empty();
        RestDeviceQualificationRequest request = RestDeviceQualificationRequest.builder().taxCodes(tmp.getSellerTaxNo()).build();
        logger.info("deviceApiProxy.getDeviceQualifications-params {},{}", (Object)JsonUtils.writeObjectToFastJson((Object)request), (Object)groupId);
        QueryDeviceQualificationsResponse deviceQualifications = this.deviceApiProxy.getDeviceQualifications(request, groupId);
        logger.info("deviceApiProxy.getDeviceQualifications-result {}", (Object)JsonUtils.writeObjectToFastJson((Object)deviceQualifications));
        if (deviceQualifications != null && "1".equals(deviceQualifications.getCode()) && (qualificationInfo = Optional.ofNullable(deviceQualifications.getResult()).map(o -> o.getQualificationList()).map(o -> o.stream().sorted(Comparator.comparing(QualificationInfo::getLastUpdatedAt).reversed()).findFirst()).orElse(Optional.empty())).isPresent()) {
            limitInfoOptional = qualificationInfo.map(o -> o.getLimitInfoList()).orElse(Lists.newArrayList()).stream().filter(limitInfo -> {
                String invoiceType = limitInfo.getInvoiceType();
                return tmp.getInvoiceType() != null && tmp.getInvoiceType().equals(invoiceType);
            }).findFirst();
        }
        BigDecimal singleAmountLimit = null;
        if (limitInfoOptional.isPresent()) {
            singleAmountLimit = ((LimitInfo)limitInfoOptional.get()).getSingleAmountLimit();
        }
        return singleAmountLimit;
    }

    private BigDecimal getQuota(BigDecimal quota, String context) {
        if (quota.compareTo(BigDecimal.ZERO) == 0) {
            String errorMessage = "\u5f53\u524d\u9500\u65b9\u516c\u53f8\uff0c" + context + "\u6ca1\u6709\u914d\u7f6e\u9650\u989d";
            logger.info(errorMessage);
            throw new RuntimeException(errorMessage);
        }
        return quota;
    }

    public List<CfgConfigEntity> querConfigList(MsConfigQueryRequest request) {
        CfgConfigExample example = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = example.createCriteria();
        criteria.andConfigTypeEqualTo(Byte.valueOf(request.getConfigType().byteValue()));
        criteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        criteria.andInvoiceTypeIn(request.getInvoiceType());
        criteria.andSellerTaxNoEqualTo(request.getSellerTaxNo());
        example.setLimit(Integer.valueOf(request.getPageSize() == null || request.getPageSize() == 0 ? 10 : request.getPageSize()));
        List cfgConfigEntities = this.cfgConfigDao.selectByExample(example);
        return cfgConfigEntities;
    }

    public List<MsConfigItemBean> queryConfigItemsByConfigs(MsConfigItemBatchQueryRequest request) {
        CfgConfigItemExample cfgConfigItemExample = new CfgConfigItemExample();
        CfgConfigItemExample.Criteria criteria = cfgConfigItemExample.createCriteria();
        ArrayList<MsConfigItemBean> result = new ArrayList<MsConfigItemBean>();
        if (CollectionUtils.isEmpty((Collection)request.getConfigIds())) {
            return result;
        }
        criteria.andConfigIdIn(request.getConfigIds());
        criteria.andConfigItemNameIn(request.getConfigItemName());
        List cfgConfigItemEntityList = this.cfgConfigItemDao.selectByExample(cfgConfigItemExample);
        for (CfgConfigItemEntity cfgConfigItemEntity : cfgConfigItemEntityList) {
            MsConfigItemBean msConfigItemBean = ConfigItemEntityTranslator.convertFromConfigItemEntity((CfgConfigItemEntity)cfgConfigItemEntity);
            result.add(msConfigItemBean);
        }
        return result;
    }

    public int updateConfigItems(List<MsConfigItemBean> items) {
        int count = 0;
        for (MsConfigItemBean bean : items) {
            CfgConfigItemEntity itemEntity = new CfgConfigItemEntity();
            itemEntity.setConfigItemId(bean.getConfigItemId());
            itemEntity.setConfigItemValue(JsonUtils.writeObjectToFastJson((Object)bean.getConfigItemValue()));
            itemEntity.setUpdateTime(new Date());
            count += this.cfgConfigItemDao.updateByPrimaryKeySelective(itemEntity);
        }
        return count;
    }

    public MsConfigMailRuleResponse pullMailRuleConfig(Long configId) {
        MsConfigMailRuleResponse response2 = MsConfigMailRuleResponse.builder().build();
        response2.setCode(BaseResponse.OK);
        List entities = this.queryMailRuleConfig(configId);
        if (entities.size() == 0) {
            response2.setResult(null);
            return response2;
        }
        if (entities.size() > 1) {
            logger.warn("@pullMailRuleConfig multiple mail rules found, expect 1, found " + entities.size());
        }
        CfgConfigMailRuleEntity entity = (CfgConfigMailRuleEntity)entities.get(0);
        MsConfigMailRule rule = new MsConfigMailRule();
        BeanMapper.copy((Object)entity, (Object)rule);
        rule.setConfigMailRuleId(entity.getId());
        rule.setPickUCAddress(entity.getPickUcAddress().booleanValue());
        response2.setResult(rule);
        return response2;
    }

    private List<CfgConfigMailRuleEntity> queryMailRuleConfig(Long configId) {
        CfgConfigMailRuleExample example = new CfgConfigMailRuleExample();
        example.createCriteria().andConfigIdEqualTo(configId).andStatusEqualTo(ConstantValue.STATUS_ACTIVE);
        return this.cfgConfigMailRuleDao.selectByExample(example);
    }

    public Response getOptimalMatchConfigNullable(MsConfigQueryRequest msConfigQueryRequest) {
        logger.info("@getOptimalMatchConfigNullable \u83b7\u53d6\u53d1\u7968\u5339\u914d\u89c4\u5219\uff0c\u8bf7\u6c42\u53c2\u6570:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigQueryRequest));
        if (null != msConfigQueryRequest && null == msConfigQueryRequest.getStatus()) {
            msConfigQueryRequest.setStatus(Integer.valueOf(1));
        }
        Response response2 = new Response();
        List settingCfgConfigEntityList = this.queryMatchedSettingConfigList(msConfigQueryRequest);
        logger.info("getOptimalMatchConfigNullable---cfgConfigEntityList:{}", (Object)JsonUtils.writeObjectToFastJson((Object)settingCfgConfigEntityList));
        if (CollectionUtils.isEmpty((Collection)settingCfgConfigEntityList)) {
            response2.setCode(Response.Fail);
            response2.setResult(null);
        }
        MsConfigBean msConfigBean = ConfigEntityTranslater.convertFromMsConfigQueryRequest((MsConfigQueryRequest)msConfigQueryRequest);
        List settingMsConfigBeanList = settingCfgConfigEntityList.stream().map(item -> this.getMsConfigBean(item)).collect(Collectors.toList());
        MsConfigBean bestMsConfigBean = this.configMatchParserImpl.getBestMatchConfig(settingMsConfigBeanList, msConfigBean);
        logger.info("getOptimalMatchConfig---bestMsConfigBean:{}", (Object)JsonUtils.writeObjectToFastJson((Object)bestMsConfigBean));
        if (null == bestMsConfigBean) {
            CfgConfigEntity defaultCfgConfigEntity = this.queryDefaultConfig(msConfigQueryRequest);
            MsConfigBean defaultMsConfigBean = ConfigEntityTranslater.convertFromConfigEntity((CfgConfigEntity)defaultCfgConfigEntity);
            logger.info("getOptimalMatchConfig---match--failed--defaultMsConfigBean:{}", (Object)JsonUtils.writeObjectToFastJson((Object)defaultMsConfigBean));
            return this.fillConfigItems(defaultMsConfigBean);
        }
        return this.fillConfigItems(bestMsConfigBean);
    }

    public Response getOptimalMatchConfigWithAttrOfEmail(MsConfigQueryRequest msConfigQueryRequest) {
        logger.info("\u83b7\u53d6\u53d1\u7968\u5339\u914d\u89c4\u5219\uff0c\u8bf7\u6c42\u53c2\u6570:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigQueryRequest));
        if (null != msConfigQueryRequest && null == msConfigQueryRequest.getStatus()) {
            msConfigQueryRequest.setStatus(Integer.valueOf(1));
        }
        List settingCfgConfigEntityList = this.querySettingConfigList(msConfigQueryRequest);
        logger.info("getOptimalMatchConfigWithAttrOfEmail---cfgConfigEntityList:{}", (Object)JsonUtils.writeObjectToFastJson((Object)settingCfgConfigEntityList));
        if (CollectionUtils.isEmpty((Collection)settingCfgConfigEntityList)) {
            logger.warn("getOptimalMatchConfigWithAttrOfEmail \u672a\u5339\u914d\u5230\u90ae\u4ef6\u89c4\u5219, \u8fd4\u56de\u9ed8\u8ba4\u89c4\u5219");
            return this.getMailConfigResponse(null, msConfigQueryRequest.getInvoiceType());
        }
        MsConfigBean msConfigBean = ConfigEntityTranslater.convertFromMsConfigQueryRequest((MsConfigQueryRequest)msConfigQueryRequest);
        List settingMsConfigBeanList = settingCfgConfigEntityList.stream().map(item -> this.getMsConfigBean(item)).collect(Collectors.toList());
        MsConfigBean bestMsConfigBean = this.configMatchParserImpl.getBestMatchConfig(settingMsConfigBeanList, msConfigBean);
        logger.info("getOptimalMatchConfig---bestMsConfigBean:{}", (Object)JsonUtils.writeObjectToFastJson((Object)bestMsConfigBean));
        if (null == bestMsConfigBean) {
            logger.warn("getOptimalMatchConfigWithAttrOfEmail bestMsConfigBean\u4e3a\u7a7a, \u8fd4\u56de\u9ed8\u8ba4\u89c4\u5219");
            return this.getMailConfigResponse(null, msConfigQueryRequest.getInvoiceType());
        }
        return this.getMailConfigResponse(bestMsConfigBean.getConfigId(), msConfigQueryRequest.getInvoiceType());
    }

    private Response getMailConfigResponse(Long configId, List<String> invoiceType) {
        EmailConfigEntity entity = new EmailConfigEntity();
        if (null == configId) {
            CommonTools.setValue(arg_0 -> ((EmailConfigEntity)entity).setAutosend(arg_0), (Object)true);
            CommonTools.setValue(arg_0 -> ((EmailConfigEntity)entity).setPickBizBillAddress(arg_0), (Object)true);
            CommonTools.setValue(arg_0 -> ((EmailConfigEntity)entity).setUseCustomAddress(arg_0), (Object)false);
            CommonTools.setValue(arg_0 -> ((EmailConfigEntity)entity).setPickUcAddress(arg_0), (Object)false);
            entity.setAutosend(Boolean.valueOf(true));
            if (invoiceType != null && invoiceType.size() != 0 && InvoiceType.SPECIAL_ELECTRONIC.value().equals(invoiceType.get(0))) {
                entity.setAutosend(Boolean.valueOf(false));
            }
        } else {
            CfgConfigMailRuleExample example = new CfgConfigMailRuleExample();
            example.createCriteria().andConfigIdEqualTo(configId).andStatusEqualTo(Integer.valueOf(1));
            CfgConfigMailRuleEntity mailRule = this.cfgConfigMailRuleDao.selectOneByExample(example);
            if (mailRule == null) {
                CommonTools.setValue(arg_0 -> ((EmailConfigEntity)entity).setAutosend(arg_0), (Object)true);
                CommonTools.setValue(arg_0 -> ((EmailConfigEntity)entity).setPickBizBillAddress(arg_0), (Object)true);
                CommonTools.setValue(arg_0 -> ((EmailConfigEntity)entity).setUseCustomAddress(arg_0), (Object)false);
                CommonTools.setValue(arg_0 -> ((EmailConfigEntity)entity).setPickUcAddress(arg_0), (Object)false);
            } else {
                BeanUtils.copyProperties((Object)mailRule, (Object)entity);
                if (mailRule.getUseCustomAddress().booleanValue()) {
                    entity.setCustomMails((List)Lists.newArrayList((Object[])mailRule.getCustomMailList().split(";")));
                }
            }
        }
        logger.info("getOptimalMatchConfigWithAttrOfEmail---getMailConfigResponse:{}", (Object)JsonUtils.writeObjectToFastJson((Object)entity));
        Response response2 = new Response();
        response2.setResult((Object)JsonUtils.writeObjectToFastJson((Object)entity));
        response2.setCode(Response.OK);
        return response2;
    }

    public Response getSelfConfig(ConfigApiModel request) {
        int count = this.cfgConfigExtDao.selectConfigItem(request);
        if (count > 0) {
            return Response.ok((String)"\u5b58\u5728");
        }
        return Response.failed((String)"\u4e0d\u5b58\u5728");
    }

    private List<CfgConfigEntity> getRuleList(MsConfigQueryRequest request, String orderByClause) {
        CfgConfigExample example = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = this.getCommonCriteria(request, example);
        Optional.ofNullable(request.getSellerGroupId()).ifPresent(r -> criteria.andSellerGroupIdIn((List)Lists.newArrayList((Object[])new Long[]{0L, request.getSellerGroupId()})));
        Optional.ofNullable(request.getPurchaserGroupId()).ifPresent(r -> criteria.andPurchaserGroupIdIn((List)Lists.newArrayList((Object[])new Long[]{0L, request.getPurchaserGroupId()})));
        criteria.andSellerTaxNoIn((List)(StringUtils.isBlank((CharSequence)request.getSellerTaxNo()) ? Lists.newArrayList((Object[])new String[]{""}) : Lists.newArrayList((Object[])new String[]{"", request.getSellerTaxNo()}))).andPurchaserTaxNoIn((List)(StringUtils.isBlank((CharSequence)request.getPurchaserTaxNo()) ? Lists.newArrayList((Object[])new String[]{""}) : Lists.newArrayList((Object[])new String[]{"", request.getPurchaserTaxNo()})));
        example.setOrderByClause(orderByClause);
        return this.cfgConfigDao.selectByExample(example);
    }

    public int updateIssueUserInfo(CfgIssueUserInfoEntity entity) {
        return this.cfgIssueUserInfoDao.updateByPrimaryKeySelective(entity);
    }

    public int addIssueUserInfo(CfgIssueUserInfoEntity entity) {
        return this.cfgIssueUserInfoDao.insert(entity);
    }

    public List<MsConfigItemBean> querySellerIssueInfo(Long groupId, String sellerTaxNo, Long sysOrgId, String salesbillType, Integer configType) {
        CfgConfigExample query2 = new CfgConfigExample();
        query2.createCriteria().andSellerGroupIdEqualTo(groupId).andSellerTaxNoEqualTo(sellerTaxNo).andSysOrgIdEqualTo(sysOrgId).andConfigTypeEqualTo(Byte.valueOf(configType.byteValue())).andSalesbillTypeEqualTo(salesbillType).andBusinessBillTypeEqualTo("AR").andPurchaserGroupIdEqualTo(Long.valueOf(0L)).andPurchaserTaxNoEqualTo("").andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        CfgConfigEntity config = this.cfgConfigDao.selectOneByExample(query2);
        if (null == config) {
            return null;
        }
        MsConfigItemQueryRequest cfgConfigItemRequest = new MsConfigItemQueryRequest();
        cfgConfigItemRequest.setConfigId(String.valueOf(config.getConfigId()));
        return this.queryConfigItemList(cfgConfigItemRequest);
    }

    public CfgIssueUserInfoEntity queryOwnerIssueInfo(Long groupId, String sellerTaxNo, Long userId, Long sysOrgId) {
        CfgIssueUserInfoExample query2 = new CfgIssueUserInfoExample();
        query2.createCriteria().andGroupIdEqualTo(groupId).andCompanyTaxNoEqualTo(sellerTaxNo).andUserIdEqualTo(userId).andSysOrgIdEqualTo(sysOrgId);
        return this.cfgIssueUserInfoDao.selectOneByExample(query2);
    }

    public Response<List<MsConfigBean>> queryConfigRuleItemListByItemName(MsConfigQueryRequestWithUserInfo msConfigQueryRequestWithUserInfo) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{msConfigQueryRequestWithUserInfo.getItemFiledName(), msConfigQueryRequestWithUserInfo.getItemFiledValue()})) {
            return Response.failed((String)"\u914d\u7f6e\u540d\u79f0\u548c\u503c\u5747\u4e3a\u5fc5\u586b\u9879");
        }
        if (msConfigQueryRequestWithUserInfo.getSellerGroupId() == null) {
            return Response.failed((String)"\u9500\u65b9\u79df\u6237id\u5fc5\u586b\u9879");
        }
        List list = this.cfgConfigExtDao.queryConfigRuleItemListByItemName(msConfigQueryRequestWithUserInfo);
        List result = list.stream().map(ConfigEntityTranslater::convertFromConfigEntity).collect(Collectors.toList());
        return Response.from((Integer)Response.OK, (String)"\u67e5\u8be2\u6210\u529f", result);
    }

    private List<MsConfigItemTempBean> modifySplitRuleForQd(List<MsConfigItemTempBean> msConfigItemBeans) {
        boolean existsSaleListOption = msConfigItemBeans.stream().anyMatch(i -> "saleListOption".equals(i.getConfigItemName()));
        if (existsSaleListOption) {
            msConfigItemBeans.removeAll(msConfigItemBeans.stream().filter(i -> "saleListOption".equals(i.getConfigItemName())).collect(Collectors.toList()));
        }
        MsConfigItemTempBean saleListOption = new MsConfigItemTempBean();
        saleListOption.setConfigItemName("saleListOption");
        saleListOption.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{SalesListPrintEnum.PRINT_SALES_LIST.getSalesListOpt()}));
        msConfigItemBeans.add(saleListOption);
        return msConfigItemBeans;
    }

    public MsResponse<List<MsConfigBean>> getConfigByTenantId(MsConfigQueryRequest msConfigQueryRequest) {
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = cfgConfigExample.createCriteria();
        criteria.andSalesbillTypeEqualTo(msConfigQueryRequest.getSalesbillType()).andBusinessBillTypeEqualTo(msConfigQueryRequest.getBusinessBillType()).andConfigTypeEqualTo(Byte.valueOf(msConfigQueryRequest.getConfigType().byteValue())).andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        if (BusinessBillType.AR.value().equals(msConfigQueryRequest.getSalesbillType())) {
            criteria.andSellerGroupIdEqualTo(msConfigQueryRequest.getSellerGroupId());
        } else if (BusinessBillType.AP.value().equals(msConfigQueryRequest.getSalesbillType())) {
            criteria.andPurchaserGroupIdEqualTo(msConfigQueryRequest.getPurchaserGroupId());
        }
        List cfgConfigEntities = this.cfgConfigDao.selectByExample(cfgConfigExample);
        List configBeans = cfgConfigEntities.stream().map(it -> {
            MsConfigBean msConfigBean = new MsConfigBean();
            msConfigBean.setSellerTaxNo(it.getSellerTaxNo());
            msConfigBean.setPurchaserTaxNo(it.getPurchaserTaxNo());
            return msConfigBean;
        }).collect(Collectors.toList());
        return MsResponse.ok(configBeans);
    }

    public Either<String, List<MsConfigItemBean>> getAllInOneConfigItemList(MsConfigQueryRequest msConfigQueryRequest) {
        List configList = this.queryAllInOneConfig(msConfigQueryRequest);
        if (CollectionUtils.isEmpty((Collection)configList)) {
            return Either.right(Collections.emptyList());
        }
        Optional<CfgConfigEntity> configOptional = configList.stream().filter(r -> StringUtils.equals((CharSequence)r.getConfigName(), (CharSequence)(msConfigQueryRequest.getConfigType().intValue() == ConfigTypeEnum.INVOICE_USER_CONFIG_TYPE.getConfigType().intValue() ? "\u5343\u725b\u6e20\u9053\u7968\u9762\u4eba\u5458" : "\u5343\u725b\u6e20\u9053\u5f00\u7968\u62ac\u5934"))).findFirst();
        if (configOptional.isPresent()) {
            return Either.right((Object)this.queryConfigItemList(configOptional.get()));
        }
        if (configList.size() > 1) {
            return Either.right(Collections.emptyList());
        }
        return Either.right((Object)this.queryConfigItemList((CfgConfigEntity)configList.get(0)));
    }

    private List<CfgConfigEntity> queryAllInOneConfig(MsConfigQueryRequest msConfigQueryRequest) {
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = cfgConfigExample.createCriteria();
        criteria.andSellerGroupIdEqualTo(msConfigQueryRequest.getSellerGroupId());
        criteria.andSellerTaxNoEqualTo(msConfigQueryRequest.getSellerTaxNo());
        criteria.andConfigTypeEqualTo(Byte.valueOf(msConfigQueryRequest.getConfigType().byteValue()));
        criteria.andPurchaserGroupIdEqualTo(msConfigQueryRequest.getPurchaserGroupId());
        criteria.andPurchaserTaxNoEqualTo(msConfigQueryRequest.getPurchaserTaxNo());
        criteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        return this.cfgConfigDao.selectByExample(cfgConfigExample);
    }

    private List<MsConfigItemBean> queryConfigItemList(CfgConfigEntity config) {
        MsConfigItemQueryRequest request = new MsConfigItemQueryRequest();
        request.setConfigId(String.valueOf(config.getConfigId()));
        List configItemList = this.queryConfigItemList(request);
        this.buildQDConfigItem(config.getConfigType(), config.getTaxInvoiceSource(), config.getConfigId()).ifPresent(configItemList::add);
        return configItemList;
    }

    public int updateConfigItemValue(Long configItemId, String configItemValue) {
        CfgConfigItemEntity update2 = new CfgConfigItemEntity();
        update2.setConfigItemId(configItemId);
        update2.setConfigItemValue(configItemValue);
        return this.cfgConfigItemDao.updateByPrimaryKeySelective(update2);
    }

    public Either<String, List<Long>> queryConfigItemIdList(List<String> salesbillTypeList, Integer configType, Long sellerGroupId) {
        if (CollectionUtils.isEmpty(salesbillTypeList)) {
            return Either.left((Object)"\u5355\u636e\u7c7b\u578b\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List configIdList = this.cfgConfigDataService.queryFieldsByCondition(criteria -> criteria.andSalesbillTypeIn(salesbillTypeList).andConfigTypeEqualTo(Byte.valueOf(configType.byteValue())).andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue())).andSellerGroupIdEqualTo(sellerGroupId), (List)Lists.newArrayList((Object[])new String[]{"config_id"}), CfgConfigEntity::getConfigId);
        if (CollectionUtils.isEmpty((Collection)configIdList)) {
            return Either.left((Object)"\u672a\u67e5\u8be2\u5230\u9500\u9879\u4e1a\u52a1\u89c4\u5219,\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u5165\u4f4f.");
        }
        List configItemList = this.cfgConfigDataService.queryItemByConfigIdList(configIdList, "taxInvoiceSource");
        if (CollectionUtils.isEmpty((Collection)configItemList) || configItemList.size() != configIdList.size()) {
            return Either.left((Object)"\u5b58\u5728\u56fd\u7a0e\u6765\u6e90\u914d\u7f6e\u9879\u4e3a\u7a7a\u4e1a\u52a1\u89c4\u5219, \u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u5165\u4f4f.");
        }
        return Either.right(configItemList.stream().map(CfgConfigItemEntity::getConfigItemId).collect(Collectors.toList()));
    }

    public int batchUpdateConfigItemValue(List<Long> cfgItemIdList, String configItemValue) {
        CfgConfigItemEntity update2 = new CfgConfigItemEntity();
        update2.setConfigItemValue(configItemValue);
        CfgConfigItemExample updateExample = new CfgConfigItemExample();
        updateExample.createCriteria().andConfigItemIdIn(cfgItemIdList);
        return this.cfgConfigItemDao.updateByExampleSelective(update2, updateExample);
    }

    public Either<String, Boolean> getAllowAddIssuerConfig(MsConfigQueryRequest msConfigQueryRequest) {
        logger.info("getAllowAddIssuerConfig request:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigQueryRequest));
        Long groupId = Optional.ofNullable(this.userInfoHolder.get()).map(UserInfo::getGroupId).orElse(-1L);
        String businessBillType = Optional.ofNullable(msConfigQueryRequest.getBusinessBillType()).orElse(BusinessBillType.AR.value());
        msConfigQueryRequest.setBusinessBillType(businessBillType);
        msConfigQueryRequest.setSellerGroupId(groupId);
        Optional strOptional = this.checkQueryParam(msConfigQueryRequest);
        if (strOptional.isPresent()) {
            return Either.left(strOptional.get());
        }
        List configList = this.querySystemConfigList(msConfigQueryRequest);
        if (CollectionUtils.isEmpty((Collection)configList)) {
            return Either.right((Object)true);
        }
        List itemList = this.querySystemConfigItemList(configList.stream().map(CfgConfigEntity::getConfigId).distinct().collect(Collectors.toList()));
        Map<Long, CfgConfigItemEntity> itemMap = itemList.stream().filter(item -> StringUtils.equals((CharSequence)item.getConfigItemName(), (CharSequence)"allowAddIssuer")).collect(Collectors.toMap(CfgConfigItemEntity::getConfigId, r -> r, (a, b) -> a));
        if (itemMap.isEmpty()) {
            return Either.right((Object)true);
        }
        HashSet booleanSet = Sets.newHashSet();
        for (CfgConfigEntity config : configList) {
            if (booleanSet.size() > 1) break;
            CfgConfigItemEntity item2 = itemMap.getOrDefault(config.getConfigId(), null);
            if (null == item2) {
                booleanSet.add(true);
                continue;
            }
            booleanSet.add(item2.getConfigItemValue() != null && (Boolean)JSON.parseArray((String)item2.getConfigItemValue(), Boolean.class).get(0) != false);
        }
        if (booleanSet.size() == 1 && booleanSet.contains(true)) {
            return Either.right((Object)true);
        }
        return Either.right((Object)false);
    }

    private Optional<String> checkQueryParam(MsConfigQueryRequest msConfigQueryRequest) {
        if (!StringUtils.equalsAnyIgnoreCase((CharSequence)msConfigQueryRequest.getBusinessBillType(), (CharSequence[])new CharSequence[]{BusinessBillType.AR.value(), BusinessBillType.AP.value()})) {
            return Optional.of("\u53c2\u6570BusinessBillType\u503c\u53ea\u80fd\u662f\u3010AR\u3001AP\u3011\u4e0d\u4f20\u9ed8\u8ba4\u4e3a\u7a7a\u5b57\u7b26\u4e32");
        }
        if (StringUtils.isBlank((CharSequence)msConfigQueryRequest.getSellerTaxNo())) {
            return Optional.of("\u53c2\u6570SellerTaxNo\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (msConfigQueryRequest.getSellerGroupId() <= 0L) {
            return Optional.of("\u79df\u6237Id\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u64cd\u4f5c");
        }
        return Optional.empty();
    }

    private List<CfgConfigEntity> querySystemConfigList(MsConfigQueryRequest msConfigQueryRequest) {
        CfgConfigExample configExample = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = configExample.createCriteria();
        criteria.andSellerGroupIdEqualTo(msConfigQueryRequest.getSellerGroupId());
        criteria.andSellerTaxNoEqualTo(msConfigQueryRequest.getSellerTaxNo());
        criteria.andConfigTypeEqualTo(Byte.valueOf(ConfigTypeEnum.SYS_CONFIG_TYPE.getConfigType().byteValue()));
        criteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        criteria.andBusinessBillTypeEqualTo(msConfigQueryRequest.getBusinessBillType());
        return this.cfgConfigDao.selectByExample(configExample);
    }

    private List<CfgConfigItemEntity> querySystemConfigItemList(List<Long> configIdList) {
        if (CollectionUtils.isEmpty(configIdList)) {
            return Lists.newArrayList();
        }
        CfgConfigItemExample configItemExample = new CfgConfigItemExample();
        CfgConfigItemExample.Criteria criteria = configItemExample.createCriteria();
        criteria.andConfigIdIn(configIdList);
        return this.cfgConfigItemDao.selectByExample(configItemExample);
    }
}

