/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.phoenix.infrastructure.usercenter.model.CompanyData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.CompanyQueryParam;
import com.xforceplus.phoenix.infrastructure.usercenter.model.OrgAndCompanyData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.OrgData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.OrgQueryParam;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserCenterList;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserCenterResponse;
import com.xforceplus.phoenix.infrastructure.usercenter.services.UserCenterCompanyService;
import com.xforceplus.phoenix.infrastructure.usercenter.services.UserCenterOrgService;
import com.xforceplus.seller.config.client.model.AddCompanyRequest;
import com.xforceplus.seller.config.client.model.CompanyPageQueryRequest;
import com.xforceplus.seller.config.client.model.ConfigCompanyModel;
import com.xforceplus.seller.config.client.model.ConfigCompanyQueryRequest;
import com.xforceplus.seller.config.client.model.ConfigCompanyQueryResponse;
import com.xforceplus.seller.config.client.model.CreateCompanyInfoRequest;
import com.xforceplus.seller.config.client.model.DeleteCompanyInfoRequest;
import com.xforceplus.seller.config.client.model.MsEnumBean;
import com.xforceplus.seller.config.client.model.Page;
import com.xforceplus.seller.config.client.model.QueryStoreListRequest;
import com.xforceplus.seller.config.client.model.StoreData;
import com.xforceplus.seller.config.client.model.UpdateCompanyInfoRequest;
import com.xforceplus.seller.config.models.PurchaserCompanyQueryRequest;
import com.xforceplus.seller.config.models.PurchaserCompanyResponse;
import com.xforceplus.seller.config.repository.dao.CfgCompanyDao;
import com.xforceplus.seller.config.repository.dao.CompanyInfoDao;
import com.xforceplus.seller.config.repository.daoext.CfgConfigExtDao;
import com.xforceplus.seller.config.repository.model.CfgCompanyEntity;
import com.xforceplus.seller.config.repository.model.CfgCompanyExample;
import com.xforceplus.seller.config.repository.model.CompanyInfoEntity;
import com.xforceplus.seller.config.repository.model.CompanyInfoExample;
import com.xforceplus.seller.config.util.CommonTools;
import com.xforceplus.seller.enums.OrgType;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import io.geewit.web.utils.JsonUtils;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ConfigCompanyService {
    private static final Logger logger = LoggerFactory.getLogger(ConfigCompanyService.class);
    private final IDGenerator idGenerator;
    private final CfgCompanyDao cfgCompanyDao;
    private final CompanyInfoDao companyInfoDao;
    private final UserInfoHolder<UserInfo> userInfoHolder;
    private final UserCenterOrgService userCenterOrgService;
    private final UserCenterCompanyService userCenterCompanyService;
    private final CfgConfigExtDao cfgConfigExtDao;
    private static final String SPLIT = "\\\\n| |\\\\t|\n|\t|,";
    @Value(value="#{'${company.left.like.query.tenant-id:0}'.split(',')}")
    private List<Long> leftTenantIds;

    public ConfigCompanyService(IDGenerator idGenerator, CfgCompanyDao cfgCompanyDao, CompanyInfoDao companyInfoDao, UserInfoHolder<UserInfo> userInfoHolder, UserCenterOrgService userCenterOrgService, UserCenterCompanyService userCenterCompanyService, CfgConfigExtDao cfgConfigExtDao) {
        this.idGenerator = idGenerator;
        this.cfgCompanyDao = cfgCompanyDao;
        this.companyInfoDao = companyInfoDao;
        this.userInfoHolder = userInfoHolder;
        this.userCenterOrgService = userCenterOrgService;
        this.userCenterCompanyService = userCenterCompanyService;
        this.cfgConfigExtDao = cfgConfigExtDao;
    }

    public Response addCompany(AddCompanyRequest request) {
        CfgCompanyExample cfgCompanyExample = new CfgCompanyExample();
        cfgCompanyExample.createCriteria().andCompanyTaxNoEqualTo(request.getCompanyTaxNo()).andGroupIdEqualTo(request.getGroupId()).andCompanyNameEqualTo(request.getCompanyName());
        List cfgCompanyEntities = this.cfgCompanyDao.selectByExample(cfgCompanyExample);
        if (CollectionUtils.isEmpty((Collection)cfgCompanyEntities)) {
            CfgCompanyEntity cfgCompanyEntity = new CfgCompanyEntity();
            cfgCompanyEntity.setCompanyId(Long.valueOf(this.idGenerator.nextId()));
            cfgCompanyEntity.setCompanyName(request.getCompanyName());
            cfgCompanyEntity.setCompanyNo(CommonTools.isEmpty((String)request.getCompanyNo()) ? "" : request.getCompanyNo());
            cfgCompanyEntity.setCompanyTaxNo(request.getCompanyTaxNo());
            cfgCompanyEntity.setUserId(request.getUserId());
            cfgCompanyEntity.setGroupId(request.getGroupId());
            cfgCompanyEntity.setStatus(Byte.valueOf((byte)1));
            cfgCompanyEntity.setDeleteToken("");
            cfgCompanyEntity.setCreateTime(new Date());
            this.cfgCompanyDao.insert(cfgCompanyEntity);
        }
        return Response.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }

    public PurchaserCompanyResponse queryPurchaserCompany(PurchaserCompanyQueryRequest request) {
        Long groupId = request.getGroupId();
        if (groupId == null || groupId == 0L) {
            groupId = ((UserInfo)this.userInfoHolder.get()).getGroupId();
        }
        ConfigCompanyQueryRequest query2 = new ConfigCompanyQueryRequest();
        query2.setGroupId(groupId);
        query2.setKeyword(request.getKeyWord());
        ConfigCompanyQueryResponse queryResponse = this.queryConfigCompany(query2);
        List list = queryResponse.getList();
        List<Object> dtoList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (ConfigCompanyModel model : list) {
                MsEnumBean dto = new MsEnumBean();
                dto.setText(model.getCompanyName());
                dto.setValue(model.getCompanyName());
                dtoList.add(dto);
            }
        }
        CompanyQueryParam param = new CompanyQueryParam();
        param.setCompanyName(request.getKeyWord());
        UserCenterResponse reply2 = this.userCenterCompanyService.getCompanyByParam(groupId.longValue(), param);
        logger.info("\u7528\u6237\u4e2d\u5fc3\u67e5\u8be2\u8d2d\u65b9\u516c\u53f8\uff1a{} keyword:{} request:{}", new Object[]{JSONObject.toJSONString((Object)reply2), request.getKeyWord(), JSONObject.toJSONString((Object)param)});
        logger.info("CompanyData:{}", (Object)reply2);
        dtoList.addAll(Optional.ofNullable(reply2.getResult()).map(UserCenterList::getContent).map(data -> data.stream().map(r -> {
            MsEnumBean dto = new MsEnumBean();
            dto.setText(r.getCompanyName());
            dto.setValue(r.getCompanyName());
            return dto;
        }).collect(Collectors.toList())).orElse(Lists.newArrayList()));
        logger.info("\u67e5\u8be2\u8d2d\u65b9\u516c\u53f8\u5408\u5e76\u524d\u7684\u7ed3\u679c", (Object)JSONObject.toJSONString((Object)dtoList));
        dtoList = new ArrayList<MsEnumBean>(Sets.newHashSet((Iterable)dtoList));
        if (dtoList.size() > 50) {
            dtoList = dtoList.subList(0, 50);
        }
        PurchaserCompanyResponse reponse = new PurchaserCompanyResponse();
        reponse.setCode(Integer.valueOf(queryResponse.getCode()));
        reponse.setMessage(queryResponse.getMessage());
        reponse.setResult(dtoList);
        return reponse;
    }

    public ConfigCompanyQueryResponse queryConfigCompany(ConfigCompanyQueryRequest request) {
        Long groupId = request.getGroupId();
        String keyword = request.getKeyword();
        if (CommonTools.isEmpty((String)keyword)) {
            ConfigCompanyQueryResponse configCompanyQueryResponse = new ConfigCompanyQueryResponse();
            configCompanyQueryResponse.setCode(1);
            configCompanyQueryResponse.setMessage("\u67e5\u8be2\u6210\u529f");
            configCompanyQueryResponse.setList((List)Lists.newArrayList());
            return configCompanyQueryResponse;
        }
        logger.info("\u8d2d\u65b9\u516c\u53f8\u67e5\u8be2\u6761\u4ef6-byName groupId\uff1a{} keyword\uff1a{}", (Object)groupId, (Object)keyword);
        CfgCompanyExample cfgCompanyExample = new CfgCompanyExample();
        CfgCompanyExample.Criteria criteria = cfgCompanyExample.createCriteria();
        if (groupId != 0L) {
            criteria.andGroupIdEqualTo(groupId);
        }
        if (!CommonTools.isEmpty((String)keyword)) {
            if (this.leftTenantIds.contains(groupId)) {
                criteria.andCompanyNameLike("%" + keyword + "%");
            } else {
                criteria.andCompanyNameLike(keyword + "%");
            }
        }
        cfgCompanyExample.setLimit(Integer.valueOf(10));
        List cfgCompanyEntities = this.cfgCompanyDao.selectByExample(cfgCompanyExample);
        if (CollectionUtils.isEmpty((Collection)cfgCompanyEntities) && !CommonTools.checkContainChineseValue((String)keyword)) {
            CfgCompanyExample taxCfgCompanyExample = new CfgCompanyExample();
            CfgCompanyExample.Criteria taxNoCriteria = taxCfgCompanyExample.createCriteria();
            if (groupId != 0L) {
                taxNoCriteria.andGroupIdEqualTo(groupId);
            }
            if (!CommonTools.isEmpty((String)keyword)) {
                if (this.leftTenantIds.contains(groupId)) {
                    taxNoCriteria.andCompanyTaxNoLike("%" + keyword + "%");
                } else {
                    taxNoCriteria.andCompanyTaxNoLike(keyword + "%");
                }
            }
            taxCfgCompanyExample.setLimit(Integer.valueOf(10));
            logger.info("\u8d2d\u65b9\u516c\u53f8\u67e5\u8be2\u6761\u4ef6-byTaxNo groupId\uff1a{} keyword\uff1a{}", (Object)groupId, (Object)keyword);
            cfgCompanyEntities = this.cfgCompanyDao.selectByExample(taxCfgCompanyExample);
        }
        ArrayList listModel = Lists.newArrayList();
        cfgCompanyEntities.stream().forEach(item -> {
            ConfigCompanyModel configCompanyModel = new ConfigCompanyModel();
            BeanUtils.copyProperties((Object)item, (Object)configCompanyModel);
            listModel.add(configCompanyModel);
        });
        ConfigCompanyQueryResponse configCompanyQueryResponse = new ConfigCompanyQueryResponse();
        configCompanyQueryResponse.setCode(1);
        configCompanyQueryResponse.setMessage("\u67e5\u8be2\u6210\u529f");
        configCompanyQueryResponse.setList((List)listModel);
        return configCompanyQueryResponse;
    }

    public Tuple2<Long, List<StoreData>> queryStores(QueryStoreListRequest request) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        long groupId = userInfo.getGroupId();
        Optional orgQueryParamOptional = this.dealParamForOrgQuery(request, userInfo);
        if (!orgQueryParamOptional.isPresent()) {
            return Tuple.of((Object)0L, (Object)Lists.newArrayList());
        }
        OrgQueryParam param = (OrgQueryParam)orgQueryParamOptional.get();
        UserCenterResponse userDataResponse = this.userCenterOrgService.getPageOrgByParams(groupId, param);
        if ("1".equals(userDataResponse.getCode()) && Objects.nonNull(userDataResponse.getResult())) {
            int total = ((UserCenterList)userDataResponse.getResult()).getTotalElements();
            ArrayList orgList = Lists.newArrayList((Iterable)((UserCenterList)userDataResponse.getResult()).getContent());
            Long companyId = request.getCompanyId();
            if (Objects.nonNull(companyId) && companyId > 0L) {
                OrgQueryParam companyQuery = new OrgQueryParam();
                companyQuery.setCompanyId(companyId);
                companyQuery.setUserId(Long.valueOf(userInfo.getUserId()));
                UserCenterResponse companyOrgResponse = this.userCenterOrgService.getOrgByParams(groupId, companyQuery);
                if (Objects.nonNull(companyOrgResponse.getResult()) && CollectionUtils.isNotEmpty((Collection)((UserCenterList)companyOrgResponse.getResult()).getContent())) {
                    OrgData companyOrg = (OrgData)((UserCenterList)companyOrgResponse.getResult()).getContent().get(0);
                    if (StringUtils.isBlank((CharSequence)request.getStoreName()) || Optional.ofNullable(companyOrg.getOrgName()).orElse("").contains(request.getStoreName())) {
                        ++total;
                        orgList.add(companyOrg);
                    }
                }
            }
            Map<Long, OrgData> orgMap = orgList.stream().collect(Collectors.toMap(OrgData::getOrgId, r -> r));
            List storeDataList = orgList.stream().filter(r -> !OrgType.Group.value().equals(r.getOrgType())).map(r -> {
                StoreData storeData = new StoreData();
                storeData.setStoreName(r.getOrgName());
                storeData.setOrgId(r.getOrgId());
                storeData.setOrgType(r.getOrgType());
                storeData.setOrgCode(r.getOrgCode());
                if (OrgType.Company.value().equals(r.getOrgType())) {
                    storeData.setCompanyName(r.getCompanyName());
                    storeData.setCompanyTaxNo(r.getTaxNum());
                    storeData.setCompanyId(r.getCompanyId());
                    return storeData;
                }
                OrgData parentCompanyInfo = this.getParentCompanyInfo(orgMap, r.getParentId(), Long.valueOf(groupId));
                if (Objects.nonNull(parentCompanyInfo) && OrgType.Company.value().equals(parentCompanyInfo.getOrgType())) {
                    storeData.setCompanyName(parentCompanyInfo.getCompanyName());
                    storeData.setCompanyTaxNo(parentCompanyInfo.getTaxNum());
                    storeData.setCompanyId(parentCompanyInfo.getCompanyId());
                    return storeData;
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            return Tuple.of((Object)total, storeDataList);
        }
        return Tuple.of((Object)0L, (Object)Lists.newArrayList());
    }

    private Optional<OrgQueryParam> dealParamForOrgQuery(QueryStoreListRequest request, UserInfo userInfo) {
        OrgQueryParam param = new OrgQueryParam();
        param.setUserId(Long.valueOf(userInfo.getUserId()));
        param.setPage(Optional.ofNullable(request.getPage()).map(Page::getPageNo).orElse(1));
        param.setRow(Optional.ofNullable(request.getPage()).map(Page::getPageSize).orElse(50));
        if (StringUtils.isNotBlank((CharSequence)request.getStoreName())) {
            param.setOrgNameLike(request.getStoreName());
        }
        if (Objects.nonNull(request.getOrgType())) {
            if (!Integer.valueOf(1).equals(request.getOrgType()) && !Integer.valueOf(2).equals(request.getOrgType())) {
                logger.error("dealParamForOrgQuery,\u9519\u8bef\u7684\u7ec4\u7ec7\u7c7b\u578b:{}", (Object)JsonUtils.toJson((Object)request));
                return Optional.empty();
            }
            param.setOrgType(request.getOrgType());
        }
        Long companyId = request.getCompanyId();
        OrgData companyOrgData = null;
        if (Objects.nonNull(companyId) && companyId > 0L) {
            OrgQueryParam companyQuery = new OrgQueryParam();
            companyQuery.setCompanyId(companyId);
            UserCenterResponse companyOrgResponse = this.userCenterOrgService.getOrgByParams(userInfo.getGroupId(), companyQuery);
            if (Objects.isNull(companyOrgResponse.getResult()) || CollectionUtils.isEmpty((Collection)((UserCenterList)companyOrgResponse.getResult()).getContent())) {
                logger.error("dealParamForOrgQuery,\u516c\u53f8\u4e0d\u5b58\u5728:{}", (Object)companyId);
                return Optional.empty();
            }
            companyOrgData = (OrgData)((UserCenterList)companyOrgResponse.getResult()).getContent().get(0);
            param.setParentId(companyOrgData.getOrgId());
            param.setOrgType(OrgType.OtherOrg.value());
        }
        return Optional.of(param);
    }

    public OrgData getParentCompanyInfo(Map<Long, OrgData> orgMap, Long parentId, Long tenantId) {
        OrgData parentOrg = orgMap.get(parentId);
        if (Objects.isNull(parentOrg)) {
            parentOrg = Optional.of(this.userCenterOrgService.getOrgById(tenantId.longValue(), parentId.longValue())).map(UserCenterResponse::getResult).orElse(null);
        }
        if (Objects.isNull(parentOrg)) {
            return null;
        }
        orgMap.put(parentId, parentOrg);
        if (OrgType.OtherOrg.value().equals(parentOrg.getOrgType())) {
            return this.getParentCompanyInfo(orgMap, parentOrg.getParentId(), tenantId);
        }
        return parentOrg;
    }

    public OrgData getCompanyBySubOrgId(Long subOrgId, Long tenantId) {
        return this.getParentCompanyInfo(new HashMap(), subOrgId, tenantId);
    }

    public OrgAndCompanyData getOrgByOrgKeyAndTenantKey(String tenantKey, String orgKey, Boolean isTenantCode, Boolean isOrgCode) {
        UserCenterResponse orgPageData = this.userCenterOrgService.getOrgByOrgKeyAndTenantKey(tenantKey, orgKey, isTenantCode.booleanValue(), isOrgCode.booleanValue());
        OrgData orgData = Optional.of(orgPageData).map(UserCenterResponse::getResult).orElse(null);
        if (Objects.nonNull(orgData)) {
            OrgAndCompanyData result = new OrgAndCompanyData();
            BeanUtils.copyProperties((Object)orgData, (Object)result);
            OrgData companyOrgData = this.getCompanyBySubOrgId(orgData.getOrgId(), orgData.getTenantId());
            result.setCompany((CompanyData)this.userCenterCompanyService.getCompanyById(companyOrgData.getTenantId().longValue(), companyOrgData.getCompanyId().longValue()).getResult());
            return result;
        }
        return null;
    }

    public OrgAndCompanyData getOrgByOrgId(Long orgId) {
        OrgData orgData = (OrgData)this.userCenterOrgService.getOrgById(0L, orgId.longValue()).getResult();
        if (orgData != null) {
            OrgAndCompanyData result = new OrgAndCompanyData();
            BeanUtils.copyProperties((Object)orgData, (Object)result);
            OrgData companyOrgData = this.getCompanyBySubOrgId(orgData.getOrgId(), orgData.getTenantId());
            result.setCompany((CompanyData)this.userCenterCompanyService.getCompanyById(companyOrgData.getTenantId().longValue(), companyOrgData.getCompanyId().longValue()).getResult());
            return result;
        }
        return null;
    }

    public ConfigCompanyQueryResponse queryCompanyInfo(ConfigCompanyQueryRequest request) {
        CompanyInfoExample example = new CompanyInfoExample();
        example.createCriteria().andTenantIdEqualTo(request.getGroupId()).andTaxNoIn(request.getTaxNoList()).andTypeEqualTo(request.getType()).andStatusEqualTo(Integer.valueOf(1));
        List companyInfoEntities = this.companyInfoDao.selectByExample(example);
        ConfigCompanyQueryResponse response2 = new ConfigCompanyQueryResponse();
        response2.setCode(Response.OK.intValue());
        response2.setMessage("\u67e5\u8be2\u6210\u529f");
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)companyInfoEntities)) {
            companyInfoEntities.stream().forEach(item -> {
                ConfigCompanyModel configCompanyModel = new ConfigCompanyModel();
                configCompanyModel.setCompanyTaxNo(item.getTaxNo());
                list.add(configCompanyModel);
            });
        }
        response2.setList((List)list);
        return response2;
    }

    public Response queryCompanyList(CompanyPageQueryRequest request) {
        Response response2 = new Response();
        Long groupId = request.getGroupId();
        if (groupId == null || groupId == 0L) {
            groupId = ((UserInfo)this.userInfoHolder.get()).getGroupId();
        }
        if (groupId == null || groupId == 0L) {
            response2.setCode(Response.Fail);
            response2.setMessage("\u67e5\u8be2\u5931\u8d25\uff0c\u6ca1\u6709\u79df\u6237\u4fe1\u606f");
            return response2;
        }
        CompanyInfoExample example = new CompanyInfoExample();
        CompanyInfoExample.Criteria criteria = example.createCriteria();
        criteria.andTenantIdEqualTo(groupId);
        if (CollectionUtils.isNotEmpty((Collection)request.getTaxNoList())) {
            criteria.andTaxNoIn(request.getTaxNoList());
        }
        if (request.getType() != null) {
            criteria.andTypeEqualTo(request.getType());
        }
        criteria.andStatusEqualTo(Integer.valueOf(1));
        Integer pageSize = Optional.ofNullable(request.getPageSize()).filter(it -> it > 0 && it < 1000).orElse(10);
        Integer pageNumber = Optional.ofNullable(request.getPageNumber()).filter(it -> it > 0).orElse(1);
        example.setOffset(Integer.valueOf((pageNumber - 1) * pageSize));
        example.setLimit(pageSize);
        List companyInfoEntities = this.companyInfoDao.selectByExample(example);
        response2.setCode(Response.OK);
        response2.setMessage("\u67e5\u8be2\u6210\u529f");
        response2.setResult((Object)companyInfoEntities);
        return response2;
    }

    public Response createCompanyInfo(CreateCompanyInfoRequest request) {
        Long groupId = ((UserInfo)this.userInfoHolder.get()).getGroupId();
        Response response2 = new Response();
        String errorMessage = this.checkCreateInfo(groupId, request);
        if (errorMessage != null) {
            response2.setCode(Response.Fail);
            response2.setMessage(errorMessage);
            return response2;
        }
        List taxNumberList = Arrays.stream(request.getTaxNoList().split(SPLIT)).map(it -> it.trim()).filter(it -> StringUtils.isNotBlank((CharSequence)it)).collect(Collectors.toList());
        this.getAbsentTaxNumber(groupId, taxNumberList, request);
        List companyInfoEntities = taxNumberList.stream().map(it -> {
            CompanyInfoEntity entity = new CompanyInfoEntity();
            entity.setTenantId(groupId);
            entity.setStatus(Integer.valueOf(1));
            entity.setType(request.getType());
            entity.setTaxNo(it);
            entity.setId(Long.valueOf(this.idGenerator.nextId()));
            entity.setDeleteToken("");
            entity.setCreateTime(new Date());
            entity.setUpdateTime(new Date());
            return entity;
        }).collect(Collectors.toList());
        this.cfgConfigExtDao.batchInsertCompanyInfo(companyInfoEntities);
        response2.setCode(Response.OK);
        response2.setMessage("\u65b0\u589e\u6210\u529f");
        return response2;
    }

    private List<String> getAbsentTaxNumber(Long groupId, List<String> taxNumberList, CreateCompanyInfoRequest request) {
        CompanyInfoExample example = new CompanyInfoExample();
        CompanyInfoExample.Criteria criteria = example.createCriteria();
        criteria.andTenantIdEqualTo(groupId).andTaxNoIn(taxNumberList).andTypeEqualTo(request.getType()).andStatusEqualTo(Integer.valueOf(1));
        List companyInfoEntities = this.companyInfoDao.selectByExample(example);
        if (CollectionUtils.isNotEmpty((Collection)companyInfoEntities)) {
            companyInfoEntities.stream().forEach(it -> taxNumberList.remove(it.getTaxNo()));
        }
        return taxNumberList;
    }

    private String checkCreateInfo(Long groupId, CreateCompanyInfoRequest request) {
        if (groupId == null || groupId == 0L) {
            return "\u65b0\u589e\u5931\u8d25\uff0c\u6ca1\u6709\u79df\u6237\u4fe1\u606f";
        }
        if (StringUtils.isBlank((CharSequence)request.getTaxNoList())) {
            return "\u65b0\u589e\u5931\u8d25,\u7a0e\u53f7\u5217\u8868\u4e3a\u7a7a";
        }
        if (request.getType() == null || !Lists.newArrayList((Object[])new Integer[]{1, 2}).contains(request.getType())) {
            return "\u65b0\u589e\u5931\u8d25\uff0c\u65b0\u589e\u7c7b\u578b\u672a\u77e5";
        }
        return null;
    }

    public Response deleteCompanyInfo(DeleteCompanyInfoRequest request) {
        if (CollectionUtils.isNotEmpty((Collection)request.getIdList())) {
            this.cfgConfigExtDao.deleteCompanyInfo(request.getIdList());
        }
        Response response2 = new Response();
        response2.setCode(Response.OK);
        response2.setMessage("\u5220\u9664\u6210\u529f");
        return response2;
    }

    public Response updateCompanyInfo(UpdateCompanyInfoRequest request) {
        Response response2 = new Response();
        if (request.getId() == null || StringUtils.isBlank((CharSequence)request.getTaxNumber())) {
            response2.setCode(Response.Fail);
            response2.setMessage("\u4fee\u6539\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return response2;
        }
        CompanyInfoEntity entity = new CompanyInfoEntity();
        entity.setId(request.getId());
        entity.setTaxNo(request.getTaxNumber());
        entity.setUpdateTime(new Date());
        this.companyInfoDao.updateByPrimaryKeySelective(entity);
        response2.setCode(Response.OK);
        response2.setMessage("\u4fee\u6539\u6210\u529f");
        return response2;
    }
}

