/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.infrastructure.usercenter.controllers.UserCenterController;
import com.xforceplus.phoenix.infrastructure.usercenter.model.OrgData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserCenterResponse;
import com.xforceplus.seller.config.client.constant.BusinessSalesBillTypeEnum;
import com.xforceplus.seller.config.client.constant.SellerOrgTypeEnum;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigAddRequest;
import com.xforceplus.seller.config.client.model.MsConfigAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.exception.ConfigImportException;
import com.xforceplus.seller.config.models.SellerBusinessConfig;
import com.xforceplus.seller.config.services.ConfigBizConfigService;
import com.xforceplus.seller.config.services.ConfigImportAfter;
import com.xforceplus.seller.config.services.ImportConfigServiceImpl;
import com.xforceplus.seller.config.services.ImportFailConfigServiceImpl;
import com.xforceplus.seller.config.util.JsonUtils;
import com.xforceplus.xplatframework.model.Response;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ConfigImportAfterImpl
implements ConfigImportAfter {
    private static final Logger log = LoggerFactory.getLogger(ConfigImportAfterImpl.class);
    @Autowired
    ImportConfigServiceImpl importConfigService;
    @Autowired
    ConfigBizConfigService configBizConfigService;
    @Autowired
    ImportFailConfigServiceImpl importFailConfigService;
    @Autowired
    private UserCenterController userCenterController;

    public void saveConfigs(String batchNo, MsConfigAddRequest msConfigAddRequest, MsCommonUserInfo msCommonUserInfo) {
        List msConfigBeanList = msConfigAddRequest.getItemDTOList();
        if (CollectionUtils.isEmpty((Collection)msConfigBeanList)) {
            throw new ConfigImportException("\u914d\u7f6e\u9879\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Optional configBeanOptional = msConfigBeanList.stream().findFirst();
        Integer configType = configBeanOptional.map(MsConfigBean::getConfigType).orElse(0);
        ArrayList errorList = Lists.newArrayList();
        List sellerBusinessConfigs = this.importConfigService.queryConfigByBatchNo(Optional.ofNullable(batchNo).map(Long::valueOf).orElseThrow(() -> new ConfigImportException("batchNo\u4e3a\u7a7a")));
        sellerBusinessConfigs.stream().filter(sellerBusinessConfig -> this.filter(errorList, sellerBusinessConfig)).forEach(sellerBusinessConfig -> {
            MsConfigAddRequestWithUserInfo msConfigAddRequestWithUserInfo = this.getMsConfigAddRequestWithUserInfo(msCommonUserInfo, configBeanOptional, sellerBusinessConfig);
            try {
                Response response2 = this.configBizConfigService.addCfgConfig(msConfigAddRequestWithUserInfo, new String[0]);
                log.info("\u8bf7\u6c42\u62c6\u7968\u89c4\u5219\u6dfb\u52a0\u53c2\u6570:" + JsonUtils.writeObjectToFastJson((Object)response2));
                if (response2.getCode() != 1) {
                    sellerBusinessConfig.setErrorMsg(response2.getMessage());
                    errorList.add(sellerBusinessConfig);
                }
            }
            catch (Exception e) {
                sellerBusinessConfig.setErrorMsg(e.getMessage());
                errorList.add(sellerBusinessConfig);
                log.error("\u4fdd\u5b58\u89c4\u5219\u5f02\u5e38", (Throwable)e);
            }
        });
        this.importFailConfigService.dealFailBusinessConfigImport((List)errorList, msCommonUserInfo.getUserId(), msCommonUserInfo.getGroupId(), Integer.valueOf(sellerBusinessConfigs.size() - errorList.size()), SellerBusinessConfig.class);
    }

    private MsConfigAddRequestWithUserInfo getMsConfigAddRequestWithUserInfo(MsCommonUserInfo msCommonUserInfo, Optional<MsConfigBean> configBeanOptional, SellerBusinessConfig sellerBusinessConfig) {
        MsConfigBean msConfigBean = new MsConfigBean();
        msConfigBean.businessBillType(sellerBusinessConfig.getBusinessBillType());
        msConfigBean.setSellerName(sellerBusinessConfig.getSellerName());
        msConfigBean.setSellerTaxNo(sellerBusinessConfig.getSellerTaxNo());
        msConfigBean.setPurchaserName(sellerBusinessConfig.getPurchaserName());
        msConfigBean.setPurchaserTaxNo(sellerBusinessConfig.getPurchaserTaxNo());
        msConfigBean.setConfigType(Integer.valueOf(Integer.parseInt(sellerBusinessConfig.getConfigType())));
        msConfigBean.setSalesbillType(sellerBusinessConfig.getSalesbillType());
        msConfigBean.setConfigName(sellerBusinessConfig.getConfigName());
        this.validateSellerOrgValue(msCommonUserInfo, sellerBusinessConfig, msConfigBean);
        BeanMap beanMap = BeanMap.create((Object)sellerBusinessConfig);
        if (configBeanOptional.isPresent()) {
            msConfigBean.setItemList(configBeanOptional.get().getItemList());
        }
        Field[] declaredFields = sellerBusinessConfig.getClass().getDeclaredFields();
        ArrayList attributeEntityList = Lists.newArrayList();
        this.importConfigService.getBeanItemList(beanMap, declaredFields, sellerBusinessConfig.getSalesbillType(), msCommonUserInfo.getGroupId(), (List)attributeEntityList);
        msConfigBean.setAttributes((List)attributeEntityList);
        MsConfigAddRequestWithUserInfo msConfigAddRequestWithUserInfo = new MsConfigAddRequestWithUserInfo();
        ArrayList configList = Lists.newArrayList();
        configList.add(msConfigBean);
        msConfigAddRequestWithUserInfo.setUserInfo(msCommonUserInfo);
        msConfigAddRequestWithUserInfo.setItemDTOList((List)configList);
        return msConfigAddRequestWithUserInfo;
    }

    protected String validateSellerOrgValue(MsCommonUserInfo userInfo, SellerBusinessConfig configBase, MsConfigBean configBean) {
        String sellerOrgType = StringUtils.isBlank((CharSequence)configBase.getSellerOrgType()) ? SellerOrgTypeEnum.COMPANY.getValue() : configBase.getSellerOrgType();
        StringBuilder sb = new StringBuilder();
        switch (sellerOrgType) {
            case "1": {
                break;
            }
            case "2": {
                configBean.setSellerName("");
                configBean.setSellerTaxNo("");
                break;
            }
            case "3": {
                configBean.setSellerName("");
                configBean.setSellerTaxNo("");
                if (StringUtils.isBlank((CharSequence)configBase.getSellerTaxNo())) {
                    String msgStr = "\u9500\u65b9\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u7ec4\u7ec7\u65f6\uff0c\u9500\u65b9\u516c\u53f8\u7a0e\u53f7" + configBase.getSellerTaxNo() + "\u9700\u8981\u586b\u5199\u4e3a\u7ec4\u7ec7\u4ee3\u7801";
                    log.error(msgStr);
                    sb.append(msgStr);
                    break;
                }
                configBean.setSysOrgCode(configBase.getSellerTaxNo());
                UserCenterResponse result = this.userCenterController.getOrgByCode(userInfo.getGroupId().longValue(), configBean.getSysOrgCode());
                if (result.getResult() == null || !"1".equals(result.getCode())) break;
                configBean.setSysOrgId((Long)Optional.ofNullable(result.getResult()).map(OrgData::getOrgId).orElse(null));
                break;
            }
        }
        return sb.toString();
    }

    private boolean filter(List<SellerBusinessConfig> errorList, SellerBusinessConfig sellerBusinessConfig) {
        if (StringUtils.isNotBlank((CharSequence)sellerBusinessConfig.getBusinessBillType()) && BusinessSalesBillTypeEnum.checkIsExist((String)sellerBusinessConfig.getBusinessBillType())) {
            if (BusinessSalesBillTypeEnum.AR.name().equals(sellerBusinessConfig.getBusinessBillType())) {
                if (StringUtils.isBlank((CharSequence)sellerBusinessConfig.getSellerName()) || StringUtils.isBlank((CharSequence)sellerBusinessConfig.getSellerTaxNo())) {
                    sellerBusinessConfig.setErrorMsg("\u521b\u5efa\u4eba\u4e3aAR \u9500\u65b9\u516c\u53f8\u6216\u7a0e\u53f7\u4e0d\u53ef\u4e3a\u7a7a");
                    errorList.add(sellerBusinessConfig);
                    return false;
                }
            } else if (StringUtils.isBlank((CharSequence)sellerBusinessConfig.getPurchaserName()) || StringUtils.isBlank((CharSequence)sellerBusinessConfig.getPurchaserTaxNo())) {
                sellerBusinessConfig.setErrorMsg("\u521b\u5efa\u4eba\u4e3aAR \u8d2d\u65b9\u516c\u53f8\u6216\u7a0e\u53f7\u4e0d\u53ef\u4e3a\u7a7a");
                errorList.add(sellerBusinessConfig);
                return false;
            }
        } else {
            sellerBusinessConfig.setErrorMsg("\u521b\u5efa\u4eba\u672a\u586b\u6216\u8d85\u8fc7\u586b\u5199\u8303\u56f4\uff08AR,AP\uff09");
            errorList.add(sellerBusinessConfig);
            return false;
        }
        if (StringUtils.isBlank((CharSequence)sellerBusinessConfig.getSalesbillType())) {
            sellerBusinessConfig.setErrorMsg("\u4e1a\u52a1\u5355\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
            errorList.add(sellerBusinessConfig);
            return false;
        }
        if (StringUtils.isBlank((CharSequence)sellerBusinessConfig.getConfigName())) {
            sellerBusinessConfig.setErrorMsg("\u914d\u7f6e\u540d\u4e0d\u53ef\u4e3a\u7a7a");
            errorList.add(sellerBusinessConfig);
            return false;
        }
        return true;
    }
}

