/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services;

import com.xforceplus.micro.tax.device.contract.model.DeviceInfo;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.phoenix.infrastructure.usercenter.model.OrgData;
import com.xforceplus.seller.config.converters.InventoryConfigConverter;
import com.xforceplus.seller.config.core.enums.InventoryLogAction;
import com.xforceplus.seller.config.core.enums.InventoryReceiverType;
import com.xforceplus.seller.config.core.enums.InvoiceTypeEnum;
import com.xforceplus.seller.config.core.enums.ValueEnum;
import com.xforceplus.seller.config.infrastructure.client.InvoiceInventoryClient;
import com.xforceplus.seller.config.infrastructure.client.UserCenterService;
import com.xforceplus.seller.config.infrastructure.job.SendInvoiceMailService;
import com.xforceplus.seller.config.models.AddInventoryConfigRequest;
import com.xforceplus.seller.config.models.CheckInventoryConfigRequest;
import com.xforceplus.seller.config.models.ConditionQueryInfo;
import com.xforceplus.seller.config.models.DataList;
import com.xforceplus.seller.config.models.InventoryConfigImportData;
import com.xforceplus.seller.config.models.InventoryData;
import com.xforceplus.seller.config.models.InventoryLogData;
import com.xforceplus.seller.config.models.InventoryPageInfo;
import com.xforceplus.seller.config.models.InventorySortInfo;
import com.xforceplus.seller.config.models.InventoryUniqueData;
import com.xforceplus.seller.config.models.InvoiceInventoryModel;
import com.xforceplus.seller.config.models.QueryInventoryByWarnConfigRequest;
import com.xforceplus.seller.config.models.QueryInventoryConfigRequest;
import com.xforceplus.seller.config.models.UpdateInventoryConfigRequest;
import com.xforceplus.seller.config.models.WarnReceiver;
import com.xforceplus.seller.config.repository.dao.CfgConfigInventoryDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigInventoryLogDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigInventoryReceiverDao;
import com.xforceplus.seller.config.repository.daoext.CfgConfigInventoryExtDao;
import com.xforceplus.seller.config.repository.daoext.CfgConfigInventoryLogExtDao;
import com.xforceplus.seller.config.repository.daoext.CfgConfigInventoryReceiverExtDao;
import com.xforceplus.seller.config.repository.model.CfgConfigInventoryEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigInventoryExample;
import com.xforceplus.seller.config.repository.model.CfgConfigInventoryLogEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigInventoryLogExample;
import com.xforceplus.seller.config.repository.model.CfgConfigInventoryReceiverEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigInventoryReceiverExample;
import com.xforceplus.seller.config.services.ConfigDeviceService;
import com.xforceplus.seller.config.services.ConfigInventoryService;
import com.xforceplus.seller.config.services.ConfigInventoryServiceImpl;
import com.xforceplus.seller.config.services.ImportFailConfigServiceImpl;
import com.xforceplus.seller.config.util.DateTools;
import com.xforceplus.seller.config.util.MatchUtil;
import com.xforceplus.seller.config.util.StringUtil;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatframework.utils.JsonUtils;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import io.vavr.control.Either;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 t2\u00020\u0001:\u0001tB\u0089\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u0012\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 \u00a2\u0006\u0002\u0010\"J\u001c\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)0'2\u0006\u0010*\u001a\u00020+H\u0017J&\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u00101\u001a\u00020)2\u0006\u00102\u001a\u00020)H\u0012J,\u00103\u001a\u0002042\u0006\u00101\u001a\u00020)2\u0006\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00010(2\b\u00108\u001a\u0004\u0018\u00010(H\u0012J\"\u00109\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020;0:0/2\u0006\u0010*\u001a\u00020<H\u0016J0\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010?\u001a\u00020(2\u0006\u0010@\u001a\u00020(2\u0014\u0010A\u001a\u0010\u0012\u0004\u0012\u00020(\u0012\u0006\u0012\u0004\u0018\u00010>0BH\u0012J\u0016\u0010C\u001a\u00020D2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020(0/H\u0012J4\u0010E\u001a\u0004\u0018\u00010(2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020F0/2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020F0H2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020F0HH\u0012J\u0018\u0010J\u001a\u0004\u0018\u00010(2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0012J(\u0010K\u001a\u00020D2\u0006\u0010L\u001a\u00020)2\u0006\u0010M\u001a\u00020(2\u0006\u0010N\u001a\u00020(2\u0006\u0010O\u001a\u00020PH\u0012J \u0010Q\u001a\u00020(2\u0006\u0010R\u001a\u00020(2\u0006\u0010S\u001a\u00020(2\u0006\u0010T\u001a\u00020(H\u0012J\u001e\u0010U\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020F0H2\u0006\u0010V\u001a\u00020FH\u0012J\"\u0010W\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020D0'2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020)0/H\u0017J$\u0010X\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020Z0Y2\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020PH\u0012J4\u0010^\u001a \u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020(0_\u0012\u0004\u0012\u00020P0Y2\f\u0010`\u001a\b\u0012\u0004\u0012\u00020\\0/H\u0012J*\u0010a\u001a\u00020-2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0c2\u0012\u0010e\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020Z0YH\u0016J,\u0010f\u001a\u00020-2\u0006\u00101\u001a\u00020)2\u0006\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00010(2\b\u00108\u001a\u0004\u0018\u00010(H\u0012J2\u0010f\u001a\u00020-2\f\u0010g\u001a\b\u0012\u0004\u0012\u00020)0/2\u0006\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00010(2\b\u00108\u001a\u0004\u0018\u00010(H\u0012J\"\u0010h\u001a\u0014\u0012\u0004\u0012\u00020(\u0012\n\u0012\b\u0012\u0004\u0012\u00020j0i0'2\u0006\u0010*\u001a\u00020kH\u0016J\u0016\u0010l\u001a\b\u0012\u0004\u0012\u00020m0/2\u0006\u00101\u001a\u00020)H\u0016J\b\u0010n\u001a\u00020-H\u0016J\u001c\u0010o\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)0'2\u0006\u0010*\u001a\u00020pH\u0017J\u0018\u0010q\u001a\u00020P2\u000e\u0010r\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010/H\u0016J>\u0010s\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0/\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0/0:2\u0006\u00101\u001a\u00020)2\f\u0010I\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u00102\u001a\u00020)H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\n %*\u0004\u0018\u00010$0$X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006u"}, d2={"Lcom/xforceplus/seller/config/services/ConfigInventoryServiceImpl;", "Lcom/xforceplus/seller/config/services/ConfigInventoryService;", "cfgConfigInventoryDao", "Lcom/xforceplus/seller/config/repository/dao/CfgConfigInventoryDao;", "cfgConfigInventoryReceiverDao", "Lcom/xforceplus/seller/config/repository/dao/CfgConfigInventoryReceiverDao;", "cfgConfigInventoryLogDao", "Lcom/xforceplus/seller/config/repository/dao/CfgConfigInventoryLogDao;", "userInfo", "Lcom/xforceplus/xplatframework/spring/domain/UserInfoHolder;", "Lcom/xforceplus/xplatframework/apimodel/UserInfo;", "inventoryConfigConverter", "Lcom/xforceplus/seller/config/converters/InventoryConfigConverter;", "idGenerator", "Lcom/xforceplus/phoenix/generator/IDGenerator;", "userCenterService", "Lcom/xforceplus/seller/config/infrastructure/client/UserCenterService;", "cfgConfigInventoryExtDao", "Lcom/xforceplus/seller/config/repository/daoext/CfgConfigInventoryExtDao;", "cfgConfigInventoryLogExtDao", "Lcom/xforceplus/seller/config/repository/daoext/CfgConfigInventoryLogExtDao;", "cfgConfigInventoryReceiverExtDao", "Lcom/xforceplus/seller/config/repository/daoext/CfgConfigInventoryReceiverExtDao;", "configDeviceService", "Lcom/xforceplus/seller/config/services/ConfigDeviceService;", "importFailConfigServiceImpl", "Lcom/xforceplus/seller/config/services/ImportFailConfigServiceImpl;", "sendInvoiceMailService", "Lcom/xforceplus/seller/config/infrastructure/job/SendInvoiceMailService;", "invoiceInventoryClient", "Lcom/xforceplus/seller/config/infrastructure/client/InvoiceInventoryClient;", "contextHolder", "Lcom/xforceplus/xplatsecurity/domain/ContextHolder;", "Lcom/xforceplus/xplatsecurity/domain/UserContext;", "(Lcom/xforceplus/seller/config/repository/dao/CfgConfigInventoryDao;Lcom/xforceplus/seller/config/repository/dao/CfgConfigInventoryReceiverDao;Lcom/xforceplus/seller/config/repository/dao/CfgConfigInventoryLogDao;Lcom/xforceplus/xplatframework/spring/domain/UserInfoHolder;Lcom/xforceplus/seller/config/converters/InventoryConfigConverter;Lcom/xforceplus/phoenix/generator/IDGenerator;Lcom/xforceplus/seller/config/infrastructure/client/UserCenterService;Lcom/xforceplus/seller/config/repository/daoext/CfgConfigInventoryExtDao;Lcom/xforceplus/seller/config/repository/daoext/CfgConfigInventoryLogExtDao;Lcom/xforceplus/seller/config/repository/daoext/CfgConfigInventoryReceiverExtDao;Lcom/xforceplus/seller/config/services/ConfigDeviceService;Lcom/xforceplus/seller/config/services/ImportFailConfigServiceImpl;Lcom/xforceplus/seller/config/infrastructure/job/SendInvoiceMailService;Lcom/xforceplus/seller/config/infrastructure/client/InvoiceInventoryClient;Lcom/xforceplus/xplatsecurity/domain/ContextHolder;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "add", "Lio/vavr/control/Either;", "", "", "request", "Lcom/xforceplus/seller/config/models/AddInventoryConfigRequest;", "addReceiver", "", "list", "", "Lcom/xforceplus/seller/config/models/WarnReceiver;", "inventoryId", "userId", "assembleLog", "Lcom/xforceplus/seller/config/repository/model/CfgConfigInventoryLogEntity;", "action", "Lcom/xforceplus/seller/config/core/enums/InventoryLogAction;", "message", "userName", "check", "Lio/vavr/Tuple2;", "Lcom/xforceplus/seller/config/models/InventoryUniqueData;", "Lcom/xforceplus/seller/config/models/CheckInventoryConfigRequest;", "checkDeviceExist", "Lcom/xforceplus/micro/tax/device/contract/model/DeviceInfo;", "taxNo", "deviceNo", "deviceMap", "", "checkEmail", "", "checkParams", "Lcom/xforceplus/seller/config/models/ConditionQueryInfo;", "inventoryList", "", "receiverList", "checkReceiverFormat", "checkRepeat", "companyId", "deviceUn", "invoiceType", "warnNum", "", "concatContent", "preContent", "baseContent", "jointContent", "convertParam", "param", "delete", "getEmailProperties", "", "", "entity", "Lcom/xforceplus/seller/config/repository/model/CfgConfigInventoryEntity;", "leftNum", "getInventory", "Lio/vavr/Tuple3;", "entityList", "importInventoryConfig", "dataList", "Lkotlin/sequences/Sequence;", "Lcom/xforceplus/seller/config/models/InventoryConfigImportData;", "headers", "insertLog", "inventoryIdList", "query", "Lcom/xforceplus/seller/config/models/DataList;", "Lcom/xforceplus/seller/config/models/InventoryData;", "Lcom/xforceplus/seller/config/models/QueryInventoryConfigRequest;", "queryLog", "Lcom/xforceplus/seller/config/models/InventoryLogData;", "timingSendEmail", "update", "Lcom/xforceplus/seller/config/models/UpdateInventoryConfigRequest;", "updateDeviceUn", "deviceNoList", "updatePartReceiverDeletedAndAddNew", "STATIC", "seller-config-service"})
@SourceDebugExtension(value={"SMAP\nConfigInventoryServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigInventoryServiceImpl.kt\ncom/xforceplus/seller/config/services/ConfigInventoryServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,633:1\n1855#2,2:634\n1549#2:636\n1620#2,3:637\n1549#2:641\n1620#2,3:642\n1208#2,2:645\n1238#2,4:647\n766#2:651\n857#2,2:652\n1549#2:654\n1620#2,3:655\n1549#2:658\n1620#2,3:659\n1549#2:662\n1620#2,3:663\n1549#2:666\n1620#2,3:667\n1549#2:670\n1620#2,3:671\n1477#2:674\n1502#2,3:675\n1505#2,3:685\n1549#2:688\n1620#2,3:689\n1603#2,9:692\n1855#2:701\n1856#2:703\n1612#2:704\n1549#2:705\n1620#2,2:706\n766#2:708\n857#2,2:709\n1549#2:711\n1620#2,3:712\n1549#2:715\n1620#2,3:716\n1477#2:719\n1502#2,3:720\n1505#2,3:730\n1194#2,2:733\n1222#2,4:735\n1603#2,9:742\n1855#2:751\n1856#2:753\n1612#2:754\n1603#2,9:755\n1855#2:764\n1856#2:766\n1612#2:767\n1622#2:769\n1549#2:785\n1620#2,3:786\n288#2,2:790\n1747#2,3:792\n1603#2,9:795\n1855#2:804\n1856#2:806\n1612#2:807\n1603#2,9:808\n1855#2:817\n1856#2:819\n1612#2:820\n766#2:821\n857#2,2:822\n1179#2,2:824\n1253#2,4:826\n1477#2:830\n1502#2,3:831\n1505#2,3:841\n1603#2,9:845\n1855#2:854\n1856#2:856\n1612#2:857\n1208#2,2:859\n1238#2,4:861\n766#2:865\n857#2,2:866\n1208#2,2:868\n1238#2,2:870\n766#2:872\n857#2,2:873\n1490#2:875\n1520#2,3:876\n1523#2,3:886\n1241#2:889\n1#3:640\n1#3:702\n1#3:752\n1#3:765\n1#3:805\n1#3:818\n1#3:855\n361#4,7:678\n361#4,7:723\n361#4,7:774\n361#4,7:834\n361#4,7:879\n125#5:739\n152#5,2:740\n154#5:768\n215#5:844\n216#5:858\n970#6:770\n999#6,3:771\n1002#6,3:781\n1295#6:784\n1296#6:789\n*S KotlinDebug\n*F\n+ 1 ConfigInventoryServiceImpl.kt\ncom/xforceplus/seller/config/services/ConfigInventoryServiceImpl\n*L\n97#1:634,2\n124#1:636\n124#1:637,3\n183#1:641\n183#1:642,3\n191#1:645,2\n191#1:647,4\n194#1:651\n194#1:652,2\n202#1:654\n202#1:655,3\n214#1:658\n214#1:659,3\n253#1:662\n253#1:663,3\n292#1:666\n292#1:667,3\n301#1:670\n301#1:671,3\n305#1:674\n305#1:675,3\n305#1:685,3\n309#1:688\n309#1:689,3\n317#1:692,9\n317#1:701\n317#1:703\n317#1:704\n351#1:705\n351#1:706,2\n358#1:708\n358#1:709,2\n359#1:711\n359#1:712,3\n368#1:715\n368#1:716,3\n375#1:719\n375#1:720,3\n375#1:730,3\n377#1:733,2\n377#1:735,4\n388#1:742,9\n388#1:751\n388#1:753\n388#1:754\n390#1:755,9\n390#1:764\n390#1:766\n390#1:767\n351#1:769\n460#1:785\n460#1:786,3\n482#1:790,2\n488#1:792,3\n508#1:795,9\n508#1:804\n508#1:806\n508#1:807\n516#1:808,9\n516#1:817\n516#1:819\n516#1:820\n529#1:821\n529#1:822,2\n532#1:824,2\n532#1:826,4\n547#1:830\n547#1:831,3\n547#1:841,3\n561#1:845,9\n561#1:854\n561#1:856\n561#1:857\n576#1:859,2\n576#1:861,4\n615#1:865\n615#1:866,2\n616#1:868,2\n616#1:870,2\n619#1:872\n619#1:873,2\n620#1:875\n620#1:876,3\n620#1:886,3\n616#1:889\n317#1:702\n388#1:752\n390#1:765\n508#1:805\n516#1:818\n561#1:855\n305#1:678,7\n375#1:723,7\n424#1:774,7\n547#1:834,7\n620#1:879,7\n380#1:739\n380#1:740,2\n380#1:768\n549#1:844\n549#1:858\n424#1:770\n424#1:771,3\n424#1:781,3\n445#1:784\n445#1:789\n*E\n"})
public class ConfigInventoryServiceImpl
implements ConfigInventoryService {
    @NotNull
    public static final STATIC STATIC = new STATIC(null);
    @NotNull
    private final CfgConfigInventoryDao cfgConfigInventoryDao;
    @NotNull
    private final CfgConfigInventoryReceiverDao cfgConfigInventoryReceiverDao;
    @NotNull
    private final CfgConfigInventoryLogDao cfgConfigInventoryLogDao;
    @NotNull
    private final UserInfoHolder<UserInfo> userInfo;
    @NotNull
    private final InventoryConfigConverter inventoryConfigConverter;
    @NotNull
    private final IDGenerator idGenerator;
    @NotNull
    private final UserCenterService userCenterService;
    @NotNull
    private final CfgConfigInventoryExtDao cfgConfigInventoryExtDao;
    @NotNull
    private final CfgConfigInventoryLogExtDao cfgConfigInventoryLogExtDao;
    @NotNull
    private final CfgConfigInventoryReceiverExtDao cfgConfigInventoryReceiverExtDao;
    @NotNull
    private final ConfigDeviceService configDeviceService;
    @NotNull
    private final ImportFailConfigServiceImpl importFailConfigServiceImpl;
    @NotNull
    private final SendInvoiceMailService sendInvoiceMailService;
    @NotNull
    private final InvoiceInventoryClient invoiceInventoryClient;
    @NotNull
    private final ContextHolder<UserContext> contextHolder;
    private final Logger log;
    @NotNull
    private static final List<String> allowWarnInvoiceTypeList;

    public ConfigInventoryServiceImpl(@NotNull CfgConfigInventoryDao cfgConfigInventoryDao, @NotNull CfgConfigInventoryReceiverDao cfgConfigInventoryReceiverDao, @NotNull CfgConfigInventoryLogDao cfgConfigInventoryLogDao, @NotNull UserInfoHolder<UserInfo> userInfo, @NotNull InventoryConfigConverter inventoryConfigConverter, @NotNull IDGenerator idGenerator, @NotNull UserCenterService userCenterService, @NotNull CfgConfigInventoryExtDao cfgConfigInventoryExtDao, @NotNull CfgConfigInventoryLogExtDao cfgConfigInventoryLogExtDao, @NotNull CfgConfigInventoryReceiverExtDao cfgConfigInventoryReceiverExtDao, @NotNull ConfigDeviceService configDeviceService, @NotNull ImportFailConfigServiceImpl importFailConfigServiceImpl, @NotNull SendInvoiceMailService sendInvoiceMailService, @NotNull InvoiceInventoryClient invoiceInventoryClient, @NotNull ContextHolder<UserContext> contextHolder) {
        Intrinsics.checkNotNullParameter((Object)cfgConfigInventoryDao, (String)"cfgConfigInventoryDao");
        Intrinsics.checkNotNullParameter((Object)cfgConfigInventoryReceiverDao, (String)"cfgConfigInventoryReceiverDao");
        Intrinsics.checkNotNullParameter((Object)cfgConfigInventoryLogDao, (String)"cfgConfigInventoryLogDao");
        Intrinsics.checkNotNullParameter(userInfo, (String)"userInfo");
        Intrinsics.checkNotNullParameter((Object)inventoryConfigConverter, (String)"inventoryConfigConverter");
        Intrinsics.checkNotNullParameter((Object)idGenerator, (String)"idGenerator");
        Intrinsics.checkNotNullParameter((Object)userCenterService, (String)"userCenterService");
        Intrinsics.checkNotNullParameter((Object)cfgConfigInventoryExtDao, (String)"cfgConfigInventoryExtDao");
        Intrinsics.checkNotNullParameter((Object)cfgConfigInventoryLogExtDao, (String)"cfgConfigInventoryLogExtDao");
        Intrinsics.checkNotNullParameter((Object)cfgConfigInventoryReceiverExtDao, (String)"cfgConfigInventoryReceiverExtDao");
        Intrinsics.checkNotNullParameter((Object)configDeviceService, (String)"configDeviceService");
        Intrinsics.checkNotNullParameter((Object)importFailConfigServiceImpl, (String)"importFailConfigServiceImpl");
        Intrinsics.checkNotNullParameter((Object)sendInvoiceMailService, (String)"sendInvoiceMailService");
        Intrinsics.checkNotNullParameter((Object)invoiceInventoryClient, (String)"invoiceInventoryClient");
        Intrinsics.checkNotNullParameter(contextHolder, (String)"contextHolder");
        this.cfgConfigInventoryDao = cfgConfigInventoryDao;
        this.cfgConfigInventoryReceiverDao = cfgConfigInventoryReceiverDao;
        this.cfgConfigInventoryLogDao = cfgConfigInventoryLogDao;
        this.userInfo = userInfo;
        this.inventoryConfigConverter = inventoryConfigConverter;
        this.idGenerator = idGenerator;
        this.userCenterService = userCenterService;
        this.cfgConfigInventoryExtDao = cfgConfigInventoryExtDao;
        this.cfgConfigInventoryLogExtDao = cfgConfigInventoryLogExtDao;
        this.cfgConfigInventoryReceiverExtDao = cfgConfigInventoryReceiverExtDao;
        this.configDeviceService = configDeviceService;
        this.importFailConfigServiceImpl = importFailConfigServiceImpl;
        this.sendInvoiceMailService = sendInvoiceMailService;
        this.invoiceInventoryClient = invoiceInventoryClient;
        this.contextHolder = contextHolder;
        this.log = LoggerFactory.getLogger(ConfigInventoryServiceImpl.class);
    }

    @Transactional(rollbackFor={Exception.class})
    @NotNull
    public Either<String, Long> add(@NotNull AddInventoryConfigRequest request) {
        String checkResult;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.log.info("addInventoryConfigRequest: " + JsonUtils.writeObjectToJson((Object)request));
        String string = request.getWarnNum() <= 0 ? "\u9884\u8b66\u5f20\u6570\u5fc5\u987b\u5927\u4e8e0" : (!allowWarnInvoiceTypeList.contains(request.getInvoiceType()) ? "\u8be5\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u8fdb\u884c\u5e93\u5b58\u9884\u8b66" : (checkResult = this.checkRepeat(request.getCompanyId(), request.getDeviceUn(), request.getInvoiceType(), request.getWarnNum()) ? "\u6570\u636e\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u65b0\u589e" : this.checkReceiverFormat(request.getReceiverList())));
        if (checkResult != null) {
            Either either = Either.left((Object)checkResult);
            Intrinsics.checkNotNullExpressionValue((Object)either, (String)"left(checkResult)");
            return either;
        }
        UserInfo user = (UserInfo)this.userInfo.get();
        long userId = user.getUserId();
        long inventoryId = this.idGenerator.nextId();
        CfgConfigInventoryEntity entity = this.inventoryConfigConverter.convert(request, Long.valueOf(inventoryId), Long.valueOf(userId));
        this.cfgConfigInventoryDao.insert(entity);
        this.addReceiver(request.getReceiverList(), inventoryId, userId);
        this.insertLog(inventoryId, InventoryLogAction.INSERT, null, user.getUserName());
        Either either = Either.right((Object)inventoryId);
        Intrinsics.checkNotNullExpressionValue((Object)either, (String)"right(inventoryId)");
        return either;
    }

    private String checkReceiverFormat(List<WarnReceiver> list) {
        if (list.isEmpty()) {
            return "\u9884\u8b66\u4eba\u4e3a\u7a7a";
        }
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WarnReceiver it = (WarnReceiver)element$iv;
            boolean bl = false;
            Optional receiverTypeOptional = ValueEnum.getEnumByValue(InventoryReceiverType.class, (Object)it.getType());
            if (!receiverTypeOptional.isPresent()) {
                return "\u9884\u8b66\u4eba\u4e0d\u5408\u6cd5";
            }
            Object t = receiverTypeOptional.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"receiverTypeOptional.get()");
            InventoryReceiverType receiverType = (InventoryReceiverType)t;
            if (receiverType != InventoryReceiverType.EMAIL) continue;
            if (StringsKt.isBlank((CharSequence)it.getReceiver())) {
                return "\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (MatchUtil.STATIC.isEmail(it.getReceiver())) continue;
            return it.getReceiver() + "\u90ae\u7bb1\u683c\u5f0f\u4e0d\u5408\u6cd5";
        }
        return null;
    }

    private boolean checkRepeat(long companyId, String deviceUn, String invoiceType, int warnNum) {
        CfgConfigInventoryExample example = new CfgConfigInventoryExample();
        example.createCriteria().andCompanyIdEqualTo(Long.valueOf(companyId)).andDeviceUnEqualTo(deviceUn).andInvoiceTypeEqualTo(invoiceType).andWarnNumEqualTo(Integer.valueOf(warnNum)).andDeletedFlagEqualTo(Long.valueOf(0L));
        return this.cfgConfigInventoryDao.countByExample(example) > 0L;
    }

    /*
     * WARNING - void declaration
     */
    private void addReceiver(List<WarnReceiver> list, long inventoryId, long userId) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            WarnReceiver warnReceiver = (WarnReceiver)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.inventoryConfigConverter.convert((WarnReceiver)it, Long.valueOf(inventoryId), Long.valueOf(this.idGenerator.nextId()), Long.valueOf(userId)));
        }
        List receiverEntityList = (List)destination$iv$iv;
        this.cfgConfigInventoryReceiverExtDao.batchInsert(receiverEntityList);
    }

    /*
     * Unable to fully structure code
     */
    @Transactional(rollbackFor={Exception.class})
    @NotNull
    public Either<String, Long> update(@NotNull UpdateInventoryConfigRequest request) {
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                this.log.info("updateInventoryConfigRequest: " + JsonUtils.writeObjectToJson((Object)request));
                entity = this.cfgConfigInventoryDao.selectByPrimaryKey(Long.valueOf(request.getId()));
                user = (UserInfo)this.userInfo.get();
                userId = user.getUserId();
                if (request.getWarnNum() > 0) break block5;
                v0 = "\u9884\u8b66\u5f20\u6570\u5fc5\u987b\u5927\u4e8e0";
                break block6;
            }
            v1 = entity.getWarnNum();
            if (v1 != null && request.getWarnNum() == v1.intValue()) ** GOTO lbl-1000
            v2 = entity.getCompanyId();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"entity.companyId");
            v3 = ((Number)v2).longValue();
            v4 = entity.getDeviceUn();
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"entity.deviceUn");
            v5 = entity.getInvoiceType();
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"entity.invoiceType");
            if (this.checkRepeat(v3, v4, v5, request.getWarnNum())) {
                v0 = "\u6570\u636e\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fee\u6539";
            } else lbl-1000:
            // 2 sources

            {
                v0 = var6_5 = this.checkReceiverFormat(request.getReceiverList());
            }
        }
        if (var6_5 != null) {
            it = var6_5;
            $i$a$-let-ConfigInventoryServiceImpl$update$1 = false;
            v6 = Either.left((Object)it);
            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"left(it)");
            return v6;
        }
        updateContent = null;
        updateContent = "";
        var8_7 = request.getWarnNum();
        it = ((Number)var8_7).intValue();
        $i$a$-takeIf-ConfigInventoryServiceImpl$update$2 = false;
        v7 = entity.getWarnNum();
        v8 = var7_11 = (v7 == null || it != v7) != false ? var8_7 : null;
        if (var7_11 != null) {
            it = ((Number)var7_11).intValue();
            $i$a$-let-ConfigInventoryServiceImpl$update$3 = false;
            updateContent = updateContent + "\u9884\u8b66\u5f20\u6570\u7531" + entity.getWarnNum() + "\u6539\u4e3a" + it;
            updateEntity = new CfgConfigInventoryEntity();
            updateEntity.setId(Long.valueOf(request.getId()));
            updateEntity.setWarnNum(Integer.valueOf(it));
            updateEntity.setModifiedAt(new Date());
            updateEntity.setModifiedBy(Long.valueOf(userId));
            this.cfgConfigInventoryDao.updateByPrimaryKeySelective(updateEntity);
        }
        emailContent = this.updatePartReceiverDeletedAndAddNew(request.getId(), request.getReceiverList(), userId);
        v9 = emailContent._1();
        Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"emailContent._1()");
        updateContent = this.concatContent(updateContent, "\u9884\u8b66\u4eba\u5220\u9664", CollectionsKt.joinToString$default((Iterable)((Iterable)v9), null, null, null, (int)0, null, null, (int)63, null));
        v10 = emailContent._2();
        Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"emailContent._2()");
        updateContent = this.concatContent(updateContent, "\u9884\u8b66\u4eba\u65b0\u589e", CollectionsKt.joinToString$default((Iterable)((Iterable)v10), null, null, null, (int)0, null, null, (int)63, null));
        if (StringsKt.isBlank((CharSequence)updateContent) == false) {
            this.insertLog(request.getId(), InventoryLogAction.UPDATE, updateContent, user.getUserName());
        }
        v11 = Either.right((Object)request.getId());
        Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"right(request.id)");
        return v11;
    }

    private String concatContent(String preContent, String baseContent, String jointContent) {
        if (StringsKt.isBlank((CharSequence)jointContent)) {
            return preContent;
        }
        return StringsKt.isBlank((CharSequence)preContent) ? baseContent + jointContent : preContent + ',' + baseContent + jointContent;
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<List<String>, List<String>> updatePartReceiverDeletedAndAddNew(long inventoryId, List<WarnReceiver> receiverList, long userId) {
        Iterable deletedExample;
        Collection collection;
        String type;
        void $this$associateByTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv;
        CfgConfigInventoryReceiverExample receiverExample = new CfgConfigInventoryReceiverExample();
        receiverExample.createCriteria().andInventoryIdEqualTo(Long.valueOf(inventoryId)).andDeletedFlagEqualTo(Long.valueOf(0L));
        List receiverEntityList = this.cfgConfigInventoryReceiverDao.selectByExample(receiverExample);
        Intrinsics.checkNotNullExpressionValue((Object)receiverEntityList, (String)"receiverEntityList");
        Iterable $this$map$iv = receiverEntityList;
        boolean $i$f$map = false;
        Object object2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CfgConfigInventoryReceiverEntity cfgConfigInventoryReceiverEntity = (CfgConfigInventoryReceiverEntity)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            String string = it.getReceiver();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.receiver");
            Object var18_26 = ValueEnum.getEnumByOrdinal(InventoryReceiverType.class, (Integer)it.getReceiverType()).map(arg_0 -> ConfigInventoryServiceImpl.updatePartReceiverDeletedAndAddNew$lambda$6$lambda$5((Function1)updatePartReceiverDeletedAndAddNew.existReceiverList.1.1.INSTANCE, arg_0)).orElse(null);
            Intrinsics.checkNotNullExpressionValue(var18_26, (String)"getEnumByOrdinal(Invento\u2026            .orElse(null)");
            object.add(new WarnReceiver(string, (String)var18_26));
        }
        List existReceiverList2 = (List)destination$iv$iv;
        List deletedList = new ArrayList();
        Iterable $this$associateBy$iv = CollectionsKt.minus((Iterable)existReceiverList2, (Iterable)receiverList);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            WarnReceiver warnReceiver = (WarnReceiver)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            WarnReceiver it = (WarnReceiver)element$iv$iv;
            String string = it.getReceiver();
            boolean bl2 = false;
            String string2 = it.getType();
            object.put(string, string2);
        }
        Object it = object2 = destination$iv$iv2;
        boolean bl = false;
        Object object3 = $i$f$map = !it.isEmpty() ? object2 : null;
        if ($i$f$map != null) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            CfgConfigInventoryReceiverEntity it2;
            void $this$filterTo$iv$iv;
            Object deletedMap = $i$f$map;
            boolean bl3 = false;
            Iterable $this$filter$iv = receiverEntityList;
            boolean $i$f$filter = false;
            Iterable $i$f$associateByTo2 = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl4;
                it2 = (CfgConfigInventoryReceiverEntity)element$iv$iv;
                boolean bl5 = false;
                type = (String)deletedMap.get(it2.getReceiver());
                if (type != null && Intrinsics.areEqual((Object)type, ValueEnum.getEnumByOrdinal(InventoryReceiverType.class, (Integer)it2.getReceiverType()).map(arg_0 -> ConfigInventoryServiceImpl.updatePartReceiverDeletedAndAddNew$lambda$13$lambda$11$lambda$10((Function1)updatePartReceiverDeletedAndAddNew.4.deletedIds.1.1.INSTANCE, arg_0)).orElse(null))) {
                    String string = it2.getReceiver();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.receiver");
                    deletedList.add(string);
                    bl4 = true;
                } else {
                    bl4 = false;
                }
                if (!bl4) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv3;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv2;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it2 = (CfgConfigInventoryReceiverEntity)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl6 = false;
                collection.add(it2.getId());
            }
            List deletedIds2 = (List)destination$iv$iv3;
            CfgConfigInventoryReceiverEntity deletedEntity = new CfgConfigInventoryReceiverEntity();
            deletedEntity.setDeletedFlag(Long.valueOf(System.currentTimeMillis()));
            deletedEntity.setModifiedAt(new Date());
            deletedEntity.setModifiedBy(Long.valueOf(userId));
            deletedExample = new CfgConfigInventoryReceiverExample();
            deletedExample.createCriteria().andIdIn(deletedIds2);
            this.cfgConfigInventoryReceiverDao.updateByExampleSelective(deletedEntity, (CfgConfigInventoryReceiverExample)deletedExample);
        }
        List insertList = new ArrayList();
        List list = CollectionsKt.minus((Iterable)receiverList, (Iterable)existReceiverList2);
        Object it3 = list;
        boolean bl7 = false;
        Object object4 = object2 = !((Collection)it3).isEmpty() ? list : null;
        if (object2 != null) {
            void $this$mapTo$iv$iv3;
            void $this$map$iv3;
            it3 = object2;
            boolean bl8 = false;
            deletedExample = (Iterable)it3;
            List list2 = insertList;
            boolean $i$f$map3 = false;
            void $i$f$mapTo2 = $this$map$iv3;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void r;
                type = (WarnReceiver)item$iv$iv;
                collection = destination$iv$iv4;
                boolean bl9 = false;
                collection.add(r.getReceiver());
            }
            list2.addAll((List)destination$iv$iv4);
            this.addReceiver((List)it3, inventoryId, userId);
        }
        Tuple2 tuple2 = Tuple.of((Object)deletedList, (Object)insertList);
        Intrinsics.checkNotNullExpressionValue((Object)tuple2, (String)"of(deletedList, insertList)");
        return tuple2;
    }

    @Transactional(rollbackFor={Exception.class})
    @NotNull
    public Either<String, Boolean> delete(@NotNull List<Long> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        this.log.info("deleteInventoryConfigRequest: " + JsonUtils.writeObjectToJson(list));
        if (list.isEmpty()) {
            Either either = Either.left((Object)"\u5f85\u5220\u9664\u7684\u5e93\u5b58\u9884\u8b66\u89c4\u5219\u96c6\u5408\u4e3a\u7a7a");
            Intrinsics.checkNotNullExpressionValue((Object)either, (String)"left(\"\u5f85\u5220\u9664\u7684\u5e93\u5b58\u9884\u8b66\u89c4\u5219\u96c6\u5408\u4e3a\u7a7a\")");
            return either;
        }
        UserInfo userInfo = (UserInfo)this.userInfo.get();
        CfgConfigInventoryExample example = new CfgConfigInventoryExample();
        example.createCriteria().andIdIn(list);
        CfgConfigInventoryEntity entity = new CfgConfigInventoryEntity();
        long deletedFlag = System.currentTimeMillis();
        entity.setDeletedFlag(Long.valueOf(deletedFlag));
        entity.setModifiedAt(new Date());
        entity.setModifiedBy(Long.valueOf(userInfo.getUserId()));
        this.cfgConfigInventoryDao.updateByExampleSelective(entity, example);
        CfgConfigInventoryReceiverExample receiverExample = new CfgConfigInventoryReceiverExample();
        receiverExample.createCriteria().andInventoryIdIn(list);
        CfgConfigInventoryReceiverEntity receiverEntity = new CfgConfigInventoryReceiverEntity();
        receiverEntity.setDeletedFlag(Long.valueOf(deletedFlag));
        this.cfgConfigInventoryReceiverDao.updateByExampleSelective(receiverEntity, receiverExample);
        this.insertLog(list, InventoryLogAction.DELETE, null, userInfo.getUserName());
        Either either = Either.right((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)either, (String)"right(true)");
        return either;
    }

    /*
     * WARNING - void declaration
     */
    private void insertLog(List<Long> inventoryIdList, InventoryLogAction action, String message, String userName) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = inventoryIdList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            long l = ((Number)item$iv$iv).longValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.assembleLog((long)it, action, message, userName));
        }
        List logList = (List)destination$iv$iv;
        this.cfgConfigInventoryLogExtDao.batchInsert(logList);
    }

    private void insertLog(long inventoryId, InventoryLogAction action, String message, String userName) {
        this.cfgConfigInventoryLogDao.insert(this.assembleLog(inventoryId, action, message, userName));
    }

    private CfgConfigInventoryLogEntity assembleLog(long inventoryId, InventoryLogAction action, String message, String userName) {
        CfgConfigInventoryLogEntity entity = new CfgConfigInventoryLogEntity();
        entity.setInventoryId(Long.valueOf(inventoryId));
        entity.setAction(Integer.valueOf(action.ordinal()));
        CharSequence charSequence = message;
        entity.setMessage(charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? action.getDescription() : message);
        entity.setCreatedAt(new Date());
        String string = userName;
        if (string == null) {
            string = "\u7cfb\u7edf";
        }
        entity.setCreatedBy(string);
        return entity;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Either<String, DataList<InventoryData>> query(@NotNull QueryInventoryConfigRequest request) {
        void $this$mapTo$iv$iv;
        Object object;
        Object list$iv$iv;
        CfgConfigInventoryReceiverEntity it;
        Object destination$iv$iv;
        void $this$mapTo$iv$iv2;
        InventorySortInfo inventorySortInfo;
        Collection<String> collection;
        void $this$mapTo$iv$iv3;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.log.info("queryInventoryConfigRequest: " + JsonUtils.writeObjectToJson((Object)request));
        List inventoryParamList = new ArrayList();
        List receiverParamList = new ArrayList();
        String checkResult = this.checkParams(request.getConditionInfoList(), inventoryParamList, receiverParamList);
        if (checkResult != null) {
            Either either = Either.left((Object)checkResult);
            Intrinsics.checkNotNullExpressionValue((Object)either, (String)"left(checkResult)");
            return either;
        }
        UserInfo user = (UserInfo)this.userInfo.get();
        UserContext userContext = (UserContext)this.contextHolder.get();
        String token = userContext != null ? userContext.getAccessToken() : null;
        Either getOrgList = this.userCenterService.getOrgIdList(user.getGroupId(), user.getUserId(), token, user.getModules());
        if (getOrgList.isLeft()) {
            Either either = Either.left((Object)getOrgList.getLeft());
            Intrinsics.checkNotNullExpressionValue((Object)either, (String)"left(getOrgList.left)");
            return either;
        }
        List orgIdList = (List)getOrgList.get();
        Intrinsics.checkNotNullExpressionValue((Object)orgIdList, (String)"orgIdList");
        Iterable iterable = orgIdList;
        String string = null;
        String string2 = "in";
        String string3 = "organization_id";
        Collection<Long> collection2 = inventoryParamList;
        boolean $i$f$map = false;
        void var11_16 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it2;
            long l = ((Number)item$iv$iv).longValue();
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(String.valueOf((long)it2));
        }
        Collection<String> collection3 = collection = (List)destination$iv$iv2;
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        collection2.add((Long)new ConditionQueryInfo(string6, string5, string4, collection3));
        inventoryParamList.add(new ConditionQueryInfo("deleted_flag", "=", "0", null));
        receiverParamList.add(new ConditionQueryInfo("deleted_flag", "=", "0", null));
        InventoryPageInfo pageInfo = InventoryPageInfo.copy$default((InventoryPageInfo)request.getPage(), (int)((request.getPage().getPageNo() - 1) * request.getPage().getPageSize()), (int)0, (int)2, null);
        InventorySortInfo inventorySortInfo2 = request.getSorts();
        if (inventorySortInfo2 != null) {
            String string7 = StringUtil.camelToUnderline((String)request.getSorts().getField());
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"camelToUnderline(request.sorts.field)");
            inventorySortInfo = InventorySortInfo.copy$default((InventorySortInfo)inventorySortInfo2, (String)string7, null, (int)2, null);
        } else {
            inventorySortInfo = null;
        }
        InventorySortInfo sortInfo = inventorySortInfo;
        List list = this.cfgConfigInventoryExtDao.selectByExample(inventoryParamList, receiverParamList, pageInfo, sortInfo);
        int total = this.cfgConfigInventoryExtDao.countByExample(inventoryParamList, receiverParamList);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"list");
        Iterable $this$map$iv2 = list;
        boolean $i$f$map2 = false;
        Iterable it2 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it3;
            CfgConfigInventoryEntity cfgConfigInventoryEntity = (CfgConfigInventoryEntity)item$iv$iv;
            collection2 = destination$iv$iv3;
            boolean bl = false;
            collection2.add(it3.getId());
        }
        List inventoryIdList = (List)destination$iv$iv3;
        if (!((Collection)inventoryIdList).isEmpty()) {
            void $this$groupByTo$iv$iv;
            CfgConfigInventoryReceiverExample receiverExample = new CfgConfigInventoryReceiverExample();
            receiverExample.createCriteria().andInventoryIdIn(inventoryIdList).andDeletedFlagEqualTo(Long.valueOf(0L));
            List list2 = this.cfgConfigInventoryReceiverDao.selectByExample(receiverExample);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"cfgConfigInventoryReceiv\u2026yExample(receiverExample)");
            Iterable $this$groupBy$iv = list2;
            boolean $i$f$groupBy = false;
            Iterable $i$f$mapTo22 = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                it = (CfgConfigInventoryReceiverEntity)element$iv$iv;
                boolean bl = false;
                Long key$iv$iv = it.getInventoryId();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            object = destination$iv$iv;
        } else {
            object = new LinkedHashMap();
        }
        Map receiverMap = object;
        Iterable $this$map$iv3 = list;
        boolean $i$f$map3 = false;
        Iterable $this$groupByTo$iv$iv = $this$map$iv3;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (CfgConfigInventoryEntity)item$iv$iv;
            Object object3 = destination$iv$iv;
            boolean bl = false;
            object3.add(this.inventoryConfigConverter.convert((CfgConfigInventoryEntity)it, (List)receiverMap.get(it.getId())));
        }
        int n = total;
        List list3 = (List)destination$iv$iv;
        Either either = Either.right((Object)new DataList(list3, n));
        Intrinsics.checkNotNullExpressionValue((Object)either, (String)"right(DataList(list.map \u2026verMap[it.id]) }, total))");
        return either;
    }

    /*
     * Unable to fully structure code
     */
    private String checkParams(List<ConditionQueryInfo> list, List<ConditionQueryInfo> inventoryList, List<ConditionQueryInfo> receiverList) {
        $this$mapNotNull$iv = list;
        $i$f$mapNotNull = false;
        var7_6 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var12_11 = $this$forEach$iv$iv$iv.iterator();
        while (var12_11.hasNext()) {
            block13: {
                element$iv$iv = element$iv$iv$iv = var12_11.next();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                it = (ConditionQueryInfo)element$iv$iv;
                $i$a$-mapNotNull-ConfigInventoryServiceImpl$checkParams$checkResult$1 = false;
                var18_17 = it.getField();
                switch (var18_17.hashCode()) {
                    case -1412818312: {
                        if (!var18_17.equals("companyId")) {
                            ** break;
                        }
                        ** GOTO lbl37
                    }
                    case 1109191567: {
                        if (!var18_17.equals("deviceUn")) {
                            ** break;
                        }
                        ** GOTO lbl37
                    }
                    case -808719889: {
                        if (var18_17.equals("receiver")) break;
                        ** break;
                    }
                    case -862001145: {
                        if (!var18_17.equals("invoiceType")) {
                            ** break;
                        }
                        ** GOTO lbl37
                    }
                    case 1109191351: {
                        if (!var18_17.equals("deviceNo")) {
                            ** break;
                        }
                        ** GOTO lbl37
                    }
                    case 110136012: {
                        if (!var18_17.equals("taxNo")) ** break;
lbl37:
                        // 5 sources

                        this.convertParam(inventoryList, it);
                        v0 = null;
                        break block13;
                    }
                }
                this.convertParam(receiverList, it);
                v0 = null;
                break block13;
lbl43:
                // 7 sources

                v0 = "\u672a\u77e5\u7b5b\u9009\u9879";
            }
            if (v0 == null) continue;
            it$iv$iv = v0;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        checkResult = (List)destination$iv$iv;
        return (String)CollectionsKt.firstOrNull((List)checkResult);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void convertParam(List<ConditionQueryInfo> list, ConditionQueryInfo param) {
        String field;
        block6: {
            field = StringUtil.camelToUnderline((String)param.getField());
            String string = param.getConditionOp();
            switch (string.hashCode()) {
                case 3321751: {
                    if (string.equals("like")) break;
                    return;
                }
                case 3365: {
                    if (!string.equals("in")) {
                        return;
                    }
                    break block6;
                }
                case 3244: {
                    if (!string.equals("eq")) return;
                    Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field");
                    list.add(ConditionQueryInfo.copy$default((ConditionQueryInfo)param, (String)field, (String)"=", null, null, (int)12, null));
                    return;
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field");
            list.add(ConditionQueryInfo.copy$default((ConditionQueryInfo)param, (String)field, null, (String)('%' + param.getValue() + '%'), null, (int)10, null));
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field");
        list.add(ConditionQueryInfo.copy$default((ConditionQueryInfo)param, (String)field, null, null, null, (int)14, null));
    }

    @NotNull
    public List<InventoryLogData> queryLog(long inventoryId) {
        CfgConfigInventoryLogExample example = new CfgConfigInventoryLogExample();
        example.createCriteria().andInventoryIdEqualTo(Long.valueOf(inventoryId));
        example.setOrderByClause(" created_at desc");
        List entityList = this.cfgConfigInventoryLogDao.selectByExample(example);
        List list = this.inventoryConfigConverter.convert(entityList);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"inventoryConfigConverter.convert(entityList)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Tuple2<String, InventoryUniqueData>> check(@NotNull CheckInventoryConfigRequest request) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Iterable $this$map$iv = request.getList();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Tuple2 tuple2;
            Object object;
            Iterable $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Object it;
            void $this$filterTo$iv$iv;
            void data;
            InventoryUniqueData inventoryUniqueData = (InventoryUniqueData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CfgConfigInventoryExample example = new CfgConfigInventoryExample();
            example.createCriteria().andTaxNoEqualTo(data.getTaxNo()).andDeviceUnEqualTo(data.getDeviceUn()).andInvoiceTypeEqualTo(data.getInvoiceType()).andDeletedFlagEqualTo(Long.valueOf(0L));
            List entityList = this.cfgConfigInventoryDao.selectByExample(example);
            Intrinsics.checkNotNullExpressionValue((Object)entityList, (String)"entityList");
            Iterable $this$filter$iv = entityList;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (CfgConfigInventoryEntity)element$iv$iv;
                boolean bl2 = false;
                int n = data.getWarnNum();
                Integer n2 = it.getWarnNum();
                Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"it.warnNum");
                if (!(n < ((Number)n2).intValue())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                it = (CfgConfigInventoryEntity)item$iv$iv2;
                object = destination$iv$iv2;
                boolean bl3 = false;
                object.add(it.getId());
            }
            List ids = (List)destination$iv$iv2;
            if (ids.isEmpty()) {
                tuple2 = Tuple.of((Object)"\u6ca1\u6709\u89e6\u53d1\u89c4\u5219", (Object)data);
            } else {
                Iterator it2;
                Iterable $this$mapTo$iv$iv3;
                void $this$map$iv3;
                CfgConfigInventoryLogExample logExample = new CfgConfigInventoryLogExample();
                logExample.createCriteria().andInventoryIdIn(ids).andActionEqualTo(Integer.valueOf(InventoryLogAction.SEND_EMAIL.ordinal())).andCreatedAtGreaterThan(DateTools.convertLocalDateTimeToDate((LocalDateTime)DateTools.getMinOfDay((LocalDateTime)LocalDateTime.now())));
                List logList = this.cfgConfigInventoryLogDao.selectByExample(logExample);
                Iterable iterable3 = ids;
                Intrinsics.checkNotNullExpressionValue((Object)logList, (String)"logList");
                $this$mapTo$iv$iv2 = logList;
                object = iterable3;
                boolean $i$f$map3 = false;
                void $i$f$mapTo22 = $this$map$iv3;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo32 = false;
                for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
                    CfgConfigInventoryLogEntity cfgConfigInventoryLogEntity = (CfgConfigInventoryLogEntity)item$iv$iv3;
                    Collection collection2 = destination$iv$iv3;
                    boolean bl4 = false;
                    collection2.add(it2.getInventoryId());
                }
                ids = CollectionsKt.minus((Iterable)object, (Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv3)));
                if (ids.isEmpty()) {
                    tuple2 = Tuple.of((Object)"\u6240\u6709\u89e6\u53d1\u89c4\u5219\u4eca\u5929\u5747\u5df2\u7ecf\u53d1\u9001\u8fc7\u90ae\u4ef6", (Object)data);
                } else {
                    boolean sendResult;
                    void $this$mapTo$iv$iv4;
                    void $this$associateByTo$iv$iv;
                    Long key$iv$iv;
                    void $this$groupByTo$iv$iv;
                    void $this$groupBy$iv;
                    CfgConfigInventoryReceiverExample receiverExample = new CfgConfigInventoryReceiverExample();
                    receiverExample.createCriteria().andInventoryIdIn(ids).andDeletedFlagEqualTo(Long.valueOf(0L));
                    List list = this.cfgConfigInventoryReceiverDao.selectByExample(receiverExample);
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"cfgConfigInventoryReceiv\u2026yExample(receiverExample)");
                    $this$mapTo$iv$iv3 = list;
                    boolean $i$f$groupBy = false;
                    void $i$f$mapTo32 = $this$groupBy$iv;
                    Map destination$iv$iv4 = new LinkedHashMap();
                    boolean $i$f$groupByTo22 = false;
                    it2 = $this$groupByTo$iv$iv.iterator();
                    while (it2.hasNext()) {
                        Object object2;
                        Object element$iv$iv = it2.next();
                        CfgConfigInventoryReceiverEntity it3 = (CfgConfigInventoryReceiverEntity)element$iv$iv;
                        boolean bl5 = false;
                        key$iv$iv = it3.getInventoryId();
                        Map $this$getOrPut$iv$iv$iv = destination$iv$iv4;
                        boolean $i$f$getOrPut = false;
                        Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl6 = false;
                            List answer$iv$iv$iv = new ArrayList();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object2 = answer$iv$iv$iv;
                        } else {
                            object2 = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object2;
                        list$iv$iv.add(element$iv$iv);
                    }
                    Map receiverMap = destination$iv$iv4;
                    Iterable $this$associateBy$iv = entityList;
                    boolean $i$f$associateBy = false;
                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                    Iterable $i$f$groupByTo22 = $this$associateBy$iv;
                    Map destination$iv$iv5 = new LinkedHashMap(capacity$iv);
                    boolean $i$f$associateByTo = false;
                    for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                        void it4;
                        key$iv$iv = (CfgConfigInventoryEntity)element$iv$iv;
                        object = destination$iv$iv5;
                        boolean bl7 = false;
                        object.put(it4.getId(), element$iv$iv);
                    }
                    Map entityMap = destination$iv$iv5;
                    boolean sendFlag = false;
                    Map $this$map$iv4 = receiverMap;
                    boolean $i$f$map4 = false;
                    destination$iv$iv5 = $this$map$iv4;
                    Collection destination$iv$iv6 = new ArrayList($this$map$iv4.size());
                    boolean $i$f$mapTo4 = false;
                    Iterator iterator = $this$mapTo$iv$iv4.entrySet().iterator();
                    while (iterator.hasNext()) {
                        String string;
                        String it$iv$iv;
                        boolean bl8;
                        CfgConfigInventoryReceiverEntity it5;
                        boolean bl9;
                        Object element$iv$iv;
                        Object element$iv$iv$iv;
                        Iterator iterator2;
                        boolean $i$f$forEach;
                        Iterable $this$forEach$iv$iv$iv;
                        Iterable $this$mapNotNullTo$iv$iv;
                        boolean $i$f$mapNotNullTo;
                        Collection destination$iv$iv7;
                        Iterable $this$mapNotNull$iv;
                        boolean $i$f$mapNotNull;
                        Map.Entry item$iv$iv4;
                        Map.Entry entry = item$iv$iv4 = iterator.next();
                        object = destination$iv$iv6;
                        boolean bl10 = false;
                        Long key = (Long)entry.getKey();
                        List value = (List)entry.getValue();
                        CfgConfigInventoryEntity cfgConfigInventoryEntity = (CfgConfigInventoryEntity)entityMap.get(key);
                        if (cfgConfigInventoryEntity == null) {
                            cfgConfigInventoryEntity = new CfgConfigInventoryEntity();
                        }
                        CfgConfigInventoryEntity entity = cfgConfigInventoryEntity;
                        sendFlag = this.sendInvoiceMailService.sendInventoryWarnEmail(entity.getCompanyName(), this.getEmailProperties(entity, data.getWarnNum()), value);
                        if (value.size() > 5) {
                            Iterable iterable4 = value.subList(0, 5);
                            StringBuilder stringBuilder = new StringBuilder();
                            $i$f$mapNotNull = false;
                            Iterable iterable5 = $this$mapNotNull$iv;
                            destination$iv$iv7 = new ArrayList();
                            $i$f$mapNotNullTo = false;
                            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                            $i$f$forEach = false;
                            iterator2 = $this$forEach$iv$iv$iv.iterator();
                            while (iterator2.hasNext()) {
                                element$iv$iv = element$iv$iv$iv = iterator2.next();
                                bl9 = false;
                                it5 = (CfgConfigInventoryReceiverEntity)element$iv$iv;
                                boolean bl11 = false;
                                if (it5.getReceiver() == null) continue;
                                bl8 = false;
                                destination$iv$iv7.add(it$iv$iv);
                            }
                            string = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv7), null, null, null, (int)0, null, null, (int)63, null)).append('\u7b49').append(value.size()).append("\u4e2a\u90ae\u7bb1").toString();
                        } else {
                            $this$mapNotNull$iv = value;
                            $i$f$mapNotNull = false;
                            $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
                            destination$iv$iv7 = new ArrayList();
                            $i$f$mapNotNullTo = false;
                            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                            $i$f$forEach = false;
                            iterator2 = $this$forEach$iv$iv$iv.iterator();
                            while (iterator2.hasNext()) {
                                element$iv$iv = element$iv$iv$iv = iterator2.next();
                                bl9 = false;
                                it5 = (CfgConfigInventoryReceiverEntity)element$iv$iv;
                                boolean bl12 = false;
                                if (it5.getReceiver() == null) continue;
                                bl8 = false;
                                destination$iv$iv7.add(it$iv$iv);
                            }
                            string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv7), null, null, null, (int)0, null, null, (int)63, null);
                        }
                        String emailAddrInMsg = string;
                        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                        this.insertLog(key.longValue(), InventoryLogAction.SEND_EMAIL, (sendFlag ? "\u53d1\u9001\u90ae\u4ef6\u6210\u529f" : "\u53d1\u9001\u90ae\u4ef6\u5931\u8d25") + emailAddrInMsg, "\u7cfb\u7edf");
                        object.add(sendFlag);
                    }
                    boolean bl13 = sendResult = ((List)destination$iv$iv6).size() > 1;
                    tuple2 = Tuple.of((Object)(sendResult ? "partSuccess" : (sendFlag ? "success" : "fail")), (Object)data);
                }
            }
            collection.add(tuple2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public void importInventoryConfig(@NotNull Sequence<InventoryConfigImportData> dataList2, @NotNull Map<String, ? extends Object> headers) {
        void $this$forEach$iv;
        Object value$iv$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        Sequence $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Intrinsics.checkNotNullParameter(dataList2, (String)"dataList");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        UserInfo user = new UserInfo();
        Object object = headers.get("userName");
        if (object == null || (object = object.toString()) == null) {
            object = "";
        }
        user.setUserName((String)object);
        Object object2 = headers.get("userId");
        user.setUserId(object2 != null && (object2 = object2.toString()) != null ? Long.parseLong((String)object2) : 0L);
        Object object3 = headers.get("groupId");
        user.setGroupId(object3 != null && (object3 = object3.toString()) != null ? Long.parseLong((String)object3) : 0L);
        this.userInfo.put((Object)user);
        Sequence sequence = SequencesKt.distinct((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.map((Sequence)SequencesKt.distinct((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull(dataList2, (Function1)((Function1)importInventoryConfig.companyMap.1.INSTANCE)), (Function1)((Function1)importInventoryConfig.companyMap.2.INSTANCE))), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */))));
        boolean $i$f$groupBy = false;
        void var7_7 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object4;
            OrgData it = (OrgData)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getCompanyName();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object4 = answer$iv$iv$iv;
            } else {
                object4 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object4;
            list$iv$iv.add(element$iv$iv);
        }
        Map companyMap2 = destination$iv$iv;
        Map deviceMap = new LinkedHashMap();
        List errorList = new ArrayList();
        $this$groupByTo$iv$iv = SequencesKt.filter(dataList2, (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List list;
            int n;
            String string;
            Object object5;
            Object object6;
            Object object7;
            String string2;
            long l;
            long l2;
            long l3;
            Object object8;
            String string3;
            AddInventoryConfigRequest request;
            Either result;
            List list2;
            String[] stringArray;
            String string4;
            Object object9;
            DeviceInfo deviceInfo;
            Object object10;
            Object object11;
            Object object12;
            Object object13;
            InventoryConfigImportData it = (InventoryConfigImportData)element$iv;
            boolean bl = false;
            List list3 = (List)companyMap2.get(it.getCompanyName());
            OrgData company = list3 != null ? (OrgData)CollectionsKt.first((List)list3) : null;
            DeviceInfo device = (DeviceInfo)deviceMap.get(it.getDeviceNo());
            String string5 = it.getCompanyName();
            if (string5 == null) {
                string5 = "";
            }
            if ((object13 = company) == null || (object13 = object13.getTaxNum()) == null) {
                object13 = "";
            }
            long l4 = (object12 = company) != null && (object12 = object12.getTenantId()) != null ? (Long)object12 : 0L;
            Object object14 = company;
            long l5 = object14 != null && (object14 = object14.getCompanyId()) != null ? (Long)object14 : 0L;
            Object object15 = company;
            long l6 = object15 != null && (object15 = object15.getOrgId()) != null ? (Long)object15 : 0L;
            String string6 = it.getDeviceNo();
            if (string6 == null) {
                string6 = "";
            }
            DeviceInfo deviceInfo2 = device;
            Object object16 = $this$getOrPut$iv$iv$iv = deviceInfo2 != null ? deviceInfo2.getDeviceType() : null;
            if (object16 == null) {
                object11 = "";
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)object16, (String)"device?.deviceType ?: \"\"");
                object11 = $this$getOrPut$iv$iv$iv;
            }
            DeviceInfo deviceInfo3 = device;
            Object object17 = $this$getOrPut$iv$iv$iv = deviceInfo3 != null ? deviceInfo3.getDeviceUn() : null;
            if (object17 == null) {
                object10 = "";
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)object17, (String)"device?.deviceUn ?: \"\"");
                object10 = $this$getOrPut$iv$iv$iv;
            }
            Object object18 = $this$getOrPut$iv$iv$iv = (deviceInfo = device) != null && (deviceInfo = deviceInfo.getTaxDeviceInfo()) != null ? deviceInfo.getTaxDeviceMachineNo() : null;
            if (object18 == null) {
                object9 = "";
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)object18, (String)"device?.taxDeviceInfo?.taxDeviceMachineNo ?: \"\"");
                object9 = $this$getOrPut$iv$iv$iv;
            }
            if ((string4 = it.getInvoiceType()) == null) {
                string4 = "";
            }
            Integer n2 = it.getWarnNum();
            int n3 = n2 != null ? n2 : 0;
            Object object19 = it.getEmail();
            if (object19 != null && (object19 = StringsKt.split$default((CharSequence)((CharSequence)object19), (String[])(stringArray = new String[]{","}), (boolean)false, (int)0, (int)6, null)) != null) {
                Collection<WarnReceiver> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                value$iv$iv$iv = (Iterable)object19;
                int n4 = n3;
                String string7 = string4;
                Object object20 = object9;
                Object object21 = object10;
                Object object22 = object11;
                String string8 = string6;
                long l7 = l6;
                long l8 = l5;
                long l9 = l4;
                Object object23 = object13;
                String string9 = string5;
                boolean $i$f$map = false;
                void var33_39 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void r;
                    String string10 = (String)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl3 = false;
                    Object object24 = InventoryReceiverType.EMAIL.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)object24, (String)"EMAIL.value");
                    collection.add(new WarnReceiver((String)r, (String)object24));
                }
                collection = (List)destination$iv$iv2;
                string5 = string9;
                object13 = object23;
                l4 = l9;
                l5 = l8;
                l6 = l7;
                string6 = string8;
                object11 = object22;
                object10 = object21;
                object9 = object20;
                string4 = string7;
                n3 = n4;
                list2 = collection;
            } else {
                list2 = CollectionsKt.emptyList();
            }
            if (!(result = this.add(request = new AddInventoryConfigRequest(string3 = string5, (String)(object8 = object13), l3 = l4, l2 = l5, l = l6, string2 = string6, (String)(object7 = object11), (String)(object6 = object10), (String)(object5 = object9), string = string4, n = n3, list = list2))).isLeft()) continue;
            errorList.add(InventoryConfigImportData.copy$default((InventoryConfigImportData)it, null, null, null, null, null, (String)((String)result.getLeft()), (int)31, null));
        }
        this.importFailConfigServiceImpl.dealFailInventoryConfigImport(errorList, headers, Integer.valueOf(SequencesKt.toList(dataList2).size() - errorList.size()));
    }

    private DeviceInfo checkDeviceExist(String taxNo, String deviceNo, Map<String, DeviceInfo> deviceMap) {
        DeviceInfo deviceInfo;
        if (StringsKt.isBlank((CharSequence)taxNo)) {
            return null;
        }
        Either response2 = this.configDeviceService.queryDeviceByTaxNo(taxNo);
        if (response2.isLeft()) {
            deviceInfo = null;
        } else {
            Object v2;
            block4: {
                Object object = response2.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"response.get()");
                Iterable $this$firstOrNull$iv = CollectionsKt.filterNotNull((Iterable)((Iterable)object));
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    DeviceInfo it = (DeviceInfo)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getDeviceNo(), (Object)deviceNo)) continue;
                    v2 = element$iv;
                    break block4;
                }
                v2 = null;
            }
            DeviceInfo deviceInfo2 = v2;
            deviceMap.put(deviceNo, deviceInfo2);
            deviceInfo = deviceInfo2;
        }
        return deviceInfo;
    }

    private boolean checkEmail(List<String> list) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(!MatchUtil.STATIC.isEmail(it))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void timingSendEmail() {
        logExample = new CfgConfigInventoryLogExample();
        current = LocalDateTime.now();
        logExample.createCriteria().andCreatedAtLessThan(DateTools.convertLocalDateTimeToDate((LocalDateTime)DateTools.getMinOfDay((LocalDateTime)current))).andCreatedAtGreaterThan(DateTools.convertLocalDateTimeToDate((LocalDateTime)DateTools.getMinOfDay((LocalDateTime)DateTools.getPreDay((LocalDateTime)current, (int)1)))).andActionEqualTo(Integer.valueOf(InventoryLogAction.SEND_EMAIL.ordinal()));
        logList = this.cfgConfigInventoryLogDao.selectByExample(logExample);
        Intrinsics.checkNotNullExpressionValue((Object)logList, (String)"logList");
        $this$mapNotNull$iv = logList;
        $i$f$mapNotNull = false;
        var7_7 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        for (T element$iv$iv$iv : $this$forEach$iv$iv$iv) {
            element$iv$iv = element$iv$iv$iv;
            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
            it = (CfgConfigInventoryLogEntity)element$iv$iv;
            $i$a$-mapNotNull-ConfigInventoryServiceImpl$timingSendEmail$inventoryIds$1 = false;
            if (it.getInventoryId() == null) continue;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        inventoryIds = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        todayLogExample = new CfgConfigInventoryLogExample();
        todayLogExample.createCriteria().andInventoryIdIn(inventoryIds).andActionEqualTo(Integer.valueOf(InventoryLogAction.SEND_EMAIL.ordinal())).andCreatedAtGreaterThan(DateTools.convertLocalDateTimeToDate((LocalDateTime)DateTools.getMinOfDay((LocalDateTime)current)));
        todaySendList = this.cfgConfigInventoryLogDao.selectByExample(todayLogExample);
        v0 = inventoryIds;
        Intrinsics.checkNotNullExpressionValue((Object)todaySendList, (String)"todaySendList");
        $this$mapNotNullTo$iv$iv = todaySendList;
        var47_44 = v0;
        $i$f$mapNotNull = false;
        $i$f$mapNotNullTo = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        for (E element$iv$iv$iv : $this$forEach$iv$iv$iv) {
            element$iv$iv = element$iv$iv$iv;
            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
            it = (CfgConfigInventoryLogEntity)element$iv$iv;
            $i$a$-mapNotNull-ConfigInventoryServiceImpl$timingSendEmail$1 = false;
            if (it.getInventoryId() == null) continue;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        inventoryIds = CollectionsKt.minus((Iterable)var47_44, (Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
        if (inventoryIds.isEmpty()) {
            return;
        }
        example = new CfgConfigInventoryExample();
        example.createCriteria().andIdIn(inventoryIds).andDeletedFlagEqualTo(Long.valueOf(0L));
        inventoryList = this.cfgConfigInventoryDao.selectByExample(example);
        Intrinsics.checkNotNullExpressionValue((Object)inventoryList, (String)"inventoryList");
        actualInventoryMap = this.getInventory(inventoryList);
        $this$filter$iv = inventoryList;
        $i$f$filter = false;
        $i$f$forEach = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (E element$iv$iv : $this$filterTo$iv$iv) {
            it = (CfgConfigInventoryEntity)element$iv$iv;
            $i$a$-filter-ConfigInventoryServiceImpl$timingSendEmail$inventoryMap$1 = false;
            if (!actualInventoryMap.containsKey(Tuple.of((Object)it.getTaxNo(), (Object)it.getDeviceNo(), (Object)it.getInvoiceType()))) ** GOTO lbl-1000
            v1 = it.getWarnNum();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it.warnNum");
            v2 = (Integer)actualInventoryMap.get(Tuple.of((Object)it.getTaxNo(), (Object)it.getDeviceNo(), (Object)it.getInvoiceType()));
            if (((Number)v1).intValue() > (v2 != null ? v2 : 0)) {
                v3 = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = false;
            }
            if (!v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$associate = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
        $i$f$associateTo = false;
        for (T element$iv$iv : $this$associateTo$iv$iv) {
            $i$a$-filter-ConfigInventoryServiceImpl$timingSendEmail$inventoryMap$1 = destination$iv$iv;
            it = (CfgConfigInventoryEntity)element$iv$iv;
            $i$a$-associate-ConfigInventoryServiceImpl$timingSendEmail$inventoryMap$2 = false;
            v4 = (Integer)actualInventoryMap.get(Tuple.of((Object)it.getTaxNo(), (Object)it.getDeviceNo(), (Object)it.getInvoiceType()));
            it = TuplesKt.to((Object)it.getId(), (Object)new Pair((Object)it, (Object)(v4 != null ? v4 : 0)));
            $i$a$-filter-ConfigInventoryServiceImpl$timingSendEmail$inventoryMap$1.put(it.getFirst(), it.getSecond());
        }
        inventoryMap = destination$iv$iv;
        sendEmailIds = CollectionsKt.toMutableList((Collection)inventoryMap.keySet());
        if (sendEmailIds.isEmpty()) {
            return;
        }
        receiverExample = new CfgConfigInventoryReceiverExample();
        receiverExample.createCriteria().andInventoryIdIn(sendEmailIds).andDeletedFlagEqualTo(Long.valueOf(0L)).andReceiverTypeEqualTo(Integer.valueOf(InventoryReceiverType.EMAIL.ordinal()));
        v5 = this.cfgConfigInventoryReceiverDao.selectByExample(receiverExample);
        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"cfgConfigInventoryReceiv\u2026yExample(receiverExample)");
        $this$associateTo$iv$iv = v5;
        $i$f$groupBy = false;
        $i$f$associateTo = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$groupByTo = false;
        for (T element$iv$iv : $this$groupByTo$iv$iv) {
            it = (CfgConfigInventoryReceiverEntity)element$iv$iv;
            $i$a$-groupBy-ConfigInventoryServiceImpl$timingSendEmail$receiverMap$1 = false;
            key$iv$iv = it.getInventoryId();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            $i$f$getOrPut = false;
            value$iv$iv$iv /* !! */  = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv /* !! */  == null) {
                $i$a$-getOrPut-CollectionsKt___CollectionsKt$groupByTo$list$1$iv$iv = false;
                answer$iv$iv$iv = new ArrayList<E>();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                v6 /* !! */  = answer$iv$iv$iv;
            } else {
                v6 /* !! */  = value$iv$iv$iv /* !! */ ;
            }
            list$iv$iv = (List)v6 /* !! */ ;
            list$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = receiverMap = destination$iv$iv;
        $i$f$forEach = false;
        var16_32 = $this$forEach$iv.entrySet().iterator();
        while (var16_32.hasNext()) {
            var18_38 = element$iv = var16_32.next();
            $i$a$-forEach-ConfigInventoryServiceImpl$timingSendEmail$2 = false;
            key = (Long)var18_38.getKey();
            value = (List)var18_38.getValue();
            v7 = inventoryPair = (Pair)inventoryMap.get(key);
            v8 = key$iv$iv = v7 != null ? (CfgConfigInventoryEntity)v7.getFirst() : null;
            if (v8 == null) {
                v9 = new CfgConfigInventoryEntity();
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"inventoryPair?.first ?: CfgConfigInventoryEntity()");
                v9 = key$iv$iv;
            }
            inventory = v9;
            v10 = inventoryPair;
            leftNum = v10 != null ? ((Number)v10.getSecond()).intValue() : 0;
            sendResult = this.sendInvoiceMailService.sendInventoryWarnEmail(inventory.getCompanyName(), this.getEmailProperties(inventory, leftNum), value);
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            value$iv$iv$iv /* !! */  = value;
            var27_57 = new StringBuilder().append(sendResult != false ? "\u53d1\u9001\u90ae\u4ef6\u6210\u529f" : "\u53d1\u9001\u90ae\u4ef6\u5931\u8d25");
            var28_59 = InventoryLogAction.SEND_EMAIL;
            var29_60 = key;
            var31_61 = this;
            $i$f$mapNotNull = false;
            var33_63 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            var38_68 = $this$forEach$iv$iv$iv.iterator();
            while (var38_68.hasNext()) {
                element$iv$iv = element$iv$iv$iv = var38_68.next();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                it = (CfgConfigInventoryReceiverEntity)element$iv$iv;
                $i$a$-mapNotNull-ConfigInventoryServiceImpl$timingSendEmail$2$1 = false;
                if (it.getReceiver() == null) continue;
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            var46_76 = (List)destination$iv$iv;
            var31_61.insertLog(var29_60, var28_59, var27_57.append(CollectionsKt.joinToString$default((Iterable)var46_76, null, null, null, (int)0, null, null, (int)63, null)).toString(), "\u7cfb\u7edf");
        }
    }

    /*
     * WARNING - void declaration
     */
    private Map<Tuple3<String, String, String>, Integer> getInventory(List<? extends CfgConfigInventoryEntity> entityList) {
        try {
            List list = this.inventoryConfigConverter.convertToUniqueData(entityList);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"inventoryConfigConverter\u2026tToUniqueData(entityList)");
            Response reply2 = this.invoiceInventoryClient.queryInventoryByWarnConfig(new QueryInventoryByWarnConfigRequest(CollectionsKt.distinct((Iterable)list)));
            Integer n = reply2.getCode();
            int n2 = 1;
            if (n != null && n == n2) {
                void $this$associateByTo$iv$iv;
                Object object = reply2.getResult();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"reply.result");
                Iterable $this$associateBy$iv = CollectionsKt.toMutableList((Collection)((Collection)object));
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable iterable = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    Tuple3 tuple3;
                    InvoiceInventoryModel it;
                    InvoiceInventoryModel invoiceInventoryModel = (InvoiceInventoryModel)element$iv$iv;
                    Map map = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)Tuple.of((Object)it.getCompanyTaxNo(), (Object)it.getDeviceNo(), (Object)it.getInvoiceType()), (String)"of(it.companyTaxNo, it.deviceNo, it.invoiceType)");
                    it = (InvoiceInventoryModel)element$iv$iv;
                    boolean bl2 = false;
                    Integer n3 = it.getInvoiceNum();
                    map.put(tuple3, n3);
                }
                return destination$iv$iv;
            }
            this.log.error("configInventoryService.getInventory fail " + JsonUtils.writeObjectToJson((Object)reply2));
        }
        catch (Exception e) {
            this.log.error("configInventoryService.getInventory exception " + e.getMessage() + ", " + e);
        }
        return MapsKt.emptyMap();
    }

    private Map<String, Object> getEmailProperties(CfgConfigInventoryEntity entity, int leftNum) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"companyName", (Object)entity.getCompanyName()), TuplesKt.to((Object)"deviceNo", (Object)entity.getDeviceNo()), TuplesKt.to((Object)"machineNo", (Object)entity.getMachineNo()), TuplesKt.to((Object)"invoiceType", (Object)ValueEnum.getEnumByValue(InvoiceTypeEnum.class, (Object)entity.getInvoiceType()).map(arg_0 -> ConfigInventoryServiceImpl.getEmailProperties$lambda$46((Function1)getEmailProperties.1.INSTANCE, arg_0)).orElse("")), TuplesKt.to((Object)"warnNum", (Object)entity.getWarnNum()), TuplesKt.to((Object)"leftNum", (Object)leftNum), TuplesKt.to((Object)"warnTime", (Object)DateTools.parseLocalDateTime())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    /*
     * WARNING - void declaration
     */
    public int updateDeviceUn(@Nullable List<String> deviceNoList) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        CfgConfigInventoryExample example = new CfgConfigInventoryExample();
        Collection collection = deviceNoList;
        if (!(collection == null || collection.isEmpty())) {
            example.createCriteria().andDeletedFlagEqualTo(Long.valueOf(0L)).andDeviceUnIsNull().andDeviceNoIn(deviceNoList);
            example.or().andDeletedFlagEqualTo(Long.valueOf(0L)).andDeviceUnEqualTo("").andDeviceNoIn(deviceNoList);
        } else {
            example.createCriteria().andDeletedFlagEqualTo(Long.valueOf(0L)).andDeviceUnIsNull();
            example.or().andDeletedFlagEqualTo(Long.valueOf(0L)).andDeviceUnEqualTo("");
        }
        List inventoryList = this.cfgConfigInventoryDao.selectByExample(example);
        Iterable<Object> iterable = inventoryList.parallelStream().map(arg_0 -> ConfigInventoryServiceImpl.updateDeviceUn$lambda$47((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"override fun updateDevic\u2026eEntity)\n        }\n\n    }");
        iterable = iterable;
        boolean $i$f$filter = false;
        void var7_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!((Either)it.getSecond()).isRight()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void $this$groupByTo$iv$iv;
            void $this$groupBy$iv;
            DeviceInfo r;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2;
            Pair bl = (Pair)element$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl2 = false;
            Pair it = (Pair)element$iv$iv;
            String string = (String)it.getFirst();
            boolean bl3 = false;
            Object object = ((Either)it.getSecond()).get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.second.get()");
            Iterable iterable2 = (Iterable)object;
            boolean $i$f$filter2 = false;
            void var17_21 = $this$filter$iv2;
            Object destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                r = (DeviceInfo)element$iv$iv2;
                boolean bl4 = false;
                CharSequence charSequence = r.getDeviceNo();
                boolean bl5 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && !((charSequence = (CharSequence)r.getDeviceUn()) == null || StringsKt.isBlank((CharSequence)charSequence));
                if (!bl5) continue;
                destination$iv$iv3.add(element$iv$iv2);
            }
            $this$filter$iv2 = (List)destination$iv$iv3;
            boolean $i$f$groupBy = false;
            $this$filterTo$iv$iv2 = $this$groupBy$iv;
            destination$iv$iv3 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv2 : $this$groupByTo$iv$iv) {
                void r2;
                Object object2;
                r = (DeviceInfo)element$iv$iv2;
                boolean $i$a$-groupBy-ConfigInventoryServiceImpl$updateDeviceUn$fullDeviceMap$4$42 = false;
                String key$iv$iv = r.getDeviceNo();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv3;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl6 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                DeviceInfo $i$a$-groupBy-ConfigInventoryServiceImpl$updateDeviceUn$fullDeviceMap$4$42 = (DeviceInfo)element$iv$iv2;
                List list = list$iv$iv;
                boolean bl7 = false;
                list.add(r2.getDeviceUn());
            }
            Object object3 = destination$iv$iv3;
            map.put(string, object3);
        }
        Map fullDeviceMap2 = destination$iv$iv2;
        Intrinsics.checkNotNullExpressionValue((Object)inventoryList, (String)"inventoryList");
        iterable = inventoryList;
        int n = 0;
        for (Object object : iterable) {
            void it;
            destination$iv$iv2 = (CfgConfigInventoryEntity)object;
            int n2 = n;
            boolean bl = false;
            CfgConfigInventoryEntity updateEntity = new CfgConfigInventoryEntity();
            updateEntity.setId(it.getId());
            Object object4 = (Map)fullDeviceMap2.get(it.getTaxNo());
            updateEntity.setDeviceUn(object4 != null && (object4 = (List)object4.get(it.getDeviceNo())) != null ? (String)CollectionsKt.firstOrNull((List)object4) : null);
            updateEntity.setModifiedAt(new Date());
            updateEntity.setModifiedBy(Long.valueOf(0L));
            int n3 = this.cfgConfigInventoryDao.updateByPrimaryKeySelective(updateEntity);
            n = n2 + n3;
        }
        return n;
    }

    private static final String updatePartReceiverDeletedAndAddNew$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String updatePartReceiverDeletedAndAddNew$lambda$13$lambda$11$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String getEmailProperties$lambda$46(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final Pair updateDeviceUn$lambda$47(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Pair)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ List access$getAllowWarnInvoiceTypeList$cp() {
        return allowWarnInvoiceTypeList;
    }

    public static final /* synthetic */ UserCenterService access$getUserCenterService$p(ConfigInventoryServiceImpl $this) {
        return $this.userCenterService;
    }

    public static final /* synthetic */ DeviceInfo access$checkDeviceExist(ConfigInventoryServiceImpl $this, String taxNo, String deviceNo, Map deviceMap) {
        return $this.checkDeviceExist(taxNo, deviceNo, deviceMap);
    }

    public static final /* synthetic */ boolean access$checkEmail(ConfigInventoryServiceImpl $this, List list) {
        return $this.checkEmail(list);
    }

    public static final /* synthetic */ ConfigDeviceService access$getConfigDeviceService$p(ConfigInventoryServiceImpl $this) {
        return $this.configDeviceService;
    }

    static {
        Object[] objectArray = new String[]{(String)InvoiceTypeEnum.SPECIAL.getValue(), (String)InvoiceTypeEnum.ELECTRIC_SPECIAL_INVOICE.getValue(), (String)InvoiceTypeEnum.NORMAL.getValue(), (String)InvoiceTypeEnum.ELECTRONIC.getValue(), (String)InvoiceTypeEnum.VEHICLE.getValue()};
        allowWarnInvoiceTypeList = CollectionsKt.listOf((Object[])objectArray);
    }
}

